
#ifndef HEP_MC_MY_GEN_VERTEX_H
#define HEP_MC_MY_GEN_VERTEX_H

namespace HepMC {
  class MyGenVertex; //  Fwd Dec
};

#include "HepMC/GenVertexBaseT.h"
#include "HepMC/MyGenEvent.h"
#include "HepMC/MyGenParticle.h"
#include "HepMC/WeightContainer.h"
#include "CLHEP/Vector/LorentzVector.h"
#include "CLHEP/Geometry/Point3D.h"
#include <iostream>
#include <iterator>
#include <vector>
#include <set>
#include <algorithm>

namespace HepMC {
  
  class MyGenVertex: 
    public GenVertexBaseT<MyGenEvent,MyGenParticle,MyGenVertex> {

    friend class MyGenEvent; // To let MyGenEvent access the static counter() method.
    friend std::ostream& operator<<( std::ostream&, const MyGenVertex& );

    public:
	MyGenVertex( const HepLorentzVector& position =HepLorentzVector(0,0,0,0),
		   int id = 0, 
		   const WeightContainer& weights = std::vector<double>() );
	MyGenVertex( const MyGenVertex& invertex );            // shallow copy
	virtual    ~MyGenVertex();

	MyGenVertex& operator= ( const MyGenVertex& invertex ); // shallow
	bool       operator==( const MyGenVertex& a ) const;
	bool       operator!=( const MyGenVertex& a ) const;
	void       print( std::ostream& ostr = std::cout ) const;

	double     check_momentum_conservation() const;//|Sum (mom_in-mom_out)|

	operator HepLorentzVector() const; // conversion operator
	operator HepPoint3D() const; // conversion operator

	////////////////////
	// access methods //
	////////////////////

	HepPoint3D              point3d() const;
	HepLorentzVector        position() const;
	void                    set_position( const HepLorentzVector& position 
					      = HepLorentzVector(0,0,0,0) );
	// we don't define what you use the id for -- but we imagine,
	// for example it might code the meaning of the weights()
	int                     id() const;
	void                    set_id( int id );

	// direct access to the weights container is allowed. 
	WeightContainer&        weights();
	const WeightContainer&  weights() const;

    protected:
	static unsigned int     counter(); // temporary for debugging

    private: // MyGenVertex data members
	HepLorentzVector     m_position;      //4-vec of vertex [mm]
	int                  m_id;
	WeightContainer      m_weights;       // weights for this vtx

	static unsigned int  s_counter;
  };

    ////////////////////////////
    // INLINES access methods //
    ////////////////////////////

    inline MyGenVertex::operator HepLorentzVector() const { return position(); }

    inline MyGenVertex::operator HepPoint3D() const { return point3d(); }

    inline HepLorentzVector MyGenVertex::position() const { return m_position; }

    inline HepPoint3D MyGenVertex::point3d() const { 
	return (HepPoint3D)m_position; 
    }

    inline int MyGenVertex::id() const { return m_id; }

    inline WeightContainer& MyGenVertex::weights() { return m_weights; }

    inline const WeightContainer& MyGenVertex::weights() const 
    { return m_weights; }

    inline void MyGenVertex::set_position( const HepLorentzVector& position ) {
	m_position = position;
    }

    inline void MyGenVertex::set_id( int id ) { m_id = id; }


};

#endif
