#include <stdio.h>
#include <time.h>
#include "is/isinfo.h"

class TestInfo : public ISInfo {
public:
	TestInfo(int size) {srand(::time(0)); m_data = new int[size]; m_size = size; n_bytes_written=n_bytes_read=0;}
	void publishGuts (ISostream& strm ) {
		for (int i=0; i<m_size; i++) {
			strm << m_data[i];
		}
		n_bytes_written += m_size * sizeof(int);
	}

	void writeFile(FILE* out) {
		if (fwrite((void*)m_data, sizeof(int), m_size, out) != m_size) cout << "Error writing to FILE" << endl;
		n_bytes_written += m_size * sizeof(int);
	}

	void refreshGuts (ISistream& strm ) {
		for (int i=0; i<m_size; i++) {
			strm >> m_data[i];
		}
		n_bytes_read += m_size * sizeof(int);
	}

	void readFile(FILE* in) {
		if (fread((void*)m_data, sizeof(int), m_size, in) != m_size) cout << "Error reading from FILE" << endl;
		n_bytes_read += m_size * sizeof(int);
	}
	
	//Fills with random values
	void Fill() {
		for (int i=0; i<m_size; i++) {
			m_data[i] = rand();
		}
	}

	//Dumps the first 10 elements to the screen
	void Scan() {
		int count =10;
		if (m_size < 10) count = m_size;
		for (int i=0; i<count; i++) cout << m_data[i] << endl;
	}

	long n_bytes_written;
	long n_bytes_read;
private:
	int* m_data;
	int m_size;
};
