#include "TestInfo.h"
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <owl/timer.h>

char* file = "/atlas/daq/code/ISSpeedTest/pipe";
int size = 10240;
int nupdates = 1024;

int main(int argc, char** argv) {
	TestInfo ti(size);
	ti.Fill();
	ti.Scan();

	OWLTimer t;

	int status = mkfifo(file, S_IWUSR | S_IRUSR | S_IRGRP | S_IROTH);
	FILE* out = fopen(file, "w+b");
	cout << status << "   " << out << endl;
	if (status != 0 || out ==0 ) cout << "Error" << endl;

	cout << "Initialized successfully, will start publishing data when you press a key!" << endl;
	char dummy;
	cin >> dummy;

	t.start();
	for (int i=0; i<nupdates; i++) {
		if (i==0) ti.Scan();
		ti.writeFile(out);
		ti.Fill();
	}
	t.stop();

	cout << "Timing: " << t.totalTime() << "  " << t.userTime() << endl;
	cout << "Data: " << ti.n_bytes_written << endl;
	
	fclose(out);
}