#include "TestInfo.h"
#include <owl/timer.h>

char* partition = "be_test";
char* server = "SpeedServer";
int size = 1024;
int nupdates = 1024;

int main(int argc, char** argv) {
	IPCPartition	p(partition);
    ISInfoDictionary	id(p);

	char* name = new char[30];
	strcpy(name, server);
	strcat(name, ".TestInfo");

	TestInfo ti(size);
	ti.Fill();
	ti.Scan();
	ISInfo* isi = &ti;

	ISInfo::Status result;

	OWLTimer t;
	t.start();
	result = id.insert(name,*isi);
	if (result != ISInfo::Success) cout << "Error publishing object" << endl;
	t.stop();

	cout << "Time to insert was: " << t.totalTime() << endl;

	t.reset();

	cout << "Initialized successfully, will start publishing data when you press a key!" << endl;
	char dummy;
	cin >> dummy;

	t.start();
	for (int i=0; i<nupdates; i++) {
		if ( (result = id.update(name,*isi) ) != ISInfo::Success ){
    		cerr << "Update for " << name[i] << " fails with error code " << result << endl;
    	}
		//ti.Fill();
	}
	t.stop();


	//Remove object
	if ( (result = id.remove(name) ) != ISInfo::Success ) cerr << "Error removing object" << endl; 
    	
	cout << "Timing: " << t.totalTime() << "  " << t.userTime() << endl;
	cout << "Data: " << ti.n_bytes_written << endl;
}