#include <stdio.h>
#include "is/isinfo.h"

class TestInfo : public ISInfo {
public:
	TestInfo(int size) {m_data = new int[size]; m_size = size; n_bytes_written=n_bytes_read=0;}
	void publishGuts (ISostream& strm ) {
		for (int i=0; i<m_size; i++) {
			strm << m_data[i];
		}
		n_bytes_written += m_size * sizeof(int);
	}

	void writeFile(FILE* out) {
		if (fwrite((void*)m_data, sizeof(int), m_size, out) != m_size) cout << "Error writing to FILE" << endl;
		n_bytes_written += m_size * sizeof(int);
	}

	void refreshGuts (ISistream& strm ) {
		for (int i=0; i<m_size; i++) {
			strm >> m_data[i];
		}
		n_bytes_read += m_size * sizeof(int);
	}

	void readFile(FILE* in) {
		if (fread((void*)m_data, sizeof(int), m_size, out) != m_size) cout << "Error reading from FILE" << endl;
		n_bytes_read += m_size * sizeof(int);
	}

	long n_bytes_written;
	long n_bytes_read;
private:
	int* m_data;
	int m_size;
};
