#include "TestInfo.h"
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <owl/timer.h>

char* file = "/atlas/daq/code/ISSpeedTest/pipe";
int size = 10240;
int nupdates = 1024;

int main(int argc, char** argv) {
	TestInfo ti(size);

	OWLTimer t;

	//int status = mkfifo(file, S_IWUSR | S_IRUSR | S_IRGRP | S_IROTH);
	FILE* in = fopen(file, "r+b");
	cout << in << endl;
	if (in ==0 ) cout << "Error" << endl;

	cout << "Initialized successfully, will start receiving data when you press a key!" << endl;
	char dummy;
	cin >> dummy;

	for (int i=0; i<nupdates; i++) {
		ti.readFile(in);
		if (i==0) {
			t.start();
			ti.Scan();
		}
	}
	t.stop();

	cout << "Timing: " << t.totalTime() << "  " << t.userTime() << endl;
	cout << "Data: " << ti.n_bytes_read << endl;

	fclose(in);
}