#include "TestInfo.h"
#include <owl/timer.h>

char* partition = "be_test";
char* server = "SpeedServer";
int size = 1024;
int nupdates = 1024;

static ISInfoReceiver * Receiver;

static void Exit() {
		cout << " Exiting ..." ;
		cout << " ( Unsubscribing ..." ;
		ISInfo::Status result;
		if ( (result = Receiver->unsubscribe(server,".*") ) != ISInfo::Success ) cerr << "unsubscribe fails with error code " << result;
  		else cout << "unsubscribe to all successfull ";
		cout << " Done )";
		Receiver->stop();
}


static void callback( ISCallbackInfo * isc ) {
 	static OWLTimer t;
	static int count = 0;
	static TestInfo ti(size);

	if (count == 0) t.start();		// Record starting time

	isc->value(ti);		//Retrieve the data

	if (count == nupdates-1) {
		t.stop();
		cout << "Timing: " << t.totalTime() <<  "  " << t.userTime() << endl;
		cout << "Data: " << ti.n_bytes_read << endl;
		Exit();
	}


	if (count == 0) ti.Scan();

	count++;
}

int main(int argc, char** argv) {
	IPCPartition	p(partition);
  	ISInfoReceiver	ir(p);
	Receiver = &ir;

	ISInfo::Status result;

	if ( (result = ir.subscribe(server,".*",callback) ) != ISInfo::Success ) {
  		cerr << "Subscribe fails with error code " << result << endl;
  		return 1;
  	}
	
	ir.run();

	cout << " done." << endl;
	return 0;
}
