//
//

#include <stdio.h>
#include <windows.h>
#include "SiUSBXp.h"
#include "chimaera.h"
#include "utils.h"

devicePacket_t lastStatus;
devicePacket_t lastData;

int main( int argc, char **argv )
{

SI_STATUS rc;
unsigned maxLoops = 10;

// Find how many devices are attached

DWORD NumDevices;

  rc = SI_GetNumDevices( &NumDevices );
  if ( rc != SI_SUCCESS )
  {
    printf( "Si_GetNumDevices(): rc = %d\n", rc );
    exit(0);
  }

  // Identify the correct device

DWORD deviceIndex;
char deviceString[256];

  for (deviceIndex=0; deviceIndex<NumDevices; deviceIndex++ )
  {
    rc = SI_GetProductString( deviceIndex, deviceString, SI_RETURN_DESCRIPTION );
    if ( rc != SI_SUCCESS )
    {
      printf( "Si_GetProductString(): rc = %d\n", rc );
      exit(0);
    }
    printf( "SI_GetProductString(): [%d] [%s] rc = %d\n", deviceIndex, deviceString, rc );
    if ( !strcmp(deviceString,"Cavendish Chimaera USB" ) ) break;
  }

  if ( deviceIndex == NumDevices )
  {
    printf( "Device not found\n", rc );
    exit(0);
  }

// Open the device

HANDLE deviceHandle;

    rc = SI_Open( deviceIndex, &deviceHandle );
    if ( rc != SI_SUCCESS )
    {
      printf( "Si_Open(): rc = %d\n", rc );
      exit(0);
    }

// Set the read timeout to 20ms and write timeout to 5s

    rc = SI_SetTimeouts(200,5000);
    if ( rc != SI_SUCCESS )
    {
      printf( "Si_SetTimeouts(): rc = %d\n", rc );
      exit(0);
    }

    //    SI_FlushBuffers( deviceHandle, 1, 1 );

    for ( unsigned arg=1;arg<argc;arg++ )
    {
      if ( !strcmp( argv[arg], "--maxLoops" ) )
      {
        maxLoops = strtoul(argv[arg+1],0,0);
        arg++;
      }
    }

    for ( unsigned loop=0; loop<maxLoops; loop++ )
    {
      printf( "Loop %d\n", loop );
      requestDevice( deviceHandle, deviceHeader_t::StatusRequest );
      readDeviceData( deviceHandle, &lastStatus, 24 );
      showLastStatus( &lastStatus );
    }

// Close the device

//    SI_FlushBuffers( deviceHandle, 1, 1 );

    rc = SI_Close( deviceHandle );
    if ( rc != SI_SUCCESS )
    {
      printf( "Si_Close(): rc = %d\n", rc );
      exit(0);
    }

}

