//
//

#include <stdio.h>
#include <windows.h>
#include "SiUSBXp.h"
#include "chimaera.h"
#include "utils.h"

devicePacket_t cmdPacket;
devicePacket_t lastStatus;
devicePacket_t lastData;
bool quiet = false;
bool verbose = false;

int main( int argc, char **argv )
{

SI_STATUS rc;
HANDLE deviceHandle;
unsigned maxLoops = 10;
unsigned maxEvents = 1;
unsigned char maxPacketRequest = 10;

    rc = openDevice( "Cavendish Chimaera USB", 0, &deviceHandle );
    if ( rc != SI_SUCCESS )
    {
      printf( "openDevice(): rc = %d\n", rc );
      exit(0);
    }

    for ( unsigned arg=1;arg<argc;arg++ )
    {
      if ( !strcmp( argv[arg], "--maxLoops" ) )
      {
        maxLoops = strtoul(argv[arg+1],0,0);
        arg++;
      }
      else if ( !strcmp( argv[arg], "--packets" ) )
      {
        maxPacketRequest = strtoul(argv[arg+1],0,0) & 0xff;
        arg++;
      }
      else if ( !strcmp( argv[arg], "--events" ) )
      {
        maxEvents = strtoul(argv[arg+1],0,0);
        arg++;
      }
      else if ( !strcmp( argv[arg], "--verbose" ) )
      {
        verbose = true;
      }
      else if ( !strcmp( argv[arg], "--quiet" ) )
      {
        quiet = true;
      }
    }

    for ( unsigned loop=0; loop<maxLoops; loop++ )
    {
      printf( "---------- Loop %d -----------\n", loop );
      //      cmdPacket.cmd = deviceHeader_t::ResetRequest;
      //      requestDevice( deviceHandle, cmdPacket );
      //      usleep(1000000);
      for ( unsigned event = 0; event < maxEvents; event++ )
      {
        cmdPacket.cmd = deviceHeader_t::GenerateLHCbEvent;
        requestDevice( deviceHandle, cmdPacket );
        usleep(10000);
      }

      cmdPacket.cmd = deviceHeader_t::StatusRequest;
      requestDevice( deviceHandle, cmdPacket );
      readDeviceData( deviceHandle, lastStatus, 68 );
      if ( verbose ) showLastStatus( lastStatus );
      if ( lastStatus.status.extra != 0xdeadface ) break;
      unsigned packets = (lastStatus.status.bufferCount>>4)+1;

      cmdPacket.cmd = deviceHeader_t::FlushRequest;
      requestDevice( deviceHandle, cmdPacket );
      usleep(10000);

      if ( verbose ) printf( "#packets = %#x\n", packets );

      unsigned char packetsRequested;

        for ( unsigned packet=0; packet<packets; packet+=packetsRequested )
        {
          if ( verbose ) printf( "Request %d\n", packet );

// The USBXpress buffer has a dual buffer so we can request up to two
// packets per transaction

          unsigned packetsRemaining = packets - packet;
          if ( packetsRemaining >= maxPacketRequest )
	  {
            packetsRequested = maxPacketRequest;
	  }
          else
	  {
            packetsRequested = packetsRemaining;
	  }

          cmdPacket.cmd = deviceHeader_t::PacketRequest;
          cmdPacket.uc[0] = packetsRequested; // Number of packets
          requestDevice( deviceHandle, cmdPacket );
          for ( unsigned char nread=packetsRequested; nread; nread-- )
	  {
            readDeviceData( deviceHandle, lastData, 68 );
            if ( !quiet ) showLastData( lastData );
            if ( lastData.cmd != deviceHeader_t::Data )
            {
	      printf( "cmd=%#x\n", lastData.cmd );
              break;
            }
	  }
       }

      if ( verbose )
      {
        cmdPacket.cmd = deviceHeader_t::StatusRequest;
        requestDevice( deviceHandle, cmdPacket );
        readDeviceData( deviceHandle, lastStatus, 68 );
        showLastStatus( lastStatus );
      }

    }

// Close the device

    rc = closeDevice( deviceHandle );
    if ( rc != SI_SUCCESS )
    {
      printf( "closeDevice(): rc = %d\n", rc );
      exit(0);
    }

}

