
#if !defined(CHIMAERA_H)
#define CHIMAERA_H

struct deviceHeader_t
{
  unsigned char cmd;
  unsigned char dummy;
  unsigned short length;

  static const unsigned char Data = 0x1;
  static const unsigned char DataAcknowledge = 0x2;
  static const unsigned char Status = 0x3;
  static const unsigned char StatusRequest = 0x4;
  static const unsigned char FlushRequest = 0x5;
  static const unsigned char PacketRequest = 0x6;
  static const unsigned char GenerateLHCbEvent = 0x7;
  static const unsigned char PIOWriteRequest = 0x8;
  static const unsigned char PIOReadRequest = 0x9;
  static const unsigned char GenerateALICEEvent = 0xa;
  static const unsigned char ResetRequest = 0xb;
  static const unsigned char ConfigurationData = 0xc;
  static const unsigned char Int0Enable = 0xd;
  static const unsigned char Int0Disable = 0xe;
  static const unsigned char Int0 = 0xf;
  static const unsigned char Idle = 0xa5;
  static const unsigned char Idle2 = 0x25;
};

struct statusData_t
{
  unsigned char PIO[3];                // Port IO
  unsigned char seq;                   // Sequence counter
  unsigned char parityErrorCount[4];
  unsigned eventCount;
  unsigned bufferCount :24;
  unsigned char rxinhibit :4;
  unsigned char rxerr :4;
  unsigned extra;
  unsigned short ADC[2];
};

struct devicePacket_t
{
  unsigned char cmd;
  unsigned char dummy;
  unsigned short length;
  union
  {
    unsigned char uc[64];
    unsigned short config[2];
    unsigned data[16];
    statusData_t status;
  };
};

SI_STATUS openDevice( char *, unsigned, HANDLE * );
SI_STATUS closeDevice( HANDLE );
unsigned requestPIOWrite( HANDLE, unsigned );
unsigned requestDevice( HANDLE, devicePacket_t & );
unsigned requestDeviceConfiguration( HANDLE, devicePacket_t & );
void showLastStatus( devicePacket_t & );
void showLastData( devicePacket_t & );
SI_STATUS readDeviceData( HANDLE deviceHandle, devicePacket_t &, unsigned );
unsigned flushBuffer( HANDLE, unsigned, bool );

#endif
