//
//

#include <stdio.h>
#include <windows.h>
#include "SiUSBXp.h"
#include "chimaera.h"

devicePacket_t cmdPacket;
devicePacket_t lastStatus;
devicePacket_t lastData;
bool verbose = false;
bool CBUSB = false;

int main( int argc, char **argv )
{
SI_STATUS rc;
unsigned deviceIndex = 0;
HANDLE deviceHandle;

// First pass over command-line arguments to find device type and index

  for ( unsigned arg=1;arg<argc;arg++ )
  {
    if ( !strcmp( argv[arg], "--CBUSB" ) )
    {
      CBUSB = true;
    }
    else if ( !strcmp( argv[arg], "--deviceIndex" ) )
    {
      deviceIndex = strtoul(argv[arg+1],0,0);
      arg++;
    }
  }

  if ( CBUSB )
  {
    rc = openDevice( "Cavendish USB GPIO", deviceIndex, &deviceHandle );
  }
  else
  {
    rc = openDevice( "Cavendish Chimaera USB", deviceIndex, &deviceHandle );
  }

  if ( rc != SI_SUCCESS )
  {
    printf( "openDevice(): rc = %d\n", rc );
    exit(0);
  }

// Second pass over command-line arguments

    for ( unsigned arg=1;arg<argc;arg++ )
    {
      if ( !strcmp( argv[arg], "--PIO" ) )
      {
        unsigned PIO = (strtoul(argv[arg+1],0,0) & 0xffffff);
        requestPIOWrite( deviceHandle, PIO );
        arg++;
      }
      else if ( !strcmp( argv[arg], "--flush" ) )
      {
        cmdPacket.cmd = deviceHeader_t::FlushRequest;
        requestDevice( deviceHandle, cmdPacket );
      }
      else if ( !strcmp( argv[arg], "--dumpBuffer" ) )
      {
        flushBuffer( deviceHandle, 2, true );
      }
      else if ( !strcmp( argv[arg], "--status" ) )
      {
        cmdPacket.cmd = deviceHeader_t::StatusRequest;
        requestDevice( deviceHandle, cmdPacket );
        readDeviceData( deviceHandle, lastStatus, 68 );
        showLastStatus( lastStatus );
      }
      else if ( !strcmp( argv[arg], "--packet" ) )
      {
        cmdPacket.cmd = deviceHeader_t::PacketRequest;
        cmdPacket.uc[0] = 1; // Number of packets
        requestDevice( deviceHandle, cmdPacket );
        readDeviceData( deviceHandle, lastData, 68 );
        showLastData( lastData );
      }
      else if ( !strcmp( argv[arg], "--lhcbEvent" ) || !strcmp( argv[arg], "--event" ) )
      {
        cmdPacket.cmd = deviceHeader_t::GenerateLHCbEvent;
        requestDevice( deviceHandle, cmdPacket );
      }
      else if ( !strcmp( argv[arg], "--aliceEvent" ) )
      {
        cmdPacket.cmd = deviceHeader_t::GenerateALICEEvent;
        requestDevice( deviceHandle, cmdPacket );
      }
      else if ( !strcmp( argv[arg], "--reset" ) )
      {
        cmdPacket.cmd = deviceHeader_t::ResetRequest;
        requestDevice( deviceHandle, cmdPacket );
      }
      else if ( !strcmp( argv[arg], "--int0Enable" ) )
      {
        cmdPacket.cmd = deviceHeader_t::Int0Enable;
        requestDevice( deviceHandle, cmdPacket );
      }
      else if ( !strcmp( argv[arg], "--int0Disable" ) )
      {
        cmdPacket.cmd = deviceHeader_t::Int0Disable;
        requestDevice( deviceHandle, cmdPacket );
      }
      else if ( !strcmp( argv[arg], "--int0Monitor" ) )
      {
        cmdPacket.cmd = deviceHeader_t::Int0Enable;
        requestDevice( deviceHandle, cmdPacket );
        printf( "Int0Monitor: waiting for interrupt\n" );
        rc = readDeviceData( deviceHandle, lastStatus, 68 );
        if ( rc == SI_SUCCESS )
	{
          printf( "Int0Monitor: rc = %#x. Successful read completion.\n", rc );
	}
        else if ( rc == SI_RX_QUEUE_NOT_READY )
	{
          printf( "Int0Monitor: rc = %#x. Read timeout.\n", rc );
	}
        else
	{
          printf( "Int0Monitor: rc = %#x\n", rc );
	}
      }
      else if ( !strcmp( argv[arg], "--verbose" ) )
      {
        verbose = true;
      }
      else if ( !strcmp( argv[arg], "--configure" ) )
      {
        devicePacket_t msg;
        msg.config[0] = strtoul(argv[arg+1],0,0) & 0xffff;
        msg.config[1] = strtoul(argv[arg+2],0,0) & 0xffff;
        requestDeviceConfiguration( deviceHandle, msg );
        arg+=2;
      }
    }

// Close the device

    rc = closeDevice( deviceHandle );
    if ( rc != SI_SUCCESS )
    {
      printf( "closeDevice(): rc = %d\n", rc );
      exit(0);
    }

}

