//-----------------------------------------------------------------------------
// bounce.c
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// Includes
//-----------------------------------------------------------------------------
#include <c8051f320.h>        
#include <stddef.h>       
#include "USB_API.h"

// Command codes.
// NB: The same codes are used between USB host and MCU and between SPISlave and MCU

enum {
 Data = 0x1,
 DataAcknowledge = 0x2,
 Status = 0x3,
 StatusRequest = 0x4,
 FlushRequest = 0x5,
 PacketRequest = 0x6,
 GenerateLHCbEvent = 0x7,
 P12Write = 0x8,
 P12Read = 0x9,
 GenerateALICEEvent = 0xa,
 ResetRequest = 0xb,
 ConfigurationData = 0xc,
 Idle = 0xa5,
 Idle2 = 0x25
};

typedef struct devicePacket_t
{
  unsigned char cmd;
  unsigned char dummy;
  unsigned short length;
  unsigned char cdata[64];
} devicePacket_t;

//-----------------------------------------------------------------------------
// Global CONSTANTS
//-----------------------------------------------------------------------------

sbit Led1 = P2^2;                         // LED='1' means OFF
sbit Led2 = P2^3;
sbit SPISlaveResetIn_b = P0^3;            // ='1' when slave is ready
sbit SPISlaveResetOut = P0^6;             // Assert to reset slave

unsigned short nByte;
devicePacket_t packet;

void SPI0_Init(void);

//-----------------------------------------------------------------------------
// Main Routine
//-----------------------------------------------------------------------------
void main(void) 
{
  unsigned short status_cnt;
  unsigned rc;
  BYTE sdata;

   PCA0MD &= ~0x40;                       // Disable Watchdog timer


   OSCICN |= 0x3; // System clock divide. Set for fastest system clock speed.

   SPI0_Init();

   IT01CF   = 0x0c;    // P0.4 INT0, active high
   IT0 = 0; 
           // INT0 type: 0=level 1=edge sensitive
   P0MDIN   = 0xFF;    // P0.0-7 set digital input
   P0MDOUT  = 0x45;    // P0.0,2,6 set push-pull (SCK,MOSI,ResetOut)
   P0       = ~0x45;   // Open-drain outputs set high impedance
   P1MDIN   = 0xFF;    // P1.0-7 set digital input
   P1MDOUT  = 0xFF;    // P1.0-7 set push-pull
   P1       = 0x00;    // P1.0-7 set low
   P2MDIN   = 0xFF;    // P2.0-7 set digital input
   P2MDOUT  = 0x0C;    // P2.2,3 set push-pull (LEDs)
   P2       = ~0x0C;   // Open-drain outputs set high impedance

   XBR0     = 0x02;    // Enable SPI IO    
   XBR1     = 0x40;    // Enable Crossbar

   Led1 = 1;
   Led2 = 1;
   SPISlaveResetOut = 0;

// Continuous transaction loop

  while ( 1 )
  {

  SPISlaveResetOut = 1;
  while ( SPISlaveResetIn_b == 1 ) ; // Wait until the slave is reset
  SPISlaveResetOut = 0;
  while ( SPISlaveResetIn_b == 0 ) ; // Wait until the slave is ready

  Led1 = 0;

  while ( 1 )
  {

    // Send status request
    SPI0DAT = StatusRequest; while ( SPIF == 0 ); sdata = SPI0DAT; SPIF = 0;

    // Wait for status block
    while (sdata != Status )
    {
      SPI0DAT = Idle; while ( SPIF == 0 ); sdata = SPI0DAT; SPIF = 0;
    }

    // Data

    for (status_cnt=0;status_cnt<16;status_cnt++)
    {
       SPI0DAT = Idle;
       while ( SPIF == 0 );  // Wait for status byte
       packet.cdata[status_cnt+4] = SPI0DAT; // Read the byte from slave
       SPIF = 0;
    }

    P1 = packet.cdata[19];
    if (packet.cdata[19] != 0xde ) Led2 = 0; 
    if (packet.cdata[18] != 0xad ) Led2 = 0; 
    if (packet.cdata[17] != 0xfa ) Led2 = 0; 
    if (packet.cdata[16] != 0xce ) Led2 = 0; 

   }
  }

}

// SPI0_Init

void SPI0_Init(void)
{
  SPI0CFG  = 0x40; // MSTEN=1, CKPHA=0, CKPOL=0
  SPI0CKR  = 0x1;  // SPI clock rate
  ESPI0    = 0;    // Disable SPI0 interrupt (we do not use it) 
  SPI0CN   = 0x1;  // Enable
}

