//-----------------------------------------------------------------------------
// eventloop.c
// Standalone (no USB) chimaera event generation and readout exerciser
//-----------------------------------------------------------------------------

#include <c8051f320.h>        
#include <stddef.h>       
#include "USB_API.h"
#include "chimaera.h"

sbit Led1 = P2^2;                         // LED='1' means OFF
sbit Led2 = P2^3;
sbit SPISlaveResetIn_b = P0^3;            // ='1' when slave is ready
sbit SPISlaveResetOut = P0^6;             // Assert to reset slave

unsigned short nByte;
unsigned short nPacket;
unsigned short resetRequest = 0;
devicePacket_t packet;
unsigned short L1Count = 0;
unsigned short L1CountLast = 0;

void main(void) 
{
  unsigned short i,status_cnt;
  unsigned rc;
  BYTE sdata;

   PCA0MD &= ~0x40;                       // Disable Watchdog timer


   OSCICN |= 0x3; // System clock divide. Set for fastest system clock speed.

   SPI0_Init();

   IT01CF   = 0x0c;    // P0.4 INT0, active high
   IT0 = 0; 
           // INT0 type: 0=level 1=edge sensitive
   P0MDIN   = 0xFF;    // P0.0-7 set digital input
   P0MDOUT  = 0x45;    // P0.0,2,6 set push-pull (SCK,MOSI,ResetOut)
   P0       = ~0x45;   // Open-drain outputs set high impedance
   P1MDIN   = 0xFF;    // P1.0-7 set digital input
   P1MDOUT  = 0xFF;    // P1.0-7 set push-pull
   P1       = 0x00;    // P1.0-7 set low
   P2MDIN   = 0xFF;    // P2.0-7 set digital input
   P2MDOUT  = 0x0C;    // P2.2,3 set push-pull (LEDs)
   P2       = ~0x0C;   // Open-drain outputs set high impedance

   XBR0     = 0x02;    // Enable SPI IO    
   XBR1     = 0x40;    // Enable Crossbar

   Led1 = 1;
   Led2 = 1;
   SPISlaveResetOut = 0;

  while ( SPISlaveResetIn_b == 0 ) ; // Wait until the slave is ready

// Continuous transaction loop

  while ( 1 )
  {

    //    Led2 = 1;

    SPIF = 0;

  resetRequest = 0;
  SPISlaveResetOut = 1;
  while ( SPISlaveResetIn_b == 1 ) ; // Wait until the slave is reset
  SPISlaveResetOut = 0;
  while ( SPISlaveResetIn_b == 0 ) ; // Wait until the slave is ready

  while ( resetRequest == 0 )
  //  for ( i = 0; i<1000 ; i ++ )
  {

    SPI0DAT = Idle; while ( SPIF == 0 ); sdata = SPI0DAT; SPIF = 0;
    // Send event generate request
    SPI0DAT = GenerateLHCbEvent; while ( SPIF == 0 ); sdata = SPI0DAT; SPIF = 0;
    // Send Idle (give time for event to be buffered
    SPI0DAT = Idle; while ( SPIF == 0 ); sdata = SPI0DAT; SPIF = 0;
    SPI0DAT = Idle; while ( SPIF == 0 ); sdata = SPI0DAT; SPIF = 0;
    SPI0DAT = Idle; while ( SPIF == 0 ); sdata = SPI0DAT; SPIF = 0;
    SPI0DAT = Idle; while ( SPIF == 0 ); sdata = SPI0DAT; SPIF = 0;
    SPI0DAT = Idle; while ( SPIF == 0 ); sdata = SPI0DAT; SPIF = 0;
    // Send flush request

    SPI0DAT = FlushRequest; while ( SPIF == 0 ); sdata = SPI0DAT; SPIF = 0;
    // Send Idle to allow flush setup to complete
    SPI0DAT = Idle; while ( SPIF == 0 ); sdata = SPI0DAT; SPIF = 0;
    SPI0DAT = Idle; while ( SPIF == 0 ); sdata = SPI0DAT; SPIF = 0;
    SPI0DAT = Idle; while ( SPIF == 0 ); sdata = SPI0DAT; SPIF = 0;

    for ( nPacket=0; nPacket<10; nPacket++ )
    {

    // Send packet request
      SPI0DAT = PacketRequest; while ( SPIF == 0 ); sdata = SPI0DAT; SPIF = 0;

      // Wait for packet
      Led2 = 1;
      while ( sdata != Data )
      {
        SPI0DAT = Idle; while ( SPIF == 0 ); sdata = SPI0DAT; SPIF = 0;
      }
      Led2 = 0;
    // Receive the 64-byte packet

      for ( nByte=0; nByte < 64; nByte++ ) // Get the data packet
      {
        SPI0DAT = Idle; while ( SPIF == 0 );
        packet.cdata[nByte] = SPI0DAT;       // Read the byte from slave
        SPIF = 0;                            // Reset the interrupt flag
      }
      //      P1 = nPacket & 0xff;

      if ( nPacket == 0 )
      {
        P1 = packet.cdata[0];
	L1Count = packet.cdata[0];
        Led1 = 1;
        if ( L1Count != ((L1CountLast + 1)&0xff) )
	{
          Led1 = 0;
          break;
	}
        L1CountLast = L1Count;
      }


       SPI0DAT = Idle; while ( SPIF == 0 ); sdata = SPI0DAT; SPIF = 0;
       SPI0DAT = Idle; while ( SPIF == 0 ); sdata = SPI0DAT; SPIF = 0;
       SPI0DAT = Idle; while ( SPIF == 0 ); sdata = SPI0DAT; SPIF = 0;
    }

    //    while (1);
    //    resetRequest = 1;

   }
  //  while (1);
  }

}

// SPI0_Init

void SPI0_Init(void)
{
  SPI0CFG  = 0x40; // MSTEN=1, CKPHA=0, CKPOL=0
  SPI0CKR  = 0x0;  // SPI clock rate (0=maximum)
  ESPI0    = 0;    // Disable SPI0 interrupt (we do not use it) 
  SPI0CN   = 0x1;  // Enable
}

