//
//

#include <stdio.h>
#include <windows.h>
#include "SiUSBXp.h"
#include "chimaera.h"
#include "utils.h"

devicePacket_t cmdPacket;
devicePacket_t lastStatus;
devicePacket_t lastData;
bool quiet = false;
bool verbose = false;
unsigned char seq = 0;

int main( int argc, char **argv )
{

SI_STATUS rc;
unsigned maxLoops = 10;
unsigned char packetsRequested = 10;
bool quit = false;

// Find how many devices are attached

DWORD NumDevices;

  rc = SI_GetNumDevices( &NumDevices );
  if ( rc != SI_SUCCESS )
  {
    printf( "Si_GetNumDevices(): rc = %d\n", rc );
    exit(0);
  }

  // Identify the correct device

DWORD deviceIndex;
char deviceString[256];

  for (deviceIndex=0; deviceIndex<NumDevices; deviceIndex++ )
  {
    rc = SI_GetProductString( deviceIndex, deviceString, SI_RETURN_DESCRIPTION );
    if ( rc != SI_SUCCESS )
    {
      printf( "Si_GetProductString(): rc = %d\n", rc );
      exit(0);
    }
    printf( "SI_GetProductString(): [%d] [%s] rc = %d\n", deviceIndex, deviceString, rc );
    if ( !strcmp(deviceString,"Cavendish USB GPIO" ) || !strcmp(deviceString,"Cavendish Chimaera USB" ) ) break;
  }

  if ( deviceIndex == NumDevices )
  {
    printf( "Device not found\n", rc );
    exit(0);
  }

// Open the device

HANDLE deviceHandle;

    rc = SI_Open( deviceIndex, &deviceHandle );
    if ( rc != SI_SUCCESS )
    {
      printf( "Si_Open(): rc = %d\n", rc );
      exit(0);
    }

// Set the read and write timeout to 5s

    rc = SI_SetTimeouts(5000,5000);
    if ( rc != SI_SUCCESS )
    {
      printf( "Si_SetTimeouts(): rc = %d\n", rc );
      exit(0);
    }

    for ( unsigned arg=1;arg<argc;arg++ )
    {
      if ( !strcmp( argv[arg], "--maxLoops" ) )
      {
        maxLoops = strtoul(argv[arg+1],0,0);
        arg++;
      }
      else if ( !strcmp( argv[arg], "--packets" ) )
      {
        packetsRequested = strtoul(argv[arg+1],0,0) & 0xff;
        arg++;
      }
      else if ( !strcmp( argv[arg], "--verbose" ) )
      {
        verbose = true;
      }
      else if ( !strcmp( argv[arg], "--quiet" ) )
      {
        quiet = true;
      }
    }

    for ( unsigned loop=0; loop<maxLoops && !quit; loop++ )
    {
      printf( "---------- Loop %d -----------\n", loop );
      
      cmdPacket.cmd = deviceHeader_t::PacketRequest;
      cmdPacket.uc[0] = packetsRequested; // Number of packets
      requestDevice( deviceHandle, cmdPacket );

      for ( unsigned char nread=packetsRequested; nread && !quit; nread-- )
      {
        readDeviceData( deviceHandle, lastData, 68 );
        if ( !quiet ) showLastData( lastData );
        for ( unsigned char nByte=0; nByte<64 && !quit; nByte++ )
	{
          if (lastData.uc[nByte] != ((nByte + seq)&0xff))
	  {
            printf( "[%#x,%#x,%#x] %#x != %#x\n", nread, seq, nByte, lastData.uc[nByte], (seq+nByte)&0xff );
            showLastData( lastData );
            quit = true;
	  }
	}
        if ( lastData.cmd != deviceHeader_t::Data )
        {
	  printf( "cmd=%#x\n", lastData.cmd );
          quit = true;
        }
        seq++;
      }
    }

// Close the device

    rc = SI_Close( deviceHandle );
    if ( rc != SI_SUCCESS )
    {
      printf( "Si_Close(): rc = %d\n", rc );
      exit(0);
    }

}

