#if !defined(_chimaera_h)
#define _chimaera_h

// Command codes.
// NB: The same codes are used between USB host and MCU and between SPISlave and MCU

enum {
 Data = 0x1,
 DataAcknowledge = 0x2,
 Status = 0x3,
 StatusRequest = 0x4,
 FlushRequest = 0x5,
 PacketRequest = 0x6,
 GenerateLHCbEvent = 0x7,
 PIOWrite = 0x8,
 PIORead = 0x9,
 GenerateALICEEvent = 0xa,
 ResetRequest = 0xb,
 ConfigurationData = 0xc,
 Int0Enable = 0xd,
 Int0Disable = 0xe,
 Int0 = 0xf,
 Idle = 0xa5,
 Idle2 = 0x25
};

typedef struct devicePacket_t
{
  unsigned char cmd;
  unsigned char dummy;
  union
  {
    unsigned short us;
    unsigned char uc[2];
  } length;
  unsigned char cdata[68];
} devicePacket_t;

typedef struct devicePacketISR_t
{
  unsigned char cmd;
  unsigned char dummy;
  union
  {
    unsigned short us;
    unsigned char uc[2];
  } length;
  unsigned char cdata[4];
} devicePacketISR_t;

void Timer_Init(void);
void Adc_Init(void);
void Port_Init(void);
void SPI0_Init(void);
void Suspend_Device(void);
void Initialize(void);

#endif
