/*
*/

package cbsw.pbw;

import java.awt.*;
import java.awt.image.*;
import java.net.URL;
import java.util.Hashtable;


// A cache of resources (images, documents) used by the applet.

public class AppletResourceDB extends Component {

    private String[] images = 
    { 
            "redsquare16.gif", "greencircle16.gif"
    };

    private String[] helpDocuments = 
    { 
        "controlsText.html"//, "xxx.html"
    };

    public static Hashtable imageCache;
    public static Hashtable documentCache;

    public AppletResourceDB() {
        imageCache = new Hashtable(images.length);
        for (int i = 0; i < images.length; i++) {
            imageCache.put(images[i], getImage(images[i], this));
        }
        documentCache = new Hashtable(helpDocuments.length);
        for (int i = 0; i < helpDocuments.length; i++) {
            documentCache.put(helpDocuments[i], getDocument(helpDocuments[i], this));
        }
    }


    public static Image getImage(String fileName, Component cmp) {
        URL url = AppletResourceDB.class.getResource("images/" + fileName);
        if ( url == null ) System.out.println("Error loading image " + fileName);
        Image img = cmp.getToolkit().createImage(url);
        MediaTracker tracker = new MediaTracker(cmp);
        tracker.addImage(img, 0);
        try {
            tracker.waitForID(0);
            if (tracker.isErrorAny()) {
                System.out.println("Error loading image");
            }
        } catch (Exception ex) { ex.printStackTrace(); }
        return img;
    }
    public static URL getDocument(String fileName, Component cmp) {
        URL url = AppletResourceDB.class.getResource("help/" + fileName);
        if ( url == null ) System.out.println("Error loading document " + fileName);
        return url;
    }
}

