#include "utils.h"

int main( int argc, char **argv )
{
  char javaLibraryPath[256];

  char *j2sdk = getenv("J2SDK");
  if ( !j2sdk )
  {
    printf( "%s J2SDK environment variable undefined. Please set to the root of the J2SDK tree.\n", argv[0] );
    return 0;
  }

  char *sysroot = getenv("SYSTEMROOT");
  if ( !sysroot )
  {
    printf( "%s Fatal error. SYSTEMROOT environment variable undefined.\n", argv[0] );
    return 0;
  }
  else
  {
    printf( "%s Using %s as system root path.\n", argv[0], sysroot );
  }

  char *home = getenv("USERPROFILE");
  if ( home )
  {
    sprintf( javaLibraryPath, "-J-Djava.library.path=%s\\system32;%s\\bin", sysroot,home );
  }
  else
  {
    sprintf( javaLibraryPath, "-J-Djava.library.path=%s\\system32", sysroot );
  }

  for ( unsigned arg=1; arg<argc; arg++ )
  {
    if ( !strcmp( "--userDLLPath", argv[arg] ) )
    {
      sprintf( javaLibraryPath, "-J-Djava.library.path=%s\\system32;%s", sysroot, argv[arg+1] );
      arg++;
    }
  }

  printf( "%s %s\n", argv[0], javaLibraryPath );

  systemf( "%s\\bin\\appletviewer.exe -J-Djava.security.policy=pbw.policy \"%s\" PixieBoogieWoogie.html", j2sdk, javaLibraryPath );

  return 0;
}
