/*
A display applet

Steve Wotton, 2000
Cavendish Lab (HEP)
*/

package cbsw.applet;

import java.io.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.Graphics2D.*;
import java.awt.print.*;
import java.net.*;
import javax.print.attribute.*;
import javax.print.attribute.standard.*;
import java.applet.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.html.*;
import javax.swing.border.*;
import java.text.DateFormat;
import java.util.Date;
import cbsw.pbw.*;
//import CellArray.*;
//import cbsw.instrument.ChimaeraControl;
import java.util.prefs.Preferences;

public class JPixieBoogieWoogie extends JApplet implements Printable, ActionListener, ChangeListener {

Preferences prefs;

    //static final int nxAnodes = 3;
    //static final int nyAnodes = 1;
    //static final int nxPixels = 22;
    //static final int nyPixels = 22;

static final int nxAnodes = 2;
static final int nyAnodes = 2;
static final int nxPixels = 32;
static final int nyPixels = 32;

static final int xSize = 10;
static final int ySize = 10;

Timer timer;
int ticks;
int sleepyTime = 10;
PixieBoogieWoogie anode[][];
int bgWidth, bgHeight;
AppletResourceDB resources;

DataThread dth;
boolean threadStopFlag = true;
boolean onlineFlag = false;

URL dataURL;
Socket dataSocket;
InputStream dataInStream;
JEditorPane editorPane;
String dataSourceString;
String lockFileString;
File lockFile;

int runNumber = 0;
int lastRunNumber = 0;

JFrame graphicFrame = new JFrame( "PixieBoogieWoogie" );
Container contentPane;

JMenuBar menuBar = new JMenuBar();

// Control panel

JComboBox dataSourceCombo;
JComboBox lockFileCombo;

JScrollPane controlsText;

JButton clearButton;

JColorChooser colorChooser = new JColorChooser();
Color fgColor = Color.yellow;
Color bgColor = Color.blue;
Color gridColor = Color.black;

JSlider persistenceControl;
JSlider saturationControl;

JMenuItem fgMenuItem;
JMenuItem bgMenuItem;
JMenuItem gridMenuItem;

JRadioButtonMenuItem rotate0Button;
JRadioButtonMenuItem rotate90Button;
JRadioButtonMenuItem rotate180Button;
JRadioButtonMenuItem rotate270Button;

JRadioButtonMenuItem offsetM2;
JRadioButtonMenuItem offsetM1;
JRadioButtonMenuItem offset0;
JRadioButtonMenuItem offsetP1;
JRadioButtonMenuItem offsetP2;

int decodeOffset = 0;

JRadioButtonMenuItem onlineButton, clearEventButton, clearBurstButton, adaptiveButton;

int persistence;
int saturation;

boolean autoClearEvent = false;
boolean autoClearBurst = true;
boolean adaptiveDisplay = false;

// This flag is not a configuration switch. It is set using info from the print job.
boolean printMono = false;

int eventCount=0, hitCount=0;

public static final int[] pid =
{
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    1,    2,    3,    4,    5,    6,    7,    8,    1,    2,    3,    4,    5,    6,    7,    8,    9,   10,   11,   12,   13,   14,   15,   16,    9,   10,   11,   12,   13,   14,   15,   16,   17,   18,   19,   20,   21,   22,   23,   24,   17,   18,   19,   20,   21,   22,   23,   24,   25,   26,   27,   28,   29,   30,   31,   32,   25,   26,   27,   28,   29,   30,   31,   32,   33,   34,   35,   36,   37,   38,   39,   40,   33,   34,   35,   36,   37,   38,   39,   40,   41,   42,   43,   44,   45,   46,   47,   48,   41,   42,   43,   44,   45,   46,   47,   48,   49,   50,   51,   52,   53,   54,   55,   56,   49,   50,   51,   52,   53,   54,   55,   56,   57,   58,   59,   60,   61,   62,   63,   64,   57,   58,   59,   60,   61,   62,   63,   64,    0,    0,    0,    0

    //    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,   48,   25,   80,  112,   64,    9,   96,  128,   49,   17,   72,  113,   33,    1,   88,   97,   47,   26,   79,  111,   63,   10,   95,  127,   50,   18,   71,  114,   34,    2,   87,   98,   46,   27,   78,  110,   62,   11,   94,  126,   51,   19,   70,  115,   35,    3,   86,   99,   45,   28,   77,  109,   61,   12,   93,  125,   52,   20,   69,  116,   36,    4,   85,  100,   44,   29,   76,  108,   60,   13,   92,  124,   53,   21,   68,  117,   37,    5,   84,  101,   43,   30,   75,  107,   59,   14,   91,  123,   54,   22,   67,  118,   38,    6,   83,  102,   42,   31,   74,  106,   58,   15,   90,  122,   55,   23,   66,  119,   39,    7,   82,  103,   41,   32,   73,  105,   57,   16,   89,  121,   56,   24,   65,  120,   40,    8,   81,  104,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0
    //    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,   48,   25,   80,  112,   64,    9,   96,  128,   49,   17,   72,  113,   33,    1,   88,   97,   47,   26,   79,  111,   63,   10,   95,  127,   50,   18,   71,  114,   34,    2,   87,   98,   46,   27,   78,  110,   62,   11,   94,  126,   51,   19,   70,  115,   35,    3,   86,   99,   45,   28,   77,  109,   61,   12,   93,  125,   52,   20,   69,  116,   36,    4,   85,  100,   44,   29,   76,  108,   60,   13,   92,  124,   53,   21,   68,  117,   37,    5,   84,  101,   43,   30,   75,  107,   59,   14,   91,  123,   54,   22,   67,  118,   38,    6,   83,  102,   42,   31,   74,  106,   58,   15,   90,  122,   55,   23,   66,  119,   39,    7,   82,  103,   41,   32,   73,  105,   57,   16,   89,  121,   56,   24,   65,  120,   40,    8,   81,  104,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0
};

static final int ndChannels=8;

public static final int[][] cid =
{
    {  0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5, 0x40, 0x40, 0x40, 0x40 },
    {  0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1, 0x40, 0x40, 0x40, 0x40 },
    {  0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7, 0x40, 0x40, 0x40, 0x40 },
    {  0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3, 0x40, 0x40, 0x40, 0x40 },
    {  0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,  0x8,  0x8,  0x8,  0x8,  0x8,  0x8,  0x8,  0x8,  0x9,  0x9,  0x9,  0x9,  0x9,  0x9,  0x9,  0x9,  0x8,  0x8,  0x8,  0x8,  0x8,  0x8,  0x8,  0x8,  0x9,  0x9,  0x9,  0x9,  0x9,  0x9,  0x9,  0x9,  0x8,  0x8,  0x8,  0x8,  0x8,  0x8,  0x8,  0x8,  0x9,  0x9,  0x9,  0x9,  0x9,  0x9,  0x9,  0x9,  0x8,  0x8,  0x8,  0x8,  0x8,  0x8,  0x8,  0x8,  0x9,  0x9,  0x9,  0x9,  0x9,  0x9,  0x9,  0x9,  0x8,  0x8,  0x8,  0x8,  0x8,  0x8,  0x8,  0x8,  0x9,  0x9,  0x9,  0x9,  0x9,  0x9,  0x9,  0x9,  0x8,  0x8,  0x8,  0x8,  0x8,  0x8,  0x8,  0x8,  0x9,  0x9,  0x9,  0x9,  0x9,  0x9,  0x9,  0x9,  0x8,  0x8,  0x8,  0x8,  0x8,  0x8,  0x8,  0x8,  0x9,  0x9,  0x9,  0x9,  0x9,  0x9,  0x9,  0x9,  0x8,  0x8,  0x8,  0x8,  0x8,  0x8,  0x8,  0x8,  0x9,  0x9,  0x9,  0x9,  0x9,  0x9,  0x9,  0x9, 0x40, 0x40, 0x40, 0x40 },
    {  0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,  0xa,  0xa,  0xa,  0xa,  0xa,  0xa,  0xa,  0xa,  0xb,  0xb,  0xb,  0xb,  0xb,  0xb,  0xb,  0xb,  0xa,  0xa,  0xa,  0xa,  0xa,  0xa,  0xa,  0xa,  0xb,  0xb,  0xb,  0xb,  0xb,  0xb,  0xb,  0xb,  0xa,  0xa,  0xa,  0xa,  0xa,  0xa,  0xa,  0xa,  0xb,  0xb,  0xb,  0xb,  0xb,  0xb,  0xb,  0xb,  0xa,  0xa,  0xa,  0xa,  0xa,  0xa,  0xa,  0xa,  0xb,  0xb,  0xb,  0xb,  0xb,  0xb,  0xb,  0xb,  0xa,  0xa,  0xa,  0xa,  0xa,  0xa,  0xa,  0xa,  0xb,  0xb,  0xb,  0xb,  0xb,  0xb,  0xb,  0xb,  0xa,  0xa,  0xa,  0xa,  0xa,  0xa,  0xa,  0xa,  0xb,  0xb,  0xb,  0xb,  0xb,  0xb,  0xb,  0xb,  0xa,  0xa,  0xa,  0xa,  0xa,  0xa,  0xa,  0xa,  0xb,  0xb,  0xb,  0xb,  0xb,  0xb,  0xb,  0xb,  0xa,  0xa,  0xa,  0xa,  0xa,  0xa,  0xa,  0xa,  0xb,  0xb,  0xb,  0xb,  0xb,  0xb,  0xb,  0xb, 0x40, 0x40, 0x40, 0x40 },
    {  0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,  0xc,  0xc,  0xc,  0xc,  0xc,  0xc,  0xc,  0xc,  0xd,  0xd,  0xd,  0xd,  0xd,  0xd,  0xd,  0xd,  0xc,  0xc,  0xc,  0xc,  0xc,  0xc,  0xc,  0xc,  0xd,  0xd,  0xd,  0xd,  0xd,  0xd,  0xd,  0xd,  0xc,  0xc,  0xc,  0xc,  0xc,  0xc,  0xc,  0xc,  0xd,  0xd,  0xd,  0xd,  0xd,  0xd,  0xd,  0xd,  0xc,  0xc,  0xc,  0xc,  0xc,  0xc,  0xc,  0xc,  0xd,  0xd,  0xd,  0xd,  0xd,  0xd,  0xd,  0xd,  0xc,  0xc,  0xc,  0xc,  0xc,  0xc,  0xc,  0xc,  0xd,  0xd,  0xd,  0xd,  0xd,  0xd,  0xd,  0xd,  0xc,  0xc,  0xc,  0xc,  0xc,  0xc,  0xc,  0xc,  0xd,  0xd,  0xd,  0xd,  0xd,  0xd,  0xd,  0xd,  0xc,  0xc,  0xc,  0xc,  0xc,  0xc,  0xc,  0xc,  0xd,  0xd,  0xd,  0xd,  0xd,  0xd,  0xd,  0xd,  0xc,  0xc,  0xc,  0xc,  0xc,  0xc,  0xc,  0xc,  0xd,  0xd,  0xd,  0xd,  0xd,  0xd,  0xd,  0xd, 0x40, 0x40, 0x40, 0x40 },
    {  0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,  0xe,  0xe,  0xe,  0xe,  0xe,  0xe,  0xe,  0xe,  0xf,  0xf,  0xf,  0xf,  0xf,  0xf,  0xf,  0xf,  0xe,  0xe,  0xe,  0xe,  0xe,  0xe,  0xe,  0xe,  0xf,  0xf,  0xf,  0xf,  0xf,  0xf,  0xf,  0xf,  0xe,  0xe,  0xe,  0xe,  0xe,  0xe,  0xe,  0xe,  0xf,  0xf,  0xf,  0xf,  0xf,  0xf,  0xf,  0xf,  0xe,  0xe,  0xe,  0xe,  0xe,  0xe,  0xe,  0xe,  0xf,  0xf,  0xf,  0xf,  0xf,  0xf,  0xf,  0xf,  0xe,  0xe,  0xe,  0xe,  0xe,  0xe,  0xe,  0xe,  0xf,  0xf,  0xf,  0xf,  0xf,  0xf,  0xf,  0xf,  0xe,  0xe,  0xe,  0xe,  0xe,  0xe,  0xe,  0xe,  0xf,  0xf,  0xf,  0xf,  0xf,  0xf,  0xf,  0xf,  0xe,  0xe,  0xe,  0xe,  0xe,  0xe,  0xe,  0xe,  0xf,  0xf,  0xf,  0xf,  0xf,  0xf,  0xf,  0xf,  0xe,  0xe,  0xe,  0xe,  0xe,  0xe,  0xe,  0xe,  0xf,  0xf,  0xf,  0xf,  0xf,  0xf,  0xf,  0xf, 0x40, 0x40, 0x40, 0x40 }

 //   {  0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40 },
 //   {  0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40 },
 //   {  0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40 },
 //   {  0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3,  0x3, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40 },
 //   {  0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40 },
 //   {  0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5,  0x5, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40 },
 //   {  0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6,  0x6, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40 },
 //   {  0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7,  0x7, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40 }
 // 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,  0x1,  0x1,  0x0,  0x0,  0x1,  0x1,  0x0,  0x0,  0x1,  0x1,  0x0,  0x0,  0x1,  0x1,  0x0,  0x0,  0x1,  0x1,  0x0,  0x0,  0x1,  0x1,  0x0,  0x0,  0x1,  0x1,  0x0,  0x0,  0x1,  0x1,  0x0,  0x0,  0x1,  0x1,  0x0,  0x0,  0x1,  0x1,  0x0,  0x0,  0x1,  0x1,  0x0,  0x0,  0x1,  0x1,  0x0,  0x0,  0x1,  0x1,  0x0,  0x0,  0x1,  0x1,  0x0,  0x0,  0x1,  0x1,  0x0,  0x0,  0x1,  0x1,  0x0,  0x0,  0x1,  0x1,  0x0,  0x0,  0x1,  0x1,  0x0,  0x0,  0x1,  0x1,  0x0,  0x0,  0x1,  0x1,  0x0,  0x0,  0x1,  0x1,  0x0,  0x0,  0x1,  0x1,  0x0,  0x0,  0x1,  0x1,  0x0,  0x0,  0x1,  0x1,  0x0,  0x0,  0x1,  0x1,  0x0,  0x0,  0x1,  0x1,  0x0,  0x0,  0x1,  0x1,  0x0,  0x0,  0x1,  0x1,  0x0,  0x0,  0x1,  0x1,  0x0,  0x0,  0x1,  0x1,  0x0,  0x0,  0x1,  0x1,  0x0,  0x0,  0x1,  0x1,  0x0,  0x0, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40
};

public int[][] sumadc = new int[ndChannels][160];
public int[][] nadc = new int[ndChannels][160];

public static final int[] SiPixid =
{
    1,   23,   45,   67,   89,  111,  133,  155,  177,   46,   68,   90,  112,  134,  156,  178,
   47,   69,   91,  113,  135,  157,  179,  201,  200,  199,   92,  114,  136,  158,  180,  202,
   93,  115,  137,  159,  181,  203,  138,  160,  182,  204,  139,  161,  183,  205,  184,  206,
  185,  207,  221,  222,  223,  224,  225,  226,  227,  228,  229,  230,  231,    0,    0,    0,
    0,    0,    0,  253,  252,  251,  250,  249,  248,  247,  246,  245,  244,  243,  273,  295,
  272,  294,  271,  293,  315,  337,  270,  292,  314,  336,  269,  291,  313,  335,  357,  379,
  268,  290,  312,  334,  356,  378,  265,  266,  267,  289,  311,  333,  355,  377,  399,  421,
  288,  310,  332,  354,  376,  398,  420,  287,  309,  331,  353,  375,  397,  419,  441,  463,
    0,   21,   20,   19,   18,   17,   16,   15,   14,   42,   41,   40,   39,   38,   37,   36,
   43,   63,   62,   61,   60,   59,   58,   57,   35,   13,   84,   83,   82,   81,   80,   79,
   85,  105,  104,  103,  102,  101,  126,  125,  124,  123,  127,  147,  146,  145,  168,  167,
  169,  189,   12,   34,   56,   78,  100,  122,  144,  166,  188,  210,  211,    0,    0,    0,
    0,    0,    0,  208,  209,  187,  165,  143,  121,   99,   77,   55,   33,   11,  186,  162,
  164,  163,  142,  141,  140,  116,  120,  119,  118,  117,   98,   97,   96,   95,   94,   70,
   76,   75,   74,   73,   72,   71,   10,   32,   54,   53,   52,   51,   50,   49,   48,   24,
   31,   30,   29,   28,   27,   26,   25,    9,    8,    7,    6,    5,    4,    3,    2,    0,
  484,  462,  440,  418,  396,  374,  352,  330,  308,  439,  417,  395,  373,  351,  329,  307,
  438,  416,  394,  372,  350,  328,  306,  284,  285,  286,  393,  371,  349,  327,  305,  283,
  392,  370,  348,  326,  304,  282,  347,  325,  303,  281,  346,  324,  302,  280,  301,  279,
  300,  278,  264,  263,  262,  261,  260,  259,  258,  257,  256,  255,  254,    0,    0,    0,
    0,    0,    0,  232,  233,  234,  235,  236,  237,  238,  239,  240,  241,  242,  212,  190,
  213,  191,  214,  192,  170,  148,  215,  193,  171,  149,  216,  194,  172,  150,  128,  106,
  217,  195,  173,  151,  129,  107,  220,  219,  218,  196,  174,  152,  130,  108,   86,   64,
  197,  175,  153,  131,  109,   87,   65,  198,  176,  154,  132,  110,   88,   66,   44,   22,
    0,  464,  465,  466,  467,  468,  469,  470,  471,  443,  444,  445,  446,  447,  448,  449,
  442,  422,  423,  424,  425,  426,  427,  428,  450,  472,  401,  402,  403,  404,  405,  406,
  400,  380,  381,  382,  383,  384,  359,  360,  361,  362,  358,  338,  339,  340,  317,  318,
  316,  296,  473,  451,  429,  407,  385,  363,  341,  319,  297,  275,  274,    0,    0,    0,
    0,    0,    0,  277,  276,  298,  320,  342,  364,  386,  408,  430,  452,  474,  299,  323,
  321,  322,  343,  344,  345,  369,  365,  366,  367,  368,  387,  388,  389,  390,  391,  415,
  409,  410,  411,  412,  413,  414,  475,  453,  431,  432,  433,  434,  435,  436,  437,  461,
  454,  455,  456,  457,  458,  459,  460,  476,  477,  478,  479,  480,  481,  482,  483,    0,
  513,  535,  557,  579,  601,  623,  645,  667,  689,  558,  580,  602,  624,  646,  668,  690,
  559,  581,  603,  625,  647,  669,  691,  713,  712,  711,  604,  626,  648,  670,  692,  714,
  605,  627,  649,  671,  693,  715,  650,  672,  694,  716,  651,  673,  695,  717,  696,  718,
  697,  719,  733,  734,  735,  736,  737,  738,  739,  740,  741,  742,  743,  512,  512,  512,
  512,  512,  512,  765,  764,  763,  762,  761,  760,  759,  758,  757,  756,  755,  785,  807,
  784,  806,  783,  805,  827,  849,  782,  804,  826,  848,  781,  803,  825,  847,  869,  891,
  780,  802,  824,  846,  868,  890,  777,  778,  779,  801,  823,  845,  867,  889,  911,  933,
  800,  822,  844,  866,  888,  910,  932,  799,  821,  843,  865,  887,  909,  931,  953,  975,
  512,  533,  532,  531,  530,  529,  528,  527,  526,  554,  553,  552,  551,  550,  549,  548,
  555,  575,  574,  573,  572,  571,  570,  569,  547,  525,  596,  595,  594,  593,  592,  591,
  597,  617,  616,  615,  614,  613,  638,  637,  636,  635,  639,  659,  658,  657,  680,  679,
  681,  701,  524,  546,  568,  590,  612,  634,  656,  678,  700,  722,  723,  512,  512,  512,
  512,  512,  512,  720,  721,  699,  677,  655,  633,  611,  589,  567,  545,  523,  698,  674,
  676,  675,  654,  653,  652,  628,  632,  631,  630,  629,  610,  609,  608,  607,  606,  582,
  588,  587,  586,  585,  584,  583,  522,  544,  566,  565,  564,  563,  562,  561,  560,  536,
  543,  542,  541,  540,  539,  538,  537,  521,  520,  519,  518,  517,  516,  515,  514,  512,
  996,  974,  952,  930,  908,  886,  864,  842,  820,  951,  929,  907,  885,  863,  841,  819,
  950,  928,  906,  884,  862,  840,  818,  796,  797,  798,  905,  883,  861,  839,  817,  795,
  904,  882,  860,  838,  816,  794,  859,  837,  815,  793,  858,  836,  814,  792,  813,  791,
  812,  790,  776,  775,  774,  773,  772,  771,  770,  769,  768,  767,  766,  512,  512,  512,
  512,  512,  512,  744,  745,  746,  747,  748,  749,  750,  751,  752,  753,  754,  724,  702,
  725,  703,  726,  704,  682,  660,  727,  705,  683,  661,  728,  706,  684,  662,  640,  618,
  729,  707,  685,  663,  641,  619,  732,  731,  730,  708,  686,  664,  642,  620,  598,  576,
  709,  687,  665,  643,  621,  599,  577,  710,  688,  666,  644,  622,  600,  578,  556,  534,
  512,  976,  977,  978,  979,  980,  981,  982,  983,  955,  956,  957,  958,  959,  960,  961,
  954,  934,  935,  936,  937,  938,  939,  940,  962,  984,  913,  914,  915,  916,  917,  918,
  912,  892,  893,  894,  895,  896,  871,  872,  873,  874,  870,  850,  851,  852,  829,  830,
  828,  808,  985,  963,  941,  919,  897,  875,  853,  831,  809,  787,  786,  512,  512,  512,
  512,  512,  512,  789,  788,  810,  832,  854,  876,  898,  920,  942,  964,  986,  811,  835,
  833,  834,  855,  856,  857,  881,  877,  878,  879,  880,  899,  900,  901,  902,  903,  927,
  921,  922,  923,  924,  925,  926,  987,  965,  943,  944,  945,  946,  947,  948,  949,  973,
  966,  967,  968,  969,  970,  971,  972,  988,  989,  990,  991,  992,  993,  994,  995,  512,
 1025, 1047, 1069, 1091, 1113, 1135, 1157, 1179, 1201, 1070, 1092, 1114, 1136, 1158, 1180, 1202,
 1071, 1093, 1115, 1137, 1159, 1181, 1203, 1225, 1224, 1223, 1116, 1138, 1160, 1182, 1204, 1226,
 1117, 1139, 1161, 1183, 1205, 1227, 1162, 1184, 1206, 1228, 1163, 1185, 1207, 1229, 1208, 1230,
 1209, 1231, 1245, 1246, 1247, 1248, 1249, 1250, 1251, 1252, 1253, 1254, 1255, 1024, 1024, 1024,
 1024, 1024, 1024, 1277, 1276, 1275, 1274, 1273, 1272, 1271, 1270, 1269, 1268, 1267, 1297, 1319,
 1296, 1318, 1295, 1317, 1339, 1361, 1294, 1316, 1338, 1360, 1293, 1315, 1337, 1359, 1381, 1403,
 1292, 1314, 1336, 1358, 1380, 1402, 1289, 1290, 1291, 1313, 1335, 1357, 1379, 1401, 1423, 1445,
 1312, 1334, 1356, 1378, 1400, 1422, 1444, 1311, 1333, 1355, 1377, 1399, 1421, 1443, 1465, 1487,
 1024, 1045, 1044, 1043, 1042, 1041, 1040, 1039, 1038, 1066, 1065, 1064, 1063, 1062, 1061, 1060,
 1067, 1087, 1086, 1085, 1084, 1083, 1082, 1081, 1059, 1037, 1108, 1107, 1106, 1105, 1104, 1103,
 1109, 1129, 1128, 1127, 1126, 1125, 1150, 1149, 1148, 1147, 1151, 1171, 1170, 1169, 1192, 1191,
 1193, 1213, 1036, 1058, 1080, 1102, 1124, 1146, 1168, 1190, 1212, 1234, 1235, 1024, 1024, 1024,
 1024, 1024, 1024, 1232, 1233, 1211, 1189, 1167, 1145, 1123, 1101, 1079, 1057, 1035, 1210, 1186,
 1188, 1187, 1166, 1165, 1164, 1140, 1144, 1143, 1142, 1141, 1122, 1121, 1120, 1119, 1118, 1094,
 1100, 1099, 1098, 1097, 1096, 1095, 1034, 1056, 1078, 1077, 1076, 1075, 1074, 1073, 1072, 1048,
 1055, 1054, 1053, 1052, 1051, 1050, 1049, 1033, 1032, 1031, 1030, 1029, 1028, 1027, 1026, 1024,
 1508, 1486, 1464, 1442, 1420, 1398, 1376, 1354, 1332, 1463, 1441, 1419, 1397, 1375, 1353, 1331,
 1462, 1440, 1418, 1396, 1374, 1352, 1330, 1308, 1309, 1310, 1417, 1395, 1373, 1351, 1329, 1307,
 1416, 1394, 1372, 1350, 1328, 1306, 1371, 1349, 1327, 1305, 1370, 1348, 1326, 1304, 1325, 1303,
 1324, 1302, 1288, 1287, 1286, 1285, 1284, 1283, 1282, 1281, 1280, 1279, 1278, 1024, 1024, 1024,
 1024, 1024, 1024, 1256, 1257, 1258, 1259, 1260, 1261, 1262, 1263, 1264, 1265, 1266, 1236, 1214,
 1237, 1215, 1238, 1216, 1194, 1172, 1239, 1217, 1195, 1173, 1240, 1218, 1196, 1174, 1152, 1130,
 1241, 1219, 1197, 1175, 1153, 1131, 1244, 1243, 1242, 1220, 1198, 1176, 1154, 1132, 1110, 1088,
 1221, 1199, 1177, 1155, 1133, 1111, 1089, 1222, 1200, 1178, 1156, 1134, 1112, 1090, 1068, 1046,
 1024, 1488, 1489, 1490, 1491, 1492, 1493, 1494, 1495, 1467, 1468, 1469, 1470, 1471, 1472, 1473,
 1466, 1446, 1447, 1448, 1449, 1450, 1451, 1452, 1474, 1496, 1425, 1426, 1427, 1428, 1429, 1430,
 1424, 1404, 1405, 1406, 1407, 1408, 1383, 1384, 1385, 1386, 1382, 1362, 1363, 1364, 1341, 1342,
 1340, 1320, 1497, 1475, 1453, 1431, 1409, 1387, 1365, 1343, 1321, 1299, 1298, 1024, 1024, 1024,
 1024, 1024, 1024, 1301, 1300, 1322, 1344, 1366, 1388, 1410, 1432, 1454, 1476, 1498, 1323, 1347,
 1345, 1346, 1367, 1368, 1369, 1393, 1389, 1390, 1391, 1392, 1411, 1412, 1413, 1414, 1415, 1439,
 1433, 1434, 1435, 1436, 1437, 1438, 1499, 1477, 1455, 1456, 1457, 1458, 1459, 1460, 1461, 1485,
 1478, 1479, 1480, 1481, 1482, 1483, 1484, 1500, 1501, 1502, 1503, 1504, 1505, 1506, 1507, 1024
};

public class EOFException extends Exception
{
    public EOFException(){;}
};

public int readInt( InputStream s ) throws EOFException, IOException
{
int result = 0;

  try
  {
    for ( int i=0;i<4;i++ )
    {
      int c = s.read();
      if ( c == -1 )
      {
	 throw new EOFException();
      }
      result = result + (c << (8*i));
    }
  }
  catch ( IOException ioe )
  {
    throw ioe;
  }

  return result;
}

public int readShort( InputStream s ) throws EOFException, IOException
{
int result = 0;

  try
  {
    for ( int i=0;i<2;i++ )
    {
      int c = s.read();
      if ( c == -1 )
      {
	 throw new EOFException();
      }
       result = result + (c << (8*i));
    }
  }
  catch ( IOException ioe )
  {
    throw ioe;
  }

  return result;
}

public void read_01020304() throws EOFException, IOException
{
      int x,y;
      int adc, dch, sample, samples, channel, channels, bytesPerSample, scale, mean, sigma;

      try
      {
// This decoding implements a simple pedestal subtraction which assumes that
// the probability of a hit in a pixel is very low.

          dch = readInt(dataInStream);
	  //          System.out.println( "Channel # = " + dch );

          samples = readInt(dataInStream);
	  //          System.out.println( "Samples per channel = " + samples );

          x = readInt(dataInStream);
	  //          System.out.println( "Bytes per sample = " + x );

          for ( sample=0; sample<samples; sample++ )
          {
            adc = readShort(dataInStream);
	    // Update accumulators for mean adc estimate
            sumadc[dch][sample] += adc;
            nadc[dch][sample]++;
            if ( sample >= (samples - 5 ) ) continue;
	    //            if ( (sample < 24) && (dch == 0)) System.out.println( "#" + sample + " " + adc + " " + pid[sample] + " " + cid[dch][sample]);
            int pmtid = cid[dch][sample];
            if ( (pmtid == 0x40) || (pmtid == 0x60) ) continue;
            int pixid = (pid[sample] - 1) & 0x3f;
            x = pixid%8 + 8*(pmtid%2);
            y = pixid/8;
	    // Display if significantly larger than the average for this pixel
            if ( (adc - sumadc[dch][sample]/nadc[dch][sample]) > 5 ) anode[pmtid/4][(pmtid/2)%2].hitPixel( x, y );
          }
      }
      catch ( EOFException eof )
      {
	 throw eof;
      }
      catch ( IOException ioe )
      {
         throw ioe;
      }
}

public void read_01020300() throws EOFException, IOException
{
      int x,y;
      int adc, dch, sample, samples, channel, channels, bytesPerSample, scale, mean, sigma;

      try
      {
          dch = readInt(dataInStream);
	  System.out.println( "Channel # = " + dch );

          samples = readInt(dataInStream);
	  //          System.out.println( "Samples per channel = " + samples );

          x = readInt(dataInStream);
	  //          System.out.println( "Bytes per sample = " + x );

          for ( ;; )
          {
            int id = readShort(dataInStream);
            if ( id == 0xffff ) break;
            adc = readShort(dataInStream);
            sample = (id & 0xff);
	    System.out.println( "sample = " + sample + " id = " + id + " adc = " + adc );
            if ( sample >= 160 ) continue;
            int pmtid = cid[dch][sample];
            if ( pmtid == 0x40 ) continue;
            pmtid += (2 * dch);
            int pixid = (pid[sample] - 1) & 0x3f;
            y = pixid%8 + (8 * (pmtid%4));
            x = 7 - pixid/8 + (8 * (pmtid/4));
            anode[0][0].hitPixel( x, y );
          }
      }
      catch ( EOFException eof )
      {
	 throw eof;
      }
      catch ( IOException ioe )
      {
         throw ioe;
      }
}

public void read_02020202() throws EOFException, IOException
{
      int x,y;
      int adc, dch, sample, samples, channel, channels, bytesPerSample, scale, mean, sigma;

      try
      {
          x = readInt(dataInStream);
          for ( int i=0; i < x; i++ )
	  {
            readInt(dataInStream);
	  }
      }
      catch ( EOFException eof )
      {
	 throw eof;
      }
      catch ( IOException ioe )
      {
         throw ioe;
      }
}

public void read_04040404() throws EOFException, IOException
{
      int x,y;
      int adc, dch, sample, samples, channel, channels, bytesPerSample, scale, mean, sigma;

      try
      {
           channels = readInt(dataInStream);
           samples = readInt(dataInStream);

           for ( channel=0; channel<channels; channel++ )
           {
	      scale = readInt(dataInStream);
              for ( int i=0; i<samples; i++ )
              {
                 sigma = readInt(dataInStream);
                 mean = readInt(dataInStream);
              }
           }
      }
      catch ( EOFException eof )
      {
	 throw eof;
      }
      catch ( IOException ioe )
      {
         throw ioe;
      }
}

public void read_c0d0e0ff() throws EOFException, IOException
{
      int x,y;
      int adc, dch, sample, samples, channel, channels, bytesPerSample, scale, mean, sigma;

      try
      {
            channel = readInt(dataInStream);
            samples = readInt(dataInStream);
            bytesPerSample = readInt(dataInStream);
            
            sample = readInt(dataInStream);
            while ( sample != 0xc0d0e0f1 )
	    {
	       adc = readInt(dataInStream);
               int siid = (sample & 0x7ff);
               int id = 0;
               if ( siid < (0x400 - decodeOffset) )
		   id = siid + decodeOffset;
               else
		   id = siid + decodeOffset - 1;
               int pixid = SiPixid[id]%0x200 - 1;
               int plane = SiPixid[id]/0x200;

               if ( pixid > -1 )
	       {
                  x = pixid%22;
                  y = pixid/22;
                  anode[plane][0].hitPixel( x, y, ((double)adc)/100.0 );
		  //                  if ( plane == 1 && x == 21 ) System.out.println( "siid=" + siid + " id=" + id + " pixid=" + pixid + " x=" + x + " y=" + y );
	       }

               sample = readInt(dataInStream);
            }
      }
      catch ( EOFException eof )
      {
	 throw eof;
      }
      catch ( IOException ioe )
      {
         throw ioe;
      }
}

public void read_f11c0000() throws EOFException, IOException
{
      int xAnode,yAnode;
      int mode, wc32, L0H0, L0H1, L0P, L1H0;
      int eventCountBurst, hitCountBurst;
      int word;

      eventCountBurst = 0;
      hitCountBurst = 0;
      mode = 0;

      if ( autoClearBurst == true )
      {
	  for (int ix = 0; ix < nxAnodes; ix ++ )
	  {
	    for (int iy = 0; iy < nyAnodes; iy ++ )
	    {
		anode[ix][iy].clear();
	    }
	  }
      }

      try
      {
	  wc32 = readInt(dataInStream); // Word count
	  System.out.println( "wc = " + wc32 );
            
          while ( wc32 > 0 )
	  {
               L1H0 = readInt(dataInStream); // L1 header word
               L0H0 = readInt(dataInStream); // L0 header word 0
               L0H1 = readInt(dataInStream); // L0 header word 1
// Decode LHCb or ALICE mode from header
               mode = 0;
// Decode the data source from the HPD/module ID in the header
               xAnode = 0;
               yAnode = 0;

               if ( autoClearEvent == true )
	       {
		 anode[xAnode][yAnode].clear();
	       }
          try
	  {
            Thread.sleep(sleepyTime);
	  }
          catch ( InterruptedException inte )
	  {
            System.err.println("Warning: " + inte.getMessage() );
	  }

	       System.out.println( "Event # " + eventCount );
               eventCount += 1;
               eventCountBurst += 1;

               for (int row = 32; row > 0; row-- )
	       {
		 if ( mode == 0 ) // LHCb mode
		 {
		   word = readInt(dataInStream);
		 }
                 else // ALICE mode, make OR of mini-pixels
		 {
		   word = 0;
		   for ( int mini_row = 8; mini_row > 0; mini_row-- )
		   {
		       word |= readInt(dataInStream);
		   }
		 }
                 for (int column = 0; column < 32; column++ )
		 {
		   if ( ((1 << column) & word ) == (1<<column) )
		   {
	             anode[xAnode][yAnode].hitPixel( column, row, 1.0 );
                     hitCount += 1;
                     hitCountBurst += 1;
		   }
	         }
               }

	       L0P = readInt(dataInStream); // Parity

               wc32 -= 36;
	  }

	  word = readInt(dataInStream); // End-of-block code
          float hitRateBurst = (float)hitCountBurst / (float)eventCountBurst ;
          float hitRate = (float)hitCount / (float)eventCount ;
	  System.out.println( "Hit counts (burst,total): (" + hitCountBurst + "/" + eventCountBurst + " = " + hitRateBurst + " ppe," + hitCount + "/" + eventCount + " = " + hitRate + " ppe)" );
	  //          threadStopFlag = true;

      }
      catch ( EOFException eof )
      {
	 throw eof;
      }
      catch ( IOException ioe )
      {
         throw ioe;
      }
}
public void read_11030000() throws EOFException, IOException
{
      int xAnode,yAnode;
      int mode, wc32, L0H0, L0H1, L0P, L1H0;
      int eventCountBurst, hitCountBurst;
      int word;

      eventCountBurst = 0;
      hitCountBurst = 0;
      mode = 0;

      if ( autoClearBurst == true )
      {
	  for (int ix = 0; ix < nxAnodes; ix ++ )
	  {
	    for (int iy = 0; iy < nyAnodes; iy ++ )
	    {
		anode[ix][iy].clear();
	    }
	  }
      }

      try
      {

//         try
// 	{
//           Thread.sleep(sleepyTime);
// 	}
//         catch ( InterruptedException inte )
// 	{
//           System.err.println("Warning: " + inte.getMessage() );
// 	}

	System.out.println( "Event # " + eventCount );
        eventCount += 1;
        eventCountBurst += 1;

	for ( yAnode = 0; yAnode < 2; yAnode++ )
	{

        L1H0 = readInt(dataInStream); // L1 header word
        L0H0 = readInt(dataInStream); // L0 header word 0
        L0H1 = readInt(dataInStream); // L0 header word 1
// Decode LHCb or ALICE mode from header
        mode = 0;
// Decode the data source from the HPD/module ID in the header
        xAnode = 0;

        if ( autoClearEvent == true )
	{
	  anode[xAnode][yAnode].clear();
	}

        for (int row = 31; row >= 0; row-- )
	{
	  if ( mode == 0 ) // LHCb mode
	  {
	    word = readInt(dataInStream);
	  }
          else // ALICE mode, make OR of mini-pixels
	  {
	    word = 0;
	    for ( int mini_row = 8; mini_row > 0; mini_row-- )
	    {
              word |= readInt(dataInStream);
      	    }
	  }
          for (int column = 0; column < 32; column++ )
	  {
	    if ( ((1 << column) & word ) == (1<<column) )
	    {
	      anode[xAnode][yAnode].hitPixel( column, row, 1.0 );
              hitCount += 1;
              hitCountBurst += 1;
            }
	  }
        }

        L0P = readInt(dataInStream); // Parity

	}

	//	word = readInt(dataInStream); // End-of-block code
        float hitRateBurst = (float)hitCountBurst / (float)eventCountBurst ;
        float hitRate = (float)hitCount / (float)eventCount ;
	System.out.println( "Hit counts (burst,total): (" + hitCountBurst + "/" + eventCountBurst + " = " + hitRateBurst + " ppe," + hitCount + "/" + eventCount + " = " + hitRate + " ppe)" );
	 //          threadStopFlag = true;

        do
	{
	    readInt(dataInStream);
	} while (true);

      }
      catch ( EOFException eof )
      {
	 throw eof;
      }
      catch ( IOException ioe )
      {
         throw ioe;
      }
}

public void readStream() throws EOFException, IOException
{
      int x,y;
      int adc, dch, sample, samples, channel, channels, bytesPerSample, scale, mean, sigma;

   while ( true )
   {
      try
      {
        x = readInt(dataInStream);
	//	System.out.println( "Id = " + x );

        switch( x )
	{
        case 0xaaaaaaaa:

          x = readInt(dataInStream);
	  //          System.out.println( "Event # = " + x );
          break;

        case 0x55555555:     // Event end

          try
	  {
            Thread.sleep(sleepyTime);
	  }
          catch ( InterruptedException inte )
	  {
            System.err.println("Warning: " + inte.getMessage() );
	  }

          break;

// Digitiser
        case 0x01020304: read_01020304(); break;

// Digitiser, zero suppressed
        case 0x01020300: read_01020300(); break;

// TDC
        case 0x02020202: read_02020202(); break;

// CRAMS zero suppression table
        case 0x04040404: read_04040404(); break;

// CRAMS zero suppressed data
        case 0xc0d0e0ff: read_c0d0e0ff(); break;

// HPD (TB 2004)
        case 0x0f11c001:
        case 0xf11c0000: read_f11c0000(); break;

// L1R3
        case 0x11030000: read_11030000(); break;

        default:

	    runNumber = x;
	  readInt(dataInStream); // File sequence number
          System.out.println( "Run # = " + x );
          if ( x != lastRunNumber )
	  {
	      lastRunNumber = x;
	      eventCount = 0;
              hitCount = 0;
	  }

	}
      }
      catch ( EOFException eof )
      {
	 throw eof;
      }
      catch ( IOException ioe )
      {
         throw ioe;
      }
   }
}

//
// DataThread handles the IO and decoding
//

public class DataThread extends Thread
{
  public DataThread(){ ; }
  public void run()
  {

//
// Loop until someone signals us to exit
//

      while ( !threadStopFlag )
      {

         try
         {

//
// A request file is created that signals the real time acquisition to generate a new source file.
// First clean up by removing an old request file if it exists and create new.
//

	    if ( onlineFlag )
	    {
              if ( lockFile.exists() )
	      {
	         lockFile.delete();
              }
              lockFile.createNewFile();

// Now wait until the source file is ready (when acquisition task removes the request file)

              while ( lockFile.exists() )
	      {
                 try
	         {
	            Thread.sleep( 10 );
	         }
                 catch ( InterruptedException inte )
	         {
                    System.err.println("Warning: " + inte.getMessage() );
	         }
	      }
	    }

// Close and destroy the stream/socket if they already exist

	    if ( dataInStream != null ) { dataInStream.close(); dataInStream = null; }
            if ( dataSocket != null ) { dataSocket.close(); dataSocket = null; }

// Find out whether to open a socket or a normal URL

            int port = dataURL.getPort();

            if ( port == 7999 )
	    {
              dataSocket = new Socket( dataURL.getHost(), port );
              dataInStream = dataSocket.getInputStream();
	    }
            else
            {
              dataInStream = dataURL.openStream();
            }

            readStream();

       }
       catch ( EOFException eofe )
       {
       }
       catch ( IOException ioe )
       {
	   threadStopFlag = true;
	   System.err.println("Warning: " + ioe.getMessage() );
       }
    }


  }
}

public void updateDataURL()
{
// Make a URL representing the source

  dataSourceString = (String)dataSourceCombo.getSelectedItem();
  System.out.println("Setting source " + dataSourceString);

  try
  {

    URL newDataURL = new URL(dataSourceString);
    if ( newDataURL == null ) System.err.println("Error forming data source URL: " + dataSourceString );

    dataURL = null;
    dataURL = newDataURL;

  }
  catch ( MalformedURLException ue )
  {
     System.err.println("Warning: " + ue.getMessage() );
  }

  return;
}

public void setPreferences()
{
  persistence = prefs.getInt("JPixieBoogieWoogie.persistence",100);
  persistenceControl.setValue(persistence);
  saturation = prefs.getInt("JPixieBoogieWoogie.saturation",1);
  saturationControl.setValue(saturation);

  onlineFlag = prefs.getBoolean("JPixieBoogieWoogie.onlineFlag",false);
  onlineButton.setSelected(onlineFlag);
  autoClearEvent = prefs.getBoolean("JPixieBoogieWoogie.autoClearEvent",false);
  clearEventButton.setSelected(autoClearEvent);
  autoClearBurst = prefs.getBoolean("JPixieBoogieWoogie.autoClearBurst",false);
  clearBurstButton.setSelected(autoClearBurst);
  adaptiveDisplay = prefs.getBoolean("JPixieBoogieWoogie.adaptive",false);
  adaptiveButton.setSelected(adaptiveDisplay);

  int lockFileComboIdx = prefs.getInt("JPixieBoogieWoogie.lockFileIdx",0);
  lockFileCombo.setSelectedIndex(lockFileComboIdx);

  int dataSourceComboIdx = prefs.getInt("JPixieBoogieWoogie.dataSourceIdx",0);
  dataSourceCombo.setSelectedIndex(dataSourceComboIdx);

  return;
}

    public void init() {

    prefs = Preferences.userNodeForPackage(JPixieBoogieWoogie.class).node("JPixieBoogieWoogie");

// Force SwingApplet to come up in the System L&F

	String laf = UIManager.getSystemLookAndFeelClassName();
	try 
        {
	    UIManager.setLookAndFeel(laf);
	}
        catch (UnsupportedLookAndFeelException exc)
        {
	    System.err.println("Warning: UnsupportedLookAndFeel: " + laf);
	}
        catch (Exception exc)
        {
	    System.err.println("Error loading " + laf + ": " + exc);
	}

// Load resources

	resources = new AppletResourceDB();

        contentPane = graphicFrame.getContentPane();

// Set the layout style

        contentPane.setLayout(new BorderLayout());
	//        contentPane.setBackground( new Color(75,200,150) );
        bgWidth = contentPane.getWidth();
        bgHeight = contentPane.getHeight();

// Make the "File" menu

        JMenu fileMenu = new JMenu( "File" );

// Make "Print" menuitem

        JMenuItem printItem = new JMenuItem( "Print..." );
        printItem.addActionListener( this );
        printItem.setActionCommand( "print" );

        fileMenu.add( printItem );

        menuBar.add( fileMenu );

// Make the option menu

	JMenu optionMenu = new JMenu( "Options" );

        makeOptionMenu( optionMenu, this );

        menuBar.add( optionMenu );

// Make a panel to contain the graphics sub-parts

        JPanel graphics = new JPanel();
        graphics.setLayout( new GridBagLayout() );
        GridBagConstraints gbC = new GridBagConstraints();

	gbC.insets = new Insets(2,2,2,2);

// ComboBox for selection of data source

        JLabel label = new JLabel( "Data source URL" );

        gbC.fill = GridBagConstraints.NONE;
        gbC.anchor = GridBagConstraints.EAST;
        gbC.gridx = 0;
        gbC.gridy = 0;
        gbC.gridwidth = 1;
        graphics.add( label, gbC );

        dataSourceCombo = new JComboBox();
        dataSourceCombo.setEditable(true);
        dataSourceCombo.setMaximumRowCount(6);
        dataSourceCombo.addItem( new String("file:/y:/pix.dat") );
        dataSourceCombo.addItem( new String("http://www.hep.phy.cam.ac.uk/lhcb/applets/pbw/Dec2005.dat") );
        dataSourceCombo.addItem( new String("http://www.hep.phy.cam.ac.uk/lhcb/applets/mapmt-small.dat") );
        dataSourceCombo.addItem( new String("http://www.hep.phy.cam.ac.uk/lhcb/applets/mapmt.dat") );
        dataSourceCombo.addItem( new String("file:/c:/Masterclass/java/mapmt.dat") );
	//        dataSourceCombo.addItem( new String("file:/y:/sitel.dat") );
        dataSourceCombo.addItem( new String("file:/y:/mapmt.dat") );
        dataSourceCombo.addItem( new String("file:/y:/flic.dat") );
	//        dataSourceCombo.addItem( new String("file:/g:/Users/l/lhcbrich/java/data/sitel.dat") );
	//        dataSourceCombo.addItem( new String("file:/g:/Users/l/lhcbrich/java/data/mapmt.dat") );
	//        dataSourceCombo.addItem( new String("http://pcbo:7999/") );
	//        dataSourceCombo.addItem( new String("http://www.hep.phy.cam.ac.uk/lhcb/sitel.dat") );
        dataSourceCombo.setActionCommand( "source" );
        dataSourceCombo.addActionListener(this);
        updateDataURL();

        gbC.fill = GridBagConstraints.HORIZONTAL;
        gbC.anchor = GridBagConstraints.CENTER;
        gbC.gridx = 1;
        gbC.gridy = 0;
        gbC.gridwidth = 2;
        graphics.add( dataSourceCombo, gbC );

// ComboBox for selection of lock file name

        JLabel lockFileComboLabel = new JLabel( "Lock file" );

        gbC.fill = GridBagConstraints.NONE;
        gbC.anchor = GridBagConstraints.EAST;
        gbC.gridx = 0;
        gbC.gridy = 1;
        gbC.gridwidth = 1;
        graphics.add( lockFileComboLabel, gbC );

        lockFileCombo = new JComboBox();
        lockFileCombo.setEditable(true);
        lockFileCombo.setMaximumRowCount(6);
        lockFileCombo.addItem( new String("y:pix.lck") );
        lockFileCombo.addItem( new String("y:flic0.lck") );
        lockFileCombo.addItem( new String("y:flic1.lck") );
        lockFileCombo.addItem( new String("y:sitel.lck") );
        lockFileCombo.addItem( new String("y:mapmt.lck") );
        lockFileCombo.setActionCommand( "lock" );
        lockFileCombo.addActionListener(this);

        lockFileString = (String)lockFileCombo.getSelectedItem();
        lockFile = new File( lockFileString );

        gbC.fill = GridBagConstraints.HORIZONTAL;
        gbC.anchor = GridBagConstraints.CENTER;
        gbC.gridx = 1;
        gbC.gridy = 1;
        gbC.gridwidth = 2;
        graphics.add( lockFileCombo, gbC );

// Pause and resume buttons

        JButton button = new JButton( "Stop",new ImageIcon( (Image)resources.imageCache.get("redsquare16.gif") ) );
        button.setActionCommand("stop");
        button.addActionListener( this );

        gbC.fill = GridBagConstraints.VERTICAL;
        gbC.anchor = GridBagConstraints.CENTER;
        gbC.gridx = 0;
        gbC.gridy = 3;
        gbC.gridwidth = 1;
        graphics.add( button, gbC );

        button = new JButton( "Go",new ImageIcon( (Image)resources.imageCache.get("greencircle16.gif") ) );
        button.setActionCommand("go");
        button.addActionListener( this );

        gbC.fill = GridBagConstraints.VERTICAL;
        gbC.anchor = GridBagConstraints.CENTER;
        gbC.gridx = 1;
        gbC.gridy = 3;
        gbC.gridwidth = 1;
        graphics.add( button, gbC );

        clearButton = new JButton( "Clear" );
        clearButton.setActionCommand("clear");

        gbC.fill = GridBagConstraints.VERTICAL;
        gbC.anchor = GridBagConstraints.WEST;
        gbC.gridx = 2;
        gbC.gridy = 3;
        gbC.gridwidth = 1;
        graphics.add( clearButton, gbC );

// Create the image control sliders

        makeSliders();

// Make a panel to contain the graphics sub-parts

        JPanel anodeBag = new JPanel();
        anodeBag.setLayout( new GridBagLayout() );
        GridBagConstraints abC = new GridBagConstraints();

	//   System.out.println( getInsets().toString() );

        abC.insets = new Insets(0,0,0,0);

        anode = new PixieBoogieWoogie[nxAnodes][nyAnodes];

        for ( int ixa = 0; ixa < nxAnodes; ixa++ )
	{
	   for ( int iya = 0; iya < nyAnodes; iya++ )
	   {
              anode[ixa][iya] = new PixieBoogieWoogie(this,nxPixels,nyPixels,xSize,ySize);
              abC.fill = GridBagConstraints.BOTH;
              abC.anchor = GridBagConstraints.CENTER;
              abC.gridx = ixa;
              abC.gridy = iya;
              abC.gridwidth = 1;
              anodeBag.add( anode[ixa][iya], abC );

              clearButton.addActionListener( anode[ixa][iya] );

              persistenceControl.addChangeListener( anode[ixa][iya] );
              saturationControl.addChangeListener( anode[ixa][iya] );

              rotate0Button.addActionListener( anode[ixa][iya] );
              rotate90Button.addActionListener( anode[ixa][iya] );
              rotate180Button.addActionListener( anode[ixa][iya] );
              rotate270Button.addActionListener( anode[ixa][iya] );

              anode[ixa][iya].setAdaptiveDisplay( adaptiveDisplay );
	   }
        }

        gbC.fill = GridBagConstraints.BOTH;
        gbC.anchor = GridBagConstraints.CENTER;
        gbC.gridx = 0;
        gbC.gridy = 2;
        gbC.gridwidth = 3;
        gbC.weightx = 1.0;
        gbC.weighty = 1.0;
        graphics.add( anodeBag, gbC );

        gbC.weightx = 0.0;
        gbC.weighty = 0.0;

        gbC.insets = new Insets(0,0,0,0);

// Add persistence, saturation controls

        gbC.fill = GridBagConstraints.HORIZONTAL;
        gbC.anchor = GridBagConstraints.CENTER;
        gbC.gridx = 0;
        gbC.gridy = 4;
        gbC.gridwidth = 3;
	graphics.add( persistenceControl, gbC );

        gbC.fill = GridBagConstraints.HORIZONTAL;
        gbC.anchor = GridBagConstraints.CENTER;
        gbC.gridx = 0;
        gbC.gridy = 5;
        gbC.gridwidth = 3;
	graphics.add( saturationControl, gbC );

        gbC.weightx = 0.0f;
        gbC.weighty = 0.0f;

// Add the menu bar and graphics pane to the applet's content pane

        contentPane.add(menuBar, BorderLayout.NORTH);
        contentPane.add(graphics, BorderLayout.SOUTH);

// Set preferences

        setPreferences();

// Create a timer

        timer = new Timer( 500, this );
        timer.setInitialDelay(0);
	timer.setCoalesce( false );

        graphicFrame.pack();
        graphicFrame.show();

	//        ChimaeraControl chimaera = new ChimaeraControl( this );
    }

public void makeSliders()
{
   persistenceControl = new JSlider( JSlider.HORIZONTAL, 0, 100, persistence );
   persistenceControl.setToolTipText( Integer.toString(persistence) );
   persistenceControl.setMinorTickSpacing( 5 );
   persistenceControl.setMajorTickSpacing( 20 );
   persistenceControl.setPaintLabels( true );
   persistenceControl.setBorder( BorderFactory.createTitledBorder("Persistence [%]") );
   persistenceControl.setName("persistence");
   persistenceControl.addChangeListener(this);

   saturationControl = new JSlider( JSlider.HORIZONTAL, 0, 100, saturation );
   saturationControl.setToolTipText( Integer.toString(saturation) );
   saturationControl.setMinorTickSpacing( 5 );
   saturationControl.setMajorTickSpacing( 20 );
   saturationControl.setPaintLabels( true );
   saturationControl.setBorder( BorderFactory.createTitledBorder("Saturation count") );
   saturationControl.setName( "saturation" );
   saturationControl.addChangeListener(this);

   return;
}

public void makeOptionMenu( JComponent m, ActionListener l )
{
// Colour buttons

    fgMenuItem = new JMenuItem( "Foreground colour..." );
    fgMenuItem.setActionCommand("fgcolor");
    fgMenuItem.addActionListener( l );

    m.add( fgMenuItem );

    bgMenuItem = new JMenuItem( "Background colour..." );
    bgMenuItem.setActionCommand("bgcolor");
    bgMenuItem.addActionListener( l );

    m.add( bgMenuItem );

    gridMenuItem = new JMenuItem( "Grid colour..." );
    gridMenuItem.setActionCommand("gridcolor");
    gridMenuItem.addActionListener( l );


    m.add( gridMenuItem );

    m.add( new JSeparator() );

    JMenu rotateMenu = new JMenu( "Rotation" );

    ButtonGroup rotateGroup = new ButtonGroup();

    rotate0Button = new JRadioButtonMenuItem( "0 deg" );
    rotate0Button.setActionCommand("rotate0");
    rotate0Button.setSelected( true );
    rotateMenu.add( rotate0Button );
    rotateGroup.add( rotate0Button );
    rotate90Button = new JRadioButtonMenuItem( "90 deg" );
    rotate90Button.setActionCommand("rotate90");
    rotateMenu.add( rotate90Button );
    rotateGroup.add( rotate90Button );
    rotate180Button = new JRadioButtonMenuItem( "180 deg" );
    rotate180Button.setActionCommand("rotate180");
    rotateMenu.add( rotate180Button );
    rotateGroup.add( rotate180Button );
    rotate270Button = new JRadioButtonMenuItem( "270 deg" );
    rotate270Button.setActionCommand("rotate270");
    rotateMenu.add( rotate270Button );
    rotateGroup.add( rotate270Button );

    m.add( rotateMenu );

    JMenu offsetMenu = new JMenu( "Decoding offset" );

    ButtonGroup offsetGroup = new ButtonGroup();

    offsetM2 = new JRadioButtonMenuItem( "-2" );
    offsetM2.addActionListener( l );
    offsetM2.setActionCommand("offsetM2");
    offsetMenu.add( offsetM2 );
    offsetGroup.add( offsetM2 );

    offsetM1 = new JRadioButtonMenuItem( "-1" );
    offsetM1.addActionListener( l );
    offsetM1.setActionCommand("offsetM1");
    offsetMenu.add( offsetM1 );
    offsetGroup.add( offsetM1 );

    offset0 = new JRadioButtonMenuItem( "0" );
    offset0.addActionListener( l );
    offset0.setActionCommand("offset0");
    offset0.setSelected( true );
    offsetMenu.add( offset0 );
    offsetGroup.add( offset0 );

    offsetP1 = new JRadioButtonMenuItem( "+1" );
    offsetP1.addActionListener( l );
    offsetP1.setActionCommand("offsetP1");
    offsetMenu.add( offsetP1 );
    offsetGroup.add( offsetP1 );

    offsetP2 = new JRadioButtonMenuItem( "+2" );
    offsetP2.addActionListener( l );
    offsetP2.setActionCommand("offsetP2");
    offsetMenu.add( offsetP2 );
    offsetGroup.add( offsetP2 );

    m.add( offsetMenu );

    m.add( new JSeparator() );

    onlineButton = new JRadioButtonMenuItem( "Online mode" );
    onlineButton.addActionListener( l );
    onlineButton.setActionCommand("online");
    onlineButton.setSelected( onlineFlag );
    m.add( onlineButton );

    clearEventButton = new JRadioButtonMenuItem( "Auto-clear event" );
    clearEventButton.addActionListener( l );
    clearEventButton.setActionCommand("clearEvent");
    clearEventButton.setSelected( autoClearEvent );
    m.add( clearEventButton );

    clearBurstButton = new JRadioButtonMenuItem( "Auto-clear burst" );
    clearBurstButton.addActionListener( l );
    clearBurstButton.setActionCommand("clearBurst");
    clearBurstButton.setSelected( autoClearBurst );
    m.add( clearBurstButton );

    adaptiveButton = new JRadioButtonMenuItem( "Adaptive display" );
    adaptiveButton.addActionListener( l );
    adaptiveButton.setActionCommand("adaptive");
    adaptiveButton.setSelected( adaptiveDisplay );
    m.add( adaptiveButton );

   return;
}

public int print(Graphics g, PageFormat pf, int pi) throws PrinterException
{
   if (pi >= 1)
   {
            return Printable.NO_SUCH_PAGE;
   }

   Paper pa = pf.getPaper();

   System.out.println( "Paper (pidx,x,y,width,height)=(" + pi + "," + pa.getImageableX() + "," + pa.getImageableY() + "," + pa.getImageableWidth() + "," + pa.getImageableHeight() + ")" );

   Graphics2D g2D = (Graphics2D)g;
   Date now = new Date();
   String dateString = DateFormat.getDateTimeInstance().format(now);
   float hitRate = (float)hitCount / (float)eventCount;
   String titleString = new String( dateString + ", Run " + runNumber + ", (Event count, hit count, hit rate)=(" + eventCount + ", " + hitCount + ", " + hitRate + ")" );

   g2D.drawString( titleString, (int)pa.getImageableX(), (int)pa.getImageableY() + (int)pa.getImageableHeight() );

   for ( int ixa = 0; ixa < nxAnodes; ixa++ )
   {
      for ( int iya = 0; iya < nyAnodes; iya++ )
      {
         anode[ixa][iya].paintNonBuffered((Graphics2D) g, pa, ixa, iya, nxAnodes, nyAnodes, printMono );
      }
   }

   return Printable.PAGE_EXISTS;
}

// On every tick of the clock we ask the display to update

public void actionPerformed( ActionEvent e )
{
String cmd = e.getActionCommand();

   if ( cmd == null )
   {
      ticks++;

// Redraw the display on every tick

      for ( int ixa = 0; ixa < nxAnodes; ixa++ )
      {
         for ( int iya = 0; iya < nyAnodes; iya++ )
	 {
            anode[ixa][iya].update();
	 }
      }

//       System.out.println( "ticks=" + ticks + " ticks mod 10 =" + ticks%10 + " delay=" + timer.getDelay() );
   }
   else if ( cmd.equals( "stop" ) )
   {
      stopThread();
   }
   else if ( cmd.equals( "go" ) )
   {
      startThread();
   }
   else if ( cmd.equals( "fgcolor" ) || cmd.equals( "bgcolor" ) || cmd.equals( "gridcolor" ) )
   {
       setColor( cmd );
   }
   else if ( cmd.equals( "print" ) )
   {   
      PrinterJob printJob = PrinterJob.getPrinterJob();
      PrintRequestAttributeSet printAttributes = new HashPrintRequestAttributeSet();
      printAttributes.add(MediaSizeName.ISO_A4);
      printAttributes.add(OrientationRequested.PORTRAIT);
      printAttributes.add(Chromaticity.MONOCHROME);
      printJob.pageDialog( printAttributes );
      if (printJob.printDialog(printAttributes))
      {
	  try
	  {
            Chromaticity chrom = (Chromaticity)printAttributes.get(Chromaticity.class);
            if ( chrom != null )
            {
	      if ( chrom.equals( Chromaticity.COLOR ) )
	      {
	        printMono = false;
	      }
              else
	      {
	        printMono = true;
	      }
            }
	    printJob.setPrintable(this);
	    printJob.print(printAttributes);  
	  }
	  catch (PrinterException pe)
	  {
            System.err.println(pe);
	  }
      }
   }
   else if ( cmd.equals( "source" ) )
   {
      updateDataURL();
   }
   else if ( cmd.equals( "lock" ) )
   {
      lockFile = null;
      lockFileString = (String)lockFileCombo.getSelectedItem();
      lockFile = new File( lockFileString );
   }
   else if ( cmd.equals( "online" ) )
   {
      onlineFlag = !onlineFlag;
      prefs.putBoolean("JPixieBoogieWoogie.onlineFlag",onlineFlag);
      onlineButton.setSelected( onlineFlag );
   }
   else if ( cmd.equals( "clearEvent" ) )
   {
      autoClearEvent = !autoClearEvent;
      prefs.putBoolean("JPixieBoogieWoogie.autoClearEvent",autoClearEvent);
      clearEventButton.setSelected( autoClearEvent );
   }
   else if ( cmd.equals( "clearBurst" ) )
   {
      autoClearBurst = !autoClearBurst;
      prefs.putBoolean("JPixieBoogieWoogie.autoClearBurst",autoClearBurst);
      clearBurstButton.setSelected( autoClearBurst );
   }
   else if ( cmd.equals( "adaptive" ) )
   {
      adaptiveDisplay = !adaptiveDisplay;
      prefs.putBoolean("JPixieBoogieWoogie.adaptiveDisplay",adaptiveDisplay);
      adaptiveButton.setSelected( adaptiveDisplay );
      for ( int ixa = 0; ixa < nxAnodes; ixa++ )
      {
        for ( int iya = 0; iya < nyAnodes; iya++ )
        {
          anode[ixa][iya].setAdaptiveDisplay( adaptiveDisplay );
        }
      }
   }
   else if ( cmd.equals( "offsetM2" ) )
   {
       decodeOffset = -2;
   }
   else if ( cmd.equals( "offsetM1" ) )
   {
       decodeOffset = -1;
   }
   else if ( cmd.equals( "offset0" ) )
   {
       decodeOffset = 0;
   }
   else if ( cmd.equals( "offsetP1" ) )
   {
       decodeOffset = 1;
   }
   else if ( cmd.equals( "offsetP2" ) )
   {
       decodeOffset = 2;
   }

       return;
}

// Change listener implementation

public void stateChanged( ChangeEvent e )
{
   JSlider source = (JSlider)e.getSource();
   String name = source.getName();
   int value = source.getValue();
   if ( name.equals("persistence") )
   {
      persistence = persistenceControl.getValue();
      prefs.putInt("JPixieBoogieWoogie.persistence",persistence);
   }
   else if ( name.equals("saturation") )
   {
      saturation = saturationControl.getValue();
      prefs.putInt("JPixieBoogieWoogie.saturation",saturation);
   }

   return;
}

public void setColor( String cmd )
{
Color newColor = null;

   if ( cmd.equals( "fgcolor" ) )
     newColor = colorChooser.showDialog( this, "Foreground colour chooser", fgColor );
   else if ( cmd.equals( "bgcolor" ) )
     newColor = colorChooser.showDialog( this, "Background colour chooser", bgColor );
   else if ( cmd.equals( "gridcolor" ) )
     newColor = colorChooser.showDialog( this, "Grid colour chooser", gridColor );

   if ( newColor != null )
   {
      for ( int ixa = 0; ixa < nxAnodes; ixa++ )
      {
         for ( int iya = 0; iya < nyAnodes; iya++ )
	 {
	    if ( cmd.equals( "fgcolor" ) )
 	       anode[ixa][iya].setForegroundColor( newColor );
            else if ( cmd.equals( "bgcolor" ) )
 	       anode[ixa][iya].setBackgroundColor( newColor );
            else if ( cmd.equals( "gridcolor" ) )
 	       anode[ixa][iya].setGridColor( newColor );
	 }
      }
   }

   return;
}

public void startThread()
{
    threadStopFlag = false;
    dth = null;
    dth = new DataThread();
    dth.start();
}

public void stopThread()
{

//
// Set the stop flag so that the thread exits and does not try to reopen the file
//

    threadStopFlag = true;

    try
    {

// Close and destroy the stream/socket if they already exist

       dataInStream.close();
       dataSocket.close();
    }
    catch (NullPointerException npe )
    {
    }
    catch (IOException ioe )
    {
    }

    
}

    public void start(){ timer.start(); }

// Suspend time (effectively stops animation)

    public void stop(){ timer.stop(); }

//    public PixieBoogieWoogie getAnode(){ return anode[0][0]; }
    public int getBgWidth(){ return bgWidth; }
    public int getBgHeight(){ return bgHeight; }

}





































