/*
A visual output for realtime use during Test Beam 2012, based on Steve Wotton's program JPixieBoogieWoogie, which has itself henceforth been renamed 'JPixieBoogieWoogie_orig.'
*/

package cbsw.applet; //this tells the compiler where to put the compiled class files generated from this java source file.  In this case, they will be put in the directory cbsw/applet

import java.io.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.Graphics2D.*;
import java.awt.print.*;
import java.net.*;
import javax.print.attribute.*;
import javax.print.attribute.standard.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.html.*;
import javax.swing.border.*;
import java.text.DateFormat;
import java.util.*;
import java.util.Date;
import java.util.ArrayList;
import cbsw.pbw.*;
import cbsw.applet.*;
import java.util.prefs.Preferences;

public class JPixieBoogieWoogie extends JPanel implements Printable, ActionListener {  //this entire file just defines the class JPixieBoogieWoogie

//find the part where data is read, and make it relevant to 2 x 64-channel MAPMT's, with readout bits as specified in mdf file


/*____________________________________________________________________________________________________*/

	//This section contains general display configuration and initialises the data source//

Preferences prefs;

HashMap<String,Integer> hpdHash;
ArrayList<HpdListElement> hpdList;

//set the number of pixels relevant for tb2012: 16x8 grid (combines both PMT's on one grid)

static final int nxPixels = 16;
static final int nyPixels = 8;

static final int xSize = 30; //leave this for now, may change later
static final int ySize = 30;

javax.swing.Timer timer;
int ticks;
JTextField sleepyTimeTF;
int sleepyTime = 10;
AppletResourceDB resources;

DataThread dth;
boolean threadStopFlag = true;

URL dataURL;  //possible data source
Socket dataSocket;  //possible data source
InputStream dataInStream; //relates to reading the data
JEditorPane editorPane;
String dataSourceString;
JPanel anodeListGB;
JScrollPane anodeListSP;

int runNumber = 0;
int lastRunNumber = 0;

// Control panel

JComboBox dataSourceCombo;

JScrollPane controlsText;

JButton clearButton;

JColorChooser colorChooser = new JColorChooser();
Color fgColor = Color.yellow;
Color bgColor = Color.blue;
Color gridColor = Color.black;

JMenuItem fgMenuItem;
JMenuItem bgMenuItem;
JMenuItem gridMenuItem;

JRadioButtonMenuItem rotate0Button;
JRadioButtonMenuItem rotate90Button;
JRadioButtonMenuItem rotate180Button;
JRadioButtonMenuItem rotate270Button;

JRadioButtonMenuItem clearEventButton, adaptiveButton, overlayButton;

JComboBox hpdIdCombo;
int hpdId = 0;

JRadioButton sortByOccupancyRB;
JRadioButton sortByIdRB;

boolean autoClearEvent = false;
boolean adaptiveDisplay = false;
boolean overlay = false;

int eventCount;

// This flag is not a configuration switch. It is set using info from the print job.
boolean printMono = false;

public JPixieBoogieWoogie( JMenuBar menuBar ) {

    prefs = Preferences.userNodeForPackage(JPixieBoogieWoogie.class).node("JPixieBoogieWoogie");

// Load resources

	resources = new AppletResourceDB();

// Make the "File" menu

        JMenu fileMenu = new JMenu( "File" );

// Make "Print" menuitem

        JMenuItem printItem = new JMenuItem( "Print..." );
        printItem.addActionListener( this );
        printItem.setActionCommand( "print" );

        fileMenu.add( printItem );

        menuBar.add( fileMenu );

// Make the option menu

	JMenu optionMenu = new JMenu( "Options" );

        makeOptionMenu( optionMenu, this );

        menuBar.add( optionMenu );

// Make a panel to contain the graphics sub-parts

        JPanel graphics = new JPanel();
        graphics.setLayout( new GridBagLayout() );
        GridBagConstraints gbC = new GridBagConstraints();

	gbC.insets = new Insets(2,2,2,2);

// ComboBox for selection of data source

        JLabel label = new JLabel( "Data source URL" );

        gbC.fill = GridBagConstraints.NONE;
        gbC.anchor = GridBagConstraints.EAST;
        gbC.weightx = 1.0;
        gbC.weighty = 1.0;

        graphics.add( label, gbC );

        gbC.weightx = 0.0;
        gbC.weighty = 0.0;

        dataSourceCombo = new JComboBox();
        dataSourceCombo.setEditable(true);
        dataSourceCombo.setMaximumRowCount(6);
        //dataSourceCombo.addItem( new String("http://www.hep.phy.cam.ac.uk/lhcb/applets/pbw/run0013.mdf") );
        //dataSourceCombo.addItem( new String("http://www.hep.phy.cam.ac.uk/lhcb/applets/pbw/run0027.mdf") );
        //dataSourceCombo.addItem( new String("file:/c:/Disk2/Data/Testbeam/2006/run0013.mdf") );
        //dataSourceCombo.addItem( new String("file:/c:/Disk2/Data/Testbeam/2006/run0027.mdf") );
        //dataSourceCombo.addItem( new String("file:/y:/pix.mdf") );
	
/*_________________________________________________________________________________________________________*/
		//need to add filepath of relevant mdf file//	
	dataSourceCombo.addItem(new String("file:/C:/Users/lisa smith/Desktop/feb-000002.mdf")); //write filename in url format (note forward slashes instead of back)
	dataSourceCombo.addItem(new String("file:/C:/Users/lisa smith/Desktop/mapmtfeb_007246.mdf"));
	dataSourceCombo.addItem(new String("file:/C:/Users/lisa smith/Desktop/mapmtfeb_000010.mdf"));
	dataSourceCombo.addItem(new String("file:/C:/Users/lisa smith/Desktop/mapmtfeb_000013.mdf"));
	dataSourceCombo.addItem(new String("file:/C:/Users/lisa smith/Desktop/mapmtfeb_000014.mdf"));
	dataSourceCombo.addItem(new String("file:/C:/Users/lisa smith/Desktop/mapmtfeb_000031.mdf"));

	//        dataSourceCombo.addItem( new String("http://pcbo:7999/") );
        dataSourceCombo.setActionCommand( "source" );
        dataSourceCombo.addActionListener(this);
        dataSourceCombo.setToolTipText( "URL of dataset" );
        int dataSourceComboIdx = prefs.getInt("JPixieBoogieWoogie.dataSourceIdx",0);
        dataSourceCombo.setSelectedIndex(dataSourceComboIdx);

        updateDataURL();

        gbC.fill = GridBagConstraints.HORIZONTAL;
        gbC.anchor = GridBagConstraints.CENTER;
        gbC.gridwidth = GridBagConstraints.REMAINDER;
        graphics.add( dataSourceCombo, gbC );

        gbC.gridwidth = 1;

// HPD ID filter

        JLabel hpdIdComboLabel = new JLabel( "Add HPD" );

        gbC.fill = GridBagConstraints.NONE;
        gbC.anchor = GridBagConstraints.EAST;
        graphics.add( hpdIdComboLabel, gbC );

        hpdIdCombo = new JComboBox();
        hpdIdCombo.setEditable(true);
        hpdIdCombo.setMaximumRowCount(36);
        hpdId = prefs.getInt("JPixieBoogieWoogie.hpdId",0);
        hpdIdCombo.addItem(Integer.toString(hpdId));
        hpdIdCombo.addItem( new String("0") );
        hpdIdCombo.addItem( new String("117") );
        hpdIdCombo.addItem( new String("126") );
        hpdIdCombo.addItem( new String("131") );
        hpdIdCombo.addItem( new String("222") );
        hpdIdCombo.addItem( new String("265") );
        hpdIdCombo.addItem( new String("283") );
        hpdIdCombo.setActionCommand( "hpdId" );
        hpdIdCombo.addActionListener(this);
        hpdIdCombo.setToolTipText( "Hardware ID of HPD (decimal)" );

        hpdId = Integer.parseInt((String)hpdIdCombo.getSelectedItem());

        gbC.fill = GridBagConstraints.HORIZONTAL;
        gbC.anchor = GridBagConstraints.CENTER;
        graphics.add( hpdIdCombo, gbC );

	// Sleep time

        JLabel sleepyTimeTFLabel = new JLabel( "Delay [ms]" );

        gbC.fill = GridBagConstraints.NONE;
        gbC.anchor = GridBagConstraints.EAST;
        graphics.add( sleepyTimeTFLabel, gbC );

        sleepyTime = prefs.getInt("JPixieBoogieWoogie.sleepyTime",100);
        sleepyTimeTF = new JTextField( Integer.toString(sleepyTime), 5 );
        sleepyTimeTF.setEditable(true);
        sleepyTimeTF.setActionCommand( "sleepyTime" );
        sleepyTimeTF.addActionListener(this);
        sleepyTimeTF.setToolTipText( "Time in milliseconds between events" );

        gbC.fill = GridBagConstraints.HORIZONTAL;
        gbC.anchor = GridBagConstraints.CENTER;
        gbC.gridwidth = GridBagConstraints.REMAINDER;
        graphics.add( sleepyTimeTF, gbC );

        gbC.gridwidth = 1;

        adaptiveDisplay = prefs.getBoolean("JPixieBoogieWoogie.adaptiveDisplay",false);
        adaptiveButton.setSelected(adaptiveDisplay);

        overlay = prefs.getBoolean("JPixieBoogieWoogie.overlay",false);
        overlayButton.setSelected(overlay);

// Make a scrolling area for the anode list

        hpdHash = new HashMap<String,Integer>();
        hpdList = new ArrayList<HpdListElement>();

        anodeListGB = new JPanel();
        anodeListGB.setLayout( new GridBagLayout() );

        anodeListSP = new JScrollPane( anodeListGB );
	anodeListSP.setPreferredSize( new Dimension( 400,300 ) );

        gbC.fill = GridBagConstraints.VERTICAL;
        gbC.anchor = GridBagConstraints.CENTER;
        gbC.gridwidth = GridBagConstraints.REMAINDER;
        graphics.add( anodeListSP, gbC );

        gbC.gridwidth = 1;

// Sort controls

        ButtonGroup sortByBG = new ButtonGroup();

        JButton sortUpButton = new JButton( "Sort Up" );
        sortUpButton.setActionCommand("sortUp");
        sortUpButton.addActionListener( this );

        gbC.fill = GridBagConstraints.BOTH;
        gbC.anchor = GridBagConstraints.CENTER;
        graphics.add( sortUpButton, gbC );

        sortByIdRB = new JRadioButton( "Hardware ID" );
        sortByIdRB.setSelected( true );
        sortByBG.add( sortByIdRB );

        gbC.fill = GridBagConstraints.VERTICAL;
        gbC.anchor = GridBagConstraints.WEST;
        gbC.gridwidth = GridBagConstraints.REMAINDER;
        graphics.add( sortByIdRB, gbC );

        gbC.gridwidth = 1;

        JButton sortDownButton = new JButton( "Sort Down" );
        sortDownButton.setActionCommand("sortDown");
        sortDownButton.addActionListener( this );

        gbC.fill = GridBagConstraints.BOTH;
        gbC.anchor = GridBagConstraints.CENTER;
        graphics.add( sortDownButton, gbC );

        sortByOccupancyRB = new JRadioButton( "Occupancy" );
        sortByOccupancyRB.setSelected( false );
        sortByBG.add( sortByOccupancyRB );

        gbC.fill = GridBagConstraints.VERTICAL;
        gbC.anchor = GridBagConstraints.WEST;
        gbC.gridwidth = GridBagConstraints.REMAINDER;
        graphics.add( sortByOccupancyRB, gbC );

        gbC.gridwidth = 1;

// Stop, Go and Clear buttons

        JButton stopButton = new JButton( "Stop",new ImageIcon( (Image)resources.imageCache.get("redsquare16.gif") ) );
        stopButton.setActionCommand("stop");
        stopButton.addActionListener( this );

        gbC.fill = GridBagConstraints.VERTICAL;
        gbC.anchor = GridBagConstraints.CENTER;
        graphics.add( stopButton, gbC );

        JButton goButton = new JButton( "Go",new ImageIcon( (Image)resources.imageCache.get("greencircle16.gif") ) );
        goButton.setActionCommand("go");
        goButton.addActionListener( this );

        gbC.fill = GridBagConstraints.VERTICAL;
        gbC.anchor = GridBagConstraints.CENTER;
        graphics.add( goButton, gbC );

        clearButton = new JButton( "Clear all" );
        clearButton.setActionCommand("clear");
        clearButton.addActionListener( this );

        gbC.fill = GridBagConstraints.VERTICAL;
        gbC.anchor = GridBagConstraints.WEST;
        gbC.gridwidth = GridBagConstraints.REMAINDER;
        graphics.add( clearButton, gbC );

        gbC.gridwidth = 1;

        gbC.weightx = 0.0f;
        gbC.weighty = 0.0f;

// Add the graphics pane

        add(graphics, BorderLayout.SOUTH);

// Set preferences

        setPreferences();

// Create a timer

        timer = new javax.swing.Timer( 500, this );
        timer.setInitialDelay(0);
	timer.setCoalesce( false );
        timer.start();

};

public class EOFException extends Exception
{
    public EOFException(){;}
};



public int readInt( InputStream s ) throws EOFException, IOException
//defines InputStream - reads 4 bytes of data and stores them as an int (=32 bits, makes sense)

{
int result = 0;

  try
  {
    for ( int i=0;i<4;i++ )
    {
      int c = s.read();
      if ( c == -1 )
      {
	 throw new EOFException();
      }
      result = result + (c << (8*i));  // '<<' gives bitwise shift to the left
      		//therefore, (c<<(8*i)) shifts the binary representation of c to the left by i bytes
    }
  }
  catch ( IOException ioe )
  {
    throw ioe;
  }
 // System.out.println("used readInt, result="+result);
  return result;
}

public int readShort( InputStream s ) throws EOFException, IOException
//reads 2 bytes of data and stores them as an int, which therefore contains only 16 data bits

{
int result = 0;

  try
  {
    for ( int i=0;i<2;i++ )
    {
      int c = s.read();
      if ( c == -1 )
      {
	 throw new EOFException();
      }
       result = result + (c << (8*i));
    }
  }
  catch ( IOException ioe )
  {
    throw ioe;
  }
  //System.out.println("used readShort, result="+result);
  return result;
}


/*__________________________________________________________________________________________________________________________________________________*/

	//need to add some sort of decode_Test-Beam_data equivalent to the classes defined above

int decodeTESTBEAM(PixieBoogieWoogie pbw, int length) throws EOFException, IOException  //this function reads the data file to return a HITCOUNT
{											//also UPDATES THE DISPLAY
											//note - takes 'length' as an argument.  When the decode func is called, it is always passed 'nzcount' for the length argument.
int hitCount = 0;

  try
  {
    for(int i=0; i<8; i++){ //each iteration reads a new line.  therefore need !length=8! (as there are 8 lines of data).
	 //   int line = dataInStream.read();
	 //   if (line == -1) throw new EOFException();
	    int line = readInt(dataInStream); //TRYING SOMETHING DIFFERENT - replaces the above 2 lines  
	    if (i>3){continue;} 
	    for (int column=0; column<16; column++){
		    if(((1<<column)&line) == (1<<column)){ //starting from rhs, check 16 bits at end of line. For each bit equal to 1:
		    //if(((1<<(column+16))&line) == (1<<(column+16))){  //TEST - this reads the 7,6,5,4,3,2,1,0 part of the data
	  	      if(pbw != null) pbw.hitPixel(column, i, 1.0); //update display
			  // System.out.println("display and hitCount updated by decodeTESTBEAM");
		      	    hitCount++; //iterate hitcount
			  // System.out.println("hitCount="+hitCount);    
		     	}
		    }
	    }
	

  }
  catch (IOException ioe){ throw ioe; }
  catch (EOFException eof){ throw eof; }

  return hitCount;
}


public synchronized HpdListElement addHpdListElement( int hpd )
{

  HpdListElement hpdLE = null;

  if ( hpdHash.containsKey(String.valueOf(hpd)) == false )
  {
    hpdLE = new HpdListElement(hpd);
    hpdList.add( hpdLE );
    int index = hpdList.indexOf( hpdLE );
    hpdHash.put(String.valueOf(hpd),new Integer(index));
    hpdLE.addElementsToPanel( anodeListGB );
    anodeListSP.validate();
  }
  
  return hpdLE;

}

double eventcounter;

public void read_Rich_xc0( int length ) throws EOFException, IOException  
//reads ingress header, l1 header, and actual data
//only difference from read_Rich_x81 is that l1 header contains an extra 2 x 32bit words at the end
{

	//need to add option to decode Test Beam data

//note '&'=bitwise AND:  output bit is 1 iff both corresponding input bits were 1.  If either, or both, input bits were 0, output bit will be 0.  //
		  //0x1000 = 0001 0000 0000 0000 in binary
	eventcounter++;
	if (eventcounter %100 == 0) { System.out.println("event number"+eventcounter); }

  try
  {
    for(int count=0;count<length; )
    {
      int ingressHeader = readInt(dataInStream); count+=4;

      int mask = (ingressHeader>>16) & 0xfff;  //stores 'mask' from ingress header

      for(int ch=0;ch<12;ch++) //for each of these bits
      {
        if((mask & 0x1) == 0x1) //see if it equals 1
	{
	  int l1Header = readInt(dataInStream); count+=4;
	  int nzcount = (l1Header>>16) & 0x7ff;
	  int hpd = (l1Header & 0x7ff);
	  if (overlay){
		  hpd = 0; }
	  PixieBoogieWoogie pbw;
	  HpdListElement hpdLE = addHpdListElement(hpd);
	  if (hpdLE != null){
		  System.out.println("Added ID "+hpd);
		  pbw = null;
	  }
	  else {
	    Integer idx = hpdHash.get(String.valueOf(hpd));
	    hpdLE = hpdList.get(idx.intValue());
	    if(hpdLE == null){ pbw = null; }
	    else{ pbw = hpdLE.getPBW(); }
	  }

	  if((l1Header & 0x40000000) == 0x40000000){
	    mask = (mask>>1);
	    continue;
	  } 
	  if((l1Header & 0x20000000) == 0x20000000){
	    int l0Header = readInt(dataInStream); count+=4;
	    l0Header = readInt(dataInStream); count+=4;
	  }
	  int hitCount;
	 //System.out.println("called decodeTESTBEAM");
	  hitCount = decodeTESTBEAM(pbw, 8); // WAS 'nzcount' instead of 8.  calls decodeTESTBEAM to obtain the hitcount.  However, this also has the effect of updating the visual display,
	//System.out.println("return from decodeTESTBEAM");
	  count += 32;              //accounts for raw data read
	  hpdLE.updateOccupancy(hitCount);
	}
	mask = (mask>>1);
      }

    }
  }
  catch (IOException ioe){ throw ioe;}
  catch (EOFException eof){ throw eof;}
return;
}



public void readStream() throws EOFException, IOException //reads up to end of rawHeader, then decides how to read rest of data
{
   int x;

   while ( true )
   {
      if ( autoClearEvent == true )
      {
        ListIterator<HpdListElement> it = hpdList.listIterator();
        while ( it.hasNext()  )
        {
          HpdListElement hpdLE = it.next();
          PixieBoogieWoogie pbw = hpdLE.getPBW();
          if ( pbw != null ) pbw.clear();
        }
      }

      try
      {
	int mdfLength = readInt(dataInStream); // used to have +4 on RHS, apparently now mdfLength is correct. Reads 1st 4 bytes of data
	//System.out.println( "mdfLength = " + mdfLength ); //the first 4 bytes of this give the length of the data stored

	for ( int i=0;i<11;i++ ) // Swallow rest of header
	{
          x = readInt(dataInStream); //this loop reads 11 ints worth of data = 11 x 4bytes = 44 bytes
	}

        mdfLength -= 48; //48 bytes in total have been read so far

        while ( mdfLength > 0 ) //reading raw data bank, beginning with raw header
	{
          int magic = readShort(dataInStream); //short = 2 BYTES
          int length = readShort(dataInStream);
          int type = readShort(dataInStream);  //contains both 'type' and 'version' of rawHeader 
          int source = readShort(dataInStream);
	 // System.out.println( "magic = " + magic );
	 // System.out.println( "length = " + length );
	  //	  System.out.println( "type = " + type );

          switch( type ) //switch chooses how to decode data depending on the data 'type' - a short combining the 4 'type' bits, and 4 'version' bits of the struct
	  {

// RICH version 0x80
//          case 0x8009: read_Rich_x80( length-8 ); break;

// RICH version 0x81
//          case 0x8109: read_Rich_x81( length-8 ); break;

// ODIN version 0
//          case 0x0210: read_Odin_x00( length-8 ); break;

// Test Beam 2012: 0xc0
	    case 0xc009: read_Rich_xc0( length-8 ); break;
	    
	    default:

	    for ( int i=0;i<length-8;i++ )
	    {
	     System.out.println("Warning - default case has been chosen. read_Rich_xc0 has not been called");
	      x = dataInStream.read();  //x is defined above as an int
	    }
	  
	  }
          
	  
	  
	  mdfLength -= length;
	}
        eventCount++;
        if ( eventCount%1000 == 0 )
	{
	  System.out.println( "Event #" + eventCount );
	}
      }
      
      
      catch ( EOFException eof )
      {
	 throw eof;
      }
      catch ( IOException ioe )
      {
         throw ioe;
      }

      try
      {
        Thread.sleep(sleepyTime);
      }
      catch ( InterruptedException inte )
      {
        System.err.println("Warning: " + inte.getMessage() );
      }

   }
}

/*________________________________________________________________________________________________________*/
		
		//The rest can be kept as it is//

//
// DataThread handles the IO and decoding
//

public class DataThread extends Thread
{
  public DataThread(){ ; }
  public void run()
  {

//
// Loop until someone signals us to exit
//

      while ( !threadStopFlag )
      {

         try
         {

// Close and destroy the stream/socket if they already exist

	    if ( dataInStream != null ) { dataInStream.close(); dataInStream = null; }
            if ( dataSocket != null ) { dataSocket.close(); dataSocket = null; }

// Find out whether to open a socket or a normal URL

            int port = dataURL.getPort();

            if ( port == 7999 )
	    {
              dataSocket = new Socket( dataURL.getHost(), port );
              dataInStream = dataSocket.getInputStream();
	    }
            else
            {
              dataInStream = dataURL.openStream();
            }

            readStream();

       }
       catch ( EOFException eofe )
       {
	   System.err.println( "End of file" );
           threadStopFlag = true;
       }
       catch ( IOException ioe )
       {
	   threadStopFlag = true;
	   System.err.println("Warning: " + ioe.getMessage() );
       }
    }


  }
}


public void updateDataURL()
{
// Make a URL representing the source

  dataSourceString = (String)dataSourceCombo.getSelectedItem();
  System.out.println("Setting source " + dataSourceString);

  try
  {

    URL newDataURL = new URL(dataSourceString);
    if ( newDataURL == null ) System.err.println("Error forming data source URL: " + dataSourceString );

    dataURL = null;
    dataURL = newDataURL;

  }
  catch ( MalformedURLException ue )
  {
     System.err.println("Warning: " + ue.getMessage() );
  }

  return;
}

public void setPreferences()
{
  autoClearEvent = prefs.getBoolean("JPixieBoogieWoogie.autoClearEvent",false);
  clearEventButton.setSelected(autoClearEvent);

  return;
}

public void makeOptionMenu( JComponent m, ActionListener l )
{
// Colour buttons

    fgMenuItem = new JMenuItem( "Foreground colour..." );
    fgMenuItem.setActionCommand("fgcolor");
    fgMenuItem.addActionListener( l );

    m.add( fgMenuItem );

    bgMenuItem = new JMenuItem( "Background colour..." );
    bgMenuItem.setActionCommand("bgcolor");
    bgMenuItem.addActionListener( l );

    m.add( bgMenuItem );

    gridMenuItem = new JMenuItem( "Grid colour..." );
    gridMenuItem.setActionCommand("gridcolor");
    gridMenuItem.addActionListener( l );


    m.add( gridMenuItem );

    m.add( new JSeparator() );

    JMenu rotateMenu = new JMenu( "Rotation" );

    ButtonGroup rotateGroup = new ButtonGroup();

    rotate0Button = new JRadioButtonMenuItem( "0 deg" );
    rotate0Button.setActionCommand("rotate0");
    rotate0Button.addActionListener(this);
    rotate0Button.setSelected( true );
    rotateMenu.add( rotate0Button );
    rotateGroup.add( rotate0Button );
    rotate90Button = new JRadioButtonMenuItem( "90 deg" );
    rotate90Button.setActionCommand("rotate90");
    rotate90Button.addActionListener(this);
    rotateMenu.add( rotate90Button );
    rotateGroup.add( rotate90Button );
    rotate180Button = new JRadioButtonMenuItem( "180 deg" );
    rotate180Button.setActionCommand("rotate180");
    rotate180Button.addActionListener(this);
    rotateMenu.add( rotate180Button );
    rotateGroup.add( rotate180Button );
    rotate270Button = new JRadioButtonMenuItem( "270 deg" );
    rotate270Button.setActionCommand("rotate270");
    rotate270Button.addActionListener(this);
    rotateMenu.add( rotate270Button );
    rotateGroup.add( rotate270Button );

    m.add( rotateMenu );

    m.add( new JSeparator() );

    clearEventButton = new JRadioButtonMenuItem( "Auto-clear event" );
    clearEventButton.addActionListener( l );
    clearEventButton.setActionCommand("clearEvent");
    clearEventButton.setSelected( autoClearEvent );
    m.add( clearEventButton );

    adaptiveButton = new JRadioButtonMenuItem( "Adaptive display" );
    adaptiveButton.addActionListener( l );
    adaptiveButton.setActionCommand("adaptive");
    adaptiveButton.setSelected( adaptiveDisplay );
    m.add( adaptiveButton );

    overlayButton = new JRadioButtonMenuItem( "Overlay" );
    overlayButton.addActionListener( l );
    overlayButton.setActionCommand("overlay");
    overlayButton.setSelected( overlay );
    m.add( overlayButton );

   return;
}

public int print(Graphics g, PageFormat pf, int pi) throws PrinterException
{
   if (pi >= 1)
   {
            return Printable.NO_SUCH_PAGE;
   }

   Paper pa = pf.getPaper();

   System.out.println( "Paper (pidx,x,y,width,height)=(" + pi + "," + pa.getImageableX() + "," + pa.getImageableY() + "," + pa.getImageableWidth() + "," + pa.getImageableHeight() + ")" );

   Graphics2D g2D = (Graphics2D)g;
   Date now = new Date();
   String dateString = DateFormat.getDateTimeInstance().format(now);
   String titleString = new String( dateString + ", Run " + runNumber );

   g2D.drawString( titleString, (int)pa.getImageableX(), (int)pa.getImageableY() + (int)pa.getImageableHeight() );

   //   anode.paintNonBuffered((Graphics2D) g, pa, printMono );

   return Printable.PAGE_EXISTS;
}

// On every tick of the clock we ask the display to update

public void actionPerformed( ActionEvent e )
{
String cmd = e.getActionCommand();

   if ( cmd == null )
   {
      ticks++;

// Redraw the display on every tick

      ListIterator<HpdListElement> it = hpdList.listIterator();
      while ( it.hasNext()  )
      {
        HpdListElement hpdLE = it.next();
        PixieBoogieWoogie pbw = hpdLE.getPBW();
        if ( pbw != null ) pbw.refresh();
      }

      //       System.out.println( "ticks=" + ticks + " ticks mod 10 =" + ticks%10 + " delay=" + timer.getDelay() );
   }
   else if ( cmd.equals( "stop" ) )
   {
      stopThread();
   }
   else if ( cmd.equals( "go" ) )
   {
      startThread();
   }
   else if ( cmd.equals( "clear" ) )
   {
      eventCount = 0;
      ListIterator<HpdListElement> it = hpdList.listIterator();
      while ( it.hasNext()  )
      {
        HpdListElement hpdLE = it.next();
        PixieBoogieWoogie pbw = hpdLE.getPBW();
        hpdLE.resetOccupancy();
        if ( pbw != null ) pbw.clear();
      }
   }
   else if ( cmd.equals( "rotate0" ) )
   {
     setRotation( 0.0 );
   }
   else if ( cmd.equals( "rotate90" ) )
   {
     setRotation( 90.0 );
   }
   else if ( cmd.equals( "rotate180" ) )
   {
     setRotation( 180.0 );
   }
   else if ( cmd.equals( "rotate270" ) )
   {
     setRotation( 270.0 );
   }
   else if ( cmd.equals( "fgcolor" ) || cmd.equals( "bgcolor" ) || cmd.equals( "gridcolor" ) )
   {
       setColor( cmd );
   }
   else if ( cmd.equals( "print" ) )
   {   
      PrinterJob printJob = PrinterJob.getPrinterJob();
      PrintRequestAttributeSet printAttributes = new HashPrintRequestAttributeSet();
      printAttributes.add(MediaSizeName.ISO_A4);
      printAttributes.add(OrientationRequested.PORTRAIT);
      printAttributes.add(Chromaticity.MONOCHROME);
      printJob.pageDialog( printAttributes );
      if (printJob.printDialog(printAttributes))
      {
	  try
	  {
            Chromaticity chrom = (Chromaticity)printAttributes.get(Chromaticity.class);
            if ( chrom != null )
            {
	      if ( chrom.equals( Chromaticity.COLOR ) )
	      {
	        printMono = false;
	      }
              else
	      {
	        printMono = true;
	      }
            }
	    printJob.setPrintable(this);
	    printJob.print(printAttributes);  
	  }
	  catch (PrinterException pe)
	  {
            System.err.println(pe);
	  }
      }
   }
   else if ( cmd.equals( "source" ) )
   {
      updateDataURL();
   }
   else if ( cmd.equals( "hpdId" ) )
   {

      String hpdIdString = (String)hpdIdCombo.getSelectedItem();
      hpdId = Integer.parseInt(hpdIdString);
      prefs.putInt("JPixieBoogieWoogie.hpdId",hpdId);

      if ( hpdHash.containsKey(hpdIdString) == false )
      {
        HpdListElement hpdLE = new HpdListElement(hpdId);
        hpdList.add( hpdLE );
	hpdLE.addElementsToPanel( anodeListGB );
        anodeListSP.validate();
      }
      else
      {
	  System.out.println("Duplicate ID " + hpdId + " rejected" );
      }

   }
   else if ( cmd.equals( "sortUp" ) )
   {
     int sortBy;
     if ( sortByOccupancyRB.isSelected() )
     {
       sortBy = HpdListElementComparator.SORT_BY_OCCUPANCY;
     }
     else
     {
       sortBy = HpdListElementComparator.SORT_BY_HARDWARE_ID;
     }
     sortHpdList( sortBy, false );
   }
   else if ( cmd.equals( "sortDown" ) )
   {
     int sortBy;
     if ( sortByOccupancyRB.isSelected() )
     {
       sortBy = HpdListElementComparator.SORT_BY_OCCUPANCY;
     }
     else
     {
       sortBy = HpdListElementComparator.SORT_BY_HARDWARE_ID;
     }
     sortHpdList( sortBy, true );
   }
   else if ( cmd.equals( "sleepyTime" ) )
   {
      String sleepyTimeString = sleepyTimeTF.getText();
      sleepyTime = Integer.parseInt(sleepyTimeString);
      prefs.putInt("JPixieBoogieWoogie.sleepyTime",sleepyTime);
   }
   else if ( cmd.equals( "clearEvent" ) )
   {
      autoClearEvent = !autoClearEvent;
      prefs.putBoolean("JPixieBoogieWoogie.autoClearEvent",autoClearEvent);
      clearEventButton.setSelected( autoClearEvent );
   }
   else if ( cmd.equals( "adaptive" ) )
   {
      adaptiveDisplay = !adaptiveDisplay;
      prefs.putBoolean("JPixieBoogieWoogie.adaptiveDisplay",adaptiveDisplay);
      adaptiveButton.setSelected( adaptiveDisplay );

      ListIterator<HpdListElement> it = hpdList.listIterator();
      while ( it.hasNext()  )
      {
        HpdListElement hpdLE = it.next();
        PixieBoogieWoogie pbw = hpdLE.getPBW();
        if ( pbw != null ) pbw.setAdaptiveDisplay( adaptiveDisplay );
      }
   }
   else if ( cmd.equals( "overlay" ) )
   {
      overlay = !overlay;
      prefs.putBoolean("JPixieBoogieWoogie.overlay",overlay);
      overlayButton.setSelected( overlay );
   }

       return;
}

public synchronized void sortHpdList( int sortBy, boolean ascending )
{
  Collections.sort( hpdList, new HpdListElementComparator(sortBy, ascending) );

// Clear scrolling list and hash map

  hpdHash.clear();
  int idx = 0;
  anodeListGB.removeAll();

// Rebuild scrolling list and hash map

  ListIterator<HpdListElement> it = hpdList.listIterator();
  while ( it.hasNext()  )
  {
    HpdListElement hpdLE = it.next();
    hpdLE.addElementsToPanel( anodeListGB );
    hpdHash.put( String.valueOf(hpdLE.getHardwareId()), new Integer(idx) );
    idx++;
  }
  anodeListSP.validate();
}

public void setRotation( double rot )
{
      ListIterator<HpdListElement> it = hpdList.listIterator();
      while ( it.hasNext()  )
      {
        HpdListElement hpdLE = it.next();
        PixieBoogieWoogie pbw = hpdLE.getPBW();
        if ( pbw != null )
        {
          pbw.setRotation( rot );
        }
      }

   return;
}

public void setColor( String cmd )
{
Color newColor = null;

   if ( cmd.equals( "fgcolor" ) )
     newColor = colorChooser.showDialog( this, "Foreground colour chooser", fgColor );
   else if ( cmd.equals( "bgcolor" ) )
     newColor = colorChooser.showDialog( this, "Background colour chooser", bgColor );
   else if ( cmd.equals( "gridcolor" ) )
     newColor = colorChooser.showDialog( this, "Grid colour chooser", gridColor );

   if ( newColor != null )
   {
      ListIterator<HpdListElement> it = hpdList.listIterator();
      while ( it.hasNext()  )
      {
        HpdListElement hpdLE = it.next();
        PixieBoogieWoogie pbw = hpdLE.getPBW();
        if ( pbw != null )
        {
          if ( cmd.equals( "fgcolor" ) )
            pbw.setForegroundColor( newColor );
          else if ( cmd.equals( "bgcolor" ) )
            pbw.setBackgroundColor( newColor );
          else if ( cmd.equals( "gridcolor" ) )
            pbw.setGridColor( newColor );
        }
      }

   }

   return;
}

public void startThread()
{
    threadStopFlag = false;
    dth = null;
    dth = new DataThread();
    dth.start();
}

public void stopThread()
{

//
// Set the stop flag so that the thread exits and does not try to reopen the file
//

    threadStopFlag = true;

    try
    {

// Close and destroy the stream/socket if they already exist

       dataInStream.close();
       dataSocket.close();
    }
    catch (NullPointerException npe )
    {
    }
    catch (IOException ioe )
    {
    }

    
}

    public void start(){ timer.start(); }

// Suspend time (effectively stops animation)

    public void stop(){ timer.stop(); }

private class HpdListElementComparator implements Comparator<HpdListElement>
{

  public static final int SORT_BY_HARDWARE_ID = 1;
  public static final int SORT_BY_OCCUPANCY = 2;
  int sortBy;
  boolean ascending;

  public HpdListElementComparator( int sb, boolean as )
  {
    sortBy = sb;
    ascending = as;
  }

  public int compare( HpdListElement e1, HpdListElement e2 )
  {
      if ( sortBy == SORT_BY_HARDWARE_ID )
      {
        return HpdListElement.compareHwId( e1, e2, ascending );
      }
      else
      {
        return HpdListElement.compareOccupancy( e1, e2, ascending );
      }
  }
}

}


