/*
A display panel

Steve Wotton, 2000-2007
Cavendish Lab (HEP)
*/

package cbsw.applet;

import java.io.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.Graphics2D.*;
import java.net.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.html.*;
import javax.swing.border.*;
import javax.swing.filechooser.*;
import java.util.*;
import java.util.ArrayList;
import cbsw.pbw.*;
import cbsw.applet.*;
import java.util.prefs.Preferences;

public class JPixieBoogieWoogie extends JPanel implements ActionListener {

Preferences prefs;

HashMap<String,Integer> hpdHash;
ArrayList<HpdListElement> hpdList;

static final int nxPixels = 16;
static final int nyPixels = 8;

static final int xSize = 10;
static final int ySize = 10;

javax.swing.Timer timer;
int ticks;
JTextField sleepyTimeTF;
int sleepyTime = 10;
AppletResourceDB resources;

DataThread dth;
boolean threadStopFlag = true;

URL dataURL;
Socket dataSocket;
InputStream dataInStream;
JEditorPane editorPane;
String dataSourceString;
JPanel anodeListGB;
JScrollPane anodeListSP;

int runNumber = 0;
int lastRunNumber = 0;

// Control panel

JComboBox<String> dataSourceCombo;

JScrollPane controlsText;

JButton clearButton;

JColorChooser colorChooser = new JColorChooser();
Color fgColor = Color.yellow;
Color bgColor = Color.blue;
Color gridColor = Color.black;

JMenuItem fgMenuItem;
JMenuItem bgMenuItem;
JMenuItem gridMenuItem;

JRadioButtonMenuItem rotate0Button;
JRadioButtonMenuItem rotate90Button;
JRadioButtonMenuItem rotate180Button;
JRadioButtonMenuItem rotate270Button;

JRadioButtonMenuItem loopButton, clearEventButton, adaptiveButton, overlayButton;

JComboBox<String> hpdIdCombo;
int hpdId = 0;

JRadioButton sortByOccupancyRB;
JRadioButton sortByIdRB;

boolean autoClearEvent = false;
boolean restartAtEOF = false;
boolean adaptiveDisplay = false;
boolean overlay = false;

int eventCount;

public JPixieBoogieWoogie( JMenuBar menuBar ) {

    prefs = Preferences.userNodeForPackage(JPixieBoogieWoogie.class).node("JPixieBoogieWoogie");

// Load resources

	resources = new AppletResourceDB();

// Make the "File" menu

        JMenu fileMenu = new JMenu( "File" );

// Make "Exit..." menuitem

        JMenuItem exitItem = new JMenuItem( "Exit..." );
        exitItem.addActionListener( this );
        exitItem.setActionCommand( "exit" );

        fileMenu.add( exitItem );

        menuBar.add( fileMenu );

// Make the option menu

	JMenu optionMenu = new JMenu( "Options" );

        makeOptionMenu( optionMenu, this );

        menuBar.add( optionMenu );

// Make a panel to contain the graphics sub-parts

        JPanel graphics = new JPanel();
        graphics.setLayout( new GridBagLayout() );
        GridBagConstraints gbC = new GridBagConstraints();

	gbC.insets = new Insets(2,2,2,2);

// ComboBox for selection of data source

        JLabel label = new JLabel( "Data source URL" );

        gbC.fill = GridBagConstraints.NONE;
        gbC.anchor = GridBagConstraints.EAST;
        gbC.weightx = 1.0;
        gbC.weighty = 1.0;

        graphics.add( label, gbC );

        gbC.weightx = 0.0;
        gbC.weighty = 0.0;

	// Get a list of MDF files

        dataSourceCombo = new JComboBox<String>();
        dataSourceCombo.setEditable(true);
	//        dataSourceCombo.setMaximumRowCount(6);
	dataSourceCombo.addItem( prefs.get("JPixieBoogieWoogie.dataSourcePath","file:feb-000001.mdf") );
        File dataSourceDirectory = new File( prefs.get("JPixieBoogieWoogie.dataSourceDirectory","file:.") );
        java.io.FileFilter filter = new java.io.FileFilter() { public boolean accept(File f){ return f.toURI().toString().endsWith(".mdf");} };
        File mdfFiles [] = dataSourceDirectory.listFiles(filter);
        if ( mdfFiles != null )
	{
	  for ( int ifile=0; ifile<mdfFiles.length; ifile++ )
	  {
            dataSourceCombo.addItem( mdfFiles[ifile].toURI().toString() );
	  }
	}
        dataSourceCombo.addItem( new String("http://www.hep.phy.cam.ac.uk/lhcb/applets/pbw/run0013.mdf") );
        dataSourceCombo.addItem( new String("file:/c:/Data/run0013.mdf") );
	//        dataSourceCombo.addItem( new String("http://pcbo:7999/") );
        dataSourceCombo.setActionCommand( "source" );
        dataSourceCombo.addActionListener(this);
        dataSourceCombo.setToolTipText( "URL of dataset" );
	//        int dataSourceComboIdx = prefs.getInt("JPixieBoogieWoogie.dataSourceIdx",0);
	//        dataSourceCombo.setSelectedIndex(dataSourceComboIdx);

        updateDataURL();

        gbC.fill = GridBagConstraints.HORIZONTAL;
        gbC.anchor = GridBagConstraints.CENTER;
        graphics.add( dataSourceCombo, gbC );

        JButton browseButton = new JButton( "Browse" );
        browseButton.setActionCommand("browse");
        browseButton.addActionListener( this );

        gbC.fill = GridBagConstraints.VERTICAL;
        gbC.anchor = GridBagConstraints.CENTER;
        gbC.gridwidth = GridBagConstraints.REMAINDER;
        graphics.add( browseButton, gbC );

        gbC.gridwidth = 1;

// HPD ID filter

        JButton hpdIdAddButton = new JButton( "Add ID" );
        hpdIdAddButton.setActionCommand( "hpdId" );
        hpdIdAddButton.addActionListener(this);

        gbC.fill = GridBagConstraints.NONE;
        gbC.anchor = GridBagConstraints.EAST;
        graphics.add( hpdIdAddButton, gbC );

        hpdIdCombo = new JComboBox<String>();
        hpdIdCombo.setEditable(true);
        hpdIdCombo.setMaximumRowCount(36);
        hpdId = prefs.getInt("JPixieBoogieWoogie.hpdId",0);
        hpdIdCombo.addItem(Integer.toString(hpdId));
        hpdIdCombo.addItem( new String("0") );
        hpdIdCombo.addItem( new String("117") );
        hpdIdCombo.addItem( new String("126") );
        hpdIdCombo.addItem( new String("131") );
        hpdIdCombo.addItem( new String("222") );
        hpdIdCombo.addItem( new String("265") );
        hpdIdCombo.addItem( new String("283") );
        hpdIdCombo.setToolTipText( "Hardware ID of imaging element (decimal)" );

        hpdId = Integer.parseInt((String)hpdIdCombo.getSelectedItem());

        gbC.fill = GridBagConstraints.HORIZONTAL;
        gbC.anchor = GridBagConstraints.CENTER;
        graphics.add( hpdIdCombo, gbC );

	// Sleep time

        JLabel sleepyTimeTFLabel = new JLabel( "Delay [ms]" );

        gbC.fill = GridBagConstraints.NONE;
        gbC.anchor = GridBagConstraints.EAST;
        graphics.add( sleepyTimeTFLabel, gbC );

        sleepyTime = prefs.getInt("JPixieBoogieWoogie.sleepyTime",100);
        sleepyTimeTF = new JTextField( Integer.toString(sleepyTime), 5 );
        sleepyTimeTF.setEditable(true);
        sleepyTimeTF.setActionCommand( "sleepyTime" );
        sleepyTimeTF.addActionListener(this);
        sleepyTimeTF.setToolTipText( "Time in milliseconds between events" );

        gbC.fill = GridBagConstraints.HORIZONTAL;
        gbC.anchor = GridBagConstraints.CENTER;
        gbC.gridwidth = GridBagConstraints.REMAINDER;
        graphics.add( sleepyTimeTF, gbC );

        gbC.gridwidth = 1;

        adaptiveDisplay = prefs.getBoolean("JPixieBoogieWoogie.adaptiveDisplay",false);
        adaptiveButton.setSelected(adaptiveDisplay);

        overlay = prefs.getBoolean("JPixieBoogieWoogie.overlay",false);
        overlayButton.setSelected(overlay);

// Make a scrolling area for the anode list

        hpdHash = new HashMap<String,Integer>();
        hpdList = new ArrayList<HpdListElement>();

        anodeListGB = new JPanel();
        anodeListGB.setLayout( new GridBagLayout() );

        anodeListSP = new JScrollPane( anodeListGB );
	anodeListSP.setPreferredSize( new Dimension( 400,300 ) );

        gbC.fill = GridBagConstraints.VERTICAL;
        gbC.anchor = GridBagConstraints.CENTER;
        gbC.gridwidth = GridBagConstraints.REMAINDER;
        graphics.add( anodeListSP, gbC );

        gbC.gridwidth = 1;

// Sort controls

        ButtonGroup sortByBG = new ButtonGroup();

        JButton sortUpButton = new JButton( "Sort Up" );
        sortUpButton.setActionCommand("sortUp");
        sortUpButton.addActionListener( this );

        gbC.fill = GridBagConstraints.BOTH;
        gbC.anchor = GridBagConstraints.CENTER;
        graphics.add( sortUpButton, gbC );

        sortByIdRB = new JRadioButton( "Sort by hardware ID" );
        sortByIdRB.setSelected( true );
        sortByBG.add( sortByIdRB );

        gbC.fill = GridBagConstraints.VERTICAL;
        gbC.anchor = GridBagConstraints.WEST;
        gbC.gridwidth = GridBagConstraints.REMAINDER;
        graphics.add( sortByIdRB, gbC );

        gbC.gridwidth = 1;

        JButton sortDownButton = new JButton( "Sort Down" );
        sortDownButton.setActionCommand("sortDown");
        sortDownButton.addActionListener( this );

        gbC.fill = GridBagConstraints.BOTH;
        gbC.anchor = GridBagConstraints.CENTER;
        graphics.add( sortDownButton, gbC );

        sortByOccupancyRB = new JRadioButton( "Sort by occupancy" );
        sortByOccupancyRB.setSelected( false );
        sortByBG.add( sortByOccupancyRB );

        gbC.fill = GridBagConstraints.VERTICAL;
        gbC.anchor = GridBagConstraints.WEST;
        gbC.gridwidth = GridBagConstraints.REMAINDER;
        graphics.add( sortByOccupancyRB, gbC );

        gbC.gridwidth = 1;

// Stop, Go and Clear buttons

        JButton stopButton = new JButton( "Stop",new ImageIcon( (Image)resources.imageCache.get("redsquare16.gif") ) );
        stopButton.setActionCommand("stop");
        stopButton.addActionListener( this );

        gbC.fill = GridBagConstraints.VERTICAL;
        gbC.anchor = GridBagConstraints.CENTER;
        graphics.add( stopButton, gbC );

        JButton goButton = new JButton( "Go",new ImageIcon( (Image)resources.imageCache.get("greencircle16.gif") ) );
        goButton.setActionCommand("go");
        goButton.addActionListener( this );

        gbC.fill = GridBagConstraints.VERTICAL;
        gbC.anchor = GridBagConstraints.CENTER;
        graphics.add( goButton, gbC );

        clearButton = new JButton( "Clear all" );
        clearButton.setActionCommand("clear");
        clearButton.addActionListener( this );

        gbC.fill = GridBagConstraints.VERTICAL;
        gbC.anchor = GridBagConstraints.WEST;
        gbC.gridwidth = GridBagConstraints.REMAINDER;
        graphics.add( clearButton, gbC );

        gbC.gridwidth = 1;

        gbC.weightx = 0.0f;
        gbC.weighty = 0.0f;

// Add the graphics pane

        add(graphics, BorderLayout.SOUTH);

// Set preferences

        setPreferences();

// Create a timer

        timer = new javax.swing.Timer( 500, this );
        timer.setInitialDelay(0);
	timer.setCoalesce( false );
        timer.start();

};

public class EOFException extends Exception
{
    public EOFException(){;}
};

public int readInt( InputStream s ) throws EOFException, IOException
{
int result = 0;

  try
  {
    for ( int i=0;i<4;i++ )
    {
      int c = s.read();
      if ( c == -1 )
      {
	 throw new EOFException();
      }
      result = result + (c << (8*i));
    }
  }
  catch ( IOException ioe )
  {
    throw ioe;
  }

  return result;
}

public int readShort( InputStream s ) throws EOFException, IOException
{
int result = 0;

  try
  {
    for ( int i=0;i<2;i++ )
    {
      int c = s.read();
      if ( c == -1 )
      {
	 throw new EOFException();
      }
       result = result + (c << (8*i));
    }
  }
  catch ( IOException ioe )
  {
    throw ioe;
  }

  return result;
}

int decodeLHCbNZS( PixieBoogieWoogie pbw ) throws EOFException, IOException
{
int hitCount = 0;

  try
  {
    for (int row = 31; row >= 0; row-- )
    {
      int word = readInt(dataInStream);

      for (int column = 0; column < 32; column++ )
      {
        if ( ((1 << column) & word ) == (1<<column) )
        {
	    // Hack to remove large events	  if ( pbw != null ) pbw.hitPixel( column, row, 1.0 );
          hitCount++;
        }
      }
    }
  }
  catch ( IOException ioe )
  {
    throw ioe;
  }
  catch ( EOFException eof )
  {
    throw eof;
  }

  return hitCount;
}

int decodeAliceNZS( PixieBoogieWoogie pbw ) throws EOFException, IOException
{
int hitCount = 0;

  try
  {
    for (int row = 31; row >= 0; row-- )
    {
      int word = 0;
      for ( int mini_row = 8; mini_row > 0; mini_row-- )
      {
        word |= readInt(dataInStream);
      }

      for (int column = 0; column < 32; column++ )
      {
        if ( ((1 << column) & word ) == (1<<column) )
        {
	  if ( pbw != null ) pbw.hitPixel( column, row, 1.0 );
          hitCount++;
        }
      }
    }
  }
  catch ( IOException ioe )
  {
    throw ioe;
  }
  catch ( EOFException eof )
  {
    throw eof;
  }

  return hitCount;
}

int decodeLHCbZS( PixieBoogieWoogie pbw, int length ) throws EOFException, IOException
{
int hitCount = 0;

  try
  {

    for ( int i=0; i<length; i++ )
    {
      int pixels = dataInStream.read();
      if ( pixels == -1 ) throw new EOFException();
      int addr = dataInStream.read();
      if ( addr == -1 ) throw new EOFException();
      int columnOffset = 8 * (addr & 0x3);
      int row = (addr >> 2) & 0x1f;

      for (int column = 0; column < 8; column++ )
      {
        if ( ((1 << column) & pixels ) == (1<<column) )
        {
	  if ( pbw != null ) pbw.hitPixel( columnOffset+column, row, 1.0 );
          hitCount++;
        }
      }
    }

// If length was odd, read the pad word

    if ( (length & 0x1) == 0x1 )
    {
      int tmp = dataInStream.read();
      if ( tmp == -1 ) throw new EOFException();
      tmp = dataInStream.read();
      if ( tmp == -1 ) throw new EOFException();
    }
  }
  catch ( IOException ioe )
  {
    throw ioe;
  }
  catch ( EOFException eof )
  {
    throw eof;
  }

  return hitCount;
}

int decodeAliceZS( PixieBoogieWoogie pbw, int length ) throws EOFException, IOException
{
int hitCount = 0;

  try
  {
    int oddOffset = -1;
    int evenOffset = -1;
    int length16 = 2*((length + 1)/2);
    for ( int i=0; i<length16; i++ )
    {
      int pixels = dataInStream.read();
      if ( pixels == -1 ) throw new EOFException();
      int addr = dataInStream.read();
      if ( addr == -1 ) throw new EOFException();
      int columnOffset = 8 * (addr & 0x3);
      if ( addr == 0 ) evenOffset++;
      if ( addr == 1 ) oddOffset++;
      if ( (addr & 0x1) == 0 )
      {
        addr = ((evenOffset << 8) | addr) & 0x3ff;
      }
      else
      {
        addr = ((oddOffset << 8) | addr) & 0x3ff;
      } 

      int row = (addr >> 5) & 0x1f; // Compress ALICE row address

      for (int column = 0; column < 8; column++ )
      {
        if ( ((1 << column) & pixels ) == (1<<column) )
        {
	  if ( pbw != null ) pbw.hitPixel( columnOffset+column, row, 1.0 );
          hitCount++;
        }
      }

    }

// If length was odd, read the pad word

    if ( (length16 & 0x1) == 0x1 )
    {
      int tmp = dataInStream.read();
      if ( tmp == -1 ) throw new EOFException();
      tmp = dataInStream.read();
      if ( tmp == -1 ) throw new EOFException();
    }
  }
  catch (IOException ioe)
  {
    throw ioe;
  }
  catch (EOFException eof)
  {
    throw eof;
  }

  return hitCount;
}

int decode0xC0(PixieBoogieWoogie pbw) throws EOFException, IOException
{
int hitCount = 0;

  try
  {
    for(int i=0; i<8; i++)
    {
      int line = readInt(dataInStream);
      for (int column=0; column<16; column++)
      {
 //starting from rhs, check 16 bits at end of line. For each bit equal to 1:
        if(((1<<column)&line) == (1<<column))
        {
          if(pbw != null) pbw.hitPixel(column, i, 1.0);
          hitCount++;
     	}
      }
    }
  }
  catch (IOException ioe){ throw ioe; }
  catch (EOFException eof){ throw eof; }

  return hitCount;
}

public void read_Odin_x00( int length ) throws EOFException, IOException
{
}

public void read_Rich_x81( int length ) throws EOFException, IOException
{

  try
  {
    for ( int count=0;count<length; )
    {
      int ingressHeader = readInt( dataInStream ); count += 4;

      int mask = (ingressHeader>>16) & 0x1ff;

      for ( int ch=0;ch<9;ch++ )
      {

        if ( (mask & 0x1) == 0x1 )
        {
          int l1Header = readInt( dataInStream ); count += 4;
          int nzcount = (l1Header >> 16) & 0x7ff;

          int hpd = (l1Header & 0x7ff);
          if ( overlay )
	  {
            hpd = 0;
	  }

          PixieBoogieWoogie pbw;
          HpdListElement hpdLE = addHpdListElement(hpd);

          if ( hpdLE != null )
          {
	    System.out.println("Added ID " + hpd );
            pbw = null;
          }
          else
	  {
            Integer idx = hpdHash.get(String.valueOf(hpd));
	    hpdLE = hpdList.get( idx.intValue() );
            if ( hpdLE == null )
	    {
	      pbw = null;
            }
            else
	    {
	      pbw = hpdLE.getPBW();
	    }
	  }

          if ((l1Header & 0x40000000) == 0x40000000 ) // GT
          {
            mask = (mask >> 1);
            continue;
          }
          if ( (l1Header & 0x20000000) == 0x20000000 ) // Extended headers
	  {
            int l0Header = readInt( dataInStream ); count += 4;
            l0Header = readInt( dataInStream ); count += 4;
	  }
          int hitCount;
          if ( (l1Header & 0x08000000) == 0x08000000 )
	  {
	    if ((l1Header & 0x10000000) == 0x10000000) // ALICE-LHCb
	    {
              hitCount = decodeAliceZS( pbw, nzcount );
	    }
            else
	    {
              hitCount = decodeLHCbZS( pbw, nzcount );
	    }
            count += 4*((nzcount + 1)/2);
	  }
          else
	  {
	    if ((l1Header & 0x10000000) == 0x10000000) // ALICE-LHCb
	    {
              hitCount = decodeAliceNZS( pbw );
              count += 1024;
	    }
            else
	    {
              hitCount = decodeLHCbNZS( pbw );
              count += 128;
	    }
	  }
          hpdLE.updateOccupancy(hitCount);
          if ( (l1Header & 0x20000000) == 0x20000000 ) // Extended header
	  {
            int l0Trailer = readInt( dataInStream ); count += 4;
	  }
        }
        mask = (mask >> 1);
      }
    }
  }
  catch ( IOException ioe )
  {
      throw ioe;
  }
  catch ( EOFException eof )
  {
      throw eof;
  }
  return;
}

public synchronized HpdListElement addHpdListElement( int hpd )
{

  HpdListElement hpdLE = null;

  if ( hpdHash.containsKey(String.valueOf(hpd)) == false )
  {
    hpdLE = new HpdListElement(hpd,nxPixels,nyPixels,xSize,ySize);
    hpdList.add( hpdLE );
    int index = hpdList.indexOf( hpdLE );
    hpdHash.put(String.valueOf(hpd),new Integer(index));
    hpdLE.addElementsToPanel( anodeListGB );
    anodeListSP.validate();
  }
  
  return hpdLE;

}

public void read_Rich_x80( int length ) throws EOFException, IOException
{

      try
      {
	int count = 0;
	while ( count < length )
	{
          int L1H0 = readInt(dataInStream); count += 4; // L1 header word
          int L0H0 = readInt(dataInStream); count += 4; // L0 header word 0
          int L0H1 = readInt(dataInStream); count += 4; // L0 header word 1

          int hpd = (L0H1 & 0x7ff);
          PixieBoogieWoogie pbw;
          HpdListElement hpdLE = addHpdListElement(hpd);

          if ( hpdLE != null )
          {
	    System.out.println("Added ID " + hpd );
            pbw = null;
          }
          else
	  {
            Integer idx = hpdHash.get(String.valueOf(hpd));
	    hpdLE = hpdList.get( idx.intValue() );
            if ( hpdLE == null )
	    {
	      pbw = null;
            }
            else
	    {
	      pbw = hpdLE.getPBW();
	    }
	  }

// Decode LHCb or ALICE mode from header

	  int mode;
          if ( (L1H0 & 0x1000) == 0x1000 )
	  {
	    mode = 1;
	  }
          else
	  {
            mode = 0;
	  }

// Decode ZS mode from header

	  int zs;
          if ( (L1H0 & 0x800) == 0x800 )
	  {
	    zs = 1;
	  }
          else
	  {
            zs = 0;
	  }

// Get word NZ word count

          int nzcount = L1H0 & 0x7ff;

	  //          System.out.println( mode + " " + zs + " " + nzcount );

          int hitCount;
          if ( zs == 0 )
          {
            if (mode == 0)
            {
              hitCount = decodeLHCbNZS( pbw );
              count += 128;
            }
            else
            {
              hitCount = decodeAliceNZS( pbw );
              count += 1024;
            }
          }
          else
          {
            if (mode == 0)
            {
              hitCount = decodeLHCbZS( pbw, nzcount - 1 );
            }
            else
            {
              hitCount = decodeAliceZS( pbw, nzcount - 1 );
            }
            count += (4*(nzcount / 2));
          }

          hpdLE.updateOccupancy(hitCount);

          int L0P = readInt(dataInStream); count += 4; // Parity

	}
      }
      catch ( EOFException eof )
      {
	 throw eof;
      }
      catch ( IOException ioe )
      {
         throw ioe;
      }
}

public void read_Rich_xC0( int length ) throws EOFException, IOException
{

      try
      {
	int count = 0;
	while ( count < length )
	{
          int ing = readInt(dataInStream); count += 4; // Ingress header word
          int L1H0 = readInt(dataInStream); count += 4; // L1 header word
          int timestamp = readInt(dataInStream); count += 4; // L0 header word 0
          int evid = readInt(dataInStream); count += 4; // Frame and event ID

          int hpd = (L1H0 & 0x7ff);

          PixieBoogieWoogie pbw;
          HpdListElement hpdLE = addHpdListElement(hpd);

          if ( hpdLE != null )
          {
	    System.out.println("Added ID " + hpd );
            pbw = null;
          }
          else
	  {
            Integer idx = hpdHash.get(String.valueOf(hpd));
	    hpdLE = hpdList.get( idx.intValue() );
            if ( hpdLE == null )
	    {
	      pbw = null;
            }
            else
	    {
	      pbw = hpdLE.getPBW();
	    }
	  }

          int hitCount = decode0xC0( pbw );
          count += 32;

          hpdLE.updateOccupancy(hitCount);

	}
      }
      catch ( EOFException eof )
      {
	 throw eof;
      }
      catch ( IOException ioe )
      {
         throw ioe;
      }
}

public void readStream() throws EOFException, IOException
{
   int x;

   while ( true )
   {
      if ( autoClearEvent == true )
      {
        ListIterator<HpdListElement> it = hpdList.listIterator();
        while ( it.hasNext()  )
        {
          HpdListElement hpdLE = it.next();
          PixieBoogieWoogie pbw = hpdLE.getPBW();
          if ( pbw != null ) pbw.clear();
        }
      }

      try
      {
	int mdfLength = readInt(dataInStream);
	//	System.out.println( "mdfLength = " + mdfLength );

	for ( int i=0;i<11;i++ ) // Swallow rest of header
	{
          x = readInt(dataInStream);
	}

        mdfLength -= 48;

        while ( mdfLength > 0 )
	{
          int magic = readShort(dataInStream);
          int length = readShort(dataInStream);
          int type = readShort(dataInStream);
          int source = readShort(dataInStream);
	  //	  System.out.println( "magic = " + magic );
	  //	  System.out.println( "length = " + length );
	  //	  System.out.println( "type = " + type );

          switch( type )
	  {

// RICH version 0x80
          case 0x8009: read_Rich_x80( length-8 ); break;

// RICH version 0x81
          case 0x8109: read_Rich_x81( length-8 ); break;

// RICH version 0xc0 (MAPMTFEB)
          case 0xc009: read_Rich_xC0( length-8 ); break;

// ODIN version 0
//          case 0x0210: read_Odin_x00( length-8 ); break;

          default:

	    for ( int i=0;i<length-8;i++ )
	    {
	      x = dataInStream.read();
	    }
	  }
          mdfLength -= length;
	}
        eventCount++;
        if ( eventCount%1000 == 0 )
	{
	  System.out.println( "Event #" + eventCount );
	}
      }
      catch ( EOFException eof )
      {
	 throw eof;
      }
      catch ( IOException ioe )
      {
         throw ioe;
      }

      try
      {
        Thread.sleep(sleepyTime);
      }
      catch ( InterruptedException inte )
      {
        System.err.println("Warning: " + inte.getMessage() );
      }

   }
}

//
// DataThread handles the IO and decoding
//

public class DataThread extends Thread
{
  public DataThread(){ ; }
  public void run()
  {

//
// Loop until someone signals us to exit
//

      while ( !threadStopFlag )
      {

         try
         {

// Close and destroy the stream/socket if they already exist

	    if ( dataInStream != null ) { dataInStream.close(); dataInStream = null; }
            if ( dataSocket != null ) { dataSocket.close(); dataSocket = null; }

// Find out whether to open a socket or a normal URL

            int port = dataURL.getPort();

            if ( port == 7999 )
	    {
              dataSocket = new Socket( dataURL.getHost(), port );
              dataInStream = dataSocket.getInputStream();
	    }
            else
            {
              dataInStream = dataURL.openStream();
            }

            readStream();

       }
       catch ( EOFException eofe )
       {
           threadStopFlag = !restartAtEOF;
	   System.err.println( "End of file" );
       }
       catch ( IOException ioe )
       {
	   threadStopFlag = true;
	   System.err.println("Warning: " + ioe.getMessage() );
       }
    }


  }
}

public void updateDataURL()
{
// Make a URL representing the source

  dataSourceString = (String)dataSourceCombo.getSelectedItem();
  prefs.put("JPixieBoogieWoogie.dataSourcePath",dataSourceString);
  System.out.println("Setting source " + dataSourceString);

  try
  {

    URL newDataURL = new URL(dataSourceString);
    if ( newDataURL == null ) System.err.println("Error forming data source URL: " + dataSourceString );

    dataURL = null;
    dataURL = newDataURL;

  }
  catch ( MalformedURLException ue )
  {
     System.err.println("Warning: " + ue.getMessage() );
  }

  return;
}

public void setPreferences()
{
  autoClearEvent = prefs.getBoolean("JPixieBoogieWoogie.autoClearEvent",false);
  clearEventButton.setSelected(autoClearEvent);

  return;
}

public void makeOptionMenu( JComponent m, ActionListener l )
{
// Colour buttons

    fgMenuItem = new JMenuItem( "Foreground colour..." );
    fgMenuItem.setActionCommand("fgcolor");
    fgMenuItem.addActionListener( l );

    m.add( fgMenuItem );

    bgMenuItem = new JMenuItem( "Background colour..." );
    bgMenuItem.setActionCommand("bgcolor");
    bgMenuItem.addActionListener( l );

    m.add( bgMenuItem );

    gridMenuItem = new JMenuItem( "Grid colour..." );
    gridMenuItem.setActionCommand("gridcolor");
    gridMenuItem.addActionListener( l );


    m.add( gridMenuItem );

    m.add( new JSeparator() );

    JMenu rotateMenu = new JMenu( "Rotation" );

    ButtonGroup rotateGroup = new ButtonGroup();

    rotate0Button = new JRadioButtonMenuItem( "0 deg" );
    rotate0Button.setActionCommand("rotate0");
    rotate0Button.addActionListener(this);
    rotate0Button.setSelected( true );
    rotateMenu.add( rotate0Button );
    rotateGroup.add( rotate0Button );
    rotate90Button = new JRadioButtonMenuItem( "90 deg" );
    rotate90Button.setActionCommand("rotate90");
    rotate90Button.addActionListener(this);
    rotateMenu.add( rotate90Button );
    rotateGroup.add( rotate90Button );
    rotate180Button = new JRadioButtonMenuItem( "180 deg" );
    rotate180Button.setActionCommand("rotate180");
    rotate180Button.addActionListener(this);
    rotateMenu.add( rotate180Button );
    rotateGroup.add( rotate180Button );
    rotate270Button = new JRadioButtonMenuItem( "270 deg" );
    rotate270Button.setActionCommand("rotate270");
    rotate270Button.addActionListener(this);
    rotateMenu.add( rotate270Button );
    rotateGroup.add( rotate270Button );

    m.add( rotateMenu );

    m.add( new JSeparator() );

    clearEventButton = new JRadioButtonMenuItem( "Auto-clear event" );
    clearEventButton.addActionListener( l );
    clearEventButton.setActionCommand("clearEvent");
    clearEventButton.setSelected( autoClearEvent );
    m.add( clearEventButton );

    loopButton = new JRadioButtonMenuItem( "Restart at end of file" );
    loopButton.addActionListener( l );
    loopButton.setActionCommand("restartAtEOF");
    loopButton.setSelected( restartAtEOF );
    m.add( loopButton );

    adaptiveButton = new JRadioButtonMenuItem( "Adaptive display" );
    adaptiveButton.addActionListener( l );
    adaptiveButton.setActionCommand("adaptive");
    adaptiveButton.setSelected( adaptiveDisplay );
    m.add( adaptiveButton );

    overlayButton = new JRadioButtonMenuItem( "Overlay" );
    overlayButton.addActionListener( l );
    overlayButton.setActionCommand("overlay");
    overlayButton.setSelected( overlay );
    m.add( overlayButton );

   return;
}

// On every tick of the clock we ask the display to update

public void actionPerformed( ActionEvent e )
{
String cmd = e.getActionCommand();

   if ( cmd == null )
   {
      ticks++;

// Redraw the display on every tick

      ListIterator<HpdListElement> it = hpdList.listIterator();
      while ( it.hasNext()  )
      {
        HpdListElement hpdLE = it.next();
        PixieBoogieWoogie pbw = hpdLE.getPBW();
        if ( pbw != null ) pbw.refresh();
      }

      //       System.out.println( "ticks=" + ticks + " ticks mod 10 =" + ticks%10 + " delay=" + timer.getDelay() );
   }
   else if ( cmd.equals( "browse" ) )
   {
     JFileChooser chooser = new JFileChooser();
     javax.swing.filechooser.FileFilter filter = new javax.swing.filechooser.FileFilter() { public boolean accept(File f){ return f.getPath().endsWith(".mdf");} public String getDescription(){return new String("MDF files");}};
     //     chooser.setFileFilter( new FileNameExtensionFilter("MDF file","mdf") );
     chooser.setFileFilter( filter );
     int chooserc = chooser.showOpenDialog(null);
     if(chooserc == JFileChooser.APPROVE_OPTION)
     {
       File mdfFile = chooser.getSelectedFile();
       dataSourceCombo.insertItemAt( mdfFile.toURI().toString(),0 );
       dataSourceCombo.setSelectedIndex(0);
       prefs.put("JPixieBoogieWoogie.dataSourcePath",mdfFile.toURI().toString());
       prefs.put("JPixieBoogieWoogie.dataSourceDirectory",mdfFile.getParent());
       updateDataURL();
     }
   }
   else if ( cmd.equals( "stop" ) )
   {
      stopThread();
   }
   else if ( cmd.equals( "go" ) )
   {
      startThread();
   }
   else if ( cmd.equals( "clear" ) )
   {
      eventCount = 0;
      ListIterator<HpdListElement> it = hpdList.listIterator();
      while ( it.hasNext()  )
      {
        HpdListElement hpdLE = it.next();
        PixieBoogieWoogie pbw = hpdLE.getPBW();
        hpdLE.resetOccupancy();
        if ( pbw != null ) pbw.clear();
      }
   }
   else if ( cmd.equals( "rotate0" ) )
   {
     setRotation( 0 );
   }
   else if ( cmd.equals( "rotate90" ) )
   {
     setRotation( 1 );
   }
   else if ( cmd.equals( "rotate180" ) )
   {
     setRotation( 2 );
   }
   else if ( cmd.equals( "rotate270" ) )
   {
     setRotation( 3 );
   }
   else if ( cmd.equals( "fgcolor" ) || cmd.equals( "bgcolor" ) || cmd.equals( "gridcolor" ) )
   {
       setColor( cmd );
   }
   else if ( cmd.equals( "exit" ) )
   { 
       System.exit(0);  
   }
   else if ( cmd.equals( "source" ) )
   {
      updateDataURL();
   }
   else if ( cmd.equals( "hpdId" ) )
   {

      String hpdIdString = (String)hpdIdCombo.getSelectedItem();
      hpdId = Integer.parseInt(hpdIdString);
      prefs.putInt("JPixieBoogieWoogie.hpdId",hpdId);

      HpdListElement hpdLE = addHpdListElement(hpdId);
      if ( hpdLE == null )
      {
	System.out.println("Duplicate ID " + hpdId + " rejected" );
      }
      else
      {
	System.out.println("Added ID " + hpdId );
      }

   }
   else if ( cmd.equals( "sortUp" ) )
   {
     int sortBy;
     if ( sortByOccupancyRB.isSelected() )
     {
       sortBy = HpdListElementComparator.SORT_BY_OCCUPANCY;
     }
     else
     {
       sortBy = HpdListElementComparator.SORT_BY_HARDWARE_ID;
     }
     sortHpdList( sortBy, false );
   }
   else if ( cmd.equals( "sortDown" ) )
   {
     int sortBy;
     if ( sortByOccupancyRB.isSelected() )
     {
       sortBy = HpdListElementComparator.SORT_BY_OCCUPANCY;
     }
     else
     {
       sortBy = HpdListElementComparator.SORT_BY_HARDWARE_ID;
     }
     sortHpdList( sortBy, true );
   }
   else if ( cmd.equals( "sleepyTime" ) )
   {
      String sleepyTimeString = sleepyTimeTF.getText();
      sleepyTime = Integer.parseInt(sleepyTimeString);
      prefs.putInt("JPixieBoogieWoogie.sleepyTime",sleepyTime);
   }
   else if ( cmd.equals( "clearEvent" ) )
   {
      autoClearEvent = !autoClearEvent;
      prefs.putBoolean("JPixieBoogieWoogie.autoClearEvent",autoClearEvent);
      clearEventButton.setSelected( autoClearEvent );
   }
   else if ( cmd.equals( "restartAtEOF" ) )
   {
      restartAtEOF = !restartAtEOF;
      prefs.putBoolean("JPixieBoogieWoogie.restartAtEOF",restartAtEOF);
      loopButton.setSelected( restartAtEOF );
   }
   else if ( cmd.equals( "adaptive" ) )
   {
      adaptiveDisplay = !adaptiveDisplay;
      prefs.putBoolean("JPixieBoogieWoogie.adaptiveDisplay",adaptiveDisplay);
      adaptiveButton.setSelected( adaptiveDisplay );

      ListIterator<HpdListElement> it = hpdList.listIterator();
      while ( it.hasNext()  )
      {
        HpdListElement hpdLE = it.next();
        PixieBoogieWoogie pbw = hpdLE.getPBW();
        if ( pbw != null ) pbw.setAdaptiveDisplay( adaptiveDisplay );
      }
   }
   else if ( cmd.equals( "overlay" ) )
   {
      overlay = !overlay;
      prefs.putBoolean("JPixieBoogieWoogie.overlay",overlay);
      overlayButton.setSelected( overlay );
   }

       return;
}

public synchronized void sortHpdList( int sortBy, boolean ascending )
{
  Collections.sort( hpdList, new HpdListElementComparator(sortBy, ascending) );

// Clear scrolling list and hash map

  hpdHash.clear();
  int idx = 0;
  anodeListGB.removeAll();

// Rebuild scrolling list and hash map

  ListIterator<HpdListElement> it = hpdList.listIterator();
  while ( it.hasNext()  )
  {
    HpdListElement hpdLE = it.next();
    hpdLE.addElementsToPanel( anodeListGB );
    hpdHash.put( String.valueOf(hpdLE.getHardwareId()), new Integer(idx) );
    idx++;
  }
  anodeListSP.validate();
}

public void setRotation( int quadrant )
{
      ListIterator<HpdListElement> it = hpdList.listIterator();
      while ( it.hasNext()  )
      {
        HpdListElement hpdLE = it.next();
        PixieBoogieWoogie pbw = hpdLE.getPBW();
        if ( pbw != null )
        {
          pbw.setRotation( quadrant );
        }
      }

   return;
}

public void setColor( String cmd )
{
Color newColor = null;

   if ( cmd.equals( "fgcolor" ) )
     newColor = colorChooser.showDialog( this, "Foreground colour chooser", fgColor );
   else if ( cmd.equals( "bgcolor" ) )
     newColor = colorChooser.showDialog( this, "Background colour chooser", bgColor );
   else if ( cmd.equals( "gridcolor" ) )
     newColor = colorChooser.showDialog( this, "Grid colour chooser", gridColor );

   if ( newColor != null )
   {
      ListIterator<HpdListElement> it = hpdList.listIterator();
      while ( it.hasNext()  )
      {
        HpdListElement hpdLE = it.next();
        PixieBoogieWoogie pbw = hpdLE.getPBW();
        if ( pbw != null )
        {
          if ( cmd.equals( "fgcolor" ) )
            pbw.setForegroundColor( newColor );
          else if ( cmd.equals( "bgcolor" ) )
            pbw.setBackgroundColor( newColor );
          else if ( cmd.equals( "gridcolor" ) )
            pbw.setGridColor( newColor );
        }
      }

   }

   return;
}

public void startThread()
{
    threadStopFlag = false;
    dth = null;
    dth = new DataThread();
    dth.start();
}

public void stopThread()
{

//
// Set the stop flag so that the thread exits and does not try to reopen the file
//

    threadStopFlag = true;

    try
    {

// Close and destroy the stream/socket if they already exist

       dataInStream.close();
       dataSocket.close();
    }
    catch (NullPointerException npe )
    {
    }
    catch (IOException ioe )
    {
    }

    
}

    public void start(){ timer.start(); }

// Suspend time (effectively stops animation)

    public void stop(){ timer.stop(); }

private class HpdListElementComparator implements Comparator<HpdListElement>
{

  public static final int SORT_BY_HARDWARE_ID = 1;
  public static final int SORT_BY_OCCUPANCY = 2;
  int sortBy;
  boolean ascending;

  public HpdListElementComparator( int sb, boolean as )
  {
    sortBy = sb;
    ascending = as;
  }

  public int compare( HpdListElement e1, HpdListElement e2 )
  {
      if ( sortBy == SORT_BY_HARDWARE_ID )
      {
        return HpdListElement.compareHwId( e1, e2, ascending );
      }
      else
      {
        return HpdListElement.compareOccupancy( e1, e2, ascending );
      }
  }
}

}





































