package cbsw.applet;

import java.io.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.html.*;
import javax.swing.border.*;
import java.util.*;
import java.text.*;
import cbsw.pbw.*;
import cbsw.applet.*;

public class HpdListElement implements ActionListener
{

  int hardwareId;
  JFrame anodeFrame;
  PixieBoogieWoogie pbw;
  JLabel idLabel;
  JCheckBox displayCB;
  JCheckBox adaptiveCB;
  JProgressBar occupancyPB;
  float occupancy;
  DecimalFormat occupancyDF;
  int totalHitCount;
  int updateOccupancyCount;
  JTextField saturationTF;
  JButton clearButton;
  int nxPixels;
  int nyPixels;
  int xSize;
  int ySize;

  public HpdListElement( int id, int nx, int ny, int dx, int dy )
  {
    hardwareId = id;

    nxPixels = nx;
    nyPixels = ny;
    xSize = dx;
    ySize = dy;

    occupancyDF = new DecimalFormat("0.0");

// Visibility checkBox

    displayCB = new JCheckBox();
    displayCB.setActionCommand("display");
    displayCB.addActionListener( this );
    displayCB.setToolTipText("Create/destroy the display");

// Label

    idLabel = new JLabel( Integer.toString(id) );

// Occupancy progressBar

    occupancyPB = new JProgressBar(0,500);

    occupancyPB.setValue(0);
    occupancyPB.setBackground(Color.green);
    occupancyPB.setString( "Occupancy:" + 0 );
    occupancyPB.setStringPainted(true);
    occupancyPB.setToolTipText("Average number of hits per event");

// Visibility checkBox

    adaptiveCB = new JCheckBox();
    adaptiveCB.setActionCommand("adaptive");
    adaptiveCB.addActionListener( this );
    adaptiveCB.setSelected( true );
    adaptiveCB.setToolTipText("Enable adaptive display");

// Saturation count textField

    saturationTF = new JTextField( Integer.toString(1), 4 );
    saturationTF.setActionCommand("saturation");
    saturationTF.addActionListener( this );
    saturationTF.setToolTipText("Cell saturation value");

// Clear button

    clearButton = new JButton( "Clear" );
    clearButton.setActionCommand("clear");
    clearButton.addActionListener( this );
    clearButton.setToolTipText("Clear the display");

  };

  public void addElementsToPanel( JPanel panel )
  {

    GridBagConstraints gbC = new GridBagConstraints();

    gbC.insets = new Insets(0,0,0,1);

// Display checkBox

    gbC.fill = GridBagConstraints.NONE;
    gbC.anchor = GridBagConstraints.WEST;
    panel.add( displayCB, gbC );

// Label

    gbC.fill = GridBagConstraints.NONE;
    gbC.anchor = GridBagConstraints.WEST;

    panel.add( idLabel, gbC );

// Occupancy progressBar

    gbC.fill = GridBagConstraints.HORIZONTAL;
    gbC.anchor = GridBagConstraints.WEST;
    gbC.weightx = 1.0;
    gbC.weighty = 1.0;

    panel.add( occupancyPB, gbC );

    gbC.weightx = 0.0;
    gbC.weighty = 0.0;

// Adaptive display checkBox

    gbC.fill = GridBagConstraints.NONE;
    gbC.anchor = GridBagConstraints.WEST;
    panel.add( adaptiveCB, gbC );

// Saturation count textField

    gbC.fill = GridBagConstraints.NONE;
    gbC.anchor = GridBagConstraints.WEST;
    panel.add( saturationTF, gbC );

// Clear button

    gbC.fill = GridBagConstraints.NONE;
    gbC.anchor = GridBagConstraints.WEST;
    gbC.gridwidth = GridBagConstraints.REMAINDER;
    panel.add( clearButton, gbC );

  };

  public PixieBoogieWoogie getPBW(){ return pbw; }

  public int getHardwareId(){ return hardwareId; }

  public static int compareHwId( HpdListElement e1, HpdListElement e2, boolean ascending )
  {
    if ( ascending )
      return e1.hardwareId - e2.hardwareId;
    else
      return e2.hardwareId - e1.hardwareId;
  }

  public static int compareOccupancy( HpdListElement e1, HpdListElement e2, boolean ascending )
  {
    int order;

    if ( e1.occupancy < e2.occupancy )
      order = -1;
    else if ( e1.occupancy > e2.occupancy )
      order = 1;
    else
      order = 0;

    if ( ascending )
      return order;
    else
      return (-order);

  }

  public void resetOccupancy()
  {
    totalHitCount = 0;
    updateOccupancyCount = 0;

    occupancy = (float)0.0;

    occupancyPB.setValue(0);
    occupancyPB.setString( "Occupancy:" + occupancyDF.format( new Float(occupancy)) );

    return;
  }

  public void updateOccupancy( int hitCount )
  {
    totalHitCount += hitCount;
    updateOccupancyCount++;

    occupancy = (float)totalHitCount/(float)updateOccupancyCount;

    occupancyPB.setValue((int)(10*occupancy));
    occupancyPB.setString( "Occupancy:" + occupancyDF.format( new Float(occupancy)) );

    return;
  }

  public void actionPerformed( ActionEvent e )
  {
    String cmd = e.getActionCommand();

    if ( cmd == null )
    {
    }
    else if ( cmd.equals( "display" ) )
    {
      if ( displayCB.isSelected() )
      {
	if ( anodeFrame == null )
	{
          anodeFrame = new JFrame("PBW - " + Integer.toString(hardwareId));
          Container anodeCP = anodeFrame.getContentPane();

          pbw = new PixieBoogieWoogie(nxPixels,nyPixels,xSize,ySize);
          anodeCP.add( pbw );

          clearButton.addActionListener( pbw );

	  if ( adaptiveCB.isSelected() )
	  {
	    pbw.setAdaptiveDisplay( true );
          }
          else
	  {
	    pbw.setAdaptiveDisplay( false );
	  }

          anodeFrame.pack();
	}
        anodeFrame.setVisible( true );
      }
      else
      {
	anodeFrame.setVisible( false );
        pbw = null;
	anodeFrame = null;
      }
    }
    else if ( cmd.equals( "saturation" ) )
    {
      String saturationString = saturationTF.getText();
      int saturation = Integer.parseInt(saturationString);
      if ( pbw != null )
      {
	pbw.setSaturationCount(saturation);
      }
    }
    else if ( cmd.equals( "clear" ) )
    {
      if ( pbw != null )
      {
	pbw.clear();
        resetOccupancy();
      }
    }
    else if ( cmd.equals( "adaptive" ) )
    {
      if ( pbw != null )
      {
	if ( adaptiveCB.isSelected() )
	{
	  pbw.setAdaptiveDisplay( true );
        }
        else
	{
	  pbw.setAdaptiveDisplay( false );
	}
      }
    }
  };


};
