/*

Simple semaphore class.

Steve Wotton Aug-96

*/

#ifndef _semaphore_h
#define _semaphore_h

#include <sys/sem.h>
#include <stdlib.h>
#include <errno.h>
#include "utils.h"

#if defined(_SEM_SEMUN_UNDEFINED)
union semun
{
  int val;                           // <= value for SETVAL
  struct semid_ds *buf;              // <= buffer for IPC_STAT & IPC_SET
  unsigned short int *array;         // <= array for GETALL & SETALL
  struct seminfo *__buf;             // <= buffer for IPC_INFO
};
#endif

class semaphore
{
private:

   int id;
   void op( struct sembuf * );
   void ctl( int, int, int );
   void ctl( int, int, unsigned short * );
   void mksem( int nsems, int perm );

protected:

   key_t key;

public:

   bool openedNew;

   semaphore( key_t k, int nsems=1, int perm=0660 );
   semaphore( const char *file, int nsems=1, int perm=0660 );
   ~semaphore(){ remove(); }

   void get( int n=0 );
   void release( int n=0 );
   int getval( int n=0 );
   void setval( int n=0, int val=1 );
   int testget( int n=0 );
   void remove( void );
   key_t getKey(void);
};

inline key_t semaphore::getKey(void){ return key; }

inline void semaphore::ctl( int semnum, int cmd, int arg )
{
semun argun;

   argun.val = arg;
   int rc = semctl(id,semnum,cmd,argun);
   return;
}

inline void semaphore::ctl( int semnum, int cmd, unsigned short *arg )
{
semun argun;

   argun.array = arg;
   int rc = semctl(id,semnum,cmd,argun);
   return;
}

inline void semaphore::get( int n )
{
struct sembuf sops={0,-1,0};

   sops.sem_num=n;
   op( &sops );
   return;
}

inline void semaphore::release( int n )
{
struct sembuf sops={0,1,0};

   sops.sem_num=n;
   op( &sops );
   return;
}

inline int semaphore::getval( int n )
{
   ctl( n, GETVAL, 0 );
}

inline void semaphore::setval( int n, int val )
{
   ctl( n, SETVAL, val );
   return;
}

#endif

