#if !defined(_mdfrich_h)
#define _mdfrich_h

struct mdfHeader_t
{
  unsigned length;
  unsigned length_1;
  unsigned length_2;
  unsigned checksum;
  unsigned compression :8;
  unsigned size :4;
  unsigned version :4;
  unsigned dataType :8;
  unsigned spare :8;
};

struct eventHeader_t
{
  unsigned mask[4];
  unsigned run;
  unsigned orbit;
  unsigned bunch;
};

struct rawHeader_t
{
  unsigned short magic;
  unsigned short length; // including this header
  unsigned char type;
  unsigned char version;
  unsigned short source;
};

struct ingressHeader_t
{
  unsigned event :8;
  unsigned bxid  :8;
  unsigned channelMask :12;
  unsigned id :2;
  unsigned truncated : 1;
  unsigned :1;
};

struct l1Header_xc0_t // Testbeam 2012
{
  unsigned hpd :11;
  unsigned event :5;
  unsigned nzcount :11;
  unsigned zs :1;
  unsigned mode :1;
  unsigned ext :1;
  unsigned gt :1;
  unsigned reserved :1;
  unsigned timestamp;
  unsigned short evid;
  unsigned short frame;
};

struct l1Header_x81_t
{
  unsigned hpd :11;
  unsigned event :5;
  unsigned nzcount :11;
  unsigned zs :1;
  unsigned mode :1;
  unsigned ext :1;
  unsigned gt :1;
  unsigned reserved :1;
};

struct l1Header_x80_t
{
  unsigned nzcount :11;
  unsigned zs :1;
  unsigned mode :1;
  unsigned pad_0 :3;
  unsigned event :15;
  unsigned reserved :1;
};

struct l1Trailer_t
{
  unsigned parity;
};

struct l0Header_t
{
  unsigned event :8;
  unsigned pad_0 :8;
  unsigned bxid :12;
  unsigned pad_1 :3;
  unsigned parity_0 :1;
  unsigned hpd :11;
  unsigned fifoOccupancy :4;
  unsigned fifoEmpty :1;
  unsigned fifoFull :1;
  unsigned testPattern :1;
  unsigned calibration :1;
  unsigned mode :1;
  unsigned otherGolStatus :1;
  unsigned pad_2 :10;
  unsigned parity_1 :1;
};

struct odin_t
{
  unsigned run;
  unsigned eventType;
  unsigned orbit;
  unsigned eventId[2];
  unsigned gpsTime[2];
  unsigned status :24;
  unsigned errors :8;
  unsigned bunchId :12;
  unsigned :4;
  unsigned triggerType :3;
  unsigned readoutType :2;
  unsigned forcedTrigger :1;
  unsigned bxType :2;
  unsigned bunchCurrent :8;
};

#endif
