/*
 * Decompiled with CFR 0.152.
 */
package cbsw.lhcb;

import cbsw.gui.CellArray;
import cbsw.gui.GuiJPanel;
import cbsw.gui.GuiPreferences;
import cbsw.gui.NetPreferences;
import cbsw.lhcb.DbPreferencesJP;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.text.DateFormat;
import java.util.Date;
import java.util.Vector;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class JRichEcConfigurator
extends GuiJPanel {
    CellArray ec;
    Preferences guiPrefs;
    Preferences richPrefs;
    JComboBox<String> elementaryCellCB;
    JComboBox<String> preferencesCB;
    JComboBox<String> db1CB;
    JComboBox<String> db0CB;
    JMenu rotateMenu;
    JTextArea rotationKeyTA;
    JFrame claroJF;
    JPanel claroGlobalJP;
    JPanel claroChannelJP;
    JFrame marocJF;
    JPanel marocSettingsJP;
    JTextField marocDac0TF;
    JTextField marocDac1TF;
    JTextField marocGainTF;
    JCheckBox marocSumCB;
    JCheckBox marocCtestCB;
    JCheckBox marocMaskOr1CB;
    JCheckBox marocMaskOr2CB;
    JTextArea textArea;
    JScrollPane textSP;
    ActionListener exitAL = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            System.exit(0);
        }
    };
    ActionListener rotateAL = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("rotate0")) {
                JRichEcConfigurator.this.setRotation(0);
            } else if (string.equals("rotate90")) {
                JRichEcConfigurator.this.setRotation(1);
            } else if (string.equals("rotate180")) {
                JRichEcConfigurator.this.setRotation(2);
            } else if (string.equals("rotate270")) {
                JRichEcConfigurator.this.setRotation(3);
            }
        }
    };
    ActionListener dbAL = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            Preferences preferences = Preferences.userRoot().node("RICH/DB/---- ----");
            DbPreferencesJP dbPreferencesJP = new DbPreferencesJP(JRichEcConfigurator.this.guiPrefs, preferences, "db.");
            int n = JOptionPane.showConfirmDialog(null, dbPreferencesJP, "DB options", 2);
            if (n == 0) {
                GuiJPanel.savePreferences(dbPreferencesJP.getPrefsUserNode(), dbPreferencesJP);
            }
        }
    };
    ActionListener exportSetAL = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            String string = jMenuItem.getText();
            GuiPreferences.exportPreferences("RICH/preferences/" + string);
        }
    };
    ActionListener exportAL = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GuiPreferences.exportPreferences(null);
        }
    };
    ActionListener importAL = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GuiPreferences.importPreferences();
        }
    };
    ActionListener dnaMenuAL = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Preferences preferences = Preferences.userRoot().node("RICH/DB/---- ----");
            NetPreferences netPreferences = new NetPreferences(preferences, "net.");
            int n = JOptionPane.showConfirmDialog(null, netPreferences, "DB Network preferences", 2);
            if (n == 0) {
                GuiJPanel.savePreferences(netPreferences.getPrefsUserNode(), netPreferences);
            }
        }
    };
    ActionListener pcNetMenuAL = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Preferences preferences = Preferences.userRoot().node("RICH/PC");
            NetPreferences netPreferences = new NetPreferences(preferences, "net.");
            int n = JOptionPane.showConfirmDialog(null, netPreferences, "PC network settings", 2);
            if (n == 0) {
                GuiJPanel.savePreferences(preferences, netPreferences);
            }
        }
    };
    ActionListener selectECAL = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JRichEcConfigurator.this.guiPrefs.put("EC", (String)JRichEcConfigurator.this.elementaryCellCB.getSelectedItem());
            JRichEcConfigurator.this.updateEcSet();
        }
    };
    ActionListener showButtonAL = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)JRichEcConfigurator.this.elementaryCellCB.getSelectedItem();
            String string2 = JRichEcConfigurator.this.richPrefs.node("EC").node(string).get("type", "R");
            JRichEcConfigurator.this.textArea.setText(null);
            Vector<Point> vector = JRichEcConfigurator.this.ec.getSelectedCells();
            for (Point point : vector) {
                String string3;
                Preferences preferences = JRichEcConfigurator.this.richPrefs.node("xy").node(String.format("%1$02d%2$02d", point.x, point.y));
                String string4 = preferences.get("pd", "A");
                if (string2.equals("H")) {
                    string4 = "H";
                }
                String string5 = preferences.get("anode", "1");
                String string6 = Preferences.userNodeForPackage(JRichEcConfigurator.class).node("JRichEcControl").get("runtime.feb-type", "CLARO");
                Preferences preferences2 = JRichEcConfigurator.this.richPrefs.node(string6).node("PD").node(string4).node(string5);
                String string7 = preferences2.get("db", "1");
                String string8 = preferences2.get("asic", "0");
                String string9 = preferences2.get("channel", "0");
                if (string6.equals("CLARO")) {
                    string3 = preferences2.get("feb", "0");
                    String string10 = String.format("%1$s[%2$s] [DB,FEB,ASIC,channel]=[%3$s,%4$s,%5$s,%6$s]", string4, string5, string7, string3, string8, string9);
                    JRichEcConfigurator.this.textArea.append(string10 + "\n");
                    continue;
                }
                string3 = String.format("%1$s[%2$s] [DB,ASIC,channel]=[%3$s,%4$s,%5$s]", string4, string5, string7, string8, string9);
                JRichEcConfigurator.this.textArea.append(string3 + "\n");
            }
        }
    };
    ActionListener setMarocButtonAL = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Preferences preferences = JRichEcConfigurator.this.richPrefs.node("preferences").node((String)JRichEcConfigurator.this.preferencesCB.getSelectedItem());
            JRichEcConfigurator.this.textArea.setText(null);
            boolean[] blArray = new boolean[4];
            for (int i = 0; i < 4; ++i) {
                blArray[i] = true;
            }
            Vector<Point> vector = JRichEcConfigurator.this.ec.getSelectedCells();
            for (Point point : vector) {
                Preferences preferences2;
                Preferences preferences3 = JRichEcConfigurator.this.richPrefs.node("xy").node(String.format("%1$02d%2$02d", point.x, point.y));
                String string = preferences3.get("pd", "A");
                String string2 = preferences3.get("anode", "1");
                Preferences preferences4 = JRichEcConfigurator.this.richPrefs.node("MAROC3/PD").node(string).node(string2);
                String string3 = preferences4.get("db", "1");
                String string4 = preferences4.get("feb", "0");
                String string5 = preferences4.get("asic", "0");
                String string6 = preferences4.get("channel", "0");
                String string7 = String.format("%1$s[%2$s] [DB,FEB,ASIC,channel]=[%3$s,%4$s,%5$s,%6$s]", string, string2, string3, string4, string5, string6);
                boolean bl = false;
                if (string.equals("A")) {
                    bl = blArray[0];
                    blArray[0] = false;
                }
                if (string.equals("B")) {
                    bl = blArray[1];
                    blArray[1] = false;
                }
                if (string.equals("C")) {
                    bl = blArray[2];
                    blArray[2] = false;
                }
                if (string.equals("D")) {
                    bl = blArray[3];
                    blArray[3] = false;
                }
                if (bl) {
                    GuiJPanel.savePreferences(preferences.node(string), JRichEcConfigurator.this.marocSettingsJP);
                    preferences2 = preferences.node(string);
                    preferences2.put("maroc.dac.0", JRichEcConfigurator.this.marocDac0TF.getText());
                    preferences2.put("maroc.dac.1", JRichEcConfigurator.this.marocDac1TF.getText());
                }
                preferences2 = preferences.node(string).node(string2);
                preferences2.put("maroc.gain", JRichEcConfigurator.this.marocGainTF.getText());
                preferences2.putBoolean("maroc.sum", JRichEcConfigurator.this.marocSumCB.isSelected());
                preferences2.putBoolean("maroc.ctest", JRichEcConfigurator.this.marocCtestCB.isSelected());
                preferences2.putBoolean("maroc.mask-or1", JRichEcConfigurator.this.marocMaskOr1CB.isSelected());
                preferences2.putBoolean("maroc.mask-or2", JRichEcConfigurator.this.marocMaskOr2CB.isSelected());
                JRichEcConfigurator.this.textArea.append(string7 + "\n");
            }
            JRichEcConfigurator.this.marocJF.setVisible(false);
            JRichEcConfigurator.this.richPrefs.put("timestamp", DateFormat.getDateTimeInstance().format(new Date()));
            try {
                preferences.flush();
            }
            catch (BackingStoreException backingStoreException) {
                backingStoreException.printStackTrace();
            }
        }
    };
    ActionListener cancelMarocButtonAL = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JRichEcConfigurator.this.marocJF.setVisible(false);
        }
    };
    ActionListener setClaroButtonAL = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)JRichEcConfigurator.this.preferencesCB.getSelectedItem();
            Preferences preferences = JRichEcConfigurator.this.richPrefs.node("preferences").node(string);
            String string2 = (String)JRichEcConfigurator.this.elementaryCellCB.getSelectedItem();
            String string3 = JRichEcConfigurator.this.richPrefs.node("EC").node(string2).get("type", "R");
            JRichEcConfigurator.this.textArea.setText(null);
            boolean[] blArray = new boolean[4];
            for (int i = 0; i < 4; ++i) {
                blArray[i] = true;
            }
            Vector<Point> vector = JRichEcConfigurator.this.ec.getSelectedCells();
            for (Point point : vector) {
                Preferences preferences2 = JRichEcConfigurator.this.richPrefs.node("xy").node(String.format("%1$02d%2$02d", point.x, point.y));
                String string4 = preferences2.get("pd", "A");
                if (string3.equals("H")) {
                    string4 = "H";
                }
                String string5 = preferences2.get("anode", "1");
                Preferences preferences3 = JRichEcConfigurator.this.richPrefs.node("CLARO/PD").node(string4).node(string5);
                String string6 = preferences3.get("db", "1");
                String string7 = preferences3.get("feb", "0");
                String string8 = preferences3.get("asic", "0");
                String string9 = preferences3.get("channel", "0");
                String string10 = String.format("%1$s[%2$s] [DB,FEB,ASIC,channel]=[%3$s,%4$s,%5$s,%6$s]", string4, string5, string6, string7, string8, string9);
                boolean bl = false;
                if (string4.equals("H")) {
                    bl = blArray[0];
                    blArray[0] = false;
                }
                if (string4.equals("A")) {
                    bl = blArray[0];
                    blArray[0] = false;
                }
                if (string4.equals("B")) {
                    bl = blArray[1];
                    blArray[1] = false;
                }
                if (string4.equals("C")) {
                    bl = blArray[2];
                    blArray[2] = false;
                }
                if (string4.equals("D")) {
                    bl = blArray[3];
                    blArray[3] = false;
                }
                if (bl) {
                    GuiJPanel.savePreferences(preferences.node(string4), JRichEcConfigurator.this.claroGlobalJP);
                }
                GuiJPanel.savePreferences(preferences.node(string4).node(string5), JRichEcConfigurator.this.claroChannelJP);
                JRichEcConfigurator.this.textArea.append(string10 + "\n");
            }
            JRichEcConfigurator.this.claroJF.setVisible(false);
            try {
                preferences.sync();
            }
            catch (BackingStoreException backingStoreException) {
                backingStoreException.printStackTrace();
            }
        }
    };
    ActionListener cancelClaroButtonAL = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JRichEcConfigurator.this.claroJF.setVisible(false);
        }
    };
    ActionListener setClaroAL = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JRichEcConfigurator.this.claroJF.setVisible(true);
        }
    };
    ActionListener setMarocAL = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JRichEcConfigurator.this.marocJF.setVisible(true);
        }
    };
    ItemListener dbCBIL = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                JComboBox jComboBox = (JComboBox)itemEvent.getSource();
                Preferences.userRoot().node("RICH/DB").node((String)jComboBox.getSelectedItem());
                Preferences preferences = JRichEcConfigurator.this.richPrefs.node("EC").node((String)JRichEcConfigurator.this.elementaryCellCB.getSelectedItem());
                preferences.put(jComboBox.getName(), (String)jComboBox.getSelectedItem());
            }
        }
    };
    ItemListener prefsCBIL = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                JComboBox jComboBox = (JComboBox)itemEvent.getSource();
                Preferences.userRoot().node("RICH/preferences").node((String)jComboBox.getSelectedItem());
                Preferences preferences = JRichEcConfigurator.this.richPrefs.node("EC").node((String)JRichEcConfigurator.this.elementaryCellCB.getSelectedItem());
                preferences.put(jComboBox.getName(), (String)jComboBox.getSelectedItem());
            }
        }
    };

    public void setRotation(int n) {
        Preferences preferences = this.richPrefs.node("EC").node((String)this.elementaryCellCB.getSelectedItem());
        this.ec.setRotation(n);
        preferences.putInt("display.rotation", n);
        this.rotationKeyTA.setText(null);
        if (n == 0) {
            this.rotationKeyTA.append("DB\nCA");
        } else if (n == 1) {
            this.rotationKeyTA.append("CD\nAB");
        } else if (n == 2) {
            this.rotationKeyTA.append("AC\nBD");
        } else if (n == 3) {
            this.rotationKeyTA.append("BA\nDC");
        }
    }

    public JRichEcConfigurator(JMenuBar jMenuBar) {
        super(Preferences.userNodeForPackage(JRichEcConfigurator.class).node("JRichEcConfigurator"), "");
        Object object;
        this.guiPrefs = this.prefs;
        this.richPrefs = Preferences.userRoot().node("RICH");
        JMenu jMenu = new JMenu("File");
        JMenuItem jMenuItem = new JMenuItem("Export...");
        jMenuItem.addActionListener(this.exportAL);
        jMenu.add(jMenuItem);
        JMenu jMenu2 = new JMenu("Export EC set");
        try {
            object = this.richPrefs.node("preferences").childrenNames();
            for (int i = 0; i < ((String[])object).length; ++i) {
                JMenuItem jMenuItem2 = new JMenuItem(object[i]);
                jMenuItem2.addActionListener(this.exportSetAL);
                jMenu2.add(jMenuItem2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        jMenu.add(jMenu2);
        jMenuItem = new JMenuItem("Import...");
        jMenuItem.addActionListener(this.importAL);
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Exit");
        jMenuItem.addActionListener(this.exitAL);
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
        jMenu = new JMenu("Settings");
        jMenuItem = new JMenuItem("DB network...");
        jMenuItem.addActionListener(this.dnaMenuAL);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("DB control...");
        jMenuItem.addActionListener(this.dbAL);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("PC network...");
        jMenuItem.addActionListener(this.pcNetMenuAL);
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
        jMenu = new JMenu("Display");
        this.rotateMenu = new JMenu("Rotation");
        object = new ButtonGroup();
        JRadioButtonMenuItem jRadioButtonMenuItem = null;
        for (int i = 0; i < 4; ++i) {
            jRadioButtonMenuItem = new JRadioButtonMenuItem(90 * i + " deg");
            jRadioButtonMenuItem.addActionListener(this.rotateAL);
            jRadioButtonMenuItem.setActionCommand("rotate" + 90 * i);
            jRadioButtonMenuItem.setName("rotate" + i);
            if (i == 0) {
                jRadioButtonMenuItem.setSelected(true);
            }
            this.rotateMenu.add(jRadioButtonMenuItem);
            ((ButtonGroup)object).add(jRadioButtonMenuItem);
        }
        jMenu.add(this.rotateMenu);
        jMenuBar.add(jMenu);
        this.initComponents();
    }

    public void updateEcSet() {
        int n;
        Preferences preferences = this.richPrefs.node("EC").node((String)this.elementaryCellCB.getSelectedItem());
        for (n = 0; n < this.db0CB.getItemCount(); ++n) {
            if (!this.db0CB.getItemAt(n).equals(preferences.get("db0.dna", "---- ----"))) continue;
            this.db0CB.setSelectedIndex(n);
        }
        for (n = 0; n < this.db1CB.getItemCount(); ++n) {
            if (!this.db1CB.getItemAt(n).equals(preferences.get("db1.dna", "---- ----"))) continue;
            this.db1CB.setSelectedIndex(n);
        }
        for (n = 0; n < this.preferencesCB.getItemCount(); ++n) {
            if (!this.preferencesCB.getItemAt(n).equals(preferences.get("preferences", "default"))) continue;
            this.preferencesCB.setSelectedIndex(n);
        }
        n = preferences.getInt("display.rotation", 0);
        for (Component component : this.rotateMenu.getMenuComponents()) {
            if (!(component instanceof JRadioButtonMenuItem) || !component.getName().equals("rotate" + n)) continue;
            ((JRadioButtonMenuItem)component).setSelected(true);
        }
        this.setRotation(n);
    }

    private void initComponents() {
        Object object;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        Preferences preferences = this.richPrefs.node("EC").node(this.guiPrefs.get("EC", "EC-Jura"));
        JPanel jPanel = new JPanel();
        gridBagConstraints.gridwidth = 0;
        int n = 0;
        this.elementaryCellCB = new JComboBox();
        this.elementaryCellCB.setEditable(true);
        try {
            for (String string : this.richPrefs.node("EC").childrenNames()) {
                this.elementaryCellCB.addItem(string);
                if (!string.equals(this.guiPrefs.get("EC", "EC-Jura"))) continue;
                this.elementaryCellCB.setSelectedItem(string);
                n = this.richPrefs.node("EC").node(string).getInt("display.rotation", 0);
            }
        }
        catch (Exception exception) {
            System.out.println("Help");
        }
        this.elementaryCellCB.addActionListener(this.selectECAL);
        jPanel.add(JRichEcConfigurator.addBorder(this.elementaryCellCB, "EC name"));
        this.preferencesCB = new JComboBox();
        this.preferencesCB.setName("preferences");
        this.preferencesCB.setEditable(true);
        try {
            for (String string : this.richPrefs.node("preferences").childrenNames()) {
                this.preferencesCB.addItem(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.preferencesCB.addItemListener(this.prefsCBIL);
        jPanel.add(JRichEcConfigurator.addBorder(this.preferencesCB, "Preference set"));
        this.rotationKeyTA = new JTextArea("DB\nCA", 2, 2);
        this.rotationKeyTA.setEditable(false);
        jPanel.add(this.rotationKeyTA);
        this.add((Component)jPanel, gridBagConstraints);
        this.ec = new CellArray(this, 16, 16, 16, 16);
        this.add((Component)JRichEcConfigurator.addBorder(this.ec, "Anode selector"), gridBagConstraints);
        this.db0CB = new JComboBox();
        this.db0CB.setName("db0.dna");
        this.db0CB.setEditable(true);
        this.db0CB.setToolTipText("Unique identifier (DNA) of target board 0");
        this.db1CB = new JComboBox();
        this.db1CB.setName("db1.dna");
        this.db1CB.setEditable(true);
        this.db1CB.setToolTipText("Unique identifier (DNA) of target board 1");
        try {
            int n2;
            object = this.richPrefs.node("DB").childrenNames();
            for (n2 = 0; n2 < ((String[])object).length; ++n2) {
                this.db0CB.addItem(object[n2]);
                if (!object[n2].equals(preferences.get("db0.dna", "AAAA AAAA"))) continue;
                this.db0CB.setSelectedIndex(n2);
            }
            for (n2 = 0; n2 < ((String[])object).length; ++n2) {
                this.db1CB.addItem(object[n2]);
                if (!object[n2].equals(preferences.get("db1.dna", "AAAA AAAA"))) continue;
                this.db1CB.setSelectedIndex(n2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.db0CB.addItemListener(this.dbCBIL);
        this.db1CB.addItemListener(this.dbCBIL);
        jPanel = new JPanel();
        jPanel.add(JRichEcConfigurator.addBorder(this.db1CB, "PDMDB (CD)"));
        jPanel.add(JRichEcConfigurator.addBorder(this.db0CB, "PDMDB (AB)"));
        this.add((Component)jPanel, gridBagConstraints);
        this.updateEcSet();
        jPanel = new JPanel();
        this.claroJF = this.makeClaroJF();
        object = new JButton("Set CLARO");
        ((AbstractButton)object).addActionListener(this.setClaroAL);
        jPanel.add((Component)object);
        this.marocJF = this.makeMarocJF();
        object = new JButton("Set MAROC");
        ((AbstractButton)object).addActionListener(this.setMarocAL);
        jPanel.add((Component)object);
        object = new JButton("Show selected");
        ((AbstractButton)object).addActionListener(this.showButtonAL);
        jPanel.add((Component)object);
        gridBagConstraints.gridwidth = 0;
        this.add((Component)jPanel, gridBagConstraints);
        this.textArea = new JTextArea(8, 10);
        this.textArea.setEditable(false);
        this.textSP = new JScrollPane(this.textArea);
        gridBagConstraints.fill = 2;
        this.add((Component)this.textSP, gridBagConstraints);
    }

    private JFrame makeClaroJF() {
        JFrame jFrame = new JFrame("CLARO settings");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.claroGlobalJP = new JPanel();
        this.claroGlobalJP.setLayout(new GridBagLayout());
        this.claroGlobalJP.setBorder(BorderFactory.createTitledBorder("Global settings"));
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        this.claroGlobalJP.add((Component)this.makeTF("claro.mux", "0", 1, "Mux", "Analogue multiplexer channel select", true).getParent(), gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        this.claroGlobalJP.add((Component)this.makeCheckBox("claro.SEU-enb", "SEU detection enable", false, true), gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        this.claroGlobalJP.add((Component)this.makeCheckBox("claro.intern-corr", "intern corr", false, true), gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        this.claroGlobalJP.add((Component)this.makeCheckBox("claro.aux-TP", "aux TP", false, true), gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        this.claroGlobalJP.add((Component)this.makeCheckBox("claro.TP-enb", "TP enable", false, true), gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        this.claroGlobalJP.add((Component)this.makeCheckBox("claro.SEU-reset", "SEU reset", false, true), gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)this.claroGlobalJP, gridBagConstraints);
        this.claroChannelJP = new JPanel();
        this.claroChannelJP.setLayout(new GridBagLayout());
        this.claroChannelJP.setBorder(BorderFactory.createTitledBorder("Channel settings"));
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 2;
        this.claroChannelJP.add((Component)this.makeTF("claro.threshold", "7", 5, "Threshold", "Threshold [0,63]", true).getParent(), gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        this.claroChannelJP.add((Component)this.makeTF("claro.attenuation", "0", 5, "Attenuation", "Attenuation [0,3]", true).getParent(), gridBagConstraints);
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        this.claroChannelJP.add((Component)this.makeCheckBox("claro.input-enable", "Input enable", true, true), gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        this.claroChannelJP.add((Component)this.makeCheckBox("claro.hysteresis-enable", "Hysteresis enable", false, true), gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        this.claroChannelJP.add((Component)this.makeCheckBox("claro.testpulse-disable", "Test pulse disable", true, true), gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        this.claroChannelJP.add((Component)this.makeCheckBox("claro.threshold-offset", "Offset thresholds", false, true), gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)this.claroChannelJP, gridBagConstraints);
        JButton jButton = new JButton("Set selected");
        jButton.addActionListener(this.setClaroButtonAL);
        gridBagConstraints.gridwidth = 1;
        jPanel.add(jButton);
        jButton = new JButton("Cancel");
        jButton.addActionListener(this.cancelClaroButtonAL);
        gridBagConstraints.gridwidth = 0;
        jPanel.add(jButton);
        jFrame.getContentPane().add(jPanel);
        jFrame.pack();
        return jFrame;
    }

    private JFrame makeMarocJF() {
        JFrame jFrame = new JFrame("MAROC settings");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.marocSettingsJP = new JPanel();
        this.marocSettingsJP.setLayout(new GridLayout(0, 1));
        this.marocSettingsJP.add(this.makeCheckBox("maroc.small_dac", "small_dac", false, true));
        this.marocSettingsJP.add(this.makeCheckBox("maroc.enb_outADC", "enb_outADC", false, true));
        this.marocSettingsJP.add(this.makeCheckBox("maroc.inv_startCmptGray", "inv_startCmptGray", false, true));
        this.marocSettingsJP.add(this.makeCheckBox("maroc.ramp_8bit", "ramp_8bit", false, true));
        this.marocSettingsJP.add(this.makeCheckBox("maroc.ramp_10bit", "ramp_10bit", false, true));
        this.marocSettingsJP.add(this.makeCheckBox("maroc.cmd_CK_mux", "cmd_CK_mux", false, true));
        this.marocSettingsJP.add(this.makeCheckBox("maroc.d1_d2", "d1_d2", false, true));
        this.marocSettingsJP.add(this.makeCheckBox("maroc.inv_discriADC", "inv_discriADC", false, true));
        this.marocSettingsJP.add(this.makeCheckBox("maroc.polar_discri", "polar_discri", false, true));
        this.marocSettingsJP.add(this.makeCheckBox("maroc.enb_tristate", "enb_tristate", false, true));
        this.marocSettingsJP.add(this.makeCheckBox("maroc.valid_dc_fsb2", "valid_dc_fsb2", false, true));
        this.marocSettingsJP.add(this.makeCheckBox("maroc.sw_fsb2_50f", "sw_fsb2_50f", false, true));
        this.marocSettingsJP.add(this.makeCheckBox("maroc.sw_fsb2_100f", "sw_fsb2_100f", false, true));
        this.marocSettingsJP.add(this.makeCheckBox("maroc.sw_fsb2_100k", "sw_fsb2_100k", false, true));
        this.marocSettingsJP.add(this.makeCheckBox("maroc.sw_fsb2_50k", "sw_fsb2_50k", false, true));
        this.marocSettingsJP.add(this.makeCheckBox("maroc.valid_dc_fs", "valid_dc_fs", false, true));
        this.marocSettingsJP.add(this.makeCheckBox("maroc.cmd_fsb_fsu", "cmd_fsb_fsu", false, true));
        this.marocSettingsJP.add(this.makeCheckBox("maroc.sw_fsb1_50f", "sw_fsb1_50f", false, true));
        this.marocSettingsJP.add(this.makeCheckBox("maroc.sw_fsb1_100f", "sw_fsb1_100f", false, true));
        this.marocSettingsJP.add(this.makeCheckBox("maroc.sw_fsb1_100k", "sw_fsb1_100k", false, true));
        this.marocSettingsJP.add(this.makeCheckBox("maroc.sw_fsb1_50k", "sw_fsb1_50k", false, true));
        this.marocSettingsJP.add(this.makeCheckBox("maroc.sw_fsu_100k", "sw_fsu_100k", false, true));
        this.marocSettingsJP.add(this.makeCheckBox("maroc.sw_fsu_50k", "sw_fsu_50k", false, true));
        this.marocSettingsJP.add(this.makeCheckBox("maroc.sw_fsu_25k", "sw_fsu_25k", false, true));
        this.marocSettingsJP.add(this.makeCheckBox("maroc.sw_fsu_40f", "sw_fsu_40f", false, true));
        this.marocSettingsJP.add(this.makeCheckBox("maroc.sw_fsu_20f", "sw_fsu_20f", false, true));
        this.marocSettingsJP.add(this.makeCheckBox("maroc.h1h2_choice", "h1h2_choice", false, true));
        this.marocSettingsJP.add(this.makeCheckBox("maroc.en_adc", "en_adc", false, true));
        this.marocSettingsJP.add(this.makeCheckBox("maroc.sw_ss_1200f", "sw_ss_1200f", false, true));
        this.marocSettingsJP.add(this.makeCheckBox("maroc.sw_ss_600f", "sw_ss_600f", false, true));
        this.marocSettingsJP.add(this.makeCheckBox("maroc.sw_ss_300f", "sw_ss_300f", false, true));
        this.marocSettingsJP.add(this.makeCheckBox("maroc.onoff_ss", "onoff_ss", false, true));
        this.marocSettingsJP.add(this.makeCheckBox("maroc.swb_buf_2p", "swb_buf_2p", false, true));
        this.marocSettingsJP.add(this.makeCheckBox("maroc.swb_buf_1p", "swb_buf_1p", false, true));
        this.marocSettingsJP.add(this.makeCheckBox("maroc.swb_buf_500f", "swb_buf_500f", false, true));
        this.marocSettingsJP.add(this.makeCheckBox("maroc.swb_buf_250f", "swb_buf_250f", false, true));
        this.marocSettingsJP.add(this.makeCheckBox("maroc.cmd_fsb", "cmd_fsb", false, true));
        this.marocSettingsJP.add(this.makeCheckBox("maroc.cmd_ss", "cmd_ss", false, true));
        this.marocSettingsJP.add(this.makeCheckBox("maroc.cmd_fsu", "cmd_fsu", false, true));
        JScrollPane jScrollPane = new JScrollPane(this.marocSettingsJP);
        jScrollPane.setBorder(BorderFactory.createTitledBorder("Global settings"));
        jScrollPane.setPreferredSize(new Dimension(200, 300));
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        this.marocDac0TF = this.makeTF("maroc.dac.0", "128", 4, "DAC0 (threshold)", "Threshold DAC0 value [0,1023]", true);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.marocDac0TF.getParent(), gridBagConstraints);
        this.marocDac1TF = this.makeTF("maroc.dac.1", "128", 4, "DAC1 (threshold)", "Threshold DAC1 value [0,1023]", true);
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)this.marocDac1TF.getParent(), gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder("Channel settings"));
        this.marocGainTF = this.makeTF("maroc.gain", "128", 5, "Gain", "Gain [0,255]", true);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 2;
        jPanel2.add((Component)this.marocGainTF.getParent(), gridBagConstraints);
        this.marocSumCB = this.makeCheckBox("maroc.sum", "Include in sum", false, true);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        jPanel2.add((Component)this.marocSumCB, gridBagConstraints);
        this.marocCtestCB = this.makeCheckBox("maroc.ctest", "Testpulse enable", false, true);
        jPanel2.add((Component)this.marocCtestCB, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.marocMaskOr1CB = this.makeCheckBox("maroc.mask-or1", "Mask OR1", false, true);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        jPanel2.add((Component)this.marocMaskOr1CB, gridBagConstraints);
        this.marocMaskOr2CB = this.makeCheckBox("maroc.mask-or2", "Mask OR2", false, true);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        jPanel2.add((Component)this.marocMaskOr2CB, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        JButton jButton = new JButton("Set selected");
        jButton.addActionListener(this.setMarocButtonAL);
        jPanel.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        jButton = new JButton("Cancel");
        jButton.addActionListener(this.cancelMarocButtonAL);
        jPanel.add((Component)jButton, gridBagConstraints);
        jFrame.getContentPane().add(jPanel);
        jFrame.pack();
        return jFrame;
    }

    private void exitForm(WindowEvent windowEvent) {
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    System.err.println("Warning: " + interruptedException.getMessage());
                }
                String string = UIManager.getSystemLookAndFeelClassName();
                try {
                    UIManager.setLookAndFeel(string);
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    System.err.println("Warning: UnsupportedLookAndFeel: " + string);
                }
                catch (Exception exception) {
                    System.err.println("Error loading " + string + ": " + exception);
                }
                JFrame jFrame = new JFrame("JRichEcConfigurator");
                jFrame.setDefaultCloseOperation(3);
                Container container = jFrame.getContentPane();
                container.setLayout(new BorderLayout());
                JMenuBar jMenuBar = new JMenuBar();
                jFrame.setJMenuBar(jMenuBar);
                JRichEcConfigurator jRichEcConfigurator = new JRichEcConfigurator(jMenuBar);
                container.add((Component)jRichEcConfigurator, "North");
                jFrame.pack();
                jFrame.setVisible(true);
            }
        });
    }
}

