/*
 * Decompiled with CFR 0.152.
 */
package cbsw.lhcb;

import cbsw.gui.ColorArray;
import cbsw.gui.GuiJPanel;
import cbsw.gui.GuiPreferences;
import cbsw.instrument.adept.JniAdeptDepp;
import cbsw.lhcb.JChimaera2Depp;
import cbsw.lhcb.JRichEcConfigurator;
import cbsw.lhcb.JniCLARO;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileNameExtensionFilter;

public class JEcTester
extends GuiJPanel {
    Timer timer;
    JniAdeptDepp depp;
    JniCLARO cla;
    JChimaera2Depp chimaera2;
    JFrame chimaera2JF;
    JTextArea textArea;
    JScrollPane textSP;
    ColorArray spiCA;
    ColorArray latchCA;
    ColorArray outCA;
    ConfiguratorFrame configuratorFrame;
    ActionListener timerAL = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            byte[] byArray = new byte[16];
            try {
                JEcTester.this.depp.getBytes(0, 16, byArray);
            }
            catch (JniAdeptDepp.DeppException deppException) {
                // empty catch block
            }
            Color[][] colorArray = new Color[16][8];
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 8; ++j) {
                    for (int k = 0; k < 8; ++k) {
                        colorArray[i * 8 + j][k] = (byArray[i * 8 + j] & 1 << k) != 0 ? Color.yellow : Color.blue;
                    }
                }
            }
            JEcTester.this.outCA.setColor(colorArray);
        }
    };
    ActionListener importHWAL = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JniAdeptDepp.importHardware("http://www.hep.phy.cam.ac.uk/lhcb/RICHEC/xml/XilinxHardwarePrefs.xml");
            JniAdeptDepp.importHardware("http://www.hep.phy.cam.ac.uk/lhcb/RICHEC/xml/RICH-CLARO-BBv2.xml");
            JniAdeptDepp.importHardware("http://www.hep.phy.cam.ac.uk/lhcb/RICHEC/xml/RICH-CLARO-PD-ECH.xml");
            JniAdeptDepp.importHardware("http://www.hep.phy.cam.ac.uk/lhcb/RICHEC/xml/RICH-xy.xml");
        }
    };
    ActionListener exitAL = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            System.exit(0);
        }
    };
    ActionListener configureAL = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JEcTester.this.doSpi(true);
        }
    };
    ActionListener checkAL = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JEcTester.this.doSpi(false);
        }
    };
    ActionListener fileAL = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JEcTester.this.chooseCLAROFile();
            JEcTester.this.cla.setStateFromFile(JEcTester.this.prefs.get("claro.filename", "claro.spi"), 0);
        }
    };
    ActionListener prefsAL = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = Preferences.userRoot().node("RICH/EC/TESTER").get("preferences", "default");
            Preferences preferences = Preferences.userRoot().node("RICH/preferences").node(string);
            JEcTester.this.cla.setStateFromPreferences(preferences, 0);
        }
    };
    ActionListener c2ShowAL = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JEcTester.this.chimaera2JF.setVisible(true);
        }
    };

    public JEcTester(String string) {
        super(Preferences.userNodeForPackage(JEcTester.class).node("JEcTester").node(string), "");
        System.out.println("Connecting to " + string);
        this.depp = new JniAdeptDepp(string);
        try {
            this.depp.open();
        }
        catch (JniAdeptDepp.DeppException deppException) {
            // empty catch block
        }
        this.cla = new JniCLARO();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 13;
        this.add((Component)new JLabel("Device"), gridBagConstraints);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        JButton jButton = new JButton("Configure");
        jButton.addActionListener(this.configureAL);
        gridBagConstraints.gridwidth = 1;
        this.add((Component)jButton, gridBagConstraints);
        jButton = new JButton("Check");
        jButton.addActionListener(this.checkAL);
        gridBagConstraints.gridwidth = 1;
        this.add((Component)jButton, gridBagConstraints);
        jButton = new JButton("Read CLARO file");
        jButton.addActionListener(this.fileAL);
        gridBagConstraints.gridwidth = 1;
        this.add((Component)jButton, gridBagConstraints);
        jButton = new JButton("Read preferences");
        jButton.addActionListener(this.prefsAL);
        gridBagConstraints.gridwidth = 0;
        this.add((Component)jButton, gridBagConstraints);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("CLARO SPI readback"));
        this.textArea = new JTextArea(16, 32);
        this.textArea.setEditable(false);
        this.textSP = new JScrollPane(this.textArea);
        jPanel.add(this.textSP);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)jPanel, gridBagConstraints);
        JTabbedPane jTabbedPane = new JTabbedPane();
        jPanel = new JPanel();
        jPanel.setName("SPI");
        this.spiCA = new ColorArray(this, 16, 8, 16, 16);
        jPanel.add(this.spiCA);
        jTabbedPane.add(jPanel);
        jPanel = new JPanel();
        jPanel.setName("Latches");
        this.latchCA = new ColorArray(this, 16, 8, 16, 16);
        jPanel.add(this.latchCA);
        jTabbedPane.add(jPanel);
        jPanel = new JPanel();
        jPanel.setName("Outputs");
        this.outCA = new ColorArray(this, 16, 8, 16, 16);
        jPanel.add(this.outCA);
        jTabbedPane.add(jPanel);
        gridBagConstraints.gridwidth = 0;
        this.add((Component)jTabbedPane, gridBagConstraints);
        this.chimaera2 = new JChimaera2Depp(this.depp, "ectester");
        this.chimaera2JF = this.chimaera2.makeFrame("Status and configuration registers");
        this.chimaera2.getMenuBar().add(this.chimaera2.makeMainMenu("Main"));
        this.chimaera2JF.pack();
        this.timer = new Timer(1000, this.timerAL);
        this.timer.addActionListener(this.timerAL);
        this.timer.setInitialDelay(1000);
        this.timer.setCoalesce(false);
        this.timer.start();
    }

    public void showText(String string) {
        if (this.textArea == null) {
            System.out.println(string);
        } else {
            this.textArea.append(string + "\n");
        }
    }

    public void chooseCLAROFile() {
        JFileChooser jFileChooser = new JFileChooser(this.prefs.get("claro.dir", "."));
        FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("CLARO config files (SPI)", "spi");
        jFileChooser.setFileFilter(fileNameExtensionFilter);
        int n = jFileChooser.showOpenDialog(null);
        if (n != 0) {
            return;
        }
        if (!jFileChooser.getSelectedFile().isFile()) {
            return;
        }
        this.prefs.put("claro.dir", jFileChooser.getSelectedFile().getParent());
        this.prefs.put("claro.filename", jFileChooser.getSelectedFile().getAbsolutePath());
    }

    public void doSpi(boolean bl) {
        this.textArea.setText(null);
        try {
            this.spiCA.setColor(Color.green);
            Color[][] colorArray = new Color[16][8];
            this.latchCA.setColor(Color.black);
            Color[][] colorArray2 = new Color[16][8];
            for (int i = 0; i < 16; ++i) {
                int n;
                this.depp.put(128, 20, (short)(1 << i));
                byte by = bl ? (byte)4 : 0;
                this.depp.put(128, 16, by);
                byte[] byArray = new byte[20];
                this.cla.getRegisterArray(i, byArray, 16, 4);
                this.depp.push(160, 16, 0, byArray, true);
                this.depp.put(128, 20, (short)0);
                this.depp.put(128, 16, (byte)0);
                byte[] byArray2 = new byte[4];
                this.depp.push(32, 16, 0, byArray2, false);
                byArray2 = new byte[16];
                this.depp.pop((byte)32, byArray2);
                StringBuffer stringBuffer = new StringBuffer();
                for (n = 0; n < byArray2.length; ++n) {
                    stringBuffer.append(String.format("%1$02x", byArray2[n]));
                }
                this.showText(stringBuffer.toString());
                if (bl) continue;
                for (n = 0; n < 8; n += 2) {
                    int n2 = n * 3 / 2;
                    if (byArray2[n2] != byArray[n2 + 4]) {
                        colorArray[i][n] = Color.red;
                    }
                    if ((byArray2[n2 + 1] & 0xF) != (byArray[n2 + 5] & 0xF)) {
                        colorArray[i][n] = Color.red;
                    }
                    if ((byArray2[n2 + 1] & 0xF0) != (byArray[n2 + 5] & 0xF0)) {
                        colorArray[i][n + 1] = Color.red;
                    }
                    if (byArray2[n2 + 2] == byArray[n2 + 6]) continue;
                    colorArray[i][n + 1] = Color.red;
                }
                for (n = 0; n < 8; ++n) {
                    if ((byArray2[15] & 1 << n) == 0) continue;
                    colorArray2[i][n] = Color.yellow;
                }
            }
            this.spiCA.setColor(colorArray);
            this.latchCA.setColor(colorArray2);
        }
        catch (JniAdeptDepp.DeppException deppException) {
            System.out.println("JEcTester::doSpi(): Depp exception");
        }
    }

    @Override
    public JMenu makeMainMenu(String string) {
        JMenu jMenu = new JMenu("Main");
        JMenuItem jMenuItem = new JMenuItem("Registers...");
        jMenuItem.addActionListener(this.c2ShowAL);
        jMenu.add(jMenuItem);
        this.configuratorFrame = new ConfiguratorFrame("Configurator");
        jMenuItem = new JMenuItem("Configurator...");
        jMenuItem.addActionListener(this.configuratorFrame);
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Import hardware");
        jMenuItem.addActionListener(this.importHWAL);
        jMenu.add(jMenuItem);
        GuiPreferences.addMenuItems(jMenu);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Exit");
        jMenuItem.addActionListener(this.exitAL);
        jMenu.add(jMenuItem);
        return jMenu;
    }

    public static void main(String[] stringArray) {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            System.err.println("Warning: " + interruptedException.getMessage());
        }
        String string = UIManager.getSystemLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel(string);
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            System.err.println("Warning: UnsupportedLookAndFeel: " + string);
        }
        catch (Exception exception) {
            System.err.println("Error loading " + string + ": " + exception);
        }
        String string2 = JniAdeptDepp.selectDevice("ectester");
        String string3 = Preferences.userRoot().node("Hardware/Xilinx").node(string2).get("connectionName", "ectester");
        JEcTester jEcTester = new JEcTester(string3);
        JFrame jFrame = jEcTester.makeFrame("JEcTester");
        jEcTester.getMenuBar().add(jEcTester.makeMainMenu("Main"));
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    private class ConfiguratorFrame
    extends JFrame
    implements ActionListener {
        public ConfiguratorFrame(String string) {
            super(string);
            JMenuBar jMenuBar = new JMenuBar();
            this.setJMenuBar(jMenuBar);
            this.getContentPane().add((Component)new JRichEcConfigurator(jMenuBar));
            this.pack();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.setVisible(true);
        }
    }
}

