/*
 * Decompiled with CFR 0.152.
 */
package cbsw.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;

public class GuiPreferences {
    static ActionListener importAL = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GuiPreferences.importPreferences();
        }
    };
    static ActionListener exportAL = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GuiPreferences.exportPreferences(null);
        }
    };

    public static void addMenuItems(JMenu jMenu) {
        JMenuItem jMenuItem = new JMenuItem("Import...");
        jMenuItem.addActionListener(importAL);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Export...");
        jMenuItem.addActionListener(exportAL);
        jMenu.add(jMenuItem);
    }

    public static void savePreferences(Preferences preferences, Container container) {
        if (preferences == null) {
            System.out.println("GuiJPanel.savePreferences(): Null prefs. Aborting...");
            return;
        }
        if (container == null) {
            System.out.println("GuiJPanel.savePreferences(): Null container. Aborting...");
            return;
        }
        for (Component component : container.getComponents()) {
            if (component == null) {
                System.out.println("GuiJPanel.savePreferences(): Null component. Aborting...");
                continue;
            }
            if (component instanceof JCheckBox) {
                if (component.getName() == null) {
                    System.out.println("CheckBox component name is null");
                    continue;
                }
                System.out.println(preferences.absolutePath() + "/" + component.getName() + "=" + ((JCheckBox)component).isSelected());
                preferences.putBoolean(component.getName(), ((JCheckBox)component).isSelected());
                continue;
            }
            if (component instanceof JTextField) {
                if (component.getName() == null) {
                    System.out.println("TextField component name is null");
                    continue;
                }
                if (((JTextField)component).getText() == null) {
                    System.out.println("TextField text is null");
                    continue;
                }
                System.out.println(preferences.absolutePath() + "/" + component.getName() + "=" + ((JTextField)component).getText());
                preferences.put(component.getName(), ((JTextField)component).getText());
                continue;
            }
            if (!(component instanceof Container)) continue;
            GuiPreferences.savePreferences(preferences, (Container)component);
        }
    }

    public static void updateFields(Preferences preferences, Container container) {
        if (preferences == null) {
            System.out.println("GuiJPanel.savePreferences(): Null prefs. Aborting...");
            return;
        }
        if (container == null) {
            System.out.println("GuiJPanel.savePreferences(): Null container. Aborting...");
            return;
        }
        for (Component component : container.getComponents()) {
            if (component == null) {
                System.out.println("GuiJPanel.updateFields(): Null component. Aborting...");
                continue;
            }
            if (component instanceof JCheckBox) {
                if (component.getName() == null) {
                    System.out.println("CheckBox component name is null");
                    continue;
                }
                ((JCheckBox)component).setSelected(preferences.getBoolean(component.getName(), false));
                continue;
            }
            if (component instanceof JTextField) {
                if (component.getName() == null) {
                    System.out.println("TextField component name is null");
                    continue;
                }
                if (((JTextField)component).getText() == null) {
                    System.out.println("TextField text is null");
                    continue;
                }
                ((JTextField)component).setText(preferences.get(component.getName(), ""));
                continue;
            }
            if (!(component instanceof Container)) continue;
            GuiPreferences.updateFields(preferences, (Container)component);
        }
    }

    public static void updateUndefinedFields(Preferences preferences, Container container) {
        if (preferences == null) {
            System.out.println("GuiJPanel.savePreferences(): Null prefs. Aborting...");
            return;
        }
        if (container == null) {
            System.out.println("GuiJPanel.savePreferences(): Null container. Aborting...");
            return;
        }
        for (Component component : container.getComponents()) {
            if (component == null) {
                System.out.println("GuiJPanel.updateFields(): Null component. Aborting...");
                continue;
            }
            if (component instanceof JCheckBox) {
                if (component.getName() == null) {
                    System.out.println("CheckBox component name is null");
                    continue;
                }
                if (preferences.get(component.getName(), "").equals("")) continue;
                ((JCheckBox)component).setSelected(preferences.getBoolean(component.getName(), false));
                continue;
            }
            if (component instanceof JTextField) {
                if (component.getName() == null) {
                    System.out.println("TextField component name is null");
                    continue;
                }
                if (((JTextField)component).getText() == null) {
                    System.out.println("TextField text is null");
                    continue;
                }
                if (preferences.get(component.getName(), "").equals("")) continue;
                ((JTextField)component).setText(preferences.get(component.getName(), ""));
                continue;
            }
            if (!(component instanceof Container)) continue;
            GuiPreferences.updateUndefinedFields(preferences, (Container)component);
        }
    }

    public static void importPreferences() {
        JFileChooser jFileChooser = new JFileChooser();
        FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("Preferences (XML)", "xml");
        jFileChooser.setFileFilter(fileNameExtensionFilter);
        int n = jFileChooser.showOpenDialog(null);
        if (n == 0) {
            try {
                FileInputStream fileInputStream = new FileInputStream(jFileChooser.getSelectedFile());
                Preferences.userRoot();
                Preferences.importPreferences(fileInputStream);
                fileInputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (InvalidPreferencesFormatException invalidPreferencesFormatException) {
                invalidPreferencesFormatException.printStackTrace();
            }
        }
    }

    public static void exportPreferences(String string) {
        if (string == null) {
            string = JOptionPane.showInputDialog("Enter preferences path");
        }
        if (string == null) {
            return;
        }
        JFileChooser jFileChooser = new JFileChooser();
        FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("Preferences (XML)", "xml");
        jFileChooser.setFileFilter(fileNameExtensionFilter);
        int n = jFileChooser.showOpenDialog(null);
        if (n == 0) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(jFileChooser.getSelectedFile());
                Preferences.userRoot().node(string).exportSubtree(fileOutputStream);
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (BackingStoreException backingStoreException) {
                backingStoreException.printStackTrace();
            }
        }
    }
}

