/*
 * Decompiled with CFR 0.152.
 */
package cbsw.gui;

import cbsw.gui.GuiJPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class GuiDaqControl
extends GuiJPanel
implements ActionListener {
    JFrame frame;
    JTextField ipProtocolTF;
    JTextField ipTtlTF;
    JTextField truncationHwmTF;
    JTextField mepEventsTF;

    public GuiDaqControl(Preferences preferences, JFrame jFrame) {
        super(preferences, "DaqControl.");
        this.frame = jFrame;
        JPanel jPanel = this.makeMacAddressPanel();
        JPanel jPanel2 = this.makeIpAddressPanel();
        JPanel jPanel3 = this.makeIpPanel();
        JPanel jPanel4 = this.makeGbePanel();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.gridwidth = 1;
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        this.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        this.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        this.add((Component)jPanel4, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        JButton jButton = new JButton("Cancel");
        jButton.addActionListener(this);
        jButton.setActionCommand("cancel");
        this.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        jButton = new JButton("Save");
        jButton.addActionListener(this);
        jButton.setActionCommand("save");
        this.add((Component)jButton, gridBagConstraints);
    }

    public JPanel makeMacAddressPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setBorder(BorderFactory.createTitledBorder("MAC address"));
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 6; ++i) {
            stringBuffer.append(this.prefs.get(String.format("net.mac.%d", 5 - i), "00"));
            if (i >= 5) continue;
            stringBuffer.append(":");
        }
        jPanel.add(new JLabel(stringBuffer.toString()));
        return jPanel;
    }

    public JPanel makeIpAddressPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setBorder(BorderFactory.createTitledBorder("IP address"));
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 4; ++i) {
            stringBuffer.append(this.prefs.get(String.format("net.ip.%d", 3 - i), "0"));
            if (i >= 3) continue;
            stringBuffer.append(".");
        }
        jPanel.add(new JLabel(stringBuffer.toString()));
        return jPanel;
    }

    public JPanel makeIpPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setBorder(BorderFactory.createTitledBorder("IP parameters"));
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.gridwidth = 1;
        jPanel.add(new JLabel("Protocol"));
        int n = this.prefs.getInt("net.ip.protocol", 242);
        this.ipProtocolTF = new JTextField(String.format("%02X", n), 2);
        this.ipProtocolTF.setName("net.ip.protocol");
        jPanel.add(this.ipProtocolTF);
        jPanel.add(new JLabel("TTL"));
        int n2 = this.prefs.getInt("net.ip_ttl", 64);
        this.ipTtlTF = new JTextField(String.format("%02X", n2), 2);
        this.ipTtlTF.setName("net.ip.ttl");
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)this.ipTtlTF, gridBagConstraints);
        return jPanel;
    }

    public JPanel makeGbePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setBorder(BorderFactory.createTitledBorder("GBE parameters"));
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add(new JLabel("Truncation size"));
        this.truncationHwmTF = new JTextField(this.prefs.get("mep.truncation-hwm", "1000"), 4);
        this.truncationHwmTF.setName("mep.truncation-hwm");
        this.truncationHwmTF.setToolTipText("MEP buffer high water mark (hex) bytes");
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)this.truncationHwmTF, gridBagConstraints);
        jPanel.add(new JLabel("MEP events"));
        this.mepEventsTF = new JTextField(this.prefs.get("mep.events", "1"), 4);
        this.mepEventsTF.setName("mep.events");
        this.mepEventsTF.setToolTipText("Number of events per MEP (decimal)");
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)this.mepEventsTF, gridBagConstraints);
        return jPanel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("save")) {
            GuiDaqControl.savePreferences(this.prefs, this);
            this.frame.setVisible(false);
        } else if (string.equals("cancel")) {
            this.frame.setVisible(false);
        }
    }
}

