/*
 * Decompiled with CFR 0.152.
 */
package cbsw.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Format;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class GuiContainer
extends Container {
    protected Preferences prefs;
    protected String prefsPrefix;

    public GuiContainer(String string, String string2) {
        this.prefs = Preferences.userNodeForPackage(GuiContainer.class).node(string);
        this.prefsPrefix = string2;
    }

    public GuiContainer(Preferences preferences, String string) {
        this.prefs = preferences;
        this.prefsPrefix = string;
    }

    public Preferences getPrefsUserNode() {
        return this.prefs;
    }

    public Preferences setPrefsUserNode(String string, String string2) {
        this.prefs = Preferences.userNodeForPackage(GuiContainer.class).node(string);
        this.prefsPrefix = string2;
        return this.prefs;
    }

    public Preferences setPrefsUserNode(Preferences preferences, String string) {
        this.prefs = preferences;
        this.prefsPrefix = string;
        return this.prefs;
    }

    public JTextField makeTF(String string, String string2, int n, String string3, String string4, boolean bl) {
        JTextField jTextField = new JTextField(this.prefs.get(this.prefsPrefix + string, string2), n);
        jTextField.setName(this.prefsPrefix + string);
        if (bl) {
            jTextField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JTextField jTextField = (JTextField)actionEvent.getSource();
                    GuiContainer.this.prefs.put(jTextField.getName(), jTextField.getText());
                }
            });
        }
        jTextField.setToolTipText(string4);
        if (string3 != null) {
            JPanel jPanel = new JPanel();
            jPanel.setBorder(BorderFactory.createTitledBorder(string3));
            jPanel.add(jTextField);
        }
        return jTextField;
    }

    public JTextField makeTF(Format format, String string, String string2, int n, String string3, String string4, boolean bl) {
        JFormattedTextField jFormattedTextField = new JFormattedTextField(format);
        jFormattedTextField.setColumns(n);
        jFormattedTextField.setText(this.prefs.get(this.prefsPrefix + string, string2));
        jFormattedTextField.setName(this.prefsPrefix + string);
        if (bl) {
            jFormattedTextField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JTextField jTextField = (JTextField)actionEvent.getSource();
                    GuiContainer.this.prefs.put(jTextField.getName(), jTextField.getText());
                }
            });
        }
        jFormattedTextField.setToolTipText(string4);
        if (string3 != null) {
            JPanel jPanel = new JPanel();
            jPanel.setBorder(BorderFactory.createTitledBorder(string3));
            jPanel.add(jFormattedTextField);
        }
        return jFormattedTextField;
    }

    public JCheckBox makeCheckBox(String string, String string2, boolean bl, boolean bl2) {
        boolean bl3 = this.prefs.getBoolean(this.prefsPrefix + string, bl);
        JCheckBox jCheckBox = new JCheckBox(string2, bl3);
        jCheckBox.setName(this.prefsPrefix + string);
        if (bl2) {
            jCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                    GuiContainer.this.prefs.putBoolean(jCheckBox.getName(), jCheckBox.isSelected());
                }
            });
        }
        return jCheckBox;
    }

    public static JPanel addBorder(JComponent jComponent, String string) {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(string));
        jPanel.add(jComponent);
        return jPanel;
    }

    public static void savePreferences(Preferences preferences, Container container) {
        if (preferences == null) {
            System.out.println("GuiContainer.savePreferences(): Null prefs. Aborting...");
            return;
        }
        if (container == null) {
            System.out.println("GuiContainer.savePreferences(): Null container. Aborting...");
            return;
        }
        for (Component component : container.getComponents()) {
            if (component == null) {
                System.out.println("GuiContainer.savePreferences(): Null component. Aborting...");
                continue;
            }
            if (component instanceof JCheckBox) {
                if (component.getName() == null) {
                    System.out.println("CheckBox component name is null");
                    continue;
                }
                System.out.println(preferences.absolutePath() + "/" + component.getName() + "=" + ((JCheckBox)component).isSelected());
                preferences.putBoolean(component.getName(), ((JCheckBox)component).isSelected());
                continue;
            }
            if (component instanceof JTextField) {
                if (component.getName() == null) {
                    System.out.println("TextField component name is null");
                    continue;
                }
                if (((JTextField)component).getText() == null) {
                    System.out.println("TextField text is null");
                    continue;
                }
                System.out.println(preferences.absolutePath() + "/" + component.getName() + "=" + ((JTextField)component).getText());
                preferences.put(component.getName(), ((JTextField)component).getText());
                continue;
            }
            if (!(component instanceof Container)) continue;
            GuiContainer.savePreferences(preferences, (Container)component);
        }
    }

    public static void updateFields(Preferences preferences, Container container) {
        if (preferences == null) {
            System.out.println("GuiContainer.savePreferences(): Null prefs. Aborting...");
            return;
        }
        if (container == null) {
            System.out.println("GuiContainer.savePreferences(): Null container. Aborting...");
            return;
        }
        for (Component component : container.getComponents()) {
            if (component == null) {
                System.out.println("GuiContainer.updateFields(): Null component. Aborting...");
                continue;
            }
            if (component instanceof JCheckBox) {
                if (component.getName() == null) {
                    System.out.println("CheckBox component name is null");
                    continue;
                }
                ((JCheckBox)component).setSelected(preferences.getBoolean(component.getName(), false));
                continue;
            }
            if (component instanceof JTextField) {
                if (component.getName() == null) {
                    System.out.println("TextField component name is null");
                    continue;
                }
                if (((JTextField)component).getText() == null) {
                    System.out.println("TextField text is null");
                    continue;
                }
                ((JTextField)component).setText(preferences.get(component.getName(), ""));
                continue;
            }
            if (!(component instanceof Container)) continue;
            GuiContainer.updateFields(preferences, (Container)component);
        }
    }

    public static void updateUndefinedFields(Preferences preferences, Container container) {
        if (preferences == null) {
            System.out.println("GuiContainer.savePreferences(): Null prefs. Aborting...");
            return;
        }
        if (container == null) {
            System.out.println("GuiContainer.savePreferences(): Null container. Aborting...");
            return;
        }
        for (Component component : container.getComponents()) {
            if (component == null) {
                System.out.println("GuiContainer.updateFields(): Null component. Aborting...");
                continue;
            }
            if (component instanceof JCheckBox) {
                if (component.getName() == null) {
                    System.out.println("CheckBox component name is null");
                    continue;
                }
                if (preferences.get(component.getName(), "").equals("")) continue;
                ((JCheckBox)component).setSelected(preferences.getBoolean(component.getName(), false));
                continue;
            }
            if (component instanceof JTextField) {
                if (component.getName() == null) {
                    System.out.println("TextField component name is null");
                    continue;
                }
                if (((JTextField)component).getText() == null) {
                    System.out.println("TextField text is null");
                    continue;
                }
                if (preferences.get(component.getName(), "").equals("")) continue;
                ((JTextField)component).setText(preferences.get(component.getName(), ""));
                continue;
            }
            if (!(component instanceof Container)) continue;
            GuiContainer.updateUndefinedFields(preferences, (Container)component);
        }
    }
}

