/*
 * Decompiled with CFR 0.152.
 */
package cbsw.gui;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.print.Paper;
import javax.swing.JPanel;

public class ColorArray
extends JPanel
implements MouseMotionListener,
ActionListener {
    Container container;
    BufferedImage bibg;
    Graphics2D bibgg2d;
    BufferedImage bifg;
    Graphics2D bifgg2d;
    Color bgColor = Color.blue;
    int pixelHeight;
    int pixelWidth;
    int nxpixels;
    int nypixels;
    Color[][] cellColor;

    public ColorArray(Container container, int n, int n2, int n3, int n4) {
        this.container = container;
        this.nxpixels = n;
        this.nypixels = n2;
        this.pixelWidth = n3;
        this.pixelHeight = n4;
        this.cellColor = new Color[this.nxpixels][this.nypixels];
        this.setColor(this.bgColor);
        this.setOpaque(true);
        this.setPreferredSize(new Dimension(n * n3, n2 * n4));
        this.bibg = new BufferedImage(n * this.pixelWidth, n2 * this.pixelHeight, 1);
        this.bibgg2d = this.bibg.createGraphics();
        this.bifg = new BufferedImage(n * this.pixelWidth, n2 * this.pixelHeight, 1);
        this.bifgg2d = this.bifg.createGraphics();
        this.bifgg2d.setColor(this.bgColor);
        this.bifgg2d.fillRect(0, 0, this.nxpixels * this.pixelWidth, this.nypixels * this.pixelHeight);
        this.addMouseMotionListener(this);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = n / this.pixelWidth;
        int n4 = n2 / this.pixelHeight;
        if (n3 < 0 || n3 >= this.nxpixels || n4 < 0 || n4 >= this.nypixels) {
            return;
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
    }

    public void update() {
        this.repaint();
    }

    public void setColor(Color color) {
        for (int i = 0; i < this.nxpixels; ++i) {
            for (int j = 0; j < this.nypixels; ++j) {
                this.cellColor[i][j] = color;
            }
        }
        this.repaint();
    }

    public void setColor(Color[][] colorArray) {
        for (int i = 0; i < this.nxpixels; ++i) {
            for (int j = 0; j < this.nypixels; ++j) {
                if (colorArray[i][j] == null) continue;
                this.cellColor[i][j] = colorArray[i][j];
            }
        }
        this.repaint();
    }

    public void paintNonBuffered(Graphics2D graphics2D, Paper paper, int n, int n2, int n3, int n4, boolean bl) {
        double d;
        AffineTransform affineTransform = graphics2D.getTransform();
        double d2 = paper.getImageableWidth() / (double)(n3 * this.nxpixels * this.pixelWidth);
        double d3 = d2 < (d = paper.getImageableHeight() / (double)(n4 * this.nypixels * this.pixelHeight)) ? d2 : d;
        graphics2D.translate(paper.getImageableX(), paper.getImageableY());
        graphics2D.scale(d3, d3);
        graphics2D.translate(n * this.nxpixels * this.pixelWidth, n2 * this.nypixels * this.pixelHeight);
        graphics2D.clearRect(0, 0, this.nxpixels * this.pixelWidth, this.nypixels * this.pixelHeight);
        if (bl) {
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(0, 0, this.nxpixels * this.pixelWidth, this.nypixels * this.pixelHeight);
            graphics2D.setColor(Color.black);
        } else {
            graphics2D.setColor(this.bgColor);
            graphics2D.fillRect(0, 0, this.nxpixels * this.pixelWidth, this.nypixels * this.pixelHeight);
        }
        for (int i = 0; i < this.nxpixels; ++i) {
            for (int j = 0; j < this.nypixels; ++j) {
                graphics2D.setColor(this.cellColor[i][j]);
                graphics2D.fillRect(i * this.pixelWidth, j * this.pixelHeight, this.pixelWidth, this.pixelHeight);
            }
        }
        graphics2D.setColor(Color.black);
        graphics2D.drawRect(0, 0, this.nxpixels * this.pixelWidth, this.nypixels * this.pixelHeight);
        graphics2D.setTransform(affineTransform);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.bifgg2d.clearRect(0, 0, this.nxpixels * this.pixelWidth, this.nypixels * this.pixelHeight);
        this.bifgg2d.drawImage((Image)this.bifg, 0, 0, this);
        for (int i = 0; i < this.nxpixels; ++i) {
            for (int j = 0; j < this.nypixels; ++j) {
                this.bifgg2d.setColor(this.cellColor[i][j]);
                this.bifgg2d.fillRect(i * this.pixelWidth, j * this.pixelHeight, this.pixelWidth, this.pixelHeight);
            }
        }
        graphics.drawImage(this.bifg, 0, 0, this);
    }
}

