/*
 * Decompiled with CFR 0.152.
 */
package cbsw.gui;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.print.Paper;
import java.util.Vector;
import javax.swing.JColorChooser;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class CellArray
extends JPanel
implements MouseMotionListener,
MouseListener,
ActionListener {
    Container container;
    JPopupMenu popupMenu;
    JColorChooser colorChooser = new JColorChooser();
    BufferedImage bibg;
    Graphics2D bibgg2d;
    BufferedImage bifg;
    Graphics2D bifgg2d;
    boolean onOffAlphaMode = false;
    Color onFgColor = Color.green;
    float onAlpha = 1.0f;
    Color offFgColor = Color.red;
    float offAlpha = 0.3f;
    Color bgColor = Color.blue;
    Color gridColor = Color.black;
    BasicStroke gridStroke = new BasicStroke(0.0f);
    int pixelHeight;
    int pixelWidth;
    int nxpixels;
    int nypixels;
    Point lastClicked;
    Point lastPressed;
    Point lastReleased;
    AffineTransform qrot;
    int quadrantRotation = 0;
    int[][] cellState;
    float[][] alpha;
    AffineTransform atfgg2d;
    AffineTransform atbgg2d;

    public CellArray(Container container, int n, int n2, int n3, int n4) {
        this.container = container;
        this.nxpixels = n;
        this.nypixels = n2;
        this.pixelWidth = n3;
        this.pixelHeight = n4;
        this.lastPressed = new Point(0, 0);
        this.lastReleased = new Point(0, 0);
        this.lastClicked = new Point(0, 0);
        this.cellState = new int[this.nxpixels][this.nypixels];
        this.alpha = new float[this.nxpixels][this.nypixels];
        for (int i = 0; i < this.nxpixels; ++i) {
            for (int j = 0; j < this.nypixels; ++j) {
                this.alpha[i][j] = 1.0f;
            }
        }
        this.setOpaque(true);
        this.setPreferredSize(new Dimension(n * n3, n2 * n4));
        this.bibg = new BufferedImage(n * this.pixelWidth, n2 * this.pixelHeight, 1);
        this.bibgg2d = this.bibg.createGraphics();
        this.atbgg2d = new AffineTransform(this.bibgg2d.getTransform());
        this.bibgg2d.setStroke(this.gridStroke);
        this.bifg = new BufferedImage(n * this.pixelWidth, n2 * this.pixelHeight, 1);
        this.bifgg2d = this.bifg.createGraphics();
        this.atfgg2d = new AffineTransform(this.bifgg2d.getTransform());
        this.qrot = new AffineTransform(this.bifgg2d.getTransform());
        this.bifgg2d.setStroke(this.gridStroke);
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 1.0f);
        this.bibgg2d.setComposite(alphaComposite);
        this.bifgg2d.setColor(this.bgColor);
        this.bifgg2d.fillRect(0, 0, this.nxpixels * this.pixelWidth, this.nypixels * this.pixelHeight);
        this.drawGrid(this.bibgg2d, this.gridColor);
        this.popupMenu = new JPopupMenu();
        this.makePopupMenu(this.popupMenu, this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void makePopupMenu(JPopupMenu jPopupMenu, ActionListener actionListener) {
        JMenuItem jMenuItem = jPopupMenu.add("On colour...");
        jMenuItem.setActionCommand("oncolor");
        jMenuItem.addActionListener(actionListener);
        jMenuItem = jPopupMenu.add("Off colour...");
        jMenuItem.setActionCommand("offcolor");
        jMenuItem.addActionListener(actionListener);
        jMenuItem = jPopupMenu.add("Background colour...");
        jMenuItem.setActionCommand("bgcolor");
        jMenuItem.addActionListener(actionListener);
        jMenuItem = jPopupMenu.add("Grid colour...");
        jMenuItem.setActionCommand("gridcolor");
        jMenuItem.addActionListener(actionListener);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = n / this.pixelWidth;
        int n4 = n2 / this.pixelHeight;
        if (n3 < 0 || n3 >= this.nxpixels || n4 < 0 || n4 >= this.nypixels) {
            return;
        }
        this.showStatus("(x,y)=(" + n3 + "," + n4 + ") state=" + this.cellState[n3][n4]);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
        try {
            Point2D point2D = this.qrot.inverseTransform(new Point(mouseEvent.getX(), mouseEvent.getY()), null);
            this.lastPressed.x = (int)point2D.getX() / this.pixelWidth;
            this.lastPressed.x = this.lastPressed.x < 0 ? 0 : this.lastPressed.x;
            this.lastPressed.x = this.lastPressed.x >= this.nxpixels ? this.nxpixels - 1 : this.lastPressed.x;
            this.lastPressed.y = (int)point2D.getY() / this.pixelHeight;
            this.lastPressed.y = this.lastPressed.y < 0 ? 0 : this.lastPressed.y;
            this.lastPressed.y = this.lastPressed.y >= this.nypixels ? this.nypixels - 1 : this.lastPressed.y;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
        try {
            Point2D point2D = this.qrot.inverseTransform(new Point(mouseEvent.getX(), mouseEvent.getY()), null);
            this.lastReleased.x = (int)point2D.getX() / this.pixelWidth;
            this.lastReleased.x = this.lastReleased.x < 0 ? 0 : this.lastReleased.x;
            this.lastReleased.x = this.lastReleased.x >= this.nxpixels ? this.nxpixels - 1 : this.lastReleased.x;
            this.lastReleased.y = (int)point2D.getY() / this.pixelHeight;
            this.lastReleased.y = this.lastReleased.y < 0 ? 0 : this.lastReleased.y;
            this.lastReleased.y = this.lastReleased.y >= this.nypixels ? this.nypixels - 1 : this.lastReleased.y;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        int n = this.lastReleased.x >= this.lastPressed.x ? this.lastPressed.x : this.lastReleased.x;
        int n2 = this.lastReleased.x >= this.lastPressed.x ? this.lastReleased.x : this.lastPressed.x;
        int n3 = this.lastReleased.y >= this.lastPressed.y ? this.lastPressed.y : this.lastReleased.y;
        int n4 = this.lastReleased.y >= this.lastPressed.y ? this.lastReleased.y : this.lastPressed.y;
        for (int i = n; i <= n2; ++i) {
            for (int j = n3; j <= n4; ++j) {
                if (this.cellState[i][j] == 0) {
                    this.setCellOn(i, j);
                    continue;
                }
                this.setCellOff(i, j);
            }
        }
        this.update();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.lastClicked.x = n / this.pixelWidth;
        this.lastClicked.y = n2 / this.pixelHeight;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    public int getLastClickedX() {
        return this.lastClicked.x;
    }

    public int getLastClickedY() {
        return this.lastClicked.y;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("oncolor") || string.equals("offcolor") || string.equals("bgcolor") || string.equals("gridcolor")) {
            this.setColor(string);
        }
    }

    public void drawGrid(Graphics2D graphics2D, Color color) {
        graphics2D.setColor(color);
        for (int i = 0; i < this.nxpixels; ++i) {
            for (int j = 0; j < this.nypixels; ++j) {
                graphics2D.drawRect(i * this.pixelWidth, j * this.pixelHeight, this.pixelWidth - 1, this.pixelHeight - 1);
            }
        }
    }

    public void update() {
        this.repaint();
    }

    public void clear() {
        for (int i = 0; i < this.nxpixels; ++i) {
            for (int j = 0; j < this.nypixels; ++j) {
                this.cellState[i][j] = 0;
            }
        }
        this.repaint();
    }

    public void setAlpha(float[][] fArray) {
        for (int i = 0; i < this.nxpixels; ++i) {
            for (int j = 0; j < this.nypixels; ++j) {
                this.alpha[i][j] = fArray[i][j];
            }
        }
        this.repaint();
    }

    public void setAlpha(float f) {
        for (int i = 0; i < this.nxpixels; ++i) {
            for (int j = 0; j < this.nypixels; ++j) {
                this.alpha[i][j] = f;
            }
        }
        this.repaint();
    }

    public void setOnColor(Color color) {
        this.onFgColor = color;
    }

    public void setOffColor(Color color) {
        this.offFgColor = color;
    }

    public Color getOnColor() {
        return this.onFgColor;
    }

    public Color getOffColor() {
        return this.offFgColor;
    }

    public void setBackgroundColor(Color color) {
        this.bgColor = color;
        this.bibgg2d.setColor(this.bgColor);
        this.bibgg2d.fillRect(0, 0, this.nxpixels * this.pixelWidth, this.nypixels * this.pixelHeight);
    }

    public Color getBackgroundColor() {
        return this.bgColor;
    }

    public void setGridColor(Color color) {
        this.gridColor = color;
        this.drawGrid(this.bibgg2d, this.gridColor);
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public void setColor(String string) {
        Color color = null;
        if (string.equals("oncolor")) {
            color = JColorChooser.showDialog(this, "On colour chooser", this.onFgColor);
        } else if (string.equals("offcolor")) {
            color = JColorChooser.showDialog(this, "Off colour chooser", this.offFgColor);
        } else if (string.equals("bgcolor")) {
            color = JColorChooser.showDialog(this, "Background colour chooser", this.bgColor);
        } else if (string.equals("gridcolor")) {
            color = JColorChooser.showDialog(this, "Grid colour chooser", this.gridColor);
        }
        if (color != null) {
            if (string.equals("oncolor")) {
                this.setOnColor(color);
            } else if (string.equals("offcolor")) {
                this.setOffColor(color);
            } else if (string.equals("bgcolor")) {
                this.setBackgroundColor(color);
            } else if (string.equals("gridcolor")) {
                this.setGridColor(color);
            }
        }
    }

    public void setCellOn(int n, int n2) {
        if (n >= this.nxpixels || n2 >= this.nypixels || n < 0 || n2 < 0) {
            this.showStatus("Array index out of bounds [x][y]=[" + n + "][" + n2 + "]");
            return;
        }
        this.cellState[n][n2] = 1;
        if (this.onOffAlphaMode) {
            this.alpha[n][n2] = this.onAlpha;
        }
        this.update();
    }

    public void setCellOff(int n, int n2) {
        if (n >= this.nxpixels || n2 >= this.nypixels || n < 0 || n2 < 0) {
            this.showStatus("Array index out of bounds [x][y]=[" + n + "][" + n2 + "]");
            return;
        }
        this.cellState[n][n2] = 0;
        if (this.onOffAlphaMode) {
            this.alpha[n][n2] = this.offAlpha;
        }
        this.update();
    }

    public void paintNonBuffered(Graphics2D graphics2D, Paper paper, int n, int n2, int n3, int n4, boolean bl) {
        double d;
        AffineTransform affineTransform = graphics2D.getTransform();
        double d2 = paper.getImageableWidth() / (double)(n3 * this.nxpixels * this.pixelWidth);
        double d3 = d2 < (d = paper.getImageableHeight() / (double)(n4 * this.nypixels * this.pixelHeight)) ? d2 : d;
        graphics2D.translate(paper.getImageableX(), paper.getImageableY());
        graphics2D.scale(d3, d3);
        graphics2D.translate(n * this.nxpixels * this.pixelWidth, n2 * this.nypixels * this.pixelHeight);
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 1.0f);
        graphics2D.setComposite(alphaComposite);
        graphics2D.clearRect(0, 0, this.nxpixels * this.pixelWidth, this.nypixels * this.pixelHeight);
        if (bl) {
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(0, 0, this.nxpixels * this.pixelWidth, this.nypixels * this.pixelHeight);
            graphics2D.setColor(Color.black);
        } else {
            graphics2D.setColor(this.bgColor);
            graphics2D.fillRect(0, 0, this.nxpixels * this.pixelWidth, this.nypixels * this.pixelHeight);
            this.drawGrid(graphics2D, this.gridColor);
        }
        for (int i = 0; i < this.nxpixels; ++i) {
            for (int j = 0; j < this.nypixels; ++j) {
                AlphaComposite alphaComposite2 = AlphaComposite.getInstance(3, this.alpha[i][j]);
                graphics2D.setComposite(alphaComposite2);
                if (this.cellState[i][j] == 0) {
                    graphics2D.setColor(this.offFgColor);
                } else {
                    graphics2D.setColor(this.onFgColor);
                }
                graphics2D.fillRect(i * this.pixelWidth, j * this.pixelHeight, this.pixelWidth, this.pixelHeight);
            }
        }
        graphics2D.setColor(Color.black);
        graphics2D.drawRect(0, 0, this.nxpixels * this.pixelWidth, this.nypixels * this.pixelHeight);
        graphics2D.setTransform(affineTransform);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 1.0f);
        this.bifgg2d.setComposite(alphaComposite);
        this.bifgg2d.clearRect(0, 0, this.nxpixels * this.pixelWidth, this.nypixels * this.pixelHeight);
        this.bifgg2d.drawImage((Image)this.bifg, 0, 0, this);
        for (int i = 0; i < this.nxpixels; ++i) {
            for (int j = 0; j < this.nypixels; ++j) {
                AlphaComposite alphaComposite2 = AlphaComposite.getInstance(3, this.alpha[i][j]);
                this.bifgg2d.setComposite(alphaComposite2);
                if (this.cellState[i][j] == 0) {
                    this.bifgg2d.setColor(this.offFgColor);
                } else {
                    this.bifgg2d.setColor(this.onFgColor);
                }
                this.bifgg2d.fillRect(i * this.pixelWidth, j * this.pixelHeight, this.pixelWidth, this.pixelHeight);
                this.bifgg2d.setColor(this.gridColor);
                this.bifgg2d.drawRect(i * this.pixelWidth, j * this.pixelHeight, this.pixelWidth - 1, this.pixelHeight - 1);
            }
        }
        graphics.drawImage(this.bifg, 0, 0, this);
    }

    public void getState(int[][] nArray) {
        for (int i = 0; i < this.nxpixels; ++i) {
            for (int j = 0; j < this.nypixels; ++j) {
                nArray[i][j] = this.cellState[i][j];
            }
        }
    }

    public void setOnOffAlphaMode(boolean bl) {
        this.onOffAlphaMode = bl;
    }

    public void showStatus(String string) {
    }

    public Vector<Point> getSelectedCells() {
        Vector<Point> vector = new Vector<Point>();
        for (int i = 0; i < this.nxpixels; ++i) {
            for (int j = 0; j < this.nypixels; ++j) {
                if (this.cellState[i][j] != 1) continue;
                vector.add(new Point(i, j));
            }
        }
        return vector;
    }

    public void setRotation(int n) {
        this.quadrantRotation = n;
        this.qrot = new AffineTransform(this.atfgg2d);
        this.qrot.quadrantRotate(this.quadrantRotation, (double)(this.nxpixels * this.pixelWidth) / 2.0, (double)(this.nypixels * this.pixelHeight) / 2.0);
        this.bifgg2d.setTransform(this.qrot);
        this.bibgg2d.setTransform(this.qrot);
        this.update();
    }
}

