/*
 * Decompiled with CFR 0.152.
 */
package cbsw.instrument.adept;

import cbsw.TapBuilder;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;
import javax.swing.JComboBox;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.Timer;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class JniAdeptDepp {
    private static XMLInputFactory xmlif;
    private static HashMap<String, HashMap<String, String>> regMap;
    private BitSet regBits;
    private static ReentrantLock djtgLock;
    private static ReentrantLock deppLock;
    static ActionListener importHWAL;
    static ActionListener enumerateAL;
    private Timer timer;
    private String deviceString;
    ActionListener timerAL = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                JniAdeptDepp.this.close();
                JniAdeptDepp.this.open();
            }
            catch (DeppException deppException) {
                System.out.println("JniAdeptDepp.timerAL(): Exception opening " + JniAdeptDepp.this.deviceString);
            }
        }
    };

    public static void addMenuItems(JMenu jMenu) {
        JMenuItem jMenuItem = new JMenuItem("Import hardware...");
        jMenuItem.addActionListener(importHWAL);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Enumerate");
        jMenuItem.addActionListener(enumerateAL);
        jMenu.add(jMenuItem);
    }

    static void loadMap(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            XMLStreamReader xMLStreamReader = xmlif.createXMLStreamReader(string, new FileInputStream(string));
            int n = xMLStreamReader.getEventType();
            while (xMLStreamReader.hasNext()) {
                n = xMLStreamReader.next();
                if (n != 1 || !xMLStreamReader.getLocalName().equals("PDMDBRegister")) continue;
                String string2 = xMLStreamReader.getAttributeValue(0);
                hashMap.clear();
                while (xMLStreamReader.hasNext() && ((n = xMLStreamReader.next()) != 2 || !xMLStreamReader.getLocalName().equals("PDMDBRegister"))) {
                    if (n != 1) continue;
                    String string3 = xMLStreamReader.getLocalName();
                    String string4 = xMLStreamReader.getElementText();
                    hashMap.put(string3, string4);
                }
                regMap.put(string2, new HashMap(hashMap));
            }
            xMLStreamReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("File not found");
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }

    public JniAdeptDepp(String string) {
        this.regBits = new BitSet(2048);
        this.deviceString = string;
        this.timer = new Timer(1000, this.timerAL);
        this.timer.setInitialDelay(0);
        this.timer.setCoalesce(true);
    }

    public JniAdeptDepp(String string, ActionListener actionListener) {
        this.regBits = new BitSet(2048);
        this.deviceString = string;
        this.timer = new Timer(1000, actionListener);
        this.timer.setInitialDelay(0);
        this.timer.setCoalesce(true);
    }

    public boolean OK() {
        return true;
    }

    public static void showEnumeratedDevices() {
        int n = dmgr.enumerate();
        for (int i = 0; i < n; ++i) {
            System.out.println(dmgr.getEnumeratedDevice(i));
        }
    }

    public void connect() {
        this.timer.start();
    }

    public void disconnect() {
        this.timer.stop();
        this.close();
    }

    public void open() throws DeppException {
        try {
            deppLock.lock();
            if (dmgr.open(this.deviceString) != 1) {
                throw new DeppException();
            }
        }
        finally {
            deppLock.unlock();
        }
    }

    public void close() {
        try {
            deppLock.lock();
            int n = dmgr.close();
        }
        finally {
            deppLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(byte by, byte[] byArray) throws DeppException {
        try {
            deppLock.lock();
            byte[] byArray2 = new byte[]{by};
            if (depp.getSet(byArray2, byArray) != 1) {
                throw new DeppException();
            }
        }
        finally {
            deppLock.unlock();
        }
    }

    public void get(byte[] byArray, byte[] byArray2) throws DeppException {
        try {
            deppLock.lock();
            if (depp.getSet(byArray, byArray2) != 1) {
                throw new DeppException();
            }
        }
        finally {
            deppLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(byte by, byte by2) throws DeppException {
        try {
            deppLock.lock();
            byte[] byArray = new byte[]{by, by2};
            if (depp.putSet(byArray) != 1) {
                throw new DeppException();
            }
        }
        finally {
            deppLock.unlock();
        }
    }

    public void put(byte[] byArray) throws DeppException {
        try {
            deppLock.lock();
            if (depp.putSet(byArray) != 1) {
                throw new DeppException();
            }
        }
        finally {
            deppLock.unlock();
        }
    }

    public void put(int n, int n2, int n3) throws DeppException {
        byte[] byArray = new byte[]{(byte)(n3 & 0xFF), (byte)(n3 >> 8 & 0xFF), (byte)(n3 >> 16 & 0xFF), (byte)(n3 >> 24 & 0xFF)};
        this.put(n, n2, byArray);
    }

    public void put(int n, int n2, short s) throws DeppException {
        byte[] byArray = new byte[]{(byte)(s & 0xFF), (byte)(s >> 8 & 0xFF)};
        this.put(n, n2, byArray);
    }

    public void put(int n, int n2, byte by) throws DeppException {
        byte[] byArray = new byte[]{by};
        this.put(n, n2, byArray);
    }

    public void push(int n, int n2, int n3, byte[] byArray, boolean bl) throws DeppException {
        byArray[0] = (byte)(n2 & 0xFF);
        byArray[1] = (byte)(n2 >> 8 & 0xFF);
        byArray[2] = (byte)(n3 & 0xFF);
        byArray[3] = (byte)(n3 >> 8 & 0x7F);
        if (bl) {
            byArray[3] = (byte)(byArray[3] | 0xFFFFFF80);
        }
        this.push((byte)(n & 0xFF), byArray);
    }

    public void push(byte by, byte[] byArray) throws DeppException {
        try {
            deppLock.lock();
            if (depp.putRepeat(by, byArray) != 1) {
                throw new DeppException();
            }
        }
        finally {
            deppLock.unlock();
        }
    }

    public void pop(byte by, byte[] byArray) throws DeppException {
        try {
            deppLock.lock();
            if (depp.getRepeat(by, byArray) != 1) {
                throw new DeppException();
            }
        }
        finally {
            deppLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(int n, int n2, byte[] byArray) throws DeppException {
        byte[] byArray2 = new byte[]{(byte)(n & 0xFF), (byte)(n2 & 0xFF), (byte)(n + 1 & 0xFF), (byte)(n2 >> 8 & 0xFF)};
        try {
            deppLock.lock();
            if (depp.putSet(byArray2) != 1) {
                throw new DeppException();
            }
            if (depp.putRepeat((byte)(n + 2 & 0xFF), byArray) != 1) {
                throw new DeppException();
            }
        }
        finally {
            deppLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getBytes(int n, int n2, byte[] byArray) throws DeppException {
        byte[] byArray2 = new byte[]{(byte)(n & 0xFF), (byte)(n2 & 0xFF), (byte)(n + 1 & 0xFF), (byte)(n2 >> 8 & 0xFF)};
        try {
            deppLock.lock();
            if (depp.putSet(byArray2) != 1) {
                throw new DeppException();
            }
            if (depp.getRepeat((byte)(n + 2 & 0xFF), byArray) != 1) {
                throw new DeppException();
            }
        }
        finally {
            deppLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(int n, int n2, byte[] byArray) throws DeppException {
        byte[] byArray2 = new byte[4];
        int n3 = 0;
        int n4 = byArray.length;
        byArray2[n3++] = (byte)(n4 & 0xFF);
        byArray2[n3++] = (byte)(n4 >> 8 & 0xFF);
        byArray2[n3++] = (byte)(n2 & 0xFF);
        byArray2[n3++] = (byte)(n2 >> 8 & 0xFF);
        try {
            deppLock.lock();
            if (depp.putRepeat((byte)(n & 0xFF), byArray2) != 1) {
                throw new DeppException();
            }
            if (depp.getRepeat((byte)(n & 0xFF), byArray) != 1) {
                throw new DeppException();
            }
        }
        finally {
            deppLock.unlock();
        }
    }

    public void set(String string, Preferences preferences) {
        HashMap<String, String> hashMap = regMap.get(string);
        int n = Integer.parseInt(hashMap.get("Offset"));
        byte by = (byte)Integer.parseInt(hashMap.get("Length"));
        int n2 = n + by;
        String string2 = preferences.get(string, "0");
        for (int i = string2.length() - 1; i >= 0 && n < n2; --i) {
            int n3 = Integer.parseInt(string2.substring(i, i + 1), 16);
            for (int j = 0; j < 4 && n < n2; ++j) {
                if ((n3 >> j & 1) == 1) {
                    this.regBits.set(n++);
                    continue;
                }
                this.regBits.clear(n++);
            }
        }
    }

    public void setBoolean(String string, Preferences preferences) {
        HashMap<String, String> hashMap = regMap.get(string);
        int n = Integer.parseInt(hashMap.get("Offset"));
        byte by = (byte)Integer.parseInt(hashMap.get("Length"));
        if (by != 1) {
            return;
        }
        if (preferences.getBoolean(string, false)) {
            this.regBits.set(n);
        } else {
            this.regBits.clear(n);
        }
    }

    public void set(String string, boolean bl) {
        HashMap<String, String> hashMap = regMap.get(string);
        int n = Integer.parseInt(hashMap.get("Offset"));
        byte by = (byte)Integer.parseInt(hashMap.get("Length"));
        if (by != 1) {
            return;
        }
        if (bl) {
            this.regBits.set(n);
        } else {
            this.regBits.clear(n);
        }
    }

    public byte[] getByteArray(int n) {
        byte[] byArray = new byte[n];
        System.arraycopy(this.regBits.toByteArray(), 0, byArray, 0, this.regBits.toByteArray().length);
        return byArray;
    }

    public byte[] getByteArray(int n, int n2) {
        byte[] byArray = new byte[n];
        int n3 = this.regBits.toByteArray().length;
        if (n3 < n2) {
            return byArray;
        }
        int n4 = n3 < n + n2 ? n3 - n2 : n;
        System.arraycopy(this.regBits.toByteArray(), n2, byArray, 0, n4);
        return byArray;
    }

    public static void importHardware(String string) {
        System.out.println("JniAdeptDepp.importHardware(): Importing " + string);
        try {
            URL uRL = new URL(string);
            if (uRL == null) {
                System.err.println("Error forming data source URL: " + string);
                return;
            }
            InputStream inputStream = uRL.openStream();
            Preferences.userRoot();
            Preferences.importPreferences(inputStream);
            inputStream.close();
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("Warning: " + malformedURLException.getMessage());
        }
        catch (EOFException eOFException) {
            System.err.println("End of file");
        }
        catch (IOException iOException) {
            System.err.println("Warning: " + iOException.getMessage());
        }
        catch (InvalidPreferencesFormatException invalidPreferencesFormatException) {
            invalidPreferencesFormatException.printStackTrace();
        }
    }

    public static JMenu makeDeviceMenu(String string, ActionListener actionListener) {
        JMenu jMenu = new JMenu(string);
        try {
            for (String string2 : Preferences.userRoot().node("Hardware/Xilinx").childrenNames()) {
                JMenuItem jMenuItem = new JMenuItem(string2);
                jMenuItem.addActionListener(actionListener);
                jMenu.add(jMenuItem);
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        return jMenu;
    }

    public static String selectDevice(String string) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (string == null) {
            string = new String("chimaera2v3");
        }
        try {
            for (String string2 : Preferences.userRoot().node("Hardware/Xilinx").childrenNames()) {
                Preferences preferences = Preferences.userRoot().node("Hardware/Xilinx").node(string2);
                if (!preferences.get("typeName", "chimaera2v3").equals(string)) continue;
                arrayList.add(string2);
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        Object[] objectArray = arrayList.toArray();
        return (String)JOptionPane.showInputDialog(null, "Select hardware", "EC tester", 3, null, objectArray, objectArray[0]);
    }

    public static JComboBox<String> makeDeviceComboBox(String string, ActionListener actionListener, String string2) {
        if (string2 == null) {
            string2 = new String("chimaera2v3");
        }
        JComboBox<String> jComboBox = new JComboBox<String>();
        if (actionListener != null) {
            jComboBox.addActionListener(actionListener);
        }
        try {
            for (String string3 : Preferences.userRoot().node("Hardware/Xilinx").childrenNames()) {
                Preferences preferences = Preferences.userRoot().node("Hardware/Xilinx").node(string3);
                if (!preferences.get("typeName", "chimaera2v3").equals(string2)) continue;
                jComboBox.addItem(string3);
                if (!string3.equals(string)) continue;
                jComboBox.setSelectedItem(string3);
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        return jComboBox;
    }

    public static Preferences getDevicePreferences(Class clazz, String string) {
        Preferences preferences = Preferences.userNodeForPackage(clazz).node(string);
        String string2 = preferences.get("hardwareId", "default");
        return Preferences.userRoot().node("Hardware/Xilinx").node(string2);
    }

    static {
        System.loadLibrary("JniAdeptDepp");
        xmlif = XMLInputFactory.newInstance();
        regMap = new HashMap();
        JniAdeptDepp.loadMap("DeppRegisters.xml");
        djtgLock = new ReentrantLock();
        deppLock = new ReentrantLock();
        importHWAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JniAdeptDepp.importHardware("http://www.hep.phy.cam.ac.uk/lhcb/RICHEC/xml/XilinxHardwarePrefs.xml");
            }
        };
        enumerateAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JniAdeptDepp.showEnumeratedDevices();
            }
        };
    }

    public static class djtg {
        public static native boolean enable();

        public static native boolean disable();

        public static native String getProperties(int var0);

        public static native boolean putTmsTdi(int var0, byte[] var1, byte[] var2);

        public static native boolean putTmsTdi(int var0, byte[] var1);

        public static native boolean putTms(int var0, byte[] var1, byte[] var2, boolean var3);

        public static native boolean putTms(int var0, byte[] var1, boolean var2);

        public static native boolean putTdi(int var0, byte[] var1, byte[] var2, boolean var3);

        public static native boolean putTdi(int var0, byte[] var1, boolean var2);

        public static native boolean clock(boolean var0, boolean var1, int var2);

        public static byte[] packAndGo(TapBuilder tapBuilder, boolean bl) {
            int n = tapBuilder.length();
            if (n < 1) {
                return null;
            }
            tapBuilder.show();
            ByteBuffer byteBuffer = tapBuilder.tmsTdoToByteBuffer();
            tapBuilder.setDebug(false);
            boolean bl2 = false;
            byte[] byArray = null;
            if (bl) {
                byArray = new byte[byteBuffer.capacity() / 2];
                bl2 = djtg.putTmsTdi(n, byteBuffer.array(), byArray);
            } else {
                bl2 = djtg.putTmsTdi(n, byteBuffer.array());
            }
            if (!bl2) {
                System.err.println("JniAdeptDepp.djtg.packAndGo(): putTmsTdi() failed.");
            }
            return byArray;
        }
    }

    public static class depp {
        public static native int enable();

        public static native int disable();

        public static native int getSet(byte[] var0, byte[] var1);

        public static native int getRepeat(byte var0, byte[] var1);

        public static native int putSet(byte[] var0);

        public static native int putRepeat(byte var0, byte[] var1);
    }

    public static class dmgr {
        public static native int open(String var0);

        public static native int close();

        public static native int enumerate();

        public static native String getEnumeratedDevice(int var0);

        public static native int getLastError();

        public static native String getLastErrorName(int var0);

        public static native String getLastErrorDescription(int var0);
    }

    public class DeppException
    extends Exception {
        int code = dmgr.getLastError();
        String name = dmgr.getLastErrorName(this.code);
        String description = dmgr.getLastErrorDescription(this.code);

        public int getCode() {
            return this.code;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

