/*
 * Decompiled with CFR 0.152.
 */
package cbsw.instrument.adept;

import cbsw.instrument.adept.JniAdeptDepp;
import java.awt.Dimension;
import java.awt.Font;
import java.util.prefs.Preferences;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class GuiTable {
    Preferences prefs;
    JniAdeptDepp depp;
    int baseAddress = 0;
    int csrAddress = 0;
    int csrSize;
    int tableDataDisplayWidth;
    String[] tableColumnNames = new String[]{"Addr", "Data"};
    Object[][] tableData;
    JScrollPane tableSP;
    JTable statusTable;

    public GuiTable(JniAdeptDepp jniAdeptDepp, int n, int n2) {
        this.depp = jniAdeptDepp;
        this.baseAddress = n & 0xFC;
        this.csrSize = n2;
    }

    public void setBaseAddress(int n) {
        this.baseAddress = n & 0xFC;
    }

    public JTable getStatusTable() {
        return this.statusTable;
    }

    public JTable makeStatusTable(int n) {
        this.tableDataDisplayWidth = n;
        this.tableData = new Object[(this.csrSize + this.tableDataDisplayWidth - 1) / this.tableDataDisplayWidth][];
        for (int i = 0; i < this.csrSize; i += this.tableDataDisplayWidth) {
            int n2 = i / this.tableDataDisplayWidth;
            this.tableData[n2] = new Object[2];
            this.tableData[n2][0] = new Integer(i);
            this.tableData[n2][1] = "";
        }
        this.statusTable = new JTable(this.tableData, this.tableColumnNames);
        this.statusTable.setFont(new Font("Monospaced", 0, 11));
        this.statusTable.setPreferredScrollableViewportSize(new Dimension(40 + this.tableDataDisplayWidth * 16, 200));
        this.statusTable.getColumnModel().getColumn(0).setPreferredWidth(40);
        this.statusTable.getColumnModel().getColumn(1).setPreferredWidth(this.tableDataDisplayWidth * 16);
        return this.statusTable;
    }

    public void setPreferencesRoot(Preferences preferences) {
        this.prefs = preferences;
    }

    public void writeArray(byte[] byArray) {
        byte[] byArray2 = new byte[]{(byte)this.baseAddress, (byte)(this.csrAddress & 0xFF), (byte)(this.baseAddress + 1), (byte)(this.csrAddress >> 8 & 0xFF)};
        try {
            this.depp.put(this.baseAddress, this.csrAddress, byArray);
        }
        catch (JniAdeptDepp.DeppException deppException) {
            // empty catch block
        }
    }

    public void readArray(byte[] byArray) {
        byte[] byArray2 = new byte[]{(byte)this.baseAddress, (byte)(this.csrAddress & 0xFF), (byte)(this.baseAddress + 1), (byte)(this.csrAddress >> 8 & 0xFF)};
        try {
            this.depp.getBytes(this.baseAddress, this.csrAddress, byArray);
        }
        catch (JniAdeptDepp.DeppException deppException) {
            // empty catch block
        }
    }

    public void updateStatusTable() {
        byte[] byArray = new byte[this.csrSize];
        byte[] byArray2 = new byte[]{(byte)this.baseAddress, (byte)(this.csrAddress & 0xFF), (byte)(this.baseAddress + 1), (byte)(this.csrAddress >> 8 & 0xFF)};
        try {
            this.depp.getBytes(this.baseAddress, this.csrAddress, byArray);
        }
        catch (JniAdeptDepp.DeppException deppException) {
            // empty catch block
        }
        for (int i = 0; i < this.csrSize; i += this.tableDataDisplayWidth) {
            int n = i / this.tableDataDisplayWidth;
            String string = "";
            for (int j = 0; j < this.tableDataDisplayWidth; ++j) {
                string = String.format("%1$02x", byArray[i + j]) + string;
            }
            this.statusTable.setValueAt(string, n, 1);
        }
    }
}

