#Check environment variables:

if (! $?SCT_DAQ_ROOT) then
    echo "SCT_DAQ_ROOT not set.  It should point to the directory this file is in"
    exit 1
endif 

if (! $?SCT_SCRATCH_DIR) then
   setenv SCT_SCRATCH_DIR /tmp
   echo "SCT_SCRATCH_DIR not set.  This directory needs to be readable/writable by the SBC and all the fitting and analysis machines. It has been set to the default which is $SCT_SCRATCH_DIR."
endif

if (! $?SCT_PERSISTENT_DIR) then
   setenv SCT_PERSISTENT_DIR /tmp
   echo "SCT_PERSISTENT_DIR not set.  This directory needs to be writable by the ArchivingService. It has been set to the default which is $SCT_PERSISTENT_DIR"
endif


if (! $?TDAQ_INST_PATH) then
   echo "TDAQ_INST_PATH not set.  You need to setup the online software first!"
   exit 1
endif

if (! $?ROOTSYS) then
    echo "ROOTSYS not set.  You need to setup Root first!"
    exit 1
endif

if (  `echo \$PATH | grep \$ROOTSYS/bin`) then
    echo "PATH not set correctly.  Please make sure $ROOTSYS/bin is in the path"
    exit 1
endif

if ( `echo \$LD_LIBRARY_PATH | grep \$ROOTSYS/lib`) then
    echo "LD_LIBRARY_PATH not set correctly.  Please make sure $ROOTSYS/lib is in LD_LIBRARY_PATH" 
    exit 1
endif 

if (! $?DF_INST_PATH) then 
    echo "DF_INST_PATH not set.  Please setup the Dataflow software correctly"
else 
    if ( `echo \$PATH | grep \$DF_INST_PATH/\$CMTCONFIG/bin`) then 
        echo "PATH not set correctly.  Please make sure $DF_INST_PATH/\$CMTCONFIG/bin is in the path"
        exit 1
    endif 
    if (`echo \$LD_LIBRARY_PATH | grep \$DF_INST_PATH/\$CMTCONFIG/lib`) then
       echo "LD_LIBRARY_PATH not set correctly.  Please make sure $DF_INST_PATH/\$CMTCONFIG/lib is in LD_LIBRARY_PATH"
       exit 1
    endif
endif

if (! $?SCTDAQ_ROD_CONFIGURATION_PATH)  then 
   echo "**** SCTDAQ_ROD_CONFIGURATION_PATH not set.  This should point to your configuration files for your rod."
   echo "**** It has been set to the default for using the DUMMY software" 
   echo "**** You should modify exampleRod.xml or use sctConfGUI to use a real setup"
   setenv SCTDAQ_ROD_CONFIGURATION_PATH $SCT_DAQ_ROOT/installed/config/TestConfig/DefaultRod.xml
   echo "SCTDAQ_ROD_CONFIGURATION_PATH=$SCTDAQ_ROD_CONFIGURATION_PATH"
endif
  
if (! $?TDAQ_DB_DATA) then 
   echo "**** TDAQ_DB_DATA not set.  This should point to your configuration files for your partition."
   echo "**** It has been set to the default for using the DUMMY software"
   echo "**** Use SCT.data.xml for the real software"
   setenv TDAQ_DB_DATA $SCT_DAQ_ROOT/installed/config/databases/SCT_test.data.xml
   echo "TDAQ_DB_DATA=$TDAQ_DB_DATA"
endif



if (! $?SCTPIXEL_DAQ_ROOT ) then
    setenv SCTPIXEL_DAQ_ROOT $SCT_DAQ_ROOT/RodDaq
endif

setenv ROD_TYPE SCT_ROD
setenv PATH ${PATH}:${SCT_DAQ_ROOT}/installed/share/bin:${SCT_DAQ_ROOT}/installed/${CMTCONFIG}/bin
setenv LD_LIBRARY_PATH ${LD_LIBRARY_PATH}:${SCT_DAQ_ROOT}/installed/${CMTCONFIG}/lib
setenv CLASSPATH $TDAQ_INST_PATH/share/lib/rc.jar:$CLASSPATH
