///////////////////////////////////////////////////////////////////////////
// This file contains the class definition to issue 
// a non-transition command (inspired from DDC code package)
//					
//    Created 01.04.03
//    by A. Abdesselam
///////////////////////////////////////////////////////////////////////////

#include <string>

#include <is/isnamedinfo.h>
#include "sctddc/SCTDdcCommandSender.hxx"
using namespace std;


  //SCTDdcCommandSender(IPCPartition& p, string** ctrlList);
SCTDdcCommandSender::SCTDdcCommandSender(IPCPartition& partition, string** ctrlList) 
  : m_partition(partition), m_commandAllowed(true), m_commandResponse(-99999), m_ctrlNum(0),
    m_controllers(ctrlList)
{
  m_receiver = new ISInfoReceiver(partition);
}

// ~SCTDdcCommandSender();
SCTDdcCommandSender::~SCTDdcCommandSender() 
{
  delete m_receiver;
}

void callback(ISCallbackInfo* cbInfo)
{
  SCTDdcCommandSender* sctDdcCommandSender = (SCTDdcCommandSender*)(cbInfo->parameter());
  
  DdcNtCommandResponse	result(sctDdcCommandSender->getPartition(),
			       (char*)cbInfo->name(), 0);
  string infoName(cbInfo->name());

  string ctrlName;
  
  //find the controller name. the received name has the format: command.controller.response
  ctrlName = infoName.substr(infoName.find('.')+1);
  ctrlName = ctrlName.substr(ctrlName.find('.')+1);
  ctrlName = ctrlName.substr(0, ctrlName.find("response")-1);

  if(cbInfo->reason() != ISInfoDeleted) 
    {
      if(cbInfo->type() == result.type()) 
	{
	  cbInfo->value(result);
	  sctDdcCommandSender->setCommandResponse(result.getValue());
	  if(result.getValue() <0) 
	    {
	      cerr << "SCTDdcCommandSender: Result of the "
		   << sctDdcCommandSender->getCommand() << " command on " << ctrlName << " is ";
	      // set the response command code
	      
	      switch(result.getValue()) 
		{
		case COMM_ERR_OK:
		  cerr << "OK" << endl;
		  break;
		case COMM_ERR_NAME:
		  cerr << "INVALIDE COMMAND NAME" << endl;
		  break;
		case COMM_ERR_DCSDP:
		  cerr << "COMMAND NOT DEFINED PROPERLY IN DCS" << endl;
		  break;
		case COMM_ERR_TIMEOUT:
		  cerr << "TIMEOUT" << endl;
		  break;
		case COMM_ERR_CONNECT:
		  cerr << "PVSS IS UNAVAILABLE" << endl;
		  break;
		case COMM_ERR_CONNBROKEN:
		  cerr << "CONNECTION TO DCS LOST" << endl;
		  break;
		case COMM_ERR_NTDESC:
		  cerr << "INVALID COMMAND DEFINITION IN IS" << endl;
		  break;
		  
		default:
		  cerr << "USER'S ERROR STATUS = " << result.getValue() 
		       <<". THIS IS NOT DEFINED "<< endl;
		}
	    } // end of if(result.getValue() <0) 
	  sctDdcCommandSender->getReceiver()->unsubscribe(infoName.c_str());
	  result.remove();
	  if(sctDdcCommandSender->decreaseCtrlNum() == 0)
	    {
	      sctDdcCommandSender->ddcRemoveCommand(ctrlName);
	      sctDdcCommandSender->ddcRemoveCommand();
	      
	      sctDdcCommandSender->setCommandAllowedTrue();
	    }
	}
      else 
	cerr << "SCTDdcCommandSender: Incorrect response. Assume "
	     << "an internal error" << endl;
    }
}

//this method  (which overload the method below) is jsut for the purpose to use a defalut 
//controller (*m_controllers[0])
int SCTDdcCommandSender::ddcSendCommand(string& commandName, 
				  string& commParameters, unsigned int timeout)
{
  string ctrlName = *m_controllers[0];
  return ddcSendCommand(ctrlName, commandName, commParameters, timeout);
}

int SCTDdcCommandSender::ddcSendCommand(string ctrlName, string& commandName, 
				  string& commParameters, unsigned int timeout)
{
  ISInfo::Status rc;
  string  respName;
  if(isValidCtrl(ctrlName)) 
    {
      m_ctrlNum = 0;
      if(ctrlName == "*") // send the command to all the contrllers
	{
	  // First subscription for the command results
	  for(unsigned int i=0; m_controllers[i] != 0; i++) 
	    {
	      respName = makeResponseName(*m_controllers[i], commandName);
	      rc = m_receiver->subscribe(respName.c_str(), callback, (void*)this);
	      if(rc == ISInfo::Success) 
		{
		  m_ctrlNum += 1;
		  cerr << "SCTDdcCommandSender_INFO: Subscribed for " << respName << endl;
		}
	      else 
		{
		  cerr << "DdcComander_WARNING: response of " << *m_controllers[i] 
		       << " is not subscribed for: ERROR code = " << rc << endl;
		}
	    }
	  
	  if(m_ctrlNum == 0) 
	    {
	      cerr << "SCTDdcCommandSender_ERROR: No response is subscribed" << endl;
	      cerr << "        ======>    No IS server to send command" << endl;
	    }
	  else 
	    {
	      // And now sending the command

	      
	      string	commEntryName(COMMAND_SERVER);
	      
	      commEntryName = commEntryName + ".DdcNtCommand";

  	      m_timeout = (timeout == 0) ? DEFAULT_TIMEOUT : timeout;
	      m_startTime = time(&m_startTime);

	      __ddcSendCommand(commEntryName, commandName, 
					 commParameters, m_timeout); 
	      m_commandName = commandName;
	      m_commandAllowed = false;
	    }
	}//end of if(ctrlName == "*")
      else 
	{
	  // First subscription for the command result
	  respName = makeResponseName(ctrlName, commandName);
	  rc = m_receiver->subscribe(respName.c_str(), callback, (void*)this);
	  if(rc != ISInfo::Success) 
	    {
	      cerr << "SCTDdcCommandSender_ERROR: " << respName
		   << " DdcNtCommandResponse subscription fault " << rc << endl;
	      cerr << "        ======>    No IS server to send command" << endl;;
	    }
	  else 
	    {
	      // And now sending the command
	      m_startTime = time(&m_startTime);
	      m_ctrlNum = 1;
	      
	      // send command for an individual DDC controller
	      string	commEntryName(COMMAND_SERVER);
	      commEntryName = commEntryName + ".DdcNtCommand" + '.' + ctrlName;
  	      m_timeout = (timeout == 0) ? DEFAULT_TIMEOUT : timeout;

	      __ddcSendCommand(commEntryName, commandName, 
					 commParameters, m_timeout);

	      m_commandName = commandName;
	      m_commandAllowed = false;
	    }
	}
    }
  else
    {
      cerr << "SCTDdcCommandSender_ERROR: Invalid controller name " << ctrlName << endl;
    }

  // wait until the command is finish the timeout sepnt
  time_t  now;
  while(!m_commandAllowed) 
    {
      usleep(10);
      now = time(&now);

      if(now - m_startTime > m_timeout) 
	{
	  for(unsigned int i=0; m_controllers[i] != 0; i++) 
	    {
	      string respEntryName = COMMAND_SERVER;
	      respEntryName = respEntryName + '.' + commandName + '.' 
		+ *m_controllers[i] + ".response";
		    m_receiver->unsubscribe(respEntryName.c_str());
		    
		    ddcRemoveCommand(*m_controllers[i]);
		    ddcRemoveCommand();
		    
		    m_commandAllowed = true;
	    }
	  cerr << "SCTDdcCommandSender: Result of the "
	       << getCommand() << " command is TIMEOUT" << endl;
	  break;
	}
    } //end while(...)
  return m_commandResponse;
}

// Help method (send command)
bool SCTDdcCommandSender::__ddcSendCommand(string& isEntryName, string& commandName, 
								   string& commParameters, unsigned int timeout)
{
  ISInfo::Status  rs;
  bool	  ok = true;

  DdcNtCommand* command = new DdcNtCommand(m_partition, (char*)isEntryName.c_str());

  if(command->isExist()) 
    {
      cerr << "SCTDdcCommandSender_ERROR: Previous command for the same controller(s)" 
	   << " seems to be still running" << endl;
      ok = false;
    }
  else 
    {
      command->setCommName(commandName);
      command->setParValue(commParameters);
      command->setTimeout(timeout);

      rs = command->checkin();

      if(rs != ISInfo::Success) {
	cerr << "SCTDdcCommandSender_ERROR: " << isEntryName
	     << " command sending fault " << rs << endl;
	ok = false;
      }
    }
  delete command;
  return(ok);
}


bool SCTDdcCommandSender::ddcRemoveCommand(string& ctrlName)
{
  ISInfo::Status rs;
  bool	  ok = true;
  string  commEntryName(COMMAND_SERVER);
  
  commEntryName = commEntryName + ".DdcNtCommand" + '.' + ctrlName;
  DdcNtCommand* command = new DdcNtCommand(m_partition, (char*)commEntryName.c_str());
  rs = command->remove();
  if(rs == ISInfo::CommFailure) {
    cerr << "SCTDdcCommandSender_ERROR: " << COMMAND_SERVER
	 << " is not running in " << m_partition.name() << endl;
    ok = false;
  }
  delete command;
  return(ok);
}


bool SCTDdcCommandSender::ddcRemoveCommand()
{
  ISInfo::Status rs;
  bool ok = true;
  string commEntryName(COMMAND_SERVER);
  
  commEntryName = commEntryName + ".DdcNtCommand";
  DdcNtCommand* command = new DdcNtCommand(m_partition, (char*)commEntryName.c_str());
  rs = command->remove();
  if(rs == ISInfo::CommFailure) {
    cerr << "SCTDdcCommandSender_ERROR: " << COMMAND_SERVER
	 << " is not running in " << m_partition.name() << endl;
    ok = false;
  }
  delete command;
  return(ok);
}

string	SCTDdcCommandSender::makeResponseName(string& ctrlName, string& commandName)
{
	string	isEntry(COMMAND_SERVER);
	
	isEntry += '.' + commandName + '.' + ctrlName + ".response";
	return(isEntry);
}


bool SCTDdcCommandSender::isValidCtrl(string& name)
{
  if(name == "*")
    {
      return(true);
    }
  else 
    {
      int i = 0;
      while(m_controllers[i] != 0) 
	{
	  if(*m_controllers[i] == name) return(true);
	  i++;
	}
      return(false);
    }
}
