///////////////////////////////////////////////////////////////////////////
// This file contains definition of functions to produce 
// DAQ request for DCS data single read (this is the DDC package DdcRequest class modified for SCT DAQ needs)
//					
//  Created 21.05.2003
//  by A. Abdesselam
///////////////////////////////////////////////////////////////////////////

#ifndef _SCTDDCREQUEST_H_
#define _SCTDDCREQUEST_H_

#ifndef _DDCDATA_H_
#include "ddc/DdcData.hxx"
#endif

class SCTDdcRequest
{
public:
  SCTDdcRequest(IPCPartition& p, string& isServer);

  void ddcSendRequest(string& dpeName, int& value, int timeout);
  void ddcSendRequest(string& dpeName, float& value, int timeout);
  void ddcSendRequest(string& dpeName, string& value, int timeout);
  void ddcSendRequest(string& dpeName, float* float_array, int& array_size, int timeout);
  void ddcSendRequest(std::vector<string>& dpeName_vec, 
		      std::map< string, float>& values_map, int timeout);

  // set methods
  void setRequestReady(bool stat){m_requestReady = stat;}
  //methods for int
  void setIntRequestResponse(int commandResp){m_intRequestResponse = commandResp;}
  // methods for float
  void setFloatRequestResponse(float commandResp){m_floatRequestResponse = commandResp;}
  // methods for string
  void setStringRequestResponse(string commandResp){m_stringRequestResponse = commandResp;}
  // methods for array of float
  void setFloatArrayRequestResponse(float* float_array, int& array_size)
  {
    m_floatArrayRequestResponse = float_array;
    m_floatArraySizeRequestResponse = array_size;
  }

  // methods for vector of float
  void setfloatVecRequestResponse(string dpeName, float dpeValue)
  {m_floatVecRequestResponse[dpeName] = dpeValue;}
  
  //methods for vector of float
  // initilizations related to request vector of float
  void requestReady_vec_init(unsigned int vecSize);
  //test if all the responses came
  bool getRequestReady_vec();
  //tell that one response came:  request =true
  void setRequestReady_vec(bool request);

  // read from IS when the parameters have requested trough the configuration file
  void readFromIS(string dpeName, float& value);
private:

  volatile bool    m_requestReady;
  // variables for int
  int            m_intRequestResponse;
  // variables for float
  float          m_floatRequestResponse;
  // variables for string
  string        m_stringRequestResponse;
  //array of float (PVSS dyn_float)
  float*         m_floatArrayRequestResponse;
  int           m_floatArraySizeRequestResponse;

  //varible for vecot of float
  volatile unsigned int m_requestReady_vec_index;
  std::vector<bool> m_requestReady_vec;
  std::map<string, float>  m_floatVecRequestResponse;

  IPCPartition	m_partition;
  string	m_requestServer;
  ISInfoReceiver*       m_infoReceiver;
};

#endif//_SCTDDCREQUEST_H_
