///////////////////////////////////////////////////////////////////////////
// This file contains the class definition to issue 
// a non-transition command (inspired from DDC code package)
//					
//    Created 01.04.03
//    by A. Abdesselam
///////////////////////////////////////////////////////////////////////////

#ifndef _SCTDDCCOMMANDSENDER_H_
#define _SCTDDCCOMMANDSENDER_H_

#ifndef _DDCCOMMAND_H_
using namespace std;  // Needed because the online headers don't have it!!!
#include "ddc/DdcCommand.hxx"
#endif

class SCTDdcCommandSender
{
public:
  //constructor
  SCTDdcCommandSender(IPCPartition& partition, string** ctrlList); 
 
  //destructor
  ~SCTDdcCommandSender();
  
  int ddcSendCommand(string& commandName, 
		     string& commParameters, unsigned int timeout);
  int ddcSendCommand(string ctrlName, string& commandName, 
		      string& commParameters, unsigned int timeout);
  bool ddcRemoveCommand();
  bool ddcRemoveCommand(string& ctrlName);
  string  makeResponseName(string& ctrlName, string& commandName);
  
  //get methods
  int decreaseCtrlNum(){ return(--m_ctrlNum);}
  IPCPartition&	getPartition(){ return(m_partition);}
  string& getCommand(){ return(m_commandName);}
  ISInfoReceiver* getReceiver(){ return(m_receiver);}
  bool commandAllowed(){return m_commandAllowed;}

  //set methods
  void setCommandAllowedTrue(){m_commandAllowed = true;}
  void setCommandResponse(int commandResp){m_commandResponse = commandResp;}

private:
  bool isValidCtrl(string& name);
  bool __ddcSendCommand(string& isEntryName, string& commandName, 
			string& commParameters, unsigned int timeout);
  
  IPCPartition	        m_partition;
  time_t		m_startTime;
  string		m_commandName;
  ISInfoReceiver*       m_receiver;
  bool			m_commandAllowed;
  int                    m_commandResponse;
  int			m_ctrlNum;
  unsigned int            m_timeout;
  string**		m_controllers;
};

#endif // _SCTDDCCOMMANDSENDER_H_

