///////////////////////////////////////////////////////////////////////////
// This file contains the class definition to issue 
// a non-transition command (SCT special commands)
//					
//    Created 01.04.03
//    by A. Abdesselam
///////////////////////////////////////////////////////////////////////////

#ifndef _SCTDCSCOMMAND_H_
#define _SCTDCSCOMMAND_H_


#define EXIT_COMMAND	"exit"

#include "SCTDdcCommandSender.hxx"
#include "SCTDdcRequest.hxx"

class SCTDCSCommand
{
public:
  SCTDCSCommand(IPCPartition& p, string** ctrlList); 
  ~SCTDCSCommand();

  
  void run(string** controllers);

  //  public methods definig DAQ commands sent to DCS
  //methods to tranform PS coordinates to PVSS coordinates
  //methods for channels addresses
  void psToPVSSChannelAddress(int crate, int channel, string para, const char* direction,
			      string& pvssAdress);
  void psToPVSSChannelAddress(int crate, int channel, std::vector<string> params,
			      const char* direction,
			      std::vector<string>& pvssAdresses);
  //methods for card addresses
  void psToPVSSCardAddress(int crate, int card, string para, const char* direction,
			   string& pvssAdress);
  void psToPVSSCardAddress(int crate, int card, std::vector<string> params,
			   const char* direction,
			   std::vector<string>& pvssAdresses);
  //methods for crate controller addresses
  void psToPVSSCrateCtrlAddress(int crate, string para, const char* direction, string& pvssAdress);
  void psToPVSSCrateCtrlAddress(int crate, std::vector<string> params, const char* direction,
		       std::vector<string>& pvssAdresses);
  //methods for crate  addresses
  void psToPVSSCrateAddress(int crate, string para, string& pvssAdress);
  void psToPVSSCrateAddress(int crate, std::vector<string> params,
				std::vector<string>& pvssAdresses);

  // read from IS DCS data. the corresponding datapoint element must be declare in the 
  //DDC config. file
  void readFromIS(string dpName, float& value);

  // methods for IV curve
  //request IV curve for one channel
  bool requestIVCurve(int crate, int channel, float Vstart, float Vstop, float Vstep, 
		      float Vend, float Iwarn, float Imax, int delay, int timeout);
  //request IV curve for all channel
  bool requestIVCurveAll(int crate, float Vstart, float Vstop, float Vstep, 
		      float Vend, float Iwarn, float Imax, int delay, int timeout);
  //this method read the IV curvre: to be called twice to read the tow arrays (voltage and current)
  void getIVCurveData(float* float_array, int& array_size, int timeout);
  //change the select line for all the channels in a given crate
  int setChannelsSelectLine(int crate, int selectLine, int timeout);
  //transition state command for one channel in a given crate
  int changeState(int crate, int channel, int state, int timeout);
  //transition state command for all channels in a given crate
  int changeState(int crate, const char* allChannels, int state, int timeout);

  //load configuration constants for all channels in a given crate
  int loadConfiguration(int crate, int state, int timeout);

  //reset one module ( correponding to a channel in a PS crate)
  int hardReset(int crate, int channel, int timeout);
  //reset 48 modules ( correponding to all channels in a PS crate)
  int hardReset(int crate, const char* allChannels, int timeout);

  //
  bool openDCSControl(string subSystem, int timeout);
  bool setDPStatus(string dpName, int state, int timeout);
  // this is a generic method, it address and datapoint element in PVSS tree
  int setParameter(int crate, int channel, string para, float value, int timeout);
  bool closeDCSControl(string subSystem, int timeout);


  // read data from DCS
  //methods to read channels parameters
  void getChannelParameter(int crate, int channel, string dpeName,
			   int& dpeValue, int timeout, const char* direction = "Recv");
  void getChannelParameter(int crate, int channel, string dpeName, float& dpeValue, 
			   int timeout, const char* direction = "Recv");
  void getChannelParameter(int crate, int channel, string dpeName, string& dpeValue, 
			   int timeout, const char* direction = "Recv");
  void getChannelParameters(int crate, int channel, std::vector<string> dpeNames, 
			    std::map<string, float>& dpeValues, int timeout, 
			    const char* direction = "Recv");
  //methods to read card parameters
  void getCardParameter(int crate, int card, string dpeName, int& dpeValue, int timeout, 
			const char* direction = "Recv");
  void getCardParameter(int crate, int card, string dpeName, float& dpeValue, int timeout, 
			const char* direction = "Recv");
  void getCardParameter(int crate, int card, string dpeName, string& dpeValue, int timeout, 
			const char* direction = "Recv");
  void getCardParameters(int crate, int card, std::vector<string> dpeNames, 
			 std::map<string, float>& dpeValues, int timeout, 
			 const char* direction = "Recv");
  //methods to read crate controller parameters
  void getCrateCtrlParameter(int crate, string dpeName, int& dpeValue, int timeout, 
			     const char* direction = "Recv");
  void getCrateCtrlParameter(int crate, string dpeName, float& dpeValue, int timeout, 
			     const char* direction = "Recv");
  void getCrateCtrlParameter(int crate, string dpeName, string& dpeValue, int timeout, 
			     const char* direction = "Recv");
  void getCrateCtrlParameters(int crate, std::vector<string> dpeNames, 
			 std::map<string, float>& dpeValues, int timeout, 
			      const char* direction = "Recv");
  //methods to read crate parameters
  void getCrateParameter(int crate, string dpeName, int& dpeValue, int timeout);
  void getCrateParameter(int crate, string dpeName, float& dpeValue, int timeout);
  void getCrateParameter(int crate, string dpeName, string& dpeValue, int timeout);
  void getCrateParameters(int crate, std::vector<string> dpeNames, 
			 std::map<string, float>& dpeValues, int timeout);


  // write data to DCS
  //methods to  set channels parameters
  int setChannelParameter(int crate, int channel, string dpeName, float dpeValue, int timeout);
  int setChannelParameters(int crate, int channel, 
			    std::map<string, float> dpeNamesAndValues, int timeout);
  
  //methods to  set card parameters
  int setCardParameter(int crate, int card, string dpeName, float dpeValue, int timeout);
  int setCardParameters(int crate, int card, 
			std::map<string, float> dpeNamesAndValues, int timeout);
  
  //methods to  set crate controller parameters
  int setCrateCtrlParameter(int crate, string dpeName, float dpeValue, int timeout);
  int setCrateCtrlParameters(int crate, std::map<string, float> dpeNamesAndValues, int timeout);

  //methods to  set crate parameters
  //int setCrateParameter(int crate, string dpeName, float dpeValue, int timeout);
  //int setCrateParameters(int crate, std::map<string, float> dpeNamesAndValues, int timeout);
  


  //get methods
  IPCPartition&	getPartition(){ return(m_partition);}

private:
  IPCPartition	        m_partition;
  SCTDdcCommandSender*	m_sctDdcCommandSender;
  SCTDdcRequest*           m_sctDdcRequest;
};

#endif //_SCTDCSCOMMAND_H_

