package guiUtilities;
/*
 
 */

import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import javax.swing.event.TableModelEvent;


public class myTableAdapter extends AbstractTableModel {
    public Vector		rows;
    public int recordCount;
    public String[]            columnNames = {};

    public myTableAdapter() {
       rows = new Vector();
       recordCount=0;
         }


// update the table using externally queried and processed data
    public void reTable(Vector theData) {
         if(theData.size()>0) {
           Vector colNames = (Vector)theData.elementAt(0); // first line should be column names
           int numberOfColumns = colNames.size();
           columnNames = new String[numberOfColumns];

           for(int column = 0; column < numberOfColumns; column++) {
             columnNames[column] = (String)colNames.elementAt(column);
             }
  
           theData.removeElementAt(0);
         }
         rows = theData;
         recordCount= (theData.size()>=0) ? theData.size() : 0;

         fireTableChanged(null); // Tell the listeners a new table has arrived.


      return ;
    }


    //  Now the Implementation of the TableModel Interface
   
    public String getColumnName(int column) {
        if (columnNames[column] != null) {
            return columnNames[column];
        } else {
            return "";
        }
    }

    public Class getColumnClass(int column) {
            return getValueAt(0, column).getClass();
   }

    public boolean isCellEditable(int row, int column) {
            return false;
 
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    // Data methods

    public int getRowCount() {
        return rows.size();
    }

    public Object getValueAt(int aRow, int aColumn) {
        Vector row = (Vector)rows.elementAt(aRow);
        return row.elementAt(aColumn);
    }


    public void setValueAt(Object value, int row, int column) {
        Vector dataRow = (Vector)rows.elementAt(row);
        dataRow.setElementAt(value, column);

    }

    public void printTableData() {
            int numRows = getRowCount();
            int numCols = getColumnCount();

            for (int i=0; i < numRows; i++) {
                System.out.print("    row " + i + ":");
                Vector theRow = (Vector)rows.elementAt(i);
                for (int j=0; j < numCols; j++) {
                    System.out.print("  " + theRow.elementAt(j));
                    }
                System.out.println();
                }
            System.out.println("--------------------------");
        }

public void writeTXT(java.io.File file) {
// write a spreadhseet file as text with semicolon as a delimiter
     try {
          java.io.FileWriter fw = new java.io.FileWriter(file);
          java.io.BufferedWriter out = new java.io.BufferedWriter(fw);

          int numRows = getRowCount();
          int numCols = getColumnCount();
          String line="";
          for(int i=0;i<numCols;i++) {
                             String title = getColumnName(i);
                             line += (i==0) ? getColumnName(i) : ";"+getColumnName(i);
                             }
          out.write(line,0,line.length());
          out.newLine();
                         
          for (int i=0; i < numRows; i++) {
              line="";
	      for (int j=0; j < numCols; j++) {
              
                     Object object = getValueAt(i,j);
                     String content = (object==null) ? "" : object.toString();
                     line += (j==0) ? content : ";"+content;                              
                     }
               out.write(line,0,line.length());
               out.newLine();
               }
          out.close();
          System.out.println("Saved file semicolon-delimited text file "+file.getAbsolutePath());
      } catch(Exception e) {System.out.println("Error creating file "+file.getAbsolutePath()+" : "+e.toString());}
  }




}
