package guiUtilities;
import javax.swing.*;
import java.awt.event.*;
import java.awt.*;
import java.io.*;
import javax.swing.border.Border;
import java.util.Vector;
import Preferences.PreferencesInterface;

public class RawDataViewer extends JFrame 
                            implements ActionListener {

    private static RawDataViewer instance = new RawDataViewer();
    JTextArea theTextArea;
    JButton saveDataButton;
    JLabel title;

    Vector theRawData;
    JComboBox fileNameMenu; 
    int current = 0;


    public RawDataViewer() {
        super("Data Viewer");
	JPanel pane = new JPanel();
        Border paneEdge = BorderFactory.createEmptyBorder(0,10,10,10);
        pane.setBorder(paneEdge);


        JScrollPane scrollPane;
        this.theRawData=theRawData;

        //A label for the caption.

        title = new JLabel("The title of this Data");
	title.setFont(new Font("SansSerif",Font.BOLD,16));
        title.setForeground(Color.blue);

        JPanel filenamePane = new JPanel();
        filenamePane.setLayout(new BoxLayout(filenamePane,BoxLayout.X_AXIS));
        fileNameMenu = new JComboBox();
        fileNameMenu.addItem("None yet");
        fileNameMenu.setFont(new Font("SansSerif",Font.PLAIN,12));
        fileNameMenu.addActionListener(this);
        fileNameMenu.setActionCommand("menuChange");
        filenamePane.add(Box.createHorizontalGlue());
        JLabel fname =new JLabel("Filename:");
        fname.setFont(new Font("SansSerif",Font.PLAIN,12));
        fname.setForeground(Color.blue);
        filenamePane.add(fname);
        filenamePane.add(fileNameMenu);
        filenamePane.add(Box.createHorizontalGlue());

        //A label for displaying the photographs.

        theTextArea = new JTextArea(60,40);
        theTextArea.setEditable(false);
        scrollPane = new JScrollPane(theTextArea);
        scrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);


        scrollPane.setPreferredSize(new Dimension(400,300));



        //Create the next and previous buttons.


         pane.setLayout(new BoxLayout(pane,BoxLayout.Y_AXIS));

        pane.add(Box.createRigidArea(new Dimension(0,20)));
        title.setAlignmentX(CENTER_ALIGNMENT);
        pane.add(title);
        pane.add(filenamePane);
        pane.add(scrollPane); 
        saveDataButton = new JButton("Save to File");
        saveDataButton.setActionCommand("save");
        saveDataButton.addActionListener(this);
        saveDataButton.setAlignmentX(CENTER_ALIGNMENT);
        pane.add(saveDataButton);

        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane,BoxLayout.X_AXIS));
        buttonPane.add(Box.createHorizontalGlue());
        buttonPane.add(saveDataButton);
  //      buttonPane.add(Box.createRigidArea(new Dimension(20,0)));
  //      buttonPane.add(nextButton);
        buttonPane.add(Box.createHorizontalGlue());
        pane.add(buttonPane);
 //       pane.setPreferredSize(new Dimension(200,200));
	  setContentPane(pane);
        pack();
    }

    public static RawDataViewer getInstance() {
        return instance;
    }


    public void actionPerformed(ActionEvent e) {

       if (e.getActionCommand().equals("save")) {

                 String fname = (String)fileNameMenu.getSelectedItem();
                 File preferredDir = new File(PreferencesInterface.getInstance().getPreference(PreferencesInterface.SCRATCH_DIR));
                 File theFile = new File(preferredDir,fname);
                 JFileChooser fc = new JFileChooser(preferredDir);

                   fc.setSelectedFile(theFile);
                   int returnVal = fc.showSaveDialog(RawDataViewer.this);

                   if (returnVal == JFileChooser.APPROVE_OPTION) {
                      File file = fc.getSelectedFile();     // ******************************************************************************************************************



                      try {
                          FileWriter fw = new FileWriter(file);
                          BufferedWriter out = new BufferedWriter(fw);
                          String rawDataList = theTextArea.getText();
                          out.write(rawDataList,0,rawDataList.length());
                          out.close();
                          System.out.println("Raw data file saved ok as "+file.getAbsolutePath());
                          } catch(IOException ioe) {System.out.println("Error creating file "+file.getAbsolutePath());}
       
                      }
             }
       else { // filename menu has changed... update textpane with string
             int nitem = fileNameMenu.getSelectedIndex();
             if(nitem>=0) theTextArea.setText((String)theRawData.elementAt(2*nitem + 1));
             }
       
        }
  public void showNewData(Vector theRawData, String theTitle) {
       this.theRawData=theRawData;
       fileNameMenu.removeAllItems();
       for(int i=0;i<theRawData.size();i++) {
           if(i%2==0) fileNameMenu.addItem((String)theRawData.elementAt(i));
           }
        theTextArea.setText((String)theRawData.elementAt(1));
        title.setText(theTitle);
        pack();
        setVisible(true);
        }
}
