package guiUtilities;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.net.URL;
import java.util.Vector;
import java.util.StringTokenizer;
import java.io.File;

import ProdDatabase.*;

public class ImageViewer extends JFrame 
                            implements ActionListener {
    Vector pictures;

    JButton previousButton;
    JButton nextButton;
    JButton saveButton;
    JLabel photographLabel;
    JLabel captionLabel;
    JLabel numberLabel;
    int current = 0;


    public ImageViewer() {
        super("Image Viewer");
	  JPanel pane = new JPanel();

        pictures = new Vector();

        //A label to identify XX of XX.
        numberLabel = new JLabel("Picture " + (current+1) +
                                 " of 0");
        numberLabel.setHorizontalAlignment(JLabel.LEFT);
        numberLabel.setFont(new Font("SansSerif",Font.BOLD,12));
        numberLabel.setForeground(Color.blue);

       numberLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 5));

        //A label for the caption.

 //       final Photo first = (Photo)pictures.firstElement();
        captionLabel = new JLabel("First caption");
	  captionLabel.setFont(new Font("SansSerif",Font.BOLD,18));
        captionLabel.setForeground(Color.blue);

        captionLabel.setHorizontalAlignment(JLabel.CENTER);
        captionLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));

        //A label for displaying the photographs.

        photographLabel = new JLabel("Loading first image...");
        photographLabel.setHorizontalAlignment(JLabel.CENTER);
        photographLabel.setVerticalAlignment(JLabel.CENTER);
        photographLabel.setVerticalTextPosition(JLabel.CENTER);
        photographLabel.setHorizontalTextPosition(JLabel.CENTER);
        photographLabel.setBorder(BorderFactory.createCompoundBorder(
                        BorderFactory.createLoweredBevelBorder(),
                        BorderFactory.createEmptyBorder(5, 5, 5, 5)
        ));
        photographLabel.setBorder(BorderFactory.createCompoundBorder(
                        BorderFactory.createEmptyBorder(0, 0, 10, 0),
                        photographLabel.getBorder()
        ));

        //Create the next and previous buttons.


        previousButton = new JButton("Previous");
 
        previousButton.setActionCommand("previous");
        previousButton.addActionListener(this);
        previousButton.setEnabled(false);


        nextButton = new JButton("Next");
        nextButton.setActionCommand("next");
        nextButton.addActionListener(this);

        saveButton = new JButton("Save Image");
        saveButton.setActionCommand("save");
        saveButton.addActionListener(this);


         pane.setLayout(new BoxLayout(pane,BoxLayout.Y_AXIS));


        captionLabel.setAlignmentX(CENTER_ALIGNMENT);
        pane.add(captionLabel); 
        numberLabel.setAlignmentX(CENTER_ALIGNMENT);
        pane.add(numberLabel);
        photographLabel.setAlignmentX(CENTER_ALIGNMENT);
        pane.add(photographLabel); 
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane,BoxLayout.X_AXIS));
        buttonPane.add(previousButton);
        buttonPane.add(Box.createRigidArea(new Dimension(20,0)));
        buttonPane.add(nextButton);
        buttonPane.add(Box.createHorizontalGlue());
        buttonPane.add(saveButton);
        pane.add(buttonPane);
	  setContentPane(pane);

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });
    }


    private void closeDialog(java.awt.event.WindowEvent evt) {
        setVisible(false);
        dispose();
    }   
    //User clicked either the next or the previous button.
    public void actionPerformed(ActionEvent e) {
        //Show loading message.

        //Compute index of photograph to view.
        if (e.getActionCommand().equals("next")) {
            current += 1;
            if (!previousButton.isEnabled()) previousButton.setEnabled(true);
            if (current == pictures.size() - 1) nextButton.setEnabled(false);
            updatePhotograph();
        } else if(e.getActionCommand().equals("previous")) {
            current -= 1;
            if (!nextButton.isEnabled()) nextButton.setEnabled(true);
            if (current == 0) previousButton.setEnabled(false);
            updatePhotograph();
        } else {
           Photo pic = (Photo)pictures.elementAt(current);
           File imageFile;
           imageFile = new File(Preferences.PreferencesInterface.getInstance().getPreference(Preferences.PreferencesInterface.SCRATCH_DIR),pic.name);
           try {
               GeneralUtilities.saveImage(pic.testno,pic.name,imageFile);
               JOptionPane.showMessageDialog(null,"Image saved as "+imageFile.toString(),"Image saved",JOptionPane.INFORMATION_MESSAGE);
                } catch(Exception e1) {System.out.println("Exception saving image: "+e1.toString());};
             }



    }

    //Must be invoked from the event-dispatching thread.
    private void updatePhotograph() {
        Photo pic = (Photo)pictures.elementAt(current);

        //Update the caption and number labels.
        captionLabel.setText(pic.headerTitle);
        numberLabel.setText("Picture " + (current+1) +
                            " of " + pictures.size() + ": "+pic.caption);

        //Update the photograph.
        ImageIcon icon = pic.getIcon();

        photographLabel.setToolTipText(pic.caption + ": " +
                                       icon.getIconWidth() + " X " +
                                       icon.getIconHeight());
        if(icon!=null) {
          photographLabel.setIcon(icon);
          photographLabel.setText("");
        }
        else {
          photographLabel.setIcon(null);
          photographLabel.setText("Image not available - data corrupted.");
        }
    }
     public void showNewPhotos(Vector listOfImages) {
        pictures = listOfImages;
        int widthOfWidest = 0;
        int heightOfTallest = 0;

        for(int i=0;i<pictures.size();i++) {
          ImageIcon tempIcon = ((Photo)pictures.elementAt(i)).getIcon();
          int iwidth = tempIcon.getIconWidth();
          int iheight = tempIcon.getIconHeight();
          if(iwidth>widthOfWidest) widthOfWidest = iwidth;
          if(iheight>heightOfTallest) heightOfTallest = iheight; 
          }
        Insets i = photographLabel.getInsets();
        photographLabel.setPreferredSize(new Dimension(
                            widthOfWidest+i.left+i.right,
                            heightOfTallest+i.bottom+i.top));
        current=0;
        previousButton.setEnabled(false);
        if(pictures.size()>1) nextButton.setEnabled(true);
        else nextButton.setEnabled(false);
        updatePhotograph();
        pack();
        setVisible(true);
        }


}
