package guiUtilities;
/*
 * A simple html viewer.
 * @author robinson
 */
import javax.swing.*;
import javax.swing.border.*;
import java.awt.*;
import java.awt.event.*;
import java.net.URL;
import javax.swing.event.*;
import java.util.Vector;
import java.util.StringTokenizer;
import java.util.regex.*;
import java.io.*;

public class HTMLViewer extends JFrame implements HyperlinkListener {
     private static HTMLViewer instance = new HTMLViewer();
     JLabel title;
     JScrollPane scrollPane;
     JEditorPane editorPane;
     JLabel linkText;
     JButton refreshButton,closeButton, backButton,forwardButton;
     Vector htmlFileList,captionList,imageFileList;
     int htmlIndex;
     int htmlCount;
     JMenu captionMenu;

     String captionString, htmlString;

     public static final int DATASHEET=0;
     public static final int WEBLINK=1;
     public static final int XYMETDATA=2;
     public static final int ZMETDATA=3;
     public static final int SENSORTESTDATA=4;
     public static final int SCTDAQTESTDATA=5;
     public static final int URLTOPOSTSCRIPT=6;
     public static final int RAWDATA=7;
     public static final int SCTDAQTESTLIST=8;
     public static final int MODULESUMMARY=9;
     public static final int SCTDBIMAGE=10;

    private HTMLViewer() {
	super("Report");
        htmlIndex=0;
        htmlCount=0;
        initComponents();
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                close();
            }
        });
        htmlFileList = new Vector();
        captionList = new Vector();
        imageFileList = new Vector();
        captionMenu = new JMenu();
        }
    public static HTMLViewer getInstance() {
        return instance;
    }

     public void close() {
        // delete all saved html files ...
        for(int i=0;i<htmlFileList.size();i++) {
                   File thisFile = new File((String)htmlFileList.elementAt(i));
                   if(thisFile.exists()) {
                           System.out.println("Deleting "+thisFile.getAbsolutePath());
                           thisFile.delete();
                           }
                   }
        synchronized(imageFileList) {
          for(int i=0;i<imageFileList.size();i++) {
                   File thisFile = new File((String)imageFileList.elementAt(i));
                   if(thisFile.exists()) {
                           System.out.println("Deleting "+thisFile.getAbsolutePath());
                           thisFile.delete();
                           }
                   }
           }
     }
        

       private void initComponents() {
        editorPane = new JEditorPane();
        editorPane.setEditable(false);
        editorPane.addHyperlinkListener(this);
        editorPane.addMouseListener(new htmlViewerMouseAdapter());

        scrollPane = new JScrollPane(editorPane);
        scrollPane.setVerticalScrollBarPolicy(
                        JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
        scrollPane.setHorizontalScrollBarPolicy(
                        JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);

        scrollPane.setPreferredSize(new Dimension(850, 400));
        scrollPane.setMinimumSize(new Dimension(650, 400));

       java.awt.GridBagConstraints gridBagConstraints;

        title = new javax.swing.JLabel();
        linkText = new javax.swing.JLabel();
        refreshButton = new javax.swing.JButton();
        refreshButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                refreshButtonActionPerformed(evt);
            }
        });
        closeButton = new javax.swing.JButton();
        closeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                closeButtonActionPerformed(evt);
            }
        });
        backButton = new javax.swing.JButton();
        backButton.setEnabled(false);
        backButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                backButtonActionPerformed(evt);
            }
        });
        forwardButton = new javax.swing.JButton();
        forwardButton.setEnabled(false);
        forwardButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                forwardButtonActionPerformed(evt);
            }
        });

        getContentPane().setLayout(new java.awt.GridBagLayout());
        title.setText("Caption to this report");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weighty = 0.1;
        getContentPane().add(title, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 0.8;
        getContentPane().add(scrollPane, gridBagConstraints);

        linkText.setText("Link:");
        linkText.setFont(new java.awt.Font("Arial", 1, 10));
        linkText.setForeground(new java.awt.Color(0, 0, 153));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weighty = 0.05;
        getContentPane().add(linkText, gridBagConstraints);

        refreshButton.setText("Refresh");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 0.25;
        gridBagConstraints.weighty = 0.05;
        getContentPane().add(refreshButton, gridBagConstraints);

        backButton.setText(" < ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.weightx = 0.25;
        getContentPane().add(backButton, gridBagConstraints);

        forwardButton.setText(" > ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 0.25;
        getContentPane().add(forwardButton, gridBagConstraints);

        closeButton.setText("Close");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.weightx = 0.25;
        getContentPane().add(closeButton, gridBagConstraints);

        pack();
        }

//*********************************************************************************
       public synchronized void show(String theHTML,String theCaption) {
          captionString=theCaption;
          htmlString=theHTML;
       javax.swing.SwingUtilities.invokeLater(new Runnable() { // force to run in event dispatching thread
                                                               // as this may be invoked from SCTDB downloader thread
          public void run() {

            String s=null;
            URL theURL;

            try {
              if(!htmlString.startsWith("http")) {
                String filename = "testreport_"+Integer.toString(htmlCount)+".html";
                File htmlFile = new File(Preferences.PreferencesInterface.getInstance().getPreference(Preferences.PreferencesInterface.SCRATCH_DIR),filename);
                BufferedWriter out = new BufferedWriter(new FileWriter(htmlFile));
                out.write(htmlString);
                out.close();
                htmlFileList.addElement(htmlFile.getAbsolutePath());
                s = "file:"+htmlFile.getAbsolutePath();
                theURL = new URL(s);
                }
              else {

                htmlIndex = htmlFileList.indexOf(htmlString);
                if(htmlIndex>=0) {
                   showExistingURL();
                   return;
                   }

                theURL = new URL(htmlString);
                htmlFileList.addElement(htmlString); 
                }

                captionList.addElement(captionString);
                htmlIndex = htmlFileList.size()-1;
              
                JMenuItem item = new JMenuItem(captionString);
                item.setFont(new java.awt.Font("Arial",java.awt.Font.PLAIN,10));
                captionMenu.add(item);
                item.addActionListener(new java.awt.event.ActionListener() {
                  public void actionPerformed(java.awt.event.ActionEvent evt) {
                  menuItemSelected(evt);
                    }
                });

              editorPane.setPage(theURL);
              title.setText(captionString);

              setButtonStates();
	      setVisible(true);
              htmlCount++;
            } catch(Exception e) {
                javax.swing.JOptionPane.showMessageDialog(null,"Exception creating URL: "+e.toString());
                }

          }
        });


       }
//********************************************************************************
       public void showExistingURL() {
            String s=(String)htmlFileList.elementAt(htmlIndex);
            URL theURL;
            try {
              if(!s.startsWith("http")) {
                 s = "file:"+s;
                 theURL = new URL(s);
                 }
              else theURL = new URL(s);
              editorPane.setPage(theURL);
              title.setText((String)captionList.elementAt(htmlIndex));

              setButtonStates();
	      setVisible(true);
            } catch(Exception e) {
                javax.swing.JOptionPane.showMessageDialog(null,"Exception creating URL: "+e.toString());
                }
       }

//*******************************************************************************
	public Insets getInsets() {
		return new Insets(20,20,20,20);
		}
        public void hyperlinkUpdate(HyperlinkEvent event) {
             Pattern linkPattern = Pattern.compile("Type(\\d+)&ref=(.*)");
             Pattern htmlLinkPattern = Pattern.compile("(http://.*)");
             String linkName = event.getDescription();
             Matcher matcher = linkPattern.matcher(linkName);
             Matcher matcher3 = htmlLinkPattern.matcher(linkName);
             int index=-1;
             String ref;
             if(matcher.matches()) {
                   index = Integer.parseInt(linkName.substring(matcher.start(1),matcher.end(1)));
                   ref = linkName.substring(matcher.start(2),matcher.end(2));
                   }
             else if(matcher3.matches()) {
                   ref = linkName.substring(matcher3.start(1),matcher3.end(1));
                   index=WEBLINK;
                   }
             else return;

             if(event.getEventType()==HyperlinkEvent.EventType.ACTIVATED) {

                   ProdDatabase.ReportDownloader d;
                   Vector list;
                   switch(index) {    
                     case WEBLINK:
                        if(ref.matches("http://.*html?(#.*)?")) show(ref,ref);
                        else {
                         StringBuffer s = new StringBuffer("<html><head></head><body>");
                         s.append("<img src="+ref+"></body></html>");
                         show(s.toString(),ref);
                         }
                        break;
                     case SENSORTESTDATA:
                        list = new Vector();
                        list.addElement(ref);
                        d = new ProdDatabase.ReportDownloader(SENSORTESTDATA, list);
                        if(d.isOkToStart()) d.start();
                        break;
                     case SCTDAQTESTLIST:
                        d = new ProdDatabase.ReportDownloader(SCTDAQTESTLIST, ref, 0);
                        if(d.isOkToStart()) d.start();
                        break;
                     case SCTDAQTESTDATA:
                        String[] info = ref.split("__");
                        d = new ProdDatabase.ReportDownloader(SCTDAQTESTDATA, info[0], Integer.parseInt(info[1]));
                        if(d.isOkToStart()) d.start();
                        break;
                     case URLTOPOSTSCRIPT:
                        d = new ProdDatabase.ReportDownloader(URLTOPOSTSCRIPT, ref, 0);
                        if(d.isOkToStart()) d.start();
                        break;
                     case SCTDBIMAGE:
                        Pattern imagePattern = Pattern.compile("(\\d+)(.*)");
                        Matcher matcher2 = imagePattern.matcher(ref);
                        if(!matcher2.matches()) {
                           System.err.println("Urecognised image info: "+ref);
                           return;
                           }
                        String testno = ref.substring(matcher2.start(1),matcher2.end(1));
                        String title = ref.substring(matcher2.start(2),matcher2.end(2));
                        try {
                          Vector pics = ProdDatabase.GeneralUtilities.getImages(testno,title);
                          if(pics.size()>0) {
                               guiUtilities.ImageViewer imageViewer = new guiUtilities.ImageViewer();
                               imageViewer.showNewPhotos(pics);
                               }
                        else System.out.println("No test images available for this test.");
                        }catch(Exception e){System.err.println("HTMLViewer::hyperlinkUpdate: Exception downloading test images: "+e.toString());}
                        break;
                     case XYMETDATA:
                        try {
                        ProdDatabase.SCTDBTestInfoHolder testInfo = ProdDatabase.GeneralUtilities.getTestInfo(ref);
                        if(testInfo==null) return;
                        String cType = testInfo.get(ProdDatabase.SCTDBTestInfoHolder.CTYPE);
                        if(cType.indexOf("bmModule")!=-1) {
                          Vector tableContents = ProdDatabase.BarrelUtilities.getXYMetrologyData(ref);
                          Vector tData = (Vector)tableContents.elementAt(2);
                          if(tData.size()>0) guiUtilities.SpreadsheetViewer.getInstance().update("XY metrology data for "+testInfo.get(ProdDatabase.SCTDBTestInfoHolder.SN)+" taken at "+testInfo.get(ProdDatabase.SCTDBTestInfoHolder.LOCATION)+" on "+testInfo.get(ProdDatabase.SCTDBTestInfoHolder.DATE),tData);       
                          }
                        else {
                          Vector tableContents = ProdDatabase.EndCapUtilities.getXYMetrologyData(ref);
                          if(tableContents.size()>0) guiUtilities.SpreadsheetViewer.getInstance().update("XY metrology data for "+testInfo.get(ProdDatabase.SCTDBTestInfoHolder.SN)+" taken at "+testInfo.get(ProdDatabase.SCTDBTestInfoHolder.LOCATION)+" on "+testInfo.get(ProdDatabase.SCTDBTestInfoHolder.DATE),tableContents);   
                          }

                        }catch(Exception e){System.err.println("HTMLViewer::hyperlinkUpdate: Exception viewing XYmetrology "+e.toString());}

                        break;
                     case ZMETDATA:
                        try {
                        ProdDatabase.SCTDBTestInfoHolder testInfo = ProdDatabase.GeneralUtilities.getTestInfo(ref);
                        if(testInfo==null) return;
                        String cType = testInfo.get(ProdDatabase.SCTDBTestInfoHolder.CTYPE);
                        if(cType.indexOf("bmModule")!=-1) {
                          Vector tableContents = ProdDatabase.BarrelUtilities.getZMetrologyData(ref);
                          Vector tData = (Vector)tableContents.elementAt(2);
                          if(tData.size()>0) guiUtilities.SpreadsheetViewer.getInstance().update("Z metrology data for "+testInfo.get(ProdDatabase.SCTDBTestInfoHolder.SN)+" taken at "+testInfo.get(ProdDatabase.SCTDBTestInfoHolder.LOCATION)+" on "+testInfo.get(ProdDatabase.SCTDBTestInfoHolder.DATE),tData);
                          }
                        else {
                          Vector tableContents = ProdDatabase.EndCapUtilities.getZMetrologyData(ref);
                          if(tableContents.size()>0) guiUtilities.SpreadsheetViewer.getInstance().update("Z metrology data for "+testInfo.get(ProdDatabase.SCTDBTestInfoHolder.SN)+" taken at "+testInfo.get(ProdDatabase.SCTDBTestInfoHolder.LOCATION)+" on "+testInfo.get(ProdDatabase.SCTDBTestInfoHolder.DATE),tableContents);   
                          }
                        }catch(Exception e){System.err.println("HTMLViewer::hyperlinkUpdate: Exception viewing Zmetrology "+e.toString());}

                        break;
                       
                     case RAWDATA:
                     case DATASHEET:
                        d = new ProdDatabase.ReportDownloader(RAWDATA, ref, 0);
                        if(d.isOkToStart()) d.start();
                        break;
                     default:
                     
                    }         
             }
             else if(event.getEventType()==HyperlinkEvent.EventType.ENTERED) {

                   switch(index) {
                     case DATASHEET:
                         linkText.setText("Link: Data sheet for "+ref);
                          break;
                     case XYMETDATA:
                         linkText.setText("Link: XY metrology datasheet");
                          break;
                     case ZMETDATA:
                         linkText.setText("Link: Z metrology datasheet");
                          break;
                     case WEBLINK:
                     case URLTOPOSTSCRIPT:
                         linkText.setText("Link: "+ref);
                          break;
                     case SCTDBIMAGE:
                         linkText.setText("Link: View plots");
                          break;
                     case SENSORTESTDATA:
                         linkText.setText("Link: Sensor test data for "+ref);
                          break;
                     case SCTDAQTESTLIST:
                         linkText.setText("Link: Report of all SCTDAQ tests");
                          break;
                     case SCTDAQTESTDATA:
                         linkText.setText("Link: Full SCTDAQ test report");
                          break;
                     case RAWDATA:
                         linkText.setText("Link: Raw Data for SCTDB test no "+ref);
                          break;
                     default:
                         linkText.setText("Link: unrecognised");
                     }

             }
             else if(event.getEventType()==HyperlinkEvent.EventType.EXITED) {
                linkText.setText("Link:");
             }
        }
//******************************************************************************
   private void refreshButtonActionPerformed(java.awt.event.ActionEvent evt) {
       try {
         String currentHTMLFile=(String)htmlFileList.elementAt(htmlIndex);
         Pattern filePattern = Pattern.compile("(.*testreport_)\\d+\\.html");
         Matcher matcher = filePattern.matcher(currentHTMLFile);
         if(matcher.matches()) {
                     String newFile = currentHTMLFile.substring(matcher.start(1),matcher.end(1))+Integer.toString(htmlCount)+".html";
                     DaveUtils.copyFile(currentHTMLFile,newFile);
                     (new File(currentHTMLFile)).delete();
                     htmlFileList.setElementAt(newFile,htmlIndex);
                     htmlCount++;
                     }
        showExistingURL();
       }catch(Exception e){System.err.println(e.toString());}
    }

   private void closeButtonActionPerformed(java.awt.event.ActionEvent evt) {
        setVisible(false);
        }
   private void forwardButtonActionPerformed(java.awt.event.ActionEvent evt) {
        htmlIndex++;
        showExistingURL();
        }
   private void backButtonActionPerformed(java.awt.event.ActionEvent evt) {
        htmlIndex--;
        showExistingURL();
        }

   private void setButtonStates() {
       forwardButton.setEnabled(htmlIndex<htmlFileList.size()-1);
       backButton.setEnabled(htmlIndex>0);
       }
   private void printState() {
       System.out.println("htmlIndex="+htmlIndex+", #="+htmlFileList.size());
       for(int i=0;i<htmlFileList.size();i++) {
          System.out.println("Caption: "+(String)captionList.elementAt(i)+" URL: "+(String)htmlFileList.elementAt(i));
          }
       }


    class htmlViewerMouseAdapter extends java.awt.event.MouseAdapter {
            public void mouseClicked(java.awt.event.MouseEvent e) {
               switch(e.getModifiers()) {
                 case java.awt.event.InputEvent.BUTTON2_MASK:
                 case java.awt.event.InputEvent.BUTTON3_MASK:
                     JPopupMenu pMenu = captionMenu.getPopupMenu();
                     pMenu.show(e.getComponent(),e.getX(),e.getY());
                     pMenu.setInvoker(captionMenu);
                 break;
                 default:
                 }
            }
    }

  public void menuItemSelected(ActionEvent e) {
         JMenuItem source = (JMenuItem)e.getSource();
         String selectedCaption = source.getText();
         for(int i=0;i<captionList.size();i++) {
            if(((String)captionList.elementAt(i)).equals(selectedCaption)) {
              htmlIndex=i;
              showExistingURL();
              break;
              }
            }
 
 
       }
  public void addImageFile(String imageFile) {
        synchronized(imageFileList) {
                imageFileList.addElement(imageFile);
          }
 
      }
}

   

 




