package guiUtilities;
import  java.io.*;
import java.util.*;
import java.util.regex.*;

public class DaveUtils {
       

	public static String padString(String theString, int theLength) {
	int i, numberOfPads, reqLength;
	reqLength = theLength;
	if(reqLength < 0) reqLength *= -1;
	if(theString.length() >= reqLength) return theString;
	StringBuffer newString = new StringBuffer(theString);
	numberOfPads = reqLength - theString.length();
	if(theLength > 0) {
		for(i=0;i<numberOfPads;i++) newString.insert(0," ");
		}
	else {
		for(i=0;i<numberOfPads;i++) newString.append(" ");
		}
	return newString.toString();
	}
	public static String padString(String theString, int theLength, char c) {
	int i, numberOfPads, reqLength;
	reqLength = theLength;
	if(reqLength < 0) reqLength *= -1;
	if(theString.length() >= reqLength) return theString;
	StringBuffer newString = new StringBuffer(theString);
	numberOfPads = reqLength - theString.length();
	if(theLength > 0) {
		for(i=0;i<numberOfPads;i++) newString.insert(0,c);
		}
	else {
		for(i=0;i<numberOfPads;i++) newString.append(c);
		}
	return newString.toString();
	}

	public static void copyFile(String fileName, String targetFileName) throws IOException {
		String lineString;

			FileReader fr = new FileReader(fileName);
			FileWriter fw = new FileWriter(targetFileName);
			BufferedReader in = new BufferedReader(fr);
			BufferedWriter out = new BufferedWriter(fw);
			while( (lineString = in.readLine()) != null) {
				out.write(lineString,0,lineString.length());
				out.newLine();
				}
			in.close();
			out.close();
		}
    public static String extractDate(String dbDate) {
       String[] monthnames = {"JAN","FEB","MAR","APR","MAY","JUN","JUL","AUG","SEP","OCT","NOV","DEC"};
       int theMonth=0;
       if(dbDate.length() < 12) return dbDate;
       String day = dbDate.substring(8,10);
       String month = dbDate.substring(5,7);
       try {
         theMonth = Integer.parseInt(month);
        }
       catch (Exception e) {theMonth=1;System.out.println("Cant extract monthname!!");}
       String year = dbDate.substring(2,4);
       month = (theMonth>0 && theMonth<13) ? monthnames[theMonth-1] : "???"; 
       return day+"-"+month+"-"+year;
       }

    public static String extractSCTDAQDate(String dbDate) {
       String[] monthnames = {"01","02","03","04","05","06","07","08","09","10","11","12"};
       int theMonth=0;
       if(dbDate.length() < 12) return dbDate;
       String day = dbDate.substring(8,10);
       String month = dbDate.substring(5,7);
       try {
         theMonth = Integer.parseInt(month);
        }
       catch (Exception e) {theMonth=0;System.out.println("Cant extract monthname!!");}
       String year = dbDate.substring(0,4);
       month = (theMonth>0 && theMonth<13) ? monthnames[theMonth-1] : "???"; 
       return day+"/"+month+"/"+year;
       }


public static void writeTXT(File file,javax.swing.table.AbstractTableModel db) {
// write a spreadhseet file as text with semicolon as a delimiter
     try {
          FileWriter fw = new FileWriter(file);
          BufferedWriter out = new BufferedWriter(fw);

          int numRows = db.getRowCount();
          int numCols = db.getColumnCount();
          String line="";
          for(int i=0;i<numCols;i++) {
                             String title = db.getColumnName(i);
                             line += (i==0) ? db.getColumnName(i) : "\t"+db.getColumnName(i);
                             }
          out.write(line,0,line.length());
          out.newLine();
                         
          for (int i=0; i < numRows; i++) {
              line="";
	      for (int j=0; j < numCols; j++) {
              
//                             Vector theRow = (Vector)db.rows.elementAt(i);
                     String content = (String)db.getValueAt(i,j);
                     line += (j==0) ? content : "\t"+content;                              
                     }
               out.write(line,0,line.length());
               out.newLine();
               }
          out.close();
          System.out.println("Saved file tab-delimited text file "+file.getAbsolutePath());
      } catch(IOException e) {System.out.println("Error creating file "+file.getAbsolutePath());}
  }
   public static double getCorrectedCurrent(double uncorrectedCurrent, double temperature) {

            double tk = temperature+273.;
// get correction factor for conversion to 20C
            double theExponent = -7019.*(temperature-20.0)/293./tk;
            double corrFactor = Math.exp(theExponent)*(293./tk)*(293./tk);
            return uncorrectedCurrent*corrFactor;
            }

public static String getStyleSheet2() {
 StringBuffer sheet = new StringBuffer();
 sheet.append("<STYLE TYPE=\"text/css\">\n");
 sheet.append("<!--\n");
 sheet.append("p {font-family: Geneva,Arial,sans-serif; font-size: 10pt }\n");
 sheet.append("ul {font-family: Geneva,Arial,sans-serif; font-size: 10pt }\n");
 sheet.append("li {font-family: Geneva,Arial,sans-serif; font-size: 10pt }\n");
 sheet.append("dd {font-family: Geneva,Arial,sans-serif; font-size: 10pt }\n");
 sheet.append("table {font-family: Geneva,Arial,sans-serif; font-size: 10pt }\n");
 sheet.append("td {font-family: Geneva,Arial,sans-serif; font-size: 10pt }\n");
 sheet.append("td.bold {font-family: Geneva,Arial,sans-serif; font-size: 10pt; font-weight: bold }\n");
 sheet.append("h1 {font-family: Arial, sans-serif; font-size: 16pt ; color: navy }\n");
 sheet.append("h2 {font-family: Arial, sans-serif; font-size: 14pt ; color: navy }\n");
 sheet.append("h3 {font-family: Arial, sans-serif; font-size: 12pt ; color: navy }\n");
 sheet.append("b {font-family: Arial, sans-serif; font-size: 10pt; font-weight: bold}\n");
 sheet.append(".bold {font-weight: bold}\n");
 sheet.append(".boldred {font-weight: bold; color: red }\n");
 sheet.append(".boldgreen {font-weight: bold; color: green}\n");
 sheet.append(".boldpurple {font-weight: bold; color: purple }\n");
 sheet.append("-->\n");
 sheet.append("</STYLE>\n");
 return sheet.toString();
}
public static String getStyleSheet() {
 StringBuffer sheet = new StringBuffer();
 sheet.append("<STYLE TYPE=\"text/css\">\n");
 sheet.append("<!--\n");
 sheet.append("FONT		{FONT-FAMILY: Tahoma, Verdana, Helvetica; FONT-SIZE: 10pt}\n");
 sheet.append("TD		{FONT-FAMILY: Tahoma, Verdana, Helvetica; FONT-SIZE: 10pt}\n");
 sheet.append("BODY		{FONT-FAMILY: Tahoma, Verdana, Helvetica; FONT-SIZE: 10pt}\n");
 sheet.append("P		{FONT-FAMILY: Tahoma, Verdana, Helvetica; FONT-SIZE: 10pt}\n");
 sheet.append("DIV		{FONT-FAMILY: Tahoma, VerdanaHelvetica; FONT-SIZE: 10pt}\n");
 sheet.append("INPUT		{FONT-FAMILY: Tahoma, Verdana, Helvetica; FONT-SIZE: 10pt}\n");
 sheet.append("TEXTAREA	{FONT-FAMILY: Tahoma, Verdana, Helvetica; FONT-SIZE: 10pt}\n");
 sheet.append("FORM 		{FONT-FAMILY: Tahoma, Verdana, Helvetica; FONT-SIZE: 10pt}\n");
 sheet.append("SELECT		{FONT-FAMILY: Tahoma, Verdana, Helvetica; FONT-SIZE: 10pt}\n");
 sheet.append("A:link          {BACKGROUND: none; COLOR: #215DC6; FONT-SIZE: 10pt; FONT-FAMILY: Tahoma, Verdana, Helvetica; TEXT-DECORATION: none}\n");
 sheet.append("A:active        {BACKGROUND: none; COLOR: #215DC6; FONT-SIZE: 10pt; FONT-FAMILY: Tahoma, Verdana, Helvetica; TEXT-DECORATION: underline}\n");
 sheet.append("A:visited       {BACKGROUND: none; COLOR: #215DC6; FONT-SIZE: 10pt; FONT-FAMILY: Tahoma, Verdana, Helvetica; TEXT-DECORATION: none}\n");
 sheet.append("A:hover         {BACKGROUND: #215DC6; COLOR: #FFFFFF; FONT-SIZE: 10pt; FONT-FAMILY: Tahoma, Verdana, Helvetica; TEXT-DECORATION: none}\n");
 sheet.append("-->\n");
 sheet.append("</STYLE>\n");
 return sheet.toString();
}
 public static String getHTMLHeader(String title) {
     StringBuffer html = new StringBuffer("<html><head>");
     html.append(guiUtilities.DaveUtils.getStyleSheet());
     html.append("<title>title</title>");
     html.append("</head><body>\n");
     html.append("<h2>"+title+"</h2>\n");
     return html.toString();
     }
 public static String getHTMLFooter() {
     return "</body></html>";
     }

  public static String getTodaysDate() {
	int number;
	Date today = new Date();
	java.text.DateFormat formatter = java.text.DateFormat.getDateInstance(java.text.DateFormat.SHORT,new Locale("en","GB"));
	String dateString = formatter.format(today);
        Pattern datePattern = Pattern.compile("(\\d+/\\d+/)(\\d+)");
        Matcher matcher = datePattern.matcher(dateString);
        if(matcher.matches()) dateString = dateString.substring(matcher.start(1),matcher.end(1))+"20"+dateString.substring(matcher.start(2),matcher.end(2));
        System.out.println("todays date is "+dateString);
        return dateString;
	}

  public static String getCurrentTime() {
        try {
	  Date today = new Date();
          java.text.DateFormat formatter = java.text.DateFormat.getTimeInstance(java.text.DateFormat.DEFAULT,new Locale("en","GB"));
	  return formatter.format(today);
          }catch(Exception e){}
        return "Unknown";
	}
 

}

