package SummaryReader;

public class TestInfo {

   String runNo;
   String scanNo;
   String testName;
   String passed;
   String problem;
   Double status =null;

   public TestInfo() {
      }

   public void setRunNo(String runNo) {
      this.runNo=runNo;
      }
   public void setScanNo(String scanNo) {
      this.scanNo=scanNo;
      }
   public String getScanNo() {
      return scanNo;
      }
   public void setName(String name) {
      this.testName=name;
      }
   public void setPassed(String flag) {
       this.passed=flag;
      }
   public void setProblem(String flag) {
       this.problem=flag;
      }
   public String getName() {
       return testName;
       }
   public void setStatus(Double status) {
       this.status=status;
       }
   public Double getTestStatusData() {
       if(status!=null) return status;
       if(passed==null || problem==null) return null;
       double statusData= (passed.equals("YES")) ? 0. : 2.;
       if(statusData==0.) {
          if(problem.equals("YES")) statusData=1.;
          }
       return new Double(statusData);
       }

   public String getSummaryTable() {
       StringBuffer table = new StringBuffer("<h3>Test Information</h3>\n");
       table.append("<table border=1>\n");
       table.append("<tr><td>Test</td><td>Run No</td><td>First ScanNo</td><td>Passed?</td><td>Problem?</td></tr>\n");
       if(runNo==null) runNo=new String("Unknown");
       if(scanNo==null) scanNo=new String("Unkown");
       if(testName==null) testName = new String("Unknown");
       if(passed==null) passed= new String("Unknown");
       if(problem==null) problem = new String("Unknown");
       table.append("<tr><td>"+testName+"</td><td>"+runNo+"</td><td>"+scanNo+"</td><td>"+passed+"</td><td>"+problem+"</td></tr>\n");
       table.append("</table>\n");
       return table.toString();
       }
}