package SummaryReader;

public class ScanInfo {

   String type;
   String points;
   String[] values;

   public ScanInfo() {
      }

   public void setType(String type) {
      this.type=type;
      }
   public void setPoints(String nPoints) {
       this.points=nPoints;
       try {
         values = new String[Integer.parseInt(nPoints)];
       }catch(Exception e2){values = new String[1];};
      }
   public void setScanPoint(int index, String value) {
       if(values!=null && index<=values.length-1) values[index]=value;
      }

   public String getSummaryTable() {
       if(type==null || type.startsWith("Null")) {
            return "<h3>Scan Information</h3>\nNone available.";
            }
       if(points==null) points="Unknown";
       StringBuffer table = new StringBuffer("<h3>Scan Information</h3>");
       table.append("<table border=1>\n");
       table.append("<tr><td>Type</td><td>#Points</td><td>Values</td></tr>\n");
       table.append("<tr><td>"+type+"</td><td>"+points+"</td><td>");
       for(int i=0;i<values.length;i++) {
           if(values[i]==null) continue;
           if(i>0) {
              if(i%16==0) table.append("<br>");
              else table.append(",");
              }
           table.append(values[i]);
           }
        table.append("</td></tr>");           
       table.append("</table>\n");
       return table.toString();
       }
}