package SummaryReader;
//
// @Author Dave Robinson
//
import java.io.*;
import java.util.*;
import java.util.regex.*;
import java.text.*;

public class Reader implements regExpressions, DisplayGUI.TestDataInfo {


    Matcher matcher;
    Test testObject;
    Vector testObjects;
    int parameterType;
    int testType;
    Map testMapping;
    java.text.DecimalFormat nf = new java.text.DecimalFormat("#.##");

    public Reader(String serialNo,String resultString, DCSInfo dcsInfo) {
            testMapping = getTestMapping();
            getTestInfo(serialNo,resultString, dcsInfo);
            }
//    public Reader(String resultString) {
//            testMapping = getTestMapping();
//            getTestInfo(null,resultString, null);
//            }


    public String getData(int index) {
         return testObject.getData(index);
         }
    public String getData() {
         return testObject.getData(-1);
         }
    public Test getTest() {
         return testObject;
         }



//***************************************************************************8
   public void getTestInfo(String serialNo,String resultString, DCSInfo dcsInfo) {
      boolean[] nextLineIsChipData = {false,false,false,false,false,false,false,false,false,false,false,false};
      boolean loopB=false;
      boolean nextLineIsLink0Data=false;
      boolean nextLineIsLink1Data=false;
      boolean nextLineIsVersion=false;
      boolean nextLineIsTime=false;
      boolean nextLineIsHost=false;
      boolean nextLineIsNoScans=false;
      boolean nextLineIsScanType=false;
      boolean nextLineIsScanPoints=false;
      boolean nextLineIsComment=false;
      boolean nextLineIsData=false;
      boolean nextLineIsT0T1=false;
      boolean nextLineIsVDETIDET=false;
      boolean nextLineIsVCCICC=false;
      boolean nextLineIsVDDIDD=false;

      int scanCount=0;
      int parameterIndex=-1;
      int byPassSection=-1;
      int byPassChipOffset=-1;
      Pattern bocPattern = Pattern.compile("^(\\d+)\\s+(\\d+).*");

      testObject = new Test();
      IVData ivData=null;
      DataBlock dataBlock=null;
      LinkInfo linkInfo=null;
      DAQInfo daqInfo = new DAQInfo();
      TestInfo testInfo = new TestInfo();
      ScanInfo scanInfo = new ScanInfo();
      DefectInfo defectInfo = new DefectInfo();
      int testno=999;

      String[] lines = resultString.split("\\n");      

      for(int i=0;i<lines.length;i++) {
          String line = lines[i];
          if(line.equals("")) continue; // shouldn't be necessary
//          System.out.println(line);

// check for new test
             if(line.matches("^%NewTest")) {
                testObject = new Test();
                continue;
             }

             if(testObject==null) continue;

// first the serial No
             matcher = serialNoPattern.matcher(line);
             if(matcher.matches()) {
                  String thisSerialNo = line.substring(matcher.start(1),matcher.end(1));
                  if(!thisSerialNo.startsWith("CRATE") && !thisSerialNo.equals(serialNo)) System.err.println("Invalid serial in SummaryWriter String");
                  testObject.setSerialNo(serialNo);
                  continue;
                  }

// then the run number and scan number
                 matcher = runPattern.matcher(line);
                 if(matcher.matches()) {
                           String runString = line.substring(matcher.start(1),matcher.end(1));
                           matcher = scanNoPattern.matcher(runString);
                           if(matcher.matches()) {
                                 testInfo.setRunNo(runString.substring(matcher.start(1),matcher.end(1)));
                                 testInfo.setScanNo(runString.substring(matcher.start(2),matcher.end(2)));
                                 }
                           else {
                                 testInfo.setRunNo(runString);
                                 testInfo.setScanNo("None");
                                 }
                           continue;
                           }
// then the date
                 matcher = testDatePattern.matcher(line);
                 if(matcher.matches()) {
                     daqInfo.put(DAQInfo.DATE,line.substring(matcher.start(1),matcher.end(1)));
                     continue;
                    }
// now passed or fail status
                 matcher = passedPattern.matcher(line);
                 if(matcher.matches()) {
                     testInfo.setPassed(line.substring(matcher.start(1),matcher.end(1)));
                     continue;
                     }
                 matcher = problemPattern.matcher(line);
                 if(matcher.matches()) {
                     testInfo.setProblem(line.substring(matcher.start(1),matcher.end(1)));
                     continue;
                     }
// now the test type
                 matcher = testregex.matcher(line);
                 if(matcher.matches()) {
                        String theTestType = line.substring(matcher.start()+1,matcher.end());
                        testInfo.setName(theTestType);
                        if(testMapping.containsKey(theTestType)) testno = ((Integer)testMapping.get(theTestType)).intValue();
                        switch(testno) {
                          case TEST_PIPELINE:
                            dataBlock = new DataBlock("Number of Defective pipelines",1,testno);
                            dataBlock.add(0,"#Channels");
                            break;
                          case TEST_FULLBYPASS:                          
                             dataBlock = new DataBlock("FullBypass Data",testParameters[testno].length-3,testno);
                             for(int header=3;header<testParameters[testno].length;header++) dataBlock.add(header-3,testParameters[testno][header]);
                             break;
                          case TEST_STROBEDELAY: 
                            dataBlock = new DataBlock("Optimum Strobe Delays",1,testno);
                            dataBlock.add(0,"Delay");
                            break;
                          case TEST_TRIM:                          
                             dataBlock = new DataBlock("Trim Data",testParameters[testno].length-3,testno);
                             for(int header=3;header<testParameters[testno].length;header++) dataBlock.add(header-3,testParameters[testno][header]);
                             break;
                          case TEST_NOISE:
                             dataBlock = new DataBlock("Noise Data",testParameters[testno].length-3,testno);
                             for(int header=3;header<testParameters[testno].length;header++) dataBlock.add(header-3,testParameters[testno][header]);
                             break;
                          case TEST_TIMEWALK:
                            dataBlock = new DataBlock("TimeWalk Data",testParameters[testno].length-3,testno);
                             for(int header=3;header<testParameters[testno].length;header++) dataBlock.add(header-3,testParameters[testno][header]);
                             break;
                          case TEST_RXTHRESHOLD: 
                            linkInfo = new LinkInfo();
                            break;
                          case TEST_RXDELAY: 
                            linkInfo = new LinkInfo();
                            break;
                          case TEST_IV:
                            ivData = new IVData(testObject.getSerialNo());
                            break;
                          default:
                          }
                        continue;
                        }
//
                 matcher = spacerPattern.matcher(line);
                 if(matcher.matches()) line=line.substring(matcher.start(1),matcher.end(1));
                 switch(testno) {
                    case TEST_IV:
                         Matcher matcher2 = ivDataPattern.matcher(line);
                         if(matcher2.matches()) ivData.add(line.substring(matcher2.start(1),matcher2.end(1)),line.substring(matcher2.start(2),matcher2.end(2)));
                         break;
                    case TEST_PIPELINE:
                         if(nextLineIsLink0Data || nextLineIsLink1Data) {
                           String[] dataLine = line.split("\\s+");
                           if(dataLine.length!=6) break;
                           for(int j=0;j<dataLine.length;j++) {
                                      int index = nextLineIsLink1Data ? j+6 : j;
                                       try {  // subtract 128 from Ngood into N-notGood
                                          int thisData = Integer.parseInt(dataLine[j]);
                                          thisData=128-thisData;
                                          dataLine[j]=Integer.toString(thisData);
                                       }catch(Exception e2){};
                                      dataBlock.add(index,0,dataLine[j]);
                                      }
                           }
                          nextLineIsLink0Data = line.startsWith("#M0");
                          nextLineIsLink1Data = line.startsWith("#M8");
                          break;
                    case TEST_FULLBYPASS:
//  byPassChipOffset   chip0  chip0   chip1  chip1
//                 0   data0  data1   data0  data1
//                 1   data0  data1   data0  data1
//          ...
// where chip0=m0,s2 etc for byPassChipOffset=0,1 etc
//       chip1=s1,s3 etc for byPassChipOffset=0,1 etc
                         if(line.matches("^#Comment$")) {
                                byPassSection=1;
                                byPassChipOffset=-1;
                                }
                         if(line.matches("^#token\\s+r_tkn\\s+token\\s+r_tkn$")) byPassSection=0;
                         if(byPassSection<0) break;
                          
                         if(byPassChipOffset!=-1) {
                           String[] dataLine = (byPassSection==1) ? line.split("\\t+") : line.split("\\s+");
                           if(dataLine.length!=4) break;
                           int colOffset = byPassSection*2;
                           // remove any " from comments
                           dataBlock.add((byPassChipOffset*2),0+colOffset,dataLine[0].replaceAll("\"","")); 
                           dataBlock.add((byPassChipOffset*2),1+colOffset,dataLine[1].replaceAll("\"",""));   
                           dataBlock.add((byPassChipOffset*2)+1,0+colOffset,dataLine[2].replaceAll("\"","")); 
                           dataBlock.add((byPassChipOffset*2)+1,1+colOffset,dataLine[3].replaceAll("\"",""));                        
                           }
                         byPassChipOffset=-1;
                         for(int offset=0;offset<6;offset++) {
                             if(line.matches(fullBypassChipPattern[offset])) {
                                   byPassChipOffset=offset;
                                   break;
                                   }
                             }
                         break;

                    case TEST_STROBEDELAY:
                         if(nextLineIsLink0Data || nextLineIsLink1Data) {
                           String[] dataLine = line.split("\\s+");
                           if(dataLine.length!=6) break;
                           for(int j=0;j<dataLine.length;j++) {
                                      int index = nextLineIsLink1Data ? j+6 : j;
                                      dataBlock.add(index,0,dataLine[j]);
                                      }
                           }
                          nextLineIsLink0Data = line.startsWith("#M0");
                          nextLineIsLink1Data = line.startsWith("#M8");
                          break;
                    case TEST_3PTGAIN:
                    case TEST_NPTGAIN:
                         if(line.startsWith("#LoopA")) {
                             dataBlock = new DataBlock("Fit Parameters",4,testno);
                             dataBlock.add(0,"Function");
                             dataBlock.add(1,"P0");
                             dataBlock.add(2,"P1");
                             dataBlock.add(3,"P2");         
                             continue;
                             }
                         if(line.startsWith("#LoopB")) {
                             if(dataBlock!=null) testObject.add(dataBlock);
                             dataBlock = new DataBlock("NPtGain Data",testParameters[testno].length-3,testno);
                             for(int header=3;header<testParameters[testno].length;header++) dataBlock.add(header-3,testParameters[testno][header]);
                             continue;
                             }
                         for(int j=0;j<12;j++) {
                              if(nextLineIsChipData[j]) {
                                String[] dataLine = line.split("\\s+");
                                for(int k=0;k<dataLine.length;k++) {
                                         dataBlock.add(j,k,dataLine[k]);
                                         }
                                }
                              nextLineIsChipData[j] = (line.matches(chipNames[j]));
                          }
                          break;
                    case TEST_TRIM:
                         for(int j=0;j<12;j++) {
                            if(nextLineIsChipData[j]) {
                                String[] dataLine = line.split("\\s+");
                                try {  // subtract 128 from Ntrimmed to turn it into Nuntrimmed
                                          int thisData = Integer.parseInt(dataLine[2]);
                                          thisData=128-thisData;
                                          dataLine[2]=Integer.toString(thisData);
                                }catch(Exception e2){};
                                for(int k=0;k<dataLine.length;k++) dataBlock.add(j,k,dataLine[k]);
                                }
                             nextLineIsChipData[j] = (line.matches(chipNames[j]));
                             }
                          break;
                    case TEST_NOISE:
                          for(int j=0;j<12;j++) {
                            if(nextLineIsChipData[j]) {
                                String[] dataLine = line.split("\\s+");
                                for(int k=0;k<dataLine.length;k++) {
                                        try {
                                          if(k==1 || k==2) dataLine[k]= (new java.text.DecimalFormat("0.##E0")).format(Double.parseDouble(dataLine[k]));
                                        }catch(Exception ne){dataLine[k]="0.";} // if not a number, save as 0. for now...
                                        dataBlock.add(j,k,dataLine[k]);
                                        }
                                }
                             nextLineIsChipData[j] = (line.matches(chipNames[j]));
                             }
                          break;
                    case TEST_TIMEWALK:
                         if(line.startsWith("#TW")) parameterIndex=0;     // 0 = TimeWalk data; 1 = TCal data
                         if(line.startsWith("#TCAL")) parameterIndex=1;
//                         if(parameterIndex!=parameterType) break;
                         if(nextLineIsLink0Data || nextLineIsLink1Data) {
                           String[] dataLine = line.split("\\s+");
                           if(dataLine.length!=6) break;
                           for(int j=0;j<dataLine.length;j++) {
                                      int index = nextLineIsLink1Data ? j+6 : j;
                                      dataBlock.add(index,parameterIndex,dataLine[j]);
                                      }
                           }
                          nextLineIsLink0Data = line.startsWith("#M0");
                          nextLineIsLink1Data = line.startsWith("#M8");
                          break;
                    case TEST_RXTHRESHOLD:
                         if(nextLineIsData) {
                           Matcher matcher = bocPattern.matcher(line);
                           if(matcher.matches()) {
                              String s = line.substring(matcher.start(1),matcher.end(1));
                              linkInfo.add(0,s);
                              s = line.substring(matcher.start(2),matcher.end(2));
                              linkInfo.add(1,s);
                              }
                            }
                          nextLineIsData = line.startsWith("#Thresholds");
                          break;
                    case TEST_RXDELAY:
                         if(nextLineIsData) {
                           Matcher matcher = bocPattern.matcher(line);
                           if(matcher.matches()) {
                              String s = line.substring(matcher.start(1),matcher.end(1));
                              linkInfo.add(0,s);
                              s = line.substring(matcher.start(2),matcher.end(2));
                              linkInfo.add(1,s);
                              }
                            }
                          nextLineIsData = line.startsWith("#Delays");
                          break;
                    default:
                    }     
          if(nextLineIsScanPoints) {
             if(line.startsWith("%") || line.startsWith("#")) {
                  nextLineIsScanPoints=false;
                  continue;
                  }
             try {
                String[] scanPoints = line.split("\\s+");
                for(int k=0;k<scanPoints.length;k++) {
                       scanInfo.setScanPoint(scanCount+k,scanPoints[k]);
                       }
                 scanCount+=scanPoints.length;
                 continue;
             }catch(Exception e3){}
          }

          matcher = defectNamePattern.matcher(line);
          if(matcher.matches()) {
             defectInfo = new DefectInfo();
             defectInfo.setName(line.substring(matcher.start(1),matcher.end(1)));
             continue;
             }
          matcher = defectNameDefect0.matcher(line);
          if(matcher.matches()) {
             defectInfo.setFirstChannel(line.substring(matcher.start(1),matcher.end(1)));
             continue;
             }
          matcher = defectNameDefect1.matcher(line);
          if(matcher.matches()) {
             defectInfo.setLastChannel(line.substring(matcher.start(1),matcher.end(1)));
             testObject.add(defectInfo);
             continue;
             }

         if(nextLineIsComment) {
             matcher = commentsPattern.matcher(line);
             if(matcher.matches()) testObject.addComment(line.substring(matcher.start(1),matcher.end(1)));
             }

             
          if(nextLineIsVersion) daqInfo.put(DAQInfo.VERSION,line);
          if(nextLineIsTime) daqInfo.put(DAQInfo.TIME,line.replaceAll("\"",""));
          if(nextLineIsHost) daqInfo.put(DAQInfo.HOST,line.replaceAll("\"",""));
          if(nextLineIsScanType) scanInfo.setType(line);
          if(nextLineIsNoScans) scanInfo.setPoints(line);

          if(nextLineIsT0T1) {
            String[] data = line.split("[\\s\\r\\n]");
            if(data.length==2) {
              if(dcsInfo==null) dcsInfo=new DCSInfo();
              try {
                dcsInfo.put(DCSInfo.T0,nf.format(Double.parseDouble(data[0])));
                dcsInfo.put(DCSInfo.T1,nf.format(Double.parseDouble(data[1])));
                }catch(Exception e){}
              }
            } 
          if(nextLineIsVCCICC) {
            String[] data = line.split("[\\s\\r\\n]");
            if(data.length==2) {
              if(dcsInfo==null) dcsInfo=new DCSInfo();
              try {
                dcsInfo.put(DCSInfo.VCC,nf.format(Double.parseDouble(data[0])));
                dcsInfo.put(DCSInfo.ICC,nf.format(Double.parseDouble(data[1])));
                }catch(Exception e){}
              }
            } 
          if(nextLineIsVDDIDD) {
            String[] data = line.split("[\\s\\r\\n]");
            if(data.length==2) {
              if(dcsInfo==null) dcsInfo=new DCSInfo();
              try {
                dcsInfo.put(DCSInfo.VDD,nf.format(Double.parseDouble(data[0])));
                dcsInfo.put(DCSInfo.IDD,nf.format(Double.parseDouble(data[1])));
                }catch(Exception e){}
              }
            } 
          if(nextLineIsVDETIDET) {
            String[] data = line.split("[\\s\\r\\n]");
            if(data.length==2) {
              if(dcsInfo==null) dcsInfo=new DCSInfo();
              try {
                dcsInfo.put(DCSInfo.VDET,nf.format(Double.parseDouble(data[0])));
                dcsInfo.put(DCSInfo.IDET,nf.format(Double.parseDouble(data[1])));
                }catch(Exception e){}
              }
            } 
 
          nextLineIsVersion = line.matches("^[\\s#]?VERSION.*");
          nextLineIsTime = line.matches("^#TIME$");
          nextLineIsHost = line.matches("^#HOST$");      
          nextLineIsScanType = line.matches("^#POINT_TYPE$");
          nextLineIsNoScans = line.matches("^#N_POINTS$");    
          nextLineIsScanPoints = line.matches("^#POINTS$");
          nextLineIsComment = line.matches("^%Comment$");
          nextLineIsT0T1 = line.matches("^#T0\\s+T1.*");
          nextLineIsVDETIDET = line.matches("^#VDET\\s+IDET.*");
          nextLineIsVCCICC = line.matches("^#VCC\\s+ICC.*");
          nextLineIsVDDIDD = line.matches("^#VDD\\s+IDD.*");


          }
       if(dataBlock!=null) testObject.add(dataBlock);
       if(ivData!=null) testObject.add(ivData);
       if(dcsInfo!=null) testObject.add(dcsInfo);
       if(linkInfo!=null) testObject.add(linkInfo);
       testObject.add(testInfo);
       testObject.add(daqInfo);
       testObject.add(scanInfo);
   }

  private Map getTestMapping() {
      Map mapping = new HashMap();
      for(int i=0;i<resultFileKeyNames.length;i++) {
         if(!resultFileKeyNames[i].equals("")) mapping.put(resultFileKeyNames[i],new Integer(i));
       }
      return mapping;
}

     



}
