package SummaryReader;
/*
 * @author robinson
 */

public class IVTest {

      java.util.List comments, vValues, iValues;
      TestInfo testInfo;
      DAQInfo daqInfo;
      DCSInfo dcsInfo;
      String serialNo;
      java.text.DecimalFormat nf = new java.text.DecimalFormat("#.###");
      java.util.regex.Pattern vstartPattern = java.util.regex.Pattern.compile("^Vstart\\s*:\\s*([-]?\\d+\\.\\d+).*"); 
      java.util.regex.Pattern vstopPattern = java.util.regex.Pattern.compile("^Vstop\\s*:\\s*([-]?\\d+\\.\\d+).*"); 
      java.util.regex.Pattern vstepPattern = java.util.regex.Pattern.compile("^Vstep\\s*:\\s*([-]?\\d+\\.\\d+).*"); 
      boolean DEBUG=false;

      public IVTest() {
        comments = new java.util.ArrayList();
        vValues = new java.util.ArrayList();
        iValues = new java.util.ArrayList();
    }

    public java.util.List getVList() {
       return new java.util.ArrayList(vValues);
       }
    public java.util.List getIList() {
       return new java.util.ArrayList(iValues);
       }

    public void add(TestInfo testInfo) {
        this.testInfo=testInfo;
       }
    public void add(DAQInfo daqInfo) {
        this.daqInfo=daqInfo;
       }
    public void add(DCSInfo dcsInfo) {
        this.dcsInfo=dcsInfo;
        }
    public DCSInfo getDCSInfo() {
        return dcsInfo;
       }
    public TestInfo getTestInfo() {
        return testInfo;
       }
    public DAQInfo getDAQInfo() {
        return daqInfo;
        }
    public void setSerialNo(String serialNo) {
        this.serialNo = serialNo;
        }
    public String getSerialNo() {
         return serialNo;
         }
    public void addIVData(java.io.File rawDataFile) {
        String line;
        boolean readingIVData=false;
        java.util.regex.Matcher matcher;
        Double vstart=null, vstop=null, vstep=null;
        try {
        java.io.BufferedReader in = new java.io.BufferedReader(new java.io.FileReader(rawDataFile));
        while((line=in.readLine())!=null) {
           if(DEBUG) System.out.println("line: "+line);
           if(line.matches("^#V\\s*I.*")) {
             if(DEBUG) System.out.println("Start reading IV data...");
             readingIVData=true;
             continue;
             }
           if(line.matches("^#V\\s*microA.*")) {
             if(DEBUG) System.out.println("Stop reading IV data...");
             readingIVData=false;
             continue;
             }
           if(readingIVData) {
             double idata = Double.parseDouble(line.split("\\s+")[1]);
             if(DEBUG) System.out.println("Current = "+idata);             
             iValues.add(Double.valueOf(nf.format(idata)));
             continue;
             }
           matcher = vstartPattern.matcher(line);
           if(matcher.matches()) {
               double data = Double.parseDouble(line.substring(matcher.start(1),matcher.end(1)));
               vstart = Double.valueOf(nf.format(data));
               if(DEBUG) System.out.println("Vstart="+vstart);
               continue;
               }
           matcher = vstopPattern.matcher(line);
           if(matcher.matches()) {
               double data = Double.parseDouble(line.substring(matcher.start(1),matcher.end(1)));
               vstop = Double.valueOf(nf.format(data));
               if(DEBUG) System.out.println("Vstop="+vstop);
               continue;
               }
           matcher = vstepPattern.matcher(line);
           if(matcher.matches()) {
               double data = Double.parseDouble(line.substring(matcher.start(1),matcher.end(1)));
               vstep = Double.valueOf(nf.format(data));
               if(DEBUG) System.out.println("Vstep="+vstep);
               continue;
               }
           }
        in.close();
        if(vstart==null || vstop==null || vstep==null) {
           System.err.println("SctGUI::SummaryReader::IVTest - Voltage information not found in raw data file "+rawDataFile.getName());
           return;
           }
        int nsteps = (int)((vstop.doubleValue()-vstart.doubleValue())/vstep.doubleValue()) +1;
        if(DEBUG) System.out.println("nsteps="+nsteps);
        for(int i=0;i<nsteps;i++) {
              Double data = new Double(vstart.doubleValue() +i*vstep.doubleValue());
              data = Double.valueOf(nf.format(data.doubleValue()));
              if(DEBUG) System.out.println("V["+i+"]="+data.toString());
              vValues.add(data);
              }
        if(vValues.size()!=iValues.size()) {
         System.err.println("SctGUI::SummaryReader::IVTest - Noncompatible I/V information in raw data file "+rawDataFile.getName());
         vValues = new java.util.ArrayList();
         iValues = new java.util.ArrayList();
         }
        
        }catch(Exception e) {System.err.println("SctGUI::SummaryReader::IVTest - Exception reading in raw data file "+rawDataFile.getName()+" : "+e.toString());}
              
          
           
        }


    public void addComment(String comment) {
        comments.add(comment);
        }
    public String getComment(int commentIndex) {
        return (String)comments.get(commentIndex);
        }
    public String getCommentsSummary() {
       StringBuffer table = new StringBuffer("<h3>Comments</h3>\n");
       if(comments.size()==0) {
           table.append("None");
           return table.toString();
           }
       for(int i=0;i<comments.size();i++) table.append((String)comments.get(i)+"\n");
       return table.toString();
       }
    public Double getCurrentData(int stepIndex) {
       return (Double)iValues.get(stepIndex);
       }
        


}
