package SummaryReader;
//
// @Author Dave Robinson
//
import hep.aida.*;

public class IVData  {

   IDataPointSet ivDataPointSet;


    public IVData(String serialNo) {
            IDataPointSetFactory dpsf = DisplayGUI.plotters.IVScanPlotter.getInstance().getDataPointSetFactory();
            // Create a one dimensional IDataPointSet.
            ivDataPointSet = dpsf.create("ivDataPointSet",(serialNo==null) ? "IV Scan Data" : serialNo,2);
            }
    public void add(String V, String I) {
        try {
          int index = ivDataPointSet.size();
          ivDataPointSet.addPoint();
          ivDataPointSet.point(index).coordinate(0).setValue( Double.parseDouble(V) );
          ivDataPointSet.point(index).coordinate(1).setValue( Double.parseDouble(I) );
          }catch(Exception e){System.err.println("SummaryReader::IVData - Exception parsing V,I as Doubles - "+e.toString());}
        }
    public Double getCurrent(int index) {
        return new Double(ivDataPointSet.point(index).coordinate(1).value());
        } 
    public Double getVoltage(int index) {
        return new Double(ivDataPointSet.point(index).coordinate(0).value());
        } 
    public IDataPointSet getDataPointSet() {
        return ivDataPointSet;
        }
    public String getSummaryTable() {
        StringBuffer buf = new StringBuffer("<h3>IV Scan Data</h3>\n");
        if(ivDataPointSet.size()==0) {
           buf.append("No data available.");
           return buf.toString();
           }
        buf.append("<table border=1>\n");
        buf.append("<tr><td><b>Volts (V)</b></td><td><b>Current (uA)</b></td></tr>\n");
        for(int i=0;i<ivDataPointSet.size();i++)  buf.append("<tr><td>"+getVoltage(i).toString()+"</td><td>"+getCurrent(i).toString()+"</td></tr>");
        buf.append("</table>");
        return buf.toString();
        }   
}