package ProdDatabase;
//
// @Author Dave Robinson
//
import java.io.*;
import java.util.Hashtable;
import java.util.Vector;
import Preferences.PreferencesInterface;
import guiUtilities.userPrompt;
import guiUtilities.DaveUtils;

public class SignoffDataInterface implements ModuleSignoffData {

   Hashtable signoffDataHash;
   private String location;
   String signoffType;
   String finalSignoffInfo;
   Vector snList;

    public SignoffDataInterface(String serialNo, String location, String signoffType) {
            this.signoffType=signoffType;
            try {
              signoffDataHash = GeneralUtilities.getSignoffDataTestNo(serialNo, location, signoffType);
              if(!signoffDataHash.containsKey(location)) return;
              String testno = (String)signoffDataHash.get(location);
              Vector rawData = GeneralUtilities.getRawData(testno);
              if(rawData.size()>0) signoffDataHash.put(location,new SignoffData(GeneralUtilities.getUploaderInfo(testno),(String)rawData.elementAt(1)));
            }catch(Exception e){System.out.println("FAILED to download signoff data: "+e.toString());}
       }
    public SignoffDataInterface(String serialNo, String signoffType) {
            this.signoffType=signoffType;
            try {
              signoffDataHash = GeneralUtilities.getSignoffDataTestNo(serialNo,signoffType);
              // replace test numbers by SignoffData objects
              for (java.util.Enumeration e = signoffDataHash.keys() ; e.hasMoreElements() ;) {
                    String location  = (String)e.nextElement();
                    String testno = (String)signoffDataHash.get(location);
                    Vector rawData = GeneralUtilities.getRawData(testno);
                    if(rawData.size()>0) signoffDataHash.put(location,new SignoffData(GeneralUtilities.getUploaderInfo(testno),(String)rawData.elementAt(1)));
                    else signoffDataHash.remove(location);
                    }
            }catch(Exception e){System.out.println("FAILED to download signoff data: "+e.toString());}
       }
   public SignoffDataInterface(String sn1, String sn2, String currLocation, String institute, String signoffType, boolean latestOnly) {
            try {
              snList = GeneralUtilities.getSignoffDataTestNos(sn1,sn2,currLocation, institute, signoffType, latestOnly);
            }catch(Exception e){System.out.println("FAILED to download signoff data: "+e.toString());}
       }

    public Vector getSignoffTable() {
          Vector tableList = new Vector();
          Vector itemList=new Vector();
          itemList.addElement("Serial No");
          itemList.addElement("Uploaded by");
          itemList.addElement("Date");
          itemList.addElement("Category");
          itemList.addElement("Reason");
          itemList.addElement("Barrel Assignment");
          itemList.addElement("Reason");
          itemList.addElement("Comments");
          tableList.addElement(itemList);
          if(snList.size()==0) return tableList;

          try {
          for(int i=0;i<snList.size();i++) {
             itemList = new Vector();
             String testno = (String)snList.elementAt(i);
             SignoffData signoffData = new SignoffData((String)snList.elementAt(i));  
             itemList.addElement(signoffData.getString(ModuleSignoffData.SERIALNO));
             System.out.println("Extracting signoff info for module "+signoffData.getString(ModuleSignoffData.SERIALNO)+" ("+Integer.toString(i+1)+" out of "+snList.size()+")");
             SCTDBTestInfoHolder testInfo = GeneralUtilities.getTestInfo(testno);
             itemList.addElement(testInfo.get(SCTDBTestInfoHolder.LOCATION));
             itemList.addElement(testInfo.get(SCTDBTestInfoHolder.DATE));
             itemList.addElement(signoffData.getString(ModuleSignoffData.CATEGORY));
             String failReason = signoffData.getString(ModuleSignoffData.FAILREASON);
             if(failReason==null) itemList.addElement("n/a");
             else itemList.addElement(failReason);
             String barrelA = signoffData.getString(ModuleSignoffData.BARREL).toUpperCase();
             if(barrelA.equals("6")) barrelA="Barrel 6 ONLY";
             itemList.addElement(barrelA);
             String b56Reason = signoffData.getString(ModuleSignoffData.B56REASON);
             if(b56Reason==null) itemList.addElement("n/a");
             else itemList.addElement(b56Reason);
             itemList.addElement(signoffData.getString(ModuleSignoffData.COMMENT));
             tableList.addElement(itemList);
             }
           }catch(Exception e){System.err.println("Exception "+e.toString());}
           return tableList;
           }

    public Vector getQualityTable() {
          Vector tableList = new Vector();
          Vector itemList=new Vector();
          itemList.addElement("Serial No");
          itemList.addElement("Uploaded by");
          itemList.addElement("Date");
          itemList.addElement("IV Category");
          itemList.addElement("IV comment");
          itemList.addElement("Elec Category");
          itemList.addElement("Elec comment");
          itemList.addElement("Elec spec Settings");
          itemList.addElement("SCurve Category");
          itemList.addElement("SCurve comment");
          tableList.addElement(itemList);
          if(snList.size()==0) return tableList;

          try {
          for(int i=0;i<snList.size();i++) {
             itemList = new Vector();
             String testno = (String)snList.elementAt(i);
             System.out.println("Extracting quality data for test number "+testno+" (test "+Integer.toString(i+1)+" out of "+snList.size()+")");
             SignoffData signoffData = new SignoffData(testno);  
             itemList.addElement(signoffData.getString(ModuleSignoffData.SERIALNO));
             SCTDBTestInfoHolder testInfo = GeneralUtilities.getTestInfo(testno);
             itemList.addElement(testInfo.get(SCTDBTestInfoHolder.LOCATION));
             itemList.addElement(testInfo.get(SCTDBTestInfoHolder.DATE));
             itemList.addElement( (signoffData.getString(ModuleSignoffData.IVCATEGORY)!=null) ? signoffData.getString(ModuleSignoffData.IVCATEGORY) : "Not known");
             itemList.addElement( (signoffData.getString(ModuleSignoffData.IVCOMMENT)!=null) ? signoffData.getString(ModuleSignoffData.IVCOMMENT) : "None");
             itemList.addElement( (signoffData.getString(ModuleSignoffData.ELECTRICALCATEGORY)!=null) ? signoffData.getString(ModuleSignoffData.ELECTRICALCATEGORY) : "Unknown");
             itemList.addElement( (signoffData.getString(ModuleSignoffData.ELECTRICALCOMMENT)!=null) ? signoffData.getString(ModuleSignoffData.ELECTRICALCOMMENT) : "None");
             itemList.addElement( (signoffData.getString(ModuleSignoffData.ELEC_SPECIAL_SETTING)!=null) ? signoffData.getString(ModuleSignoffData.ELEC_SPECIAL_SETTING) : "None");
             itemList.addElement( (signoffData.getString(ModuleSignoffData.SCURVECATEGORY)!=null) ? signoffData.getString(ModuleSignoffData.SCURVECATEGORY) : "Ok");
             itemList.addElement( (signoffData.getString(ModuleSignoffData.SCURVECOMMENT)!=null) ? signoffData.getString(ModuleSignoffData.SCURVECOMMENT) : "None");
             tableList.addElement(itemList);
             }
           }catch(Exception e){System.err.println("Exception "+e.toString());}
           return tableList;
           }
   public Vector getTestNoList() {
       return snList;
       }

       

    public String getString(String location,int index, boolean isHTML) {
        if(!signoffDataHash.containsKey(location)) return "None uploaded";
        String value=null;
        if((value=((SignoffData)signoffDataHash.get(location)).getString(index))!=null) {
               if(isHTML) value = value.replaceAll("[\\n\\r]+","<br>");
               switch(index) {
                    case ModuleSignoffData.IVCATEGORY:
                    case ModuleSignoffData.ELECTRICALCATEGORY:
                    case ModuleSignoffData.SCURVECATEGORY:
                      if(value.matches(".*GOOD|Good.*")) value="<font color=green>"+value+"</font>";
                      else value="<font color=red>"+value+"</font>";
                      break;
                    default:
                }
            }
        return (value==null) ? "None uploaded" : value;
        }
//**************************************8
// this method specifically for FINALSIGNOFF data
// where the hash should have only one key-value pair
    public String getString(int index, boolean isHTML) {
        String value=null;
        if(signoffDataHash.size()!=1) return null;
        for (java.util.Enumeration e = signoffDataHash.keys() ; e.hasMoreElements() ;) {
            String location  = (String)e.nextElement();     
            value=((SignoffData)signoffDataHash.get(location)).getString(index);
            if(isHTML) value = value.replaceAll("\\n","<br>");
            }
        return value;
        }
//**************************************************
    public boolean qualityInfoIsPresent() {
       if(signoffDataHash.size()==0) return false;
       for (java.util.Enumeration e = signoffDataHash.keys() ; e.hasMoreElements() ;) {
            String location  = (String)e.nextElement();     
            String value;
            if((value=((SignoffData)signoffDataHash.get(location)).getString(ModuleSignoffData.IVCATEGORY))==null) return false;
            }
        return true;
        }

    public Hashtable getSignoffDataHash() {
        return signoffDataHash;
        }
    public void setParameter(String location, int index, String value) {
        if(!signoffDataHash.containsKey(location)) signoffDataHash.put(location, new SignoffData());
        ((SignoffData)signoffDataHash.get(location)).put(keywords[index],value);
        }
    public String getUploaderInfo(String location) {
        if(!signoffDataHash.containsKey(location)) return null;
        return ((SignoffData)signoffDataHash.get(location)).getUploaderInfo();
        }

//**********************************************************************************
    public String writeUploadFiles(String sn, String location) {
        String userInitials=null;
        if(!signoffDataHash.containsKey(location)) return null;
        SignoffData signoffData = (SignoffData)signoffDataHash.get(location);
        try {
          userPrompt thisPrompt = new userPrompt(null,"","Your initials", GeneralUtilities.getNameList(location));
          thisPrompt.pack();
          thisPrompt.setVisible(true);
          userInitials = thisPrompt.getValidatedText();
          if (userInitials.equals("None")) return null;
          } catch(Exception e1){System.out.println("ERROR retrieving list of users from SCTDB: "+e1.toString()); return null;}
        try {
          return ProdDatabase.BarrelUtilities.writeUploadFile(sn,signoffData.writeUploadDataFile(sn),userInitials, location,signoffType);
          }catch(Exception e) {System.out.println("FAILED to create upload file: "+e.toString()); return null;}
        }

//*****************************************************************************
}