package ProdDatabase;
/*
 * @author robinson
 */
import java.sql.*;
import java.io.*;
import java.util.*;

public class ModuleIVInfo implements SCTDBInfo {
   Statement           statement;
   ResultSet           resultSet;
   StringBuffer        sqlStat;
   SCTDBInterface      db;

   private Vector sensors,modIVs;
   String moduleSerialNo;
   Hashtable i150Hash, i350Hash, temperatureHash, testnoHash;
   Hashtable moduleTestNoHash;
   String dataOrigin;
   private double tMin,tMax, i150Total, i350Total, i500Total;
   java.text.DecimalFormat ivFormatter = new java.text.DecimalFormat("#.###");
   java.text.DecimalFormat temperatureFormatter = new java.text.DecimalFormat("#.#");

   boolean DEBUG=false;

   public ModuleIVInfo(String moduleSerialNo)  {
          this.moduleSerialNo=moduleSerialNo;
          sensors=new Vector();
          initVariables();
          }

   public ModuleIVInfo(String moduleSerialNo, Vector sensors)  {
       this.moduleSerialNo=moduleSerialNo;
       this.sensors=sensors;
       initVariables();
       }
   private void initVariables() {
       modIVs = new Vector();
       i150Hash = new Hashtable();
       i350Hash = new Hashtable();
       temperatureHash = new Hashtable();
       testnoHash = new Hashtable();
       moduleTestNoHash = new Hashtable();
       dataOrigin = new String(" - ");
       tMin=100.;
       tMax=0.;
       i150Total=0.;
       i350Total=0.;
       i500Total=0.;

       db = SCTDBInterface.getInstance();
       try { 
         if(sensors.size()>0) {
           getSensorIVInfo();
           if(i150Hash.size()!=sensors.size()) getMfrIVInfo();
           if(i150Hash.size()==sensors.size()) getSensorSums();
           }
         getModuleIVs();
         getModule500VData();
         getModuleIVPlots();
         System.out.println("done");
       }catch(Exception e){System.err.println(e.toString());}
               
   }

public double geti150SensorCurrent() {
            return i150Total;
    }
public double geti350SensorCurrent() {
            return i350Total;
    }
public double geti500SensorCurrent() {
            return i500Total;
    }
public String getTemperatureRange() {
            if(tMax==0.) return " - ";
            return temperatureFormatter.format(tMin)+"-"+temperatureFormatter.format(tMax);
    }
public String getOrigin() {
            return dataOrigin;
    }
public int noModuleIVs() {
     return modIVs.size();
     }
public ModuleIV getModuleIV(int index) {
     String testno = (String)modIVs.elementAt(index);
     return (ModuleIV)moduleTestNoHash.get(testno);
     }
public ModuleIV getLastModuleIV() {
     String testno = (String)modIVs.lastElement();
     return (ModuleIV)moduleTestNoHash.get(testno);
     }     
 

//***************************************************************************************************
private void getSensorIVInfo() throws Exception {

     if(sensors.size()==0) return;
     StringBuffer sensorList = new StringBuffer();
     for(int i=0;i<sensors.size();i++) {
         if(i>0) sensorList.append(",");
         Hashtable tempHash = (Hashtable)sensors.elementAt(i);
         sensorList.append((String)tempHash.get("SERIALNO"));
         }

     if(!db.isConnected()) throw new Exception("No database connection");
     StringBuffer sqlStat = new StringBuffer("SELECT ");
     sqlStat.append("tests.ser_no,tstdetivs.i_leak_150,tstdetivs.i_leak_350,tstdetivs.temperature, tests.locn_name,tests.test_no");
     sqlStat.append(" FROM tests,tstdetivs");
     sqlStat.append(" WHERE tests.ser_no IN ("+sensorList.toString()+")");
     sqlStat.append(" AND tests.test_name='DetIVscan'");
     sqlStat.append(" AND tstdetivs.test_no=tests.test_no AND tstdetivs.temperature>0");
     sqlStat.append(" ORDER BY tests.test_date,tests.test_no");

     statement = db.connection.createStatement();
     if(DEBUG) System.out.println(sqlStat.toString());
     resultSet = statement.executeQuery(sqlStat.toString());

     for(boolean n = resultSet.next() ; n==true ; n=resultSet.next() ){
          String sn = resultSet.getString(1);
          i150Hash.put(sn,resultSet.getString(2));
          i350Hash.put(sn,resultSet.getString(3));
          temperatureHash.put(sn,resultSet.getString(4));
          dataOrigin=resultSet.getString(5);
          testnoHash.put(sn,resultSet.getString(6));
	  }
     statement.close();

     // try to get the 500V data
     }
//*****************************************************************************************************
private void getMfrIVInfo() throws Exception {
     if(!db.isConnected()) throw new Exception("No database connection");
     StringBuffer sensorList = new StringBuffer();
     for(int i=0;i<sensors.size();i++) {
         if(i>0) sensorList.append(",");
         Hashtable tempHash = (Hashtable)sensors.elementAt(i);
         sensorList.append((String)tempHash.get("SERIALNO"));
         }
      StringBuffer sqlStat = new StringBuffer("SELECT tests.ser_no,i_leak_150,i_leak_350,temperature,tests.locn_name");
      sqlStat.append(" FROM tests,tstdetmfrs WHERE tstdetmfrs.test_no=tests.test_no");
      sqlStat.append(" AND tests.ser_no IN ("+sensorList.toString()+")");
      sqlStat.append(" AND tests.test_name='DetMfrSheet'");
      sqlStat.append(" ORDER BY tests.test_date,tests.test_no");

     statement = db.connection.createStatement();
     if(DEBUG) System.out.println(sqlStat.toString());
     resultSet = statement.executeQuery(sqlStat.toString());

     for(boolean n = resultSet.next() ; n==true ; n=resultSet.next() ){
          String sn = resultSet.getString(1);
          i150Hash.put(sn,resultSet.getString(2));
          i350Hash.put(sn,resultSet.getString(3));
          temperatureHash.put(sn,resultSet.getString(4));
          dataOrigin=resultSet.getString(5);
	  }
     statement.close();
     }
//*******************************************************************************************************
private void getSensorSums() {
     int i500Count=0;
     for(Enumeration e = i150Hash.keys(); e.hasMoreElements();) {
        String sn = (String)e.nextElement();
        String testno = (String)testnoHash.get(sn);
        String i150 = (String)i150Hash.get(sn);
        String i350 = (String)i350Hash.get(sn);
        double temperature = Double.parseDouble((String)temperatureHash.get(sn));
        try {
           double i500 = GeneralUtilities.get500VData(testno);
           if(i500>0.) i500Count++; 
           i500Total+=guiUtilities.DaveUtils.getCorrectedCurrent(i500, temperature);
        }catch(Exception e2){System.err.println(e2.toString());}
        i150Total+= guiUtilities.DaveUtils.getCorrectedCurrent(Double.parseDouble(i150), temperature);
        i350Total+= guiUtilities.DaveUtils.getCorrectedCurrent(Double.parseDouble(i350), temperature);
        if(temperature>tMax) tMax=temperature;
        if(temperature<tMin) tMin=temperature;
        }
       if(i500Count!=i150Hash.size()) i500Total=0.;
      }
//*****************************************************************************************************
private void getModuleIVs() throws Exception {

     StringBuffer sqlStat = new StringBuffer("SELECT ");
     sqlStat.append("tests.ser_no,tests.test_date,tests.locn_name,tests.problem,tests.pass,tstdetivs.i_leak_150,tstdetivs.i_leak_350,tstdetivs.temperature,tests.test_no");
     sqlStat.append(" FROM tests,tstdetivs");
     sqlStat.append(" WHERE tests.ser_no="+moduleSerialNo+" AND tests.test_name='DetModIV'");
     sqlStat.append(" AND tstdetivs.test_no=tests.test_no AND tstdetivs.temperature>0");
     sqlStat.append(" ORDER BY tests.test_date,tests.test_no");

     statement = db.connection.createStatement();
     if(DEBUG) System.out.println(sqlStat.toString());
     resultSet = statement.executeQuery(sqlStat.toString());

     for(boolean n = resultSet.next() ; n==true ; n=resultSet.next() ){
       String sn = resultSet.getString(1);
       String testDate = guiUtilities.DaveUtils.extractDate(resultSet.getString(2));
       String locn = resultSet.getString(3);  
       String problem = resultSet.getString(4); 
       String pass = resultSet.getString(5);   
       String i150 = resultSet.getString(6);  
       String i350 = resultSet.getString(7);
       String temperature = resultSet.getString(8);
       String testno = resultSet.getString(9);
       String status = "FAIL";
       if(pass.equals("YES")) {
            status = (problem.equals("YES")) ? "Problem" : "Ok";
            }
       double ii150 = guiUtilities.DaveUtils.getCorrectedCurrent(Double.parseDouble(i150), Double.parseDouble(temperature));
       double ii350 = guiUtilities.DaveUtils.getCorrectedCurrent(Double.parseDouble(i350), Double.parseDouble(temperature));
       ModuleIV iv = new ModuleIV(sn,testDate,status,temperature,locn,testno,ii150,ii350);
       moduleTestNoHash.put(testno,iv);
       modIVs.add(testno);
       }
    statement.close();
    }
//*******************************************************************************
    private void getModule500VData() {
       for(int i=0;i<modIVs.size();i++) {
          String testno = (String)modIVs.elementAt(i);
          ModuleIV iv = (ModuleIV)moduleTestNoHash.get(testno);
          String temperature = iv.getTemperature();
          try {
           double i500 = GeneralUtilities.get500VData(testno);
           i500 = guiUtilities.DaveUtils.getCorrectedCurrent(i500, Double.parseDouble(temperature));
           iv.add500VData(i500);       
           moduleTestNoHash.put(testno,iv);
           }catch(Exception e2){System.err.println(e2.toString());}
       }
    }
//*******************************************************************************
    private void getModuleIVPlots() throws Exception {
       if(moduleTestNoHash.size()==0) return;
       int i=0;
       StringBuffer testnos = new StringBuffer();
       for(Enumeration e = moduleTestNoHash.keys(); e.hasMoreElements();) {
           if(i>0) testnos.append(",");
           i++;
           testnos.append((String)e.nextElement());
           }
       StringBuffer sqlStat = new StringBuffer("SELECT ");
       sqlStat.append("test_no,url FROM web_links");
     sqlStat.append(" WHERE test_no IN ("+testnos.toString()+")");

     statement = db.connection.createStatement();
     if(DEBUG) System.out.println(sqlStat.toString());
     resultSet = statement.executeQuery(sqlStat.toString());

     for(boolean n = resultSet.next() ; n==true ; n=resultSet.next() ){
         String testno = resultSet.getString(1);
         String url = resultSet.getString(2);
         ModuleIV iv = (ModuleIV)moduleTestNoHash.get(testno);
         iv.addLink(url);
         moduleTestNoHash.put(testno,iv);
         }
     statement.close();

    }


}