package ProdDatabase;
import java.util.*;
import java.sql.*;
import java.util.zip.*;
import java.io.*;
import java.text.DecimalFormat;
import Preferences.*;

public class HTMLReportUtilities implements SCTDBInfo {

   public static boolean DEBUG=false;

   private static Hashtable sctdaqTestNameHash, sctdaqTestNumberHash;

  private static void fillHashes() {
         if(sctdaqTestNameHash!=null) return;
         sctdaqTestNameHash = new Hashtable();
         sctdaqTestNumberHash = new Hashtable();
         for(int i=0;i<sctdaqDBTestNames.length;i++) {
             sctdaqTestNameHash.put(sctdaqDBTestNames[i],sctdaqNormalTestNames[i]);
             sctdaqTestNumberHash.put(sctdaqDBTestNames[i],new Integer(i));
             }
      }
//******************************************************
   public static SctDaqTestInfo getHTMLTestInfo(String test_no) throws Exception {

      SctDaqTestInfo testInfo=null;
      fillHashes();

      StringBuffer genTable = new StringBuffer();
      StringBuffer sqlStat = new StringBuffer("SELECT test_name,ser_no,test_date,locn_name FROM tests WHERE test_no="+test_no);

// submit query
     Statement statement = SCTDBInterface.getInstance().connection.createStatement();
     if(DEBUG) System.out.println(sqlStat.toString());
     ResultSet resultSet = statement.executeQuery(sqlStat.toString());
     int recordCount=0;
   
     for(boolean n = resultSet.next() ; n==true ; n=resultSet.next() ){
          recordCount++;
          String dbTestName = resultSet.getString(1);
          String testName = dbTestName;
          int index=-1;
          if(sctdaqTestNameHash.containsKey(dbTestName)) {
                testName = (String)sctdaqTestNameHash.get(dbTestName);
                index = ((Integer)sctdaqTestNumberHash.get(dbTestName)).intValue();
                }
          testInfo = new SctDaqTestInfo(resultSet.getString(2),testName,guiUtilities.DaveUtils.extractDate(resultSet.getString(3)),resultSet.getString(4),index);
          }
     statement.close();
     return testInfo;
     }
// *****************************************************************************************************************
   public static String getHTMLCommentsTable(String test_no) throws Exception {

      StringBuffer genTable = new StringBuffer("<h3>Comments</h3>\n");
      StringBuffer sqlStat = new StringBuffer("SELECT CMNT_TEXT FROM TEST_CMNTS WHERE TEST_NO="+test_no);

// submit query
     Statement statement = SCTDBInterface.getInstance().connection.createStatement();
//    System.out.println("Interrogating defects table ...");
     if(DEBUG) System.out.println(sqlStat.toString());
     ResultSet resultSet = statement.executeQuery(sqlStat.toString());
     int recordCount=0;

// now get the data
     int ntotal=0;
     int nCount=0;
     for(boolean n = resultSet.next() ; n==true ; n=resultSet.next() ){
          recordCount++;

          String comment = resultSet.getString(1);
        nCount++;
        genTable.append(comment+"<br>\n");

        }
      statement.close();
      if(nCount==0) genTable.append("No comments found\n");
      return genTable.toString();
      }
//**************************************************************************8
  public static String getHTMLPlotTable(String test_no) throws Exception {
// now look for plots
      String testnames = " AND (tests.TEST_name LIKE 'Hyb%' OR tests.TEST_name LIKE 'DetModIV')";
      StringBuffer genTable = new StringBuffer("<h3>Plots</h3>\n");

      StringBuffer sqlStat = new StringBuffer("SELECT tests.ser_no,tests.test_no,web_links.web_link_desc,web_links.url FROM tests,web_links");
      sqlStat.append(" WHERE tests.test_no=web_links.test_no AND tests.test_no="+test_no);
      sqlStat.append(testnames);
 
// submit query
     Statement statement = SCTDBInterface.getInstance().connection.createStatement();
     if(DEBUG) System.out.println(sqlStat.toString());
     ResultSet resultSet = statement.executeQuery(sqlStat.toString());
// now get the raw data
     int nCount=0;
     Hashtable webLinkHash = new Hashtable();
     for(boolean n = resultSet.next() ; n==true ; n=resultSet.next() ){
          String theSN = resultSet.getString(1);
          String thisTestNo = resultSet.getString(2);
          String urlDescription = resultSet.getString(3);
          String thisURLlink = resultSet.getString(4);
          boolean isPostscript = (thisURLlink.endsWith(".ps") || thisURLlink.endsWith(".ps.gz"));
// check special case - RAL url and longterm test
          if(thisURLlink.indexOf("http://hepunx.rl.ac.uk/atlassct/cgibin/getfile.pl?file=")!=-1) thisURLlink+="&module="+theSN;

        if(nCount==0) {
          genTable.append("<table cellspacing=5 border=1>\n");
          for(int i=0;i<2;i++) genTable.append("<col width=*>\n");
          genTable.append("<tr><td valign=top align=left><b>Title</b></td><td valign=top align=left><b>Link</b></td></tr>\n");
          }
        nCount++;
        String link= isPostscript ? "Type"+guiUtilities.HTMLViewer.URLTOPOSTSCRIPT+"&ref="+thisURLlink : thisURLlink;
        genTable.append("<tr><td valign=top align=left>"+urlDescription+"</td><td valign=top align=left><a href="+link+">"+thisURLlink+"</a></td></tr>\n");

         }
      statement.close();
      if(nCount==0) genTable.append("No Plots available.\n");
      else genTable.append("</table>\n");
      return genTable.toString();
      }



// *****************************************************************************************************************
   public static String getHTMLDCSTable(String test_no) throws Exception {

      StringBuffer genTable = new StringBuffer("<h3>DCS Information</h3>\n");
      StringBuffer sqlStat = new StringBuffer("SELECT T0,T1,VDET,IDET,VCC,ICC,VDD,IDD,TIME_POWERED FROM SCT_TSTDCSINFO WHERE TEST_NO="+test_no); 
// submit query
     Statement statement = SCTDBInterface.getInstance().connection.createStatement();
     if(DEBUG) System.out.println(sqlStat.toString());
     ResultSet resultSet = statement.executeQuery(sqlStat.toString());
     int recordCount=0;

// now get the data
     int ntotal=0;
     int nCount=0;
     for(boolean n = resultSet.next() ; n==true ; n=resultSet.next() ){
          recordCount++;
        if(nCount==0) {
          genTable.append("<table cellspacing=5 border=1>\n");
          for(int i=0;i<9;i++) genTable.append("<col width=*>\n");
          genTable.append("<tr><td><b>T0</b></td><td><b>T1</b></td><td><b>Vdet</b></td><td><b>Idet</b></td><td><b>Vcc</b></td><td><b>Icc</b></td><td><b>Vdd</b></td><td><b>Idd</b></td><td><b>Time Powered</b></td></tr>\n");
          }
        nCount++;
        genTable.append("<tr>");
        for(int i=0;i<9;i++) genTable.append("<td>"+resultSet.getString(i+1)+"</td>");
        genTable.append("</tr>\n");

        }
      statement.close();
      if(nCount==0) genTable.append("<p>No DCS information available\n");
      else genTable.append("</table>\n");
      return genTable.toString();
      }
// *****************************************************************************************************************
   public static String getHTMLDAQTable(String test_no) throws Exception {

      StringBuffer genTable = new StringBuffer("<h3>DAQ Information</h3>\n");
      StringBuffer sqlStat = new StringBuffer("SELECT HOST,VERSION,DUT,TEST_TIME FROM SCT_TSTDAQINFO WHERE TEST_NO="+test_no); 
// submit query
     Statement statement = SCTDBInterface.getInstance().connection.createStatement();
     if(DEBUG) System.out.println(sqlStat.toString());
     ResultSet resultSet = statement.executeQuery(sqlStat.toString());
     int recordCount=0;

// now get the data
     int ntotal=0;
     int nCount=0;
     for(boolean n = resultSet.next() ; n==true ; n=resultSet.next() ){
          recordCount++;
        if(nCount==0) {
          genTable.append("<table cellspacing=5 border=1>\n");
          for(int i=0;i<4;i++) genTable.append("<col width=*>\n");
          genTable.append("<tr><td valign=top align=left><b>Host</b></td><td valign=top align=left><b>DAQ Version</b></td><td valign=top align=left><b>DeviceType</b></td><td valign=top align=left><b>Time</b></td></tr>\n");
          }
        nCount++;
        genTable.append("<tr>");
        for(int i=0;i<4;i++) genTable.append("<td valign=top align=left>"+resultSet.getString(i+1)+"</td>");
        genTable.append("</tr>\n");

        }
      statement.close();
      if(nCount==0) genTable.append("No DAQ information available\n");
      else genTable.append("</table>\n");
      return genTable.toString();
      }

// *****************************************************************************************************************
   public static String getHTMLScanTable(String test_no) throws Exception {
      String[] pointValues = new String[16];
      StringBuffer genTable = new StringBuffer("<h3>Scan Information</h3>\n");
      StringBuffer sqlStat = new StringBuffer("SELECT POINT_TYPE,N_POINTS");
      for(int i=0;i<16;i++) sqlStat.append(",POINT_"+i);
      sqlStat.append(" FROM SCT_TSTSCANINFO WHERE TEST_NO="+test_no); 
// submit query
     Statement statement = SCTDBInterface.getInstance().connection.createStatement();
     if(DEBUG) System.out.println(sqlStat.toString());
     ResultSet resultSet = statement.executeQuery(sqlStat.toString());
     int recordCount=0;
    
// now get the data
     int ntotal=0;
     int nCount=0;
     for(boolean n = resultSet.next() ; n==true ; n=resultSet.next() ){
          recordCount++;
          String point_type = resultSet.getString(1);
          String nPoints = resultSet.getString(2);
          int inPoints = Integer.parseInt(nPoints);
          for(int i=0;i<16;i++) pointValues[i]=resultSet.getString(i+3);
        if(nCount==0) {
          genTable.append("<table cellspacing=5 border=1>\n");
          for(int i=0;i<2+inPoints;i++) genTable.append("<col width=*>\n");
          genTable.append("<tr><td valign=top align=left><b>Type</b></td><td valign=top align=left><b># Points</b></td><td valign=top align=left><b>Values</b></td></tr>\n");
          }
        nCount++;
        genTable.append("<tr>");
        genTable.append("<td valign=top align=left>"+point_type+"</td><td valign=top align=left>"+nPoints+"</td>");
        genTable.append("<td valign=top align=left>"+pointValues[0]);
        for(int y=1;y<inPoints;y++) genTable.append(","+pointValues[y]);
        genTable.append("</tr>\n");

        }
      statement.close();
      if(nCount==0) genTable.append("<p>No scan information for this test type.\n");
      else genTable.append("</table>\n");
      return genTable.toString();
      }
// *****************************************************************************************************************
   public static String getSCTDAQHTMLTestData(String test_no, int testType) throws Exception {
// build vector table of full data from each test.
// the first element will be a string with optional data, or just the name of the test.
     StringBuffer genTable = new StringBuffer("<h3>Test Data</h3>\n");

     if(testType==-1) {
          genTable.append("Unknown test type");
          return genTable.toString();
          }
     int nCount=0;
     SCTDBInterface db = SCTDBInterface.getInstance();
     Statement statement = db.connection.createStatement();
     ResultSet resultSet;
     StringBuffer sqlStat;

     switch(testType) {
        case SCTDB_TEST_RESET:
        case SCTDB_TEST_REDUNDANCY:
           genTable.append("No test data available for this test type.");
           return genTable.toString();
        case SCTDB_TEST_TRIM:
            sqlStat = new StringBuffer("SELECT TR_CHARGE,TR_TYPE,TR_ALGORITHM FROM "+sctdaqDBTableNames[testType]);
            sqlStat.append(" WHERE test_no="+test_no);
            resultSet = statement.executeQuery(sqlStat.toString());
            for(boolean n = resultSet.next() ; n==true ; n=resultSet.next() ){
               genTable.append("Charge="+resultSet.getString(1)+" Type="+resultSet.getString(2)+" Algorithm="+resultSet.getString(3));
               }
//            statement.close();
            break;
         default:
      }


     int totalRows = (testType==SCTDB_TEST_RESET || testType==SCTDB_TEST_LONGTERM || testType==SCTDB_TEST_IV) ? 1 : DBChipParameterNames[testType].length;
     for(int theRowNo=0;theRowNo<totalRows;theRowNo++) {
            sqlStat = new StringBuffer("SELECT ");
            switch(testType) {
                    case SCTDB_TEST_RESET:
                        sqlStat.append(sctdaqDBTableNames[testType]+".ICC_NOCONFIG");
                        sqlStat.append(","+sctdaqDBTableNames[testType]+".IDD_NOCONFIG");
                        sqlStat.append(","+sctdaqDBTableNames[testType]+".ICC_NOCLOCK");
                        sqlStat.append(","+sctdaqDBTableNames[testType]+".IDD_NOCLOCK");
                        break;
                     case SCTDB_TEST_LONGTERM:
                        sqlStat.append(sctdaqDBTableNames[testType]+".DURATION");
                        sqlStat.append(","+sctdaqDBTableNames[testType]+".FAIL_TIME");
                        sqlStat.append(","+sctdaqDBTableNames[testType]+".T0_MIN");
                        sqlStat.append(","+sctdaqDBTableNames[testType]+".T0_MAX");
                        sqlStat.append(","+sctdaqDBTableNames[testType]+".T1_MIN");
                        sqlStat.append(","+sctdaqDBTableNames[testType]+".T1_MAX");
                        sqlStat.append(","+sctdaqDBTableNames[testType]+".IDET_MIN");
                        sqlStat.append(","+sctdaqDBTableNames[testType]+".IDET_MAX");
                        sqlStat.append(","+sctdaqDBTableNames[testType]+".ICC_MIN");
                        sqlStat.append(","+sctdaqDBTableNames[testType]+".ICC_MAX");
                        sqlStat.append(","+sctdaqDBTableNames[testType]+".IDD_MIN");
                        sqlStat.append(","+sctdaqDBTableNames[testType]+".IDD_MAX");
                        break;
                      case SCTDB_TEST_IV:
                        sqlStat.append(sctdaqDBTableNames[testType]+".I_LEAK_150");
                        sqlStat.append(","+sctdaqDBTableNames[testType]+".I_LEAK_350");
                        break;
                     default:
                        sqlStat.append(chipDBnames[0]+DBChipParameterNames[testType][theRowNo]);
                        for(int y=1;y<chipDBnames.length;y++) sqlStat.append(","+chipDBnames[y]+DBChipParameterNames[testType][theRowNo]);
                     }
            sqlStat.append(" FROM "+sctdaqDBTableNames[testType]);
            sqlStat.append(" WHERE test_no="+test_no);

// submit query

     if(DEBUG) System.out.println(sqlStat.toString());
            resultSet = statement.executeQuery(sqlStat.toString());
            int recordCount=0;

// now get the data

            for(boolean n = resultSet.next() ; n==true ; n=resultSet.next() ){
               if(nCount==0) {
                  genTable.append("<table cellspacing=5 border=1>\n");
                  if(testType==SCTDB_TEST_LONGTERM) {
                  genTable.append("<tr><td><b>Duration</b></td>");
                  genTable.append("<td><b>Fail Time</b></td>");
                  genTable.append("<td><b>T0(min)</b></td>");
                  genTable.append("<td><b>T0(max)</b></td>");
                  genTable.append("<td><b>T1(min)</b></td>");
                  genTable.append("<td><b>T1(max)</b></td>");
                  genTable.append("<td><b>Idet(min)</b></td>");
                  genTable.append("<td><b>Idet(max)</b></td>");
                  genTable.append("<td><b>Icc(min)</b></td>");
                  genTable.append("<td><b>Icc(max)</b></td>");
                  genTable.append("<td><b>Idd(min)</b></td>");
                  genTable.append("<td><b>Idd(max)</b></td></tr>");
                  }
                 else if(testType==SCTDB_TEST_RESET) {
                    genTable.append("<tr><td><b>Icc NoConf</b></td>");
                    genTable.append("<td><b>Idd NoConf</b></td>");
                    genTable.append("<td><b>Icc NoClock</b></td>");
                    genTable.append("<td><b>Idd NoClock</b></td></tr>\n");
                   }
                 else if(testType==SCTDB_TEST_IV) {
                    genTable.append("<tr><td><b>I @ 150V</b></td>");
                    genTable.append("<td><b>I @ 350V</b></td></tr>\n");
                    }
                  else {
                    for(int i=0;i<13;i++) genTable.append("<col width=*>\n");
                    genTable.append("<tr><td><b>Parameter</b></td>");
                    for(int z=0;z<chipDBnames.length;z++) genTable.append("<td><b>"+chipDBnames[z].substring(0,chipDBnames[z].length()-1)+"</b></td>");
                    genTable.append("</tr>\n");
                    }
                  }
               nCount++;
               recordCount++;
// add the parameter name in the first column
     switch(testType) {
                     case SCTDB_TEST_RESET:
                     case SCTDB_TEST_LONGTERM:
                     case SCTDB_TEST_IV:
                             genTable.append("<tr>");
                             break;
                     default:
                             genTable.append("<tr><td>"+(String)fullTestParameterNames[testType][theRowNo]+"</td>");
                     }
                if(testType==SCTDB_TEST_NOISE && (theRowNo==1 || theRowNo==2)) { // scientific notation for occupancy and occ rms
                      for(int y=0;y<chipDBnames.length;y++) {
                           String theValue = resultSet.getString(1+y);
                           double theNumber = Double.valueOf(theValue).doubleValue();
                           DecimalFormat myFormatter = new DecimalFormat("0.##E0");
                           genTable.append("<td>"+myFormatter.format(theNumber)+"</td>");
                           }
                       }
               else if(testType==SCTDB_TEST_RESET) for(int y=0;y<4;y++) genTable.append("<td>"+resultSet.getString(1+y)+"</td>");
               else if(testType==SCTDB_TEST_LONGTERM) for(int y=0;y<12;y++) genTable.append("<td>"+resultSet.getString(1+y)+"</td>");
               else if(testType==SCTDB_TEST_IV) for(int y=0;y<2;y++) genTable.append("<td>"+resultSet.getString(1+y)+"</td>");               
               else for(int y=0;y<chipDBnames.length;y++) genTable.append("<td>"+resultSet.getString(1+y)+"</td>");
               genTable.append("</tr>\n");
                }
             }
      statement.close();
      if(nCount==0) genTable.append("No test data found\n");
      else genTable.append("</table>\n");
      return genTable.toString();
   }
//**********************************************************************************************
   public static String getHTMLDefectTable(String test_no) throws Exception {

      StringBuffer genTable = new StringBuffer("<h3>Defects</h3>\n");
      StringBuffer sqlStat = new StringBuffer("SELECT CHAN_1ST,CHAN_LAST,DEFECT_NAME FROM DEFECTS WHERE TEST_NO="+test_no);
      sqlStat.append(" ORDER BY CHAN_1ST");

// submit query
     Statement statement = SCTDBInterface.getInstance().connection.createStatement();
//    System.out.println("Interrogating defects table ...");
     if(DEBUG) System.out.println(sqlStat.toString());
     ResultSet resultSet = statement.executeQuery(sqlStat.toString());
     int recordCount=0;

// now get the data
     int ntotal=0;
     int nCount=0;
     for(boolean n = resultSet.next() ; n==true ; n=resultSet.next() ){
          recordCount++;
          String chan1 = resultSet.getString(1);
          String chan2 = resultSet.getString(2);
          String defectname = resultSet.getString(3);
        if(nCount==0) {
          genTable.append("<table cellspacing=5 border=1>\n");
          for(int i=0;i<2;i++) genTable.append("<col width=*>\n");
          genTable.append("<tr><td><b>Channel</b></td><td><b>Defect Type</b></td></tr>\n");
          }
        nCount++;
        String chans = (chan1.equals(chan2)) ? chan1 : chan1+"-"+chan2;
        genTable.append("<tr><td>"+chans+"</td><td>"+defectname+"</td></tr>\n");

        }
      statement.close();
      if(nCount==0) genTable.append("No defects found\n");
      else genTable.append("</table>\n");
      return genTable.toString();
      }
//**********************************************************************
     public static String getModuleReport(String serno) {

     try {
       if(!GeneralUtilities.itemExists(serno)) return null; // check it exists
     }catch(Exception ee){};

    System.out.println("Generating detailed report for module "+serno+". Be patient...");

     java.text.DecimalFormat ivFormatter = new java.text.DecimalFormat("#.###");

     ModuleInfo moduleInfo = new ModuleInfo(serno);

     StringBuffer html = new StringBuffer(guiUtilities.DaveUtils.getHTMLHeader("Module Summary Report for "+serno));

     if(!moduleInfo.isModule()) {
        html.append("Sorry, "+serno+" is not a module!");
        html.append(guiUtilities.DaveUtils.getHTMLFooter());
        return html.toString();
        }

     SignoffDataInterface signoffInfo=null;
     if(moduleInfo.isBarrelModule()) {
       signoffInfo = new SignoffDataInterface(serno,"FINALSIGNOFF");
       html.append("<h3>Module Signoff Information</h3>");
       Hashtable signoffDataHash = signoffInfo.getSignoffDataHash();
       if(signoffDataHash.size()==0) html.append("None uploaded");
       else {
          html.append("<table border=1>");
          int count=1;
          for (java.util.Enumeration e = signoffDataHash.keys() ; e.hasMoreElements() ;) {
              String location  = (String)e.nextElement();    
              html.append("<tr><td colspan=2><font color=navy>"+Integer.toString(count)+" - "+signoffInfo.getUploaderInfo(location)+"</font></td></tr>");
              html.append("<tr><td align=right><font color=navy>Overall category:</font></td><td>"+signoffInfo.getString(location,ModuleSignoffData.CATEGORY,true)+"</td></tr>");
              if(signoffInfo.getString(location,ModuleSignoffData.CATEGORY,true).matches("FAIL|Fail")) {
                html.append("<tr><td align=right><font color=navy>Reason for FAIL:</font></td><td>"+signoffInfo.getString(location,ModuleSignoffData.FAILREASON,true)+"</td></tr>");
                }
              html.append("<tr><td align=right><font color=navy>Barrel Asignment:</font></td><td>"+signoffInfo.getString(location,ModuleSignoffData.BARREL,true)+"</td></tr>");
              if(signoffInfo.getString(location,ModuleSignoffData.BARREL,true).matches("[56]+")) {
                html.append("<tr><td align=right>Reason for B5/6:</td><td>"+signoffInfo.getString(location,ModuleSignoffData.B56REASON,true)+"</td></tr>");
                }
              html.append("<tr><td align=right><font color=navy>Comment:</font></td><td>"+signoffInfo.getString(location,ModuleSignoffData.COMMENT,true)+"</td></tr>");
              count++;
              }
              html.append("</table>");
          }
       if(!signoffInfo.qualityInfoIsPresent()) signoffInfo = new SignoffDataInterface(serno,"SIGNOFF");
       }

     html.append("<h3>Assembly Information</h3>");
     html.append("<table border=1>");
     html.append("<tr><td><b>Component</b></td><td><b>SerialNo</b></td><td><b>Position</b></td><td colspan=2><b>Details</td></tr>\n");
     for(int i=0;i<moduleParts.length;i++) {
       if(moduleInfo.isForwardModule() && (i==SCTDBInfo.bmBB || i==SCTDBInfo.bmSB || i==SCTDBInfo.bmHPC)) continue;
       String sn = moduleInfo.getSerialNo(i);
       String testInfo = "n/a";
       if(moduleInfo.isBarrelModule()) {
          testInfo = moduleInfo.getDataSheetTestNo(i);
          if(testInfo==null) testInfo="Datasheet not available";
          else testInfo = "<a href=\"Type"+Integer.toString(guiUtilities.HTMLViewer.DATASHEET)+"&ref="+testInfo+"\">Datasheet</a>";
          }
       html.append("<tr><td>"+moduleParts[i]+"</td><td>"+sn+"</td><td>n/a</td><td colspan=2>"+testInfo+"</td></tr>\n");
       }
     Vector sensorList = moduleInfo.getSensorList();
     if(sensorList.size()==0) html.append("<tr><td>Sensors</td><td>Not Uploaded.</td><td>n/a</td><td colspan=2>Data not available</td></tr>\n");
     else {
        for(int i=0;i<sensorList.size();i++) {
           Hashtable tempHash = (Hashtable)sensorList.elementAt(i);
           String thisSN=(String)tempHash.get("SERIALNO");
           String posn = (String)tempHash.get("POSITION");
           String type = "Sensor";
           if(moduleInfo.isForwardModule()) {
             if(thisSN.matches("\\d{7}03\\d{5}")) type="W12 Sensor";
             else if(thisSN.matches("\\d{7}04\\d{5}")) type="W21 Sensor";
             else if(thisSN.matches("\\d{7}05\\d{5}")) type="W22 Sensor";
             else if(thisSN.matches("\\d{7}06\\d{5}")) type="W31 Sensor";
             else if(thisSN.matches("\\d{7}07\\d{5}")) type="W32 Sensor";
             }
           String link = "<a href=Type"+Integer.toString(guiUtilities.HTMLViewer.SENSORTESTDATA)+"&ref="+thisSN+">All Test Data</a>";
           html.append("<tr><td>"+type+"</td><td>"+thisSN+"</td><td>"+posn+"</td><td colspan=2>"+link+"</td></tr>\n");
           }
         }
     Vector asicList = moduleInfo.getAsicList();
     if(asicList.size()==0) html.append("<tr><td>ASICs</td><td>Not Uploaded.</td><td>n/a</td><td colspan=2>Data not available</td></tr>\n");
     else {
        for(int i=0;i<asicList.size();i++) {
           String thisASIC = (String)asicList.elementAt(i);
           String thisASICInfo = moduleInfo.getASICInfo(thisASIC);
           String thisASICcorrFactor = moduleInfo.getASICcorrFactor(thisASIC);
           html.append("<tr><td>ASIC</td><td>"+thisASIC+"</td><td>"+Integer.toString(i+1)+"</td><td>"+thisASICInfo+"</td><td>cFactor "+thisASICcorrFactor+"</td></tr>\n");
           }
        }
     html.append("</table>");

     try {
      String hsn = moduleInfo.getHybridSerialNo();
      if(hsn!=null) html.append(createASICReWorkTable(hsn));
     }catch(Exception e0){System.err.println("Error retrieving dissam logs: "+e0.toString());}

     try {
      html.append(createVisualTestTable(serno,"Module"));
      html.append(createVisualTestTable(moduleInfo.getHybridSerialNo(),"Hybrid"));
     }catch(Exception e){System.err.println("Error downloading visual inspection info: "+e.toString());}

     System.out.println("Still working...");

     html.append("<h3>Metrology Data</h3>");
     if(moduleInfo.noMetrologyTests()==0) html.append("No data uploaded.");
     else {
        html.append("<table border=1>");
        html.append("<tr><td>Type</td><td>Event</td><td>Status</td><td>Location</td><td>Date</td><td>Data</td></tr>\n");
        for(int i=0;i<moduleInfo.noMetrologyTests();i++) {
         MetrologyTest met = moduleInfo.getMetrologyTest(i);
         int linkType = (met.getType().equals("XY")) ? guiUtilities.HTMLViewer.XYMETDATA : guiUtilities.HTMLViewer.ZMETDATA;
         String link = "<a href=Type"+Integer.toString(linkType)+"&ref="+met.getTestNo()+"\">Datasheet</a>";
         html.append("<tr><td>"+met.getType()+"</td><td>"+met.getEvent()+"</td><td>"+met.getStatus()+"</td><td>"+met.getLocation()+"</td><td>"+met.getDate()+"</td></td>"+link+"</td></tr>");
         }
        html.append("</table>");
     }

     html.append("<h3>IV Data</h3>");
     html.append("<table border=1>");
     html.append("<tr><td>Component</td><td>Location</td><td>Date</td><td>150V</td><td>350V</td><td>500V</td><td>Temperature</td><td>Data</td></tr>\n");
     ModuleIVInfo ivInfo = new ModuleIVInfo(serno,sensorList);
     html.append("<tr><td>Sensor Sum</td><td>"+ivInfo.getOrigin()+"</td><td> - </td>");
     double i150sensor = ivInfo.geti150SensorCurrent();
     double i350sensor = ivInfo.geti350SensorCurrent();
     double i500sensor = ivInfo.geti500SensorCurrent();
     html.append("<td>"+ivFormatter.format(i150sensor)+"</td><td>"+ivFormatter.format(i350sensor)+"</td><td>"+ivFormatter.format(i500sensor)+"</td><td>"+ivInfo.getTemperatureRange()+"</td><td> - </td></tr>");
     for(int i=0;i<ivInfo.noModuleIVs();i++) {
        ModuleIV mIV = ivInfo.getModuleIV(i);
        html.append("<tr><td>Module</td><td>"+mIV.getLocation()+"</td><td>"+mIV.getDate()+"</td>");
        double i150 = mIV.geti150();
        if(i150==0.) html.append("<td> - </td>");
        else {
          if(i150sensor>0. && i150>(i150sensor*1.25)) html.append("<td><font color=red>"+ivFormatter.format(i150)+"</td>");
          else html.append("<td>"+ivFormatter.format(i150)+"</td>");
          }
        double i350 = mIV.geti350();
        if(i350==0.) html.append("<td> - </td>");
        else {
          if(i350sensor>0. && i350>(i350sensor*1.25)) html.append("<td><font color=red>"+ivFormatter.format(i350)+"</td>");
          else html.append("<td>"+ivFormatter.format(i350)+"</td>");
          }
        double i500 = mIV.geti500();
        if(i500==0.) html.append("<td> - </td>");
        else {
          if(i500sensor>0. && i500>(i500sensor*1.25)) html.append("<td><font color=red>"+ivFormatter.format(i500)+"</font></td>");
          else html.append("<td>"+ivFormatter.format(i500)+"</td>");
          }
        html.append("<td>"+mIV.getTemperature()+"</td>");
        String plotLink = mIV.getLink();
        if(plotLink==null) html.append("<td> - </td>");
        else {
          boolean isPostscript = (plotLink.endsWith(".ps") || plotLink.endsWith(".ps.gz"));
          String link = isPostscript ?  "Type"+Integer.toString(guiUtilities.HTMLViewer.URLTOPOSTSCRIPT)+"&ref="+plotLink : plotLink;
          html.append("<td><a href=\""+link+"\">Plot</a></td>");
          }
        html.append("</tr>");
        }
     html.append("</table>");
// now module quality - for barrels only
     if(moduleInfo.isBarrelModule()) {
       if(signoffInfo!=null) {
         html.append("<h3>IV Quality Information</h3>");
         Hashtable signoffDataHash = signoffInfo.getSignoffDataHash();
         if(signoffDataHash.size()==0) html.append("<p>None uploaded");
         else {
            html.append("<table border=1>");
            int count=1;
            for (java.util.Enumeration e = signoffDataHash.keys() ; e.hasMoreElements() ;) {
              String location  = (String)e.nextElement();      
              html.append("<tr><td colspan=2><font color=navy>"+Integer.toString(count)+" - "+signoffInfo.getUploaderInfo(location)+"</font></td></tr>");
              html.append("<tr><td align=right valign=top><font color=navy>Category: </font></td><td>"+signoffInfo.getString(location,ModuleSignoffData.IVCATEGORY,true)+"</td></tr>");
              html.append("<tr><td align=right valign=top><font color=navy>Comments: </font></td><td>"+signoffInfo.getString(location,ModuleSignoffData.IVCOMMENT,true)+"</td></tr>");
              count++;
              }
            html.append("</table>");
           }
        }
      }

     ModuleSCTDAQInfo sctdaqInfo = new ModuleSCTDAQInfo(serno);
     html.append("<h3>SCTDAQ Characterisations</h3>\n");

     if(sctdaqInfo.noTests()>0) {
       html.append("<table border=1>\n");
       html.append("<tr><td>Location</td><td>Date</td><td>Temperature</td><td>DeltaT</td><td colspan=2 align=center>Excluding Trim Defects</td><td colspan=2 align=center>Including Trim Defects</td><td>Link</td><td>Failed Tests</td></tr>\n");
       html.append("<tr><td></td><td></td><td></td><td></td><td>N(defects)</td><td>N(consecutive)</td><td>N(defects)</td><td>N(consecutive)</td><td></td><td></td></tr>\n");
       for(int i=0;i<sctdaqInfo.noTests();i++) {
         SCTDAQCharacterisation sctdaq = sctdaqInfo.getCharacterisation(i);
         String temperature = (sctdaq.getTemperature()>10.) ? "Warm" : "Cold";
         double deltaT = sctdaq.getDeltaT();
         String deltaTS = new java.text.DecimalFormat("#.###").format(deltaT);
         String dT = (Math.abs(deltaT)>=1.) ? "<font color=red>"+deltaTS+"</font>" : deltaTS;
         html.append("<tr><td valign=top>"+sctdaq.getLocation()+"</td><td valign=top>"+sctdaq.getDate()+"</td><td valign=top>"+temperature+"</td><td valign=top>"+dT+"</td>");
         html.append("<td valign=top>"+Integer.toString(sctdaq.nDefects(2))+"</td><td valign=top>"+Integer.toString(sctdaq.nDefects(3))+"</td>");
         html.append("<td valign=top>"+Integer.toString(sctdaq.nDefects(0))+"</td><td valign=top>"+Integer.toString(sctdaq.nDefects(1))+"</td>");
         String weblink = serno+"__"+sctdaq.getLocation()+"__"+sctdaq.getDate()+"__"+temperature;
         html.append("<td valign=top><a href=\"Type"+Integer.toString(guiUtilities.HTMLViewer.SCTDAQTESTLIST)+"&ref="+weblink+"\">Characterisation Report</a></td>");
         html.append("<td valign=top>");
         Set failedTests = sctdaq.getFailedTests();
         if(failedTests.size()==0) html.append(" - </td>");
         else {
             int count=0;
             for (Iterator k = failedTests.iterator(); k.hasNext(); ) {
                         if(count>0) html.append("<br>");
                         html.append((String)k.next());
                         count++;
                         }
             html.append("</td>");
           }
         html.append("</tr>\n");
         }    
       html.append("</table>"); 
       html.append("<br><a href=\"Type"+Integer.toString(guiUtilities.HTMLViewer.SCTDAQTESTLIST)+"&ref="+serno+"__\">Click here</a> for a full report of *all* sctdaq tests performed on this module.");
       }
     else html.append("None uploaded.<br>");
// now module quality - for barrels only
     if(moduleInfo.isBarrelModule()) {
//       if(!serno.startsWith("202203302")) signoffInfo = new SignoffDataInterface(serno,"SIGNOFF");
       html.append("<h3>Module Quality Information</h3>");
       Hashtable signoffDataHash = signoffInfo.getSignoffDataHash();
       if(signoffDataHash.size()==0) html.append("None uploaded");
       else {
          html.append("<table border=1>");
          int count=1;
          for (java.util.Enumeration e = signoffDataHash.keys() ; e.hasMoreElements() ;) {
              String location  = (String)e.nextElement();      
              html.append("<tr><td colspan=2><font color=navy>"+Integer.toString(count)+" - "+signoffInfo.getUploaderInfo(location)+"</font></td></tr>");
              html.append("<tr><td align=right valign=top><font color=navy>Category: </font></td><td valign=top>"+signoffInfo.getString(location,ModuleSignoffData.ELECTRICALCATEGORY,true)+"</td></tr>");
              html.append("<tr><td align=right valign=top><font color=navy>Comments: </font></td><td valign=top>"+signoffInfo.getString(location,ModuleSignoffData.ELECTRICALCOMMENT,true)+"</td></tr>");     
              html.append("<tr><td align=right valign=top><font color=navy>SCurve Category: </font></td><td valign=top>"+signoffInfo.getString(location,ModuleSignoffData.SCURVECATEGORY,true)+"</td></tr>");
              html.append("<tr><td align=right valign=top><font color=navy>SCurve Comments: </font></td><td valign=top>"+signoffInfo.getString(location,ModuleSignoffData.SCURVECOMMENT,true)+"</td></tr>");
              count++;
              }
           html.append("</table>");
         }
      }
     html.append(guiUtilities.DaveUtils.getHTMLFooter());
     return html.toString();
     }
//*************************************************************************
   public static String getSensorMfrHTMLTable(Vector snList) throws Exception {

      StringBuffer genTable = new StringBuffer("<h3>General Wafer Properties</h3>\n");

      String serialNos = (String)snList.elementAt(0);
      for(int i=1;i<snList.size();i++) serialNos+=","+snList.elementAt(i);

      StringBuffer sqlStat = new StringBuffer("SELECT ");
      sqlStat.append(" tests.ser_no,substr_orient,substr_origin,thickness,i_leak_150,i_leak_350,temperature FROM tests,tstdetmfrs");
      sqlStat.append(" WHERE tests.ser_no IN ("+serialNos+") AND tests.test_name='DetMfrSheet' AND tstdetmfrs.test_no=tests.test_no");
      sqlStat.append(" ORDER BY tests.ser_no");

      Statement statement = SCTDBInterface.getInstance().connection.createStatement();
      ResultSet resultSet = statement.executeQuery(sqlStat.toString());
      int nCount=0;

     for(boolean n = resultSet.next() ; n==true ; n=resultSet.next() ){
        if(nCount==0) {
          genTable.append("<table cellspacing=5 border=1>\n");
          for(int i=0;i<4;i++) genTable.append("<col width=*>\n");
          genTable.append("<tr><td><b>Serial Number</b></td><td><b>Orientation</b></td><td><b>Origin</b></td><td><b>Thickness(um)</b></td></tr>");
          }
        nCount++;
        genTable.append("<tr>");
        for(int i=1;i<=4;i++) genTable.append("<td>"+resultSet.getString(i)+"</td>");
        genTable.append("</tr>\n");
        }
      statement.close();
      if(nCount==0) genTable.append("<p>No data available\n");
      else genTable.append("</table>");
      return genTable.toString();
      }
//******************************************************************************************************************
   public static String getSensorIVHTMLTable(Vector snList) throws Exception {
      SCTDBInterface db = SCTDBInterface.getInstance();
      Hashtable tempHash;
      Hashtable atlasHash = new Hashtable();
      Vector tempList;
      Vector mfrList = new Vector();
      StringBuffer ivTable = new StringBuffer("<h3>IV Data</h3>\n");
      String serialNos = (String)snList.elementAt(0);
      for(int i=1;i<snList.size();i++) serialNos+=","+snList.elementAt(i);

      StringBuffer sqlStat = new StringBuffer("SELECT ");
      sqlStat.append(" tests.ser_no,tests.locn_name,tests.test_date,i_leak_150,i_leak_350,temperature FROM tests,tstdetmfrs");
      sqlStat.append(" WHERE tests.ser_no IN ("+serialNos+") AND tests.test_name='DetMfrSheet' AND tstdetmfrs.test_no=tests.test_no");
      sqlStat.append(" ORDER BY tests.ser_no");

      Statement statement = db.connection.createStatement();

     ResultSet resultSet = statement.executeQuery(sqlStat.toString());
     int nCount=0;

     for(boolean n = resultSet.next() ; n==true ; n=resultSet.next() ){
        String sn = resultSet.getString(1);
        tempHash = new Hashtable();
        tempHash.put("SERIALNO",sn);
        tempHash.put("NAME",resultSet.getString(2));
        tempHash.put("DATE",guiUtilities.DaveUtils.extractDate(resultSet.getString(3)));
        tempHash.put("I150",resultSet.getString(4));
        tempHash.put("I350",resultSet.getString(5));
        tempHash.put("TEMP",resultSet.getString(6));
        tempHash.put("STATUS","Pass");
        tempHash.put("COMNTS","None.");
        mfrList.addElement(tempHash);
        nCount++;
        }
     statement.close();

     sqlStat = new StringBuffer("SELECT ");
     sqlStat.append("tests.test_no,tests.ser_no,tests.locn_name,tests.test_date,tests.problem,tests.pass,tstdetivs.temperature,tstdetivs.i_leak_150,tstdetivs.i_leak_350");
     sqlStat.append(" FROM tests,tstdetivs");
     sqlStat.append(" WHERE tests.ser_no IN ("+serialNos+")");
     sqlStat.append(" AND tests.test_name='DetIVscan'");
     sqlStat.append(" AND tstdetivs.test_no=tests.test_no");
     sqlStat.append(" ORDER BY tests.ser_no,tests.test_no");

     statement = db.connection.createStatement();
     resultSet = statement.executeQuery(sqlStat.toString());

     for(boolean n = resultSet.next() ; n==true ; n=resultSet.next() ){
        tempHash = new Hashtable();
        String sn = resultSet.getString(2);
        if(atlasHash.containsKey(sn)) tempList = (Vector)atlasHash.get(sn);
        else tempList = new Vector();
        tempHash.put("TESTNO",resultSet.getString(1));
        tempHash.put("SERIALNO",resultSet.getString(2));
        tempHash.put("NAME",resultSet.getString(3));
        tempHash.put("DATE",guiUtilities.DaveUtils.extractDate(resultSet.getString(4)));
        String problemFlag = resultSet.getString(5);
        String passFlag = resultSet.getString(6);
        String statusFlag; 
        if(passFlag.equals("YES")) {
             statusFlag = (problemFlag.equals("YES")) ? "PROBLEM" : "Pass";
             }
        else statusFlag = "FAIL";
        tempHash.put("STATUS",statusFlag);
        tempHash.put("TEMP",resultSet.getString(7));
        tempHash.put("I150",resultSet.getString(8));
        tempHash.put("I350",resultSet.getString(9));
        tempList.addElement(tempHash);
        atlasHash.put(sn,tempList);
        nCount++;
        }
       statement.close();

// now get the comments, if any
      String subQuery = sqlStat.toString();
      subQuery = subQuery.substring(subQuery.indexOf("WHERE"),subQuery.indexOf("AND tstdetivs")-1);
      Hashtable commentsHash = GeneralUtilities.testComments(subQuery);

// Now build the html table!!!
      for(int i=0;i<mfrList.size();i++) {
        if(i==0) {
          ivTable.append("<table cellspacing=5 border=1>\n");
          for(int j=0;j<8;j++) ivTable.append("<col width=*>\n");
          ivTable.append("<tr><td nowrap><b>Serial Number</b></td><td nowrap><b>Location</b></td><td nowrap><b>Date</b></td><td nowrap><b>I@150V</b></td><td nowrap><b>I@350V</b></td><td nowrap><b>Temp(C)</b></td><td nowrap><b>Status</b></td><td nowrap><b>Remarks</b></td></tr>\n");
           }
        ivTable.append("<tr>");
        tempHash = (Hashtable)mfrList.elementAt(i);
        String sn = (String)tempHash.get("SERIALNO");
        String locn = (String)tempHash.get("NAME");
        String date = (String)tempHash.get("DATE");
        String i150 = (String)tempHash.get("I150");
        String i350 = (String)tempHash.get("I350");
        String temp = (String)tempHash.get("TEMP");
        String status = (String)tempHash.get("STATUS");
        String remarks = (String)tempHash.get("COMNTS");
        ivTable.append("<td>"+sn+"</td><td>"+locn+"</td><td>"+date+"</td><td>"+i150+"</td><td>"+i350+"</td><td>"+temp+"</td><td>"+status+"</td><td>"+remarks+"</td></tr>\n");
        if(atlasHash.containsKey(sn)) {
            tempList = (Vector)atlasHash.get(sn);
            for(int j=0;j<tempList.size();j++) {
              tempHash = (Hashtable)tempList.elementAt(j);
              String testno = (String)tempHash.get("TESTNO");
              sn = (String)tempHash.get("SERIALNO");
              locn = "<font color=green>"+(String)tempHash.get("NAME")+"</font>";
              date = (String)tempHash.get("DATE");
              i150 = (String)tempHash.get("I150");
              i350 = (String)tempHash.get("I350");
              temp = (String)tempHash.get("TEMP");
              status = (String)tempHash.get("STATUS");
              if(!status.equals("Pass")) status = "<font color=red>"+status+"</font>";
              remarks="None.";
              if(commentsHash.containsKey(testno)) remarks = (String)commentsHash.get(testno);
              if(!remarks.equals("None.")) remarks = "<font color=red>"+remarks+"</font>";
              ivTable.append("<tr><td>"+sn+"</td><td>"+locn+"</td><td>"+date+"</td><td>"+i150+"</td><td>"+i350+"</td><td>"+temp+"</td><td>"+status+"</td><td nowrap>"+remarks+"</td></tr>\n");
              }
          }
         }
      if(nCount==0) ivTable.append("<p>No data available\n");
      else ivTable.append("</table>");
      return ivTable.toString();
      }

//******************************************************************************************************************
   public static String getSensorDepletionHTMLTable(Vector snList) throws Exception {
      SCTDBInterface db = SCTDBInterface.getInstance();
      Hashtable tempHash;
      Hashtable atlasHash = new Hashtable();
      Vector tempList;
      Vector mfrList = new Vector();
      StringBuffer ivTable = new StringBuffer("<h3>Depletion Voltages</h3>\n");
      String serialNos = (String)snList.elementAt(0);
      for(int i=1;i<snList.size();i++) serialNos+=","+snList.elementAt(i);

      StringBuffer sqlStat = new StringBuffer("SELECT ");
      sqlStat.append(" tests.ser_no,tests.locn_name,tests.test_date,v_dep FROM tests,tstdetmfrs");
      sqlStat.append(" WHERE tests.ser_no IN ("+serialNos+") AND tests.test_name='DetMfrSheet' AND tstdetmfrs.test_no=tests.test_no");
      sqlStat.append(" ORDER BY tests.ser_no");

      Statement statement = db.connection.createStatement();
      ResultSet resultSet = statement.executeQuery(sqlStat.toString());
      int nCount=0;

      for(boolean n = resultSet.next() ; n==true ; n=resultSet.next() ){
        String sn = resultSet.getString(1);
        tempHash = new Hashtable();
        tempHash.put("SERIALNO",sn);
        tempHash.put("NAME",resultSet.getString(2));
        tempHash.put("DATE",guiUtilities.DaveUtils.extractDate(resultSet.getString(3)));
        tempHash.put("VDEP",resultSet.getString(4));
        tempHash.put("STATUS","Pass");
        tempHash.put("COMNTS","None.");
        mfrList.addElement(tempHash);
        nCount++;
        }

     statement.close();

     sqlStat = new StringBuffer("SELECT ");
     sqlStat.append("tests.test_no,tests.ser_no,tests.locn_name,tests.test_date,tests.problem,tests.pass,tstdetopts.v_dep");
     sqlStat.append(" FROM tests,tstdetopts");
     sqlStat.append(" WHERE tests.ser_no IN ("+serialNos+")");
     sqlStat.append(" AND tests.test_name='DetVDep'");
     sqlStat.append(" AND tstdetopts.test_no=tests.test_no");
     sqlStat.append(" ORDER BY tests.ser_no,tests.test_no");
     statement = db.connection.createStatement();
     resultSet = statement.executeQuery(sqlStat.toString());

     for(boolean n = resultSet.next() ; n==true ; n=resultSet.next() ){
        tempHash = new Hashtable();
        String sn = resultSet.getString(2);
        if(atlasHash.containsKey(sn)) tempList = (Vector)atlasHash.get(sn);
        else tempList = new Vector();
        tempHash.put("TESTNO",resultSet.getString(1));
        tempHash.put("SERIALNO",resultSet.getString(2));
        tempHash.put("NAME",resultSet.getString(3));
        tempHash.put("DATE",guiUtilities.DaveUtils.extractDate(resultSet.getString(4)));
        String problemFlag = resultSet.getString(5);
        String passFlag = resultSet.getString(6);
        String statusFlag; 
        if(passFlag.equals("YES")) {
             statusFlag = (problemFlag.equals("YES")) ? "PROBLEM" : "Pass";
             }
        else statusFlag = "FAIL";
        tempHash.put("STATUS",statusFlag);
        tempHash.put("VDEP",resultSet.getString(7));
        tempList.addElement(tempHash);
        atlasHash.put(sn,tempList);
        nCount++;
        }
      statement.close();

// now get the comments, if any
      String subQuery = sqlStat.toString();
      subQuery = subQuery.substring(subQuery.indexOf("WHERE"),subQuery.indexOf("AND tstdetopts")-1);
      Hashtable commentsHash = GeneralUtilities.testComments(subQuery);

// Now build the html table!!!
      for(int i=0;i<mfrList.size();i++) {
        if(i==0) {
          ivTable.append("<table cellspacing=5 border=1>\n");
          for(int j=0;j<8;j++) ivTable.append("<col width=*>\n");
          ivTable.append("<tr><td nowrap><b>Serial Number</b></td><td nowrap><b>Location</b></td><td nowrap><b>Date</b></td><td nowrap><b>Depletion</b></td><td nowrap><b>Status</b></td><td nowrap><b>Remarks</b></td></tr>\n");
           }
        ivTable.append("<tr>");
        tempHash = (Hashtable)mfrList.elementAt(i);
        String sn = (String)tempHash.get("SERIALNO");
        String locn = (String)tempHash.get("NAME");
        String date = (String)tempHash.get("DATE");
        String vdep = (String)tempHash.get("VDEP");
        String status = (String)tempHash.get("STATUS");
        String remarks = (String)tempHash.get("COMNTS");
        ivTable.append("<td>"+sn+"</td><td>"+locn+"</td><td>"+date+"</td><td>"+vdep+"</td><td>"+status+"</td><td>"+remarks+"</td></tr>\n");
        if(atlasHash.containsKey(sn)) {
            tempList = (Vector)atlasHash.get(sn);
            for(int j=0;j<tempList.size();j++) {
              tempHash = (Hashtable)tempList.elementAt(j);
              String testno = (String)tempHash.get("TESTNO");
              sn = (String)tempHash.get("SERIALNO");
              locn = "<font color=green>"+(String)tempHash.get("NAME")+"</font>";
              date = (String)tempHash.get("DATE");
              vdep = (String)tempHash.get("VDEP");
              status = (String)tempHash.get("STATUS");
              if(!status.equals("Pass")) status = "<font color=red>"+status+"</font>";
              remarks="None.";
              if(commentsHash.containsKey(testno)) remarks = (String)commentsHash.get(testno);
              if(!remarks.equals("None.")) remarks = "<font color=red>"+remarks+"</font>";
              ivTable.append("<tr><td>"+sn+"</td><td>"+locn+"</td><td>"+date+"</td><td>"+vdep+"</td><td>"+status+"</td><td nowrap>"+remarks+"</td></tr>\n");
              }
          }
         }
      if(nCount==0) ivTable.append("<p>No data available\n");
      else ivTable.append("</table>");
      return ivTable.toString();
      }

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      public static String getSensorDefectHTMLTable(Vector snList) throws Exception {
      SCTDBInterface db = SCTDBInterface.getInstance();
      Vector itemList = new Vector();
      String serialNos = (String)snList.elementAt(0);
      for(int i=1;i<snList.size();i++) serialNos+=","+snList.elementAt(i);
      Vector dets = new Vector();
      Vector theLine;
      String[] defectNames = {"Pinhole","Oxide-Punchthrough","Short","Open","Implant-Open","Implant-Short","Resistor-Break"};
      Hashtable nameHash = new Hashtable();
      int ndefectTypes = defectNames.length;
      Hashtable[] defectCount = new Hashtable[ndefectTypes];
      Hashtable[] defectList = new Hashtable[ndefectTypes];

      StringBuffer ivTable = new StringBuffer("<h3>Defects Summary</h3>\n");
      for(int i=0;i<ndefectTypes;i++) {
           nameHash.put(defectNames[i],new Integer(i));
           defectCount[i] = new Hashtable();
           defectList[i] = new Hashtable();
           }

      Hashtable totalCount = new Hashtable();
      Hashtable serialNoHash = new Hashtable();
      Hashtable dateHash = new Hashtable();
      Hashtable locationHash = new Hashtable();

      String ser_no="",test_no="";
      String test_date,defect_name,chan1,chanlast;


// first get a list of all the tests, so that we know what detectors have zero defects..
      StringBuffer sqlStat = new StringBuffer("SELECT tests.test_no,tests.ser_no,tests.test_date,tests.locn_name FROM tests");
      sqlStat.append(" WHERE tests.ser_no IN ("+serialNos+")");
      sqlStat.append(" AND ( tests.test_name='DetDefect' OR tests.test_name='DetMfrSheet')");
// ordering by serial number only
      sqlStat.append(" ORDER BY tests.ser_no,tests.test_no"); 
      String string1 = sqlStat.toString();


 //     System.out.println(string1);
      Statement statement = db.connection.createStatement();
      ResultSet resultSet = statement.executeQuery(string1);
      int nCount=0;
      for(boolean n = resultSet.next() ; n==true ; n=resultSet.next() ){
          nCount++;
          ser_no = resultSet.getString(2);
          test_no = resultSet.getString(1);
          String date = resultSet.getString(3);
          date = guiUtilities.DaveUtils.extractDate(date);
          dateHash.put(test_no,date);
          String location_name = resultSet.getString(4);
          locationHash.put(test_no,location_name);
          for(int i=0;i<ndefectTypes;i++) {
             defectCount[i].put(test_no,new Integer(0));
             defectList[i].put(test_no,"");
             }
          totalCount.put(test_no,new Integer(0));
          serialNoHash.put(test_no,ser_no);
          dets.addElement(test_no);
	  }
      statement.close();
      String subQuery = string1;

// need a subquery so that we are looking at the same test numbers!
      int in1 = subQuery.indexOf("FROM");
      int in2 = subQuery.indexOf("ORDER")-1;
      subQuery = "SELECT tests.test_no "+subQuery.substring(in1,in2);

      sqlStat = new StringBuffer("SELECT tests.ser_no,tests.test_no,defect_name,chan_1st,chan_last");
      sqlStat.append(" FROM tests,defects");
      sqlStat.append(" WHERE tests.ser_no IN ("+serialNos+")");
      sqlStat.append(" AND defects.test_no=tests.test_no");
      sqlStat.append(" AND tests.test_no IN ("+subQuery+")");     
      sqlStat.append(" ORDER BY tests.ser_no,tests.test_no");
      String string2 = sqlStat.toString();

      statement = db.connection.createStatement();
      resultSet = statement.executeQuery(string2);
      String olddata;
      for(boolean n = resultSet.next() ; n==true ; n=resultSet.next() ){
          nCount++;
          ser_no = resultSet.getString(1);
          test_no = resultSet.getString(2);
          defect_name = resultSet.getString(3);
          chan1 = resultSet.getString(4);
          chanlast = resultSet.getString(5);
          int i1 = Integer.parseInt(chan1);
          int i2 = Integer.parseInt(chanlast);

          if(nameHash.containsKey(defect_name)) {
             int idefect = ((Integer)nameHash.get(defect_name)).intValue();

             int defCount = ((Integer)defectCount[idefect].get(test_no)).intValue();
             int totalDefectCount = ((Integer)totalCount.get(test_no)).intValue();
             String defList = (String)defectList[idefect].get(test_no);
             for(int j=i1;j<=i2;j++) {
                  if(!defList.equals("")) defList+=",";
                  defList += Integer.toString(j);
                  defCount++;
                  totalDefectCount++;
                  }
             defectCount[idefect].put(test_no,new Integer(defCount));
             defectList[idefect].put(test_no,defList);
             totalCount.put(test_no,new Integer(totalDefectCount));

             }   
             else System.out.println("**WARNING** Strange defect declaration for "+ser_no+" was ignored: "+defect_name);          
	    }
        statement.close();
 
        for(int i=0;i<dets.size();i++) {
          if(i==0) {
            ivTable.append("<table cellspacing=5 border=1>\n");
            for(int j=0;j<11;j++) ivTable.append("<col width=* nowrap>\n");
            ivTable.append("<tr><td nowrap><b>Serial Number</b></td><td nowrap><b>Location</b></td><td nowrap><b>Date</b></td><td nowrap><b>#Defects</b></td>");
            for(int j=0;j<ndefectTypes;j++) {
                    if(defectNames[j].equals("Oxide-Punchthrough")) ivTable.append("<td nowrap><b>Oxide-PT</b></td>");
                    else if(defectNames[j].equals("Implant-Open")) ivTable.append("<td nowrap><b>Implant-O</b></td>");
                    else if(defectNames[j].equals("Implant-Short")) ivTable.append("<td nowrap><b>Implant-S</b></td>");
                    else if(defectNames[j].equals("Resistor-Break")) ivTable.append("<td nowrap><b>Resistor</b></td>");
                    else ivTable.append("<td nowrap><b>"+defectNames[j]+"</b></td>");
                    }
             }
            ivTable.append("\n<tr>");
            theLine = new Vector();
            String testno = (String)dets.elementAt(i); // this contains the testno's, ordered by serial no
            String serialno = (String)serialNoHash.get(testno);
            ivTable.append("<td>"+serialno+"</td>");
            String locn = (String)locationHash.get(testno);
            if(!locn.equals("Hamamatsu") && !locn.equals("CiS")) locn = "<font color=green>"+locn+"</font>";
            ivTable.append("<td>"+locn+"</td>");                               // 2nd column is test location
            ivTable.append("<td>"+(String)dateHash.get(testno)+"</td>");       // date
            ivTable.append("<td>"+((Integer)totalCount.get(testno)).toString()+"</td>");  // 4th column is total # defects
            for(int j=0;j<ndefectTypes;j++) {
                String defList = (String)defectList[j].get(testno);
                if(!defList.equals("")) defList=" ("+defList+")";
                ivTable.append("<td nowrap>"+((Integer)defectCount[j].get(testno)).toString()+defList+"</td>");
                }
            ivTable.append("</tr>");
           }
      if(nCount==0) ivTable.append("No data available...");
      else ivTable.append("\n</table>");

      return ivTable.toString();
	}
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    public static String getSensorVisualTestHTMLTable(Vector snList) throws Exception {
      String testnoKey = "TESTNO";
      String snKey = "SERIALNO";
      String dateKey = "DATE";
      String locationKey = "LOCN";
      String flagKey = "FLAG";
      Hashtable testnoHash = new Hashtable();
      Vector testnoList = new Vector();
      String serialNos = (String)snList.elementAt(0);
      for(int i=1;i<snList.size();i++) serialNos+=","+snList.elementAt(i);

      StringBuffer ivTable = new StringBuffer("<h3>Visual Inspection Results</h3>\n");

     StringBuffer sqlStat = new StringBuffer("SELECT ");
     sqlStat.append("tests.test_no,tests.ser_no,tests.test_date,tests.locn_name,tests.problem,tests.pass");
     sqlStat.append(" FROM tests");
     sqlStat.append(" WHERE tests.ser_no IN ("+serialNos+")");
     sqlStat.append(" AND tests.test_name='Visual_Inspection'");
     sqlStat.append(" ORDER BY tests.ser_no,tests.test_no");

     Statement statement = SCTDBInterface.getInstance().connection.createStatement();
     ResultSet resultSet = statement.executeQuery(sqlStat.toString());
     int nCount=0;
     for(boolean n = resultSet.next() ; n==true ; n=resultSet.next() ){
          Hashtable thisHash = new Hashtable();
          nCount++;
          String testno = resultSet.getString(1);
          thisHash.put(snKey,resultSet.getString(2));
          String date = resultSet.getString(3);
          thisHash.put(dateKey,guiUtilities.DaveUtils.extractDate(date));
          thisHash.put(locationKey,"<font color=green>"+resultSet.getString(4)+"</font>");
          String problemFlag = resultSet.getString(5);
          String passFlag = resultSet.getString(6);
          String statusFlag; 
          if(passFlag.equals("YES")) {
             statusFlag = (problemFlag.equals("YES")) ? "<font color=red>PROBLEM</font>" : "Pass";
             }
          else statusFlag = "<font color=red>FAIL</font>";
          thisHash.put(flagKey,statusFlag);
          testnoHash.put(testno,thisHash);   
          testnoList.addElement(testno);  

	    }

      statement.close();

// now get the comments, if any
      String subQuery = sqlStat.toString();
      subQuery = subQuery.substring(subQuery.indexOf("WHERE"),subQuery.indexOf("ORDER")-1);
      Hashtable commentsHash = GeneralUtilities.testComments(subQuery);
      Hashtable testImagesHash = GeneralUtilities.testImages(subQuery);

      StringBuffer picList = new StringBuffer("\n<h3>Image List:</h3>\n");
      int imageCount=0;
      for(int i=0;i<testnoList.size();i++) {
          if(i==0) {
            ivTable.append("<table cellspacing=5 border=1>\n");
            for(int j=0;j<6;j++) ivTable.append("<col width=* nowrap>\n");
            ivTable.append("<tr><td nowrap><b>Serial Number</b></td><td nowrap><b>Location</b></td><td nowrap><b>Date</b></td><td nowrap><b>Status</b></td><td nowrap><b>Remarks</b></td><td><b>Pictures</b></td>");           
            }
            ivTable.append("\n<tr>");


            String testno = (String)testnoList.elementAt(i); // this contains the testno's, ordered by serial no
            Hashtable tempHash = (Hashtable)testnoHash.get(testno);
            ivTable.append("<td>"+(String)tempHash.get(snKey)+"</td>");;                  // first column is serial number
            ivTable.append("<td>"+(String)tempHash.get(locationKey)+"</td>");              
            ivTable.append("<td>"+(String)tempHash.get(dateKey)+"</td>");                                    // 3rd column is the date

            ivTable.append("<td>"+(String)tempHash.get(flagKey)+"</td>");
            if(commentsHash.containsKey(testno)) ivTable.append("<td nowrap>"+(String)commentsHash.get(testno)+"</td>");
            else ivTable.append("<td></td>");
            if(testImagesHash.containsKey(testno)) {
               Vector imageList = (Vector)testImagesHash.get(testno);

               for(int j=0;j<imageList.size()/2; j++) {
                   imageCount++;
                   String imageCaption = (String)imageList.elementAt(2*j);  
                   String imageName = (String)imageList.elementAt((2*j)+1);
                   File theImageFile = new File(PreferencesInterface.getInstance().getPreference(PreferencesInterface.SCRATCH_DIR),imageName);
                   GeneralUtilities.saveImage(testno,imageName,theImageFile);
                   picList.append("\n<p>"+imageCaption+":");
                   picList.append("\n<p><img src="+imageName+">");
                   if(j==0) {
                              ivTable.append("<td nowrap>"+imageCaption+"</td></tr>");
                              }
                   else {

                              ivTable.append("\n<tr>");
                              ivTable.append("<td>"+(String)tempHash.get(snKey)+"</td>");
                              ivTable.append("<td></td>");
                              ivTable.append("<td></td>");
                              ivTable.append("<td></td>");
                              ivTable.append("<td></td>");
                              ivTable.append("<td nowrap>"+imageCaption+"</td>");  
                              ivTable.append("</tr>");                     
                          }

                      }
            }
            else ivTable.append("<td></td></tr>");
            }
      if(nCount==0) ivTable.append("No data available ...");
      else ivTable.append("</table>");
      if(imageCount>0) ivTable.append(picList);
      return ivTable.toString();


      }
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    public static String getImageHTMLTable(String testno) throws Exception {

      StringBuffer ivTable = new StringBuffer("<h3>Images</h3>\n");

     Statement statement = SCTDBInterface.getInstance().connection.createStatement();
     ResultSet resultSet = statement.executeQuery("SELECT title,name FROM test_images WHERE test_no ="+testno);
     Vector imageList = new Vector();
     for(boolean n = resultSet.next() ; n==true ; n=resultSet.next() ){
          String title = resultSet.getString(1);
          String name = resultSet.getString(2);
          imageList.addElement(title);
          imageList.addElement(name);
	  }

      statement.close();

      if(imageList.size()==0) {
        ivTable.append("None uploaded.");
        return ivTable.toString();
        }


      for(int j=0;j<imageList.size()/2; j++) {

         String imageCaption = (String)imageList.elementAt(2*j);  
         String imageName = (String)imageList.elementAt((2*j)+1);
         File theImageFile = new File(PreferencesInterface.getInstance().getPreference(PreferencesInterface.SCRATCH_DIR),imageName);
         GeneralUtilities.saveImage(testno,imageName,theImageFile);
         ivTable.append("\n<p>"+imageCaption+":");
         ivTable.append("\n<p><img src="+imageName+">");
         }
 
      return ivTable.toString();


      }

//***********************************************************************************
   public static String getHTMLModuleSummaryData(String ref) throws Exception {

      fillHashes();

      String location=null;
      String date=null;
      boolean isWarm=false;
      boolean isCold=false;
      
      String[] info = ref.split("__");
      String sn = info[0];
      System.out.println("Downloading full sctdaq report for "+sn+". Be patient...");
      if(info.length==4) {
        location = info[1];
        date = info[2];
        isWarm = (info[3].equals("Warm"));
        isCold = (info[3].equals("Cold"));
        }

      SCTDBInterface db = SCTDBInterface.getInstance();
      StringBuffer testnames = new StringBuffer(" AND (tests.test_name LIKE 'Hyb%' OR tests.test_name LIKE 'DetModIV')");
      if(location!=null && date!=null) testnames.append(" AND tests.locn_name='"+location+"' AND tests.test_date='"+date+"'");
      if(isWarm) testnames.append(" AND sct_tstdcsinfo.t0>10 AND sct_tstdcsinfo.test_no=tests.test_no");
      else if(isCold) testnames.append(" AND sct_tstdcsinfo.t0<=10 AND sct_tstdcsinfo.test_no=tests.test_no");
      else testnames.append(" AND sct_tstdcsinfo.test_no=tests.test_no");
      StringBuffer genTable = new StringBuffer("<h3>Test Data</h3>\n");
// first look for defects
      StringBuffer sqlStat = new StringBuffer("SELECT tests.test_no,defects.CHAN_1ST,defects.CHAN_LAST FROM tests,DEFECTS,sct_tstdcsinfo");
      sqlStat.append(" WHERE tests.test_no=defects.test_no AND tests.ser_no="+sn);
      sqlStat.append(testnames);

// submit query
     Statement statement = db.connection.createStatement();
    if(DEBUG) System.out.println(sqlStat.toString());
     ResultSet resultSet = statement.executeQuery(sqlStat.toString());

// now get the data
     Hashtable defectsHash = new Hashtable();
     for(boolean n = resultSet.next() ; n==true ; n=resultSet.next() ){
          String thisTestNo = resultSet.getString(1);
          int n1 = Integer.parseInt(resultSet.getString(2));
          int n2 = Integer.parseInt(resultSet.getString(3));
          int ntotal=0;
          for(int i=n1;i<=n2;i++) ntotal++;
          if(defectsHash.containsKey(thisTestNo)) {
              String thisTotal = (String)defectsHash.get(thisTestNo);
              int ntot = Integer.parseInt(thisTotal);
              ntot+=ntotal;
              defectsHash.put(thisTestNo,(String)Integer.toString(ntot));
              }
          else defectsHash.put(thisTestNo,(String)Integer.toString(ntotal));
         }
      statement.close();
// now look for raw data files
      sqlStat = new StringBuffer("SELECT tests.test_no,tests.test_name,test_rawdata.filename FROM tests,test_rawdata,sct_tstdcsinfo");
      sqlStat.append(" WHERE tests.test_no=test_rawdata.test_no AND tests.ser_no="+sn);
      sqlStat.append(testnames);
 
// submit query
     statement = db.connection.createStatement();
//    System.out.println("Interrogating raw_data table ...");
    if(DEBUG) System.out.println(sqlStat.toString());
     resultSet = statement.executeQuery(sqlStat.toString());
// now get the raw data
     Hashtable rawDataHash = new Hashtable();
     for(boolean n = resultSet.next() ; n==true ; n=resultSet.next() ){
          String thisTestNo = resultSet.getString(1);
          String testname = resultSet.getString(2);
          String thisFilename = resultSet.getString(3);
          String linkName = "Raw Data";
          if(testname.equals("Hyb3PGain") || testname.equals("HybRC")) linkName="RC";
          if(testname.equals("HybTrim")) linkName = "Trim/Mask";
          String link="Type"+guiUtilities.HTMLViewer.RAWDATA+"&ref="+thisTestNo;
          if(rawDataHash.containsKey(thisTestNo)) {
              String thisLink = (String)rawDataHash.get(thisTestNo);
              thisLink += "<br><a href="+link+">"+linkName+"</a>";
              rawDataHash.put(thisTestNo,thisLink);
              }
          else rawDataHash.put(thisTestNo,"<a href="+link+">"+linkName+"</a>");
         }
      statement.close();
// now look for plots

      sqlStat = new StringBuffer("SELECT tests.test_no,tests.ser_no,web_links.web_link_desc,web_links.url FROM tests,web_links,sct_tstdcsinfo");
      sqlStat.append(" WHERE tests.test_no=web_links.test_no AND tests.ser_no="+sn);
      sqlStat.append(testnames);
 
// submit query
     statement = db.connection.createStatement();
    if(DEBUG) System.out.println(sqlStat.toString());
     resultSet = statement.executeQuery(sqlStat.toString());
// now get the raw data
     Hashtable webLinkHash = new Hashtable();
     for(boolean n = resultSet.next() ; n==true ; n=resultSet.next() ){
          String thisTestNo = resultSet.getString(1);
          String thisSN = resultSet.getString(2);
          String urlDescription = resultSet.getString(3);
          String thisURLlink = resultSet.getString(4);
          boolean isPostscript = (thisURLlink.endsWith(".ps") || thisURLlink.endsWith(".ps.gz"));
          if(thisURLlink.indexOf("http://hepunx.rl.ac.uk/atlassct/cgibin/getfile.pl?file=")!=-1) thisURLlink+="&module="+thisSN;
          if(isPostscript) thisURLlink= "Type"+guiUtilities.HTMLViewer.URLTOPOSTSCRIPT+"&ref="+thisURLlink;
          if(webLinkHash.containsKey(thisTestNo)) {
              String thisLink = (String)webLinkHash.get(thisTestNo);
              thisLink += "<br><a href="+thisURLlink+">"+urlDescription+"</a>";
              webLinkHash.put(thisTestNo,thisLink);
              }
          else webLinkHash.put(thisTestNo,"<a href="+thisURLlink+">"+urlDescription+"</a>");
         }
      statement.close();
// look for trim ranges

      sqlStat = new StringBuffer("SELECT tests.test_no,tr_type");
      for(int i=0;i<chipDBnames.length;i++) sqlStat.append(","+chipDBnames[i]+"tr_ntrim");
      sqlStat.append(" FROM tests,sct_tsthybtrim,sct_tstdcsinfo");
      sqlStat.append(" WHERE tests.test_no=sct_tsthybtrim.test_no AND tests.ser_no="+sn);
      sqlStat.append(" AND tests.test_name LIKE 'HybTrim'");
      sqlStat.append(testnames);
 
// submit query
     statement = db.connection.createStatement();
    if(DEBUG) System.out.println(sqlStat.toString());
     resultSet = statement.executeQuery(sqlStat.toString());
// now get the raw data
     Hashtable trimRangeHash = new Hashtable();
     Hashtable commentsHash = new Hashtable();
     for(boolean n = resultSet.next() ; n==true ; n=resultSet.next() ){
          String thisTestNo = resultSet.getString(1);
          String theRange = resultSet.getString(2);
          trimRangeHash.put(thisTestNo,theRange);
          int nMasked=0;
          for(int i=0;i<chipDBnames.length;i++) {
              String ntrim = resultSet.getString(3+i);
              int itrim = Integer.parseInt(ntrim);
              nMasked += (128-itrim);
              }
           if(nMasked>0) commentsHash.put(thisTestNo,Integer.toString(nMasked)+" channels masked");
         }
      statement.close();
// look for strobe delays

      sqlStat = new StringBuffer("SELECT tests.test_no");
      for(int i=0;i<chipDBnames.length;i++) sqlStat.append(","+chipDBnames[i]+"DELAY");
      sqlStat.append(" FROM tests,sct_tsthybdelay,sct_tstdcsinfo");
      sqlStat.append(" WHERE tests.test_no=sct_tsthybdelay.test_no AND tests.ser_no="+sn);
      sqlStat.append(" AND tests.test_name LIKE 'HybDelay'");
      sqlStat.append(testnames);
 
// submit query
     statement = db.connection.createStatement();
    if(DEBUG) System.out.println(sqlStat.toString());
     resultSet = statement.executeQuery(sqlStat.toString());
// now get the raw data

     for(boolean n = resultSet.next() ; n==true ; n=resultSet.next() ){
          String thisTestNo = resultSet.getString(1);
          int strobeLow=1000;
          int strobeHigh=0;
          for(int i=0;i<chipDBnames.length;i++) {
              String nStrobe = resultSet.getString(2+i);
              int iStrobe = Integer.parseInt(nStrobe);
              if(iStrobe>strobeHigh) strobeHigh=iStrobe;
              if(iStrobe<strobeLow) strobeLow=iStrobe;
              }
          commentsHash.put(thisTestNo,"Delay from "+strobeLow+" to "+strobeHigh);
         }
      statement.close();
// look for RC data

      sqlStat = new StringBuffer("SELECT tests.test_no");
      for(int i=0;i<chipDBnames.length;i++) sqlStat.append(","+chipDBnames[i]+"RC_MN_GAIN");
      for(int i=0;i<chipDBnames.length;i++) sqlStat.append(","+chipDBnames[i]+"RC_MN_ENC");
      sqlStat.append(" FROM tests,sct_tsthybrc,sct_tstdcsinfo");
      sqlStat.append(" WHERE tests.test_no=sct_tsthybrc.test_no AND tests.ser_no="+sn);
//      sqlStat.append(" AND (tests.test_name LIKE 'Hyb3PGain' OR tests.test_name LIKE 'HybRC')");
      sqlStat.append(testnames);
 
// submit query
     statement = db.connection.createStatement();
    if(DEBUG) System.out.println(sqlStat.toString());
     resultSet = statement.executeQuery(sqlStat.toString());
// now get the raw data

     for(boolean n = resultSet.next() ; n==true ; n=resultSet.next() ){
          String thisTestNo = resultSet.getString(1);
          double gainLow=1000.;
          double gainHigh=0.;
          int ENCLow=99000;
          int ENCHigh=0;
          for(int i=0;i<chipDBnames.length;i++) {
              double iGain = Double.valueOf( resultSet.getString(2+i) ).doubleValue();
              if(iGain>gainHigh) gainHigh = iGain;
              if(iGain<gainLow) gainLow=iGain;
              }
         for(int i=0;i<chipDBnames.length;i++) {
              int iNoise = Integer.valueOf( resultSet.getString(14+i) ).intValue();
              if(iNoise>ENCHigh) ENCHigh=iNoise;
              if(iNoise<ENCLow) ENCLow=iNoise;
              }
         commentsHash.put(thisTestNo,"Gain from "+gainLow+" to "+gainHigh+"mV/fC<br>Noise from "+ENCLow+" to "+ENCHigh+" ENC");
         }
      statement.close();
// Look for noise data

      sqlStat = new StringBuffer("SELECT tests.test_no");
      for(int i=0;i<chipDBnames.length;i++) sqlStat.append(","+chipDBnames[i]+"NO_MN_OCC");
      for(int i=0;i<chipDBnames.length;i++) sqlStat.append(","+chipDBnames[i]+"NO_NSE");
      sqlStat.append(" FROM tests,sct_tsthybnoise,sct_tstdcsinfo");
      sqlStat.append(" WHERE tests.test_no=sct_tsthybnoise.test_no AND tests.ser_no="+sn);
      sqlStat.append(" AND tests.test_name LIKE 'HybNoise'");
      sqlStat.append(testnames);
 
// submit query
     statement = db.connection.createStatement();
    if(DEBUG) System.out.println(sqlStat.toString());
     resultSet = statement.executeQuery(sqlStat.toString());
// now get the raw data

     for(boolean n = resultSet.next() ; n==true ; n=resultSet.next() ){
          String thisTestNo = resultSet.getString(1);
          double occLow=1000.;
          double occHigh=0.;
          int ENCLow=99000;
          int ENCHigh=0; 
          for(int i=0;i<chipDBnames.length;i++) {
              double iOcc = Double.valueOf( resultSet.getString(2+i) ).doubleValue();
              if(iOcc>occHigh) occHigh = iOcc;
              if(iOcc<occLow) occLow=iOcc;
              }
         for(int i=0;i<chipDBnames.length;i++) {
              int iNoise = Integer.valueOf( resultSet.getString(14+i) ).intValue();
              if(iNoise>ENCHigh) ENCHigh=iNoise;
              if(iNoise<ENCLow) ENCLow=iNoise;
              }
         DecimalFormat myFormatter = new DecimalFormat("0.##E0");
         String theOccLow = myFormatter.format(occLow);
         String theOccHigh = myFormatter.format(occHigh);
         commentsHash.put(thisTestNo,"Occupancy at 1fC from "+theOccLow+" to "+theOccHigh+"<brEstimated ENC from "+ENCLow+" to "+ENCHigh+" ENC");
         }
      statement.close();
// finally.. the timewalk data

      sqlStat = new StringBuffer("SELECT tests.test_no");
      for(int i=0;i<chipDBnames.length;i++) sqlStat.append(","+chipDBnames[i]+"TW");
      sqlStat.append(" FROM tests,sct_tsthybTW,sct_tstdcsinfo");
      sqlStat.append(" WHERE tests.test_no=sct_tsthybtw.test_no AND tests.ser_no="+sn);
//      sqlStat.append(" AND tests.test_name LIKE 'HybTwalk'");
      sqlStat.append(testnames);
 
// submit query
     statement = db.connection.createStatement();
    if(DEBUG) System.out.println(sqlStat.toString());
     resultSet = statement.executeQuery(sqlStat.toString());
// now get the raw data
     int ntw=0;
     for(boolean n = resultSet.next() ; n==true ; n=resultSet.next() ){
          String thisTestNo = resultSet.getString(1);
          double iTLow=1000;
          double iTHigh=0;
          ntw++;
          for(int i=0;i<chipDBnames.length;i++) {
              double iTW = Double.valueOf( resultSet.getString(2+i) ).doubleValue();
              if(iTW>iTHigh) iTHigh=iTW;
              if(iTW<iTLow) iTLow=iTW;
              }
         commentsHash.put(thisTestNo,"Timewalk from "+iTLow+" to "+iTHigh+" ns");
         }
      statement.close();

// now the actual test data
      System.out.println("Retrieved all data, now compiling list...");
      sqlStat = new StringBuffer("SELECT tests.test_no,tests.test_name,tests.test_date,tests.locn_name,tests.pass,tests.problem,sct_tstdcsinfo.t0,sct_tstdcsinfo.t1");
      sqlStat.append(" FROM tests,sct_tstdcsinfo WHERE tests.test_no=sct_tstdcsinfo.test_no AND tests.ser_no="+sn);
      sqlStat.append(testnames);
      sqlStat.append(" ORDER BY tests.test_date,tests.test_no");
// submit query
     statement = db.connection.createStatement();
//     System.out.println(sqlStat.toString());
     resultSet = statement.executeQuery(sqlStat.toString());
     int nCount=0;
// now get the data
     for(boolean n = resultSet.next() ; n==true ; n=resultSet.next() ){
        if(nCount==0) {
          genTable.append("<table cellspacing=5 border=1>\n");
          for(int i=0;i<10;i++) genTable.append("<col width=*>\n");
          genTable.append("<tr><td valign=top align=left><b>Test</b></td><td valign=top align=left><b>Date</b></td><td valign=top align=left><b>Location</b></td><td valign=top align=left><b>Status</b></td><td valign=top align=left><b>T0</b></td><td valign=top align=left><b>T1</b></td><td valign=top align=left><b>Comments</b></td><td valign=top align=left><b>Summary</b></td><td valign=top align=left><b>Raw Data</b></td><td valign=top align=left><b>Plots</b></td></tr>\n");
          }
        String thisTestNo = resultSet.getString(1);
        String thisTestName = resultSet.getString(2);
        String colTestName = sctdaqTestNameHash.containsKey(thisTestName) ? (String)sctdaqTestNameHash.get(thisTestName) : thisTestName;
        if(trimRangeHash.containsKey(thisTestNo)) {
             colTestName += "Range "+(String)trimRangeHash.get(thisTestNo);
             }
        String thisDate = guiUtilities.DaveUtils.extractDate(resultSet.getString(3));
        String thisLocation = resultSet.getString(4);
        String passFlag = resultSet.getString(5);
        String problemFlag = resultSet.getString(6);
        String statusFlag="<font color=red>FAIL</font>";
        if(passFlag.equals("YES")) {
             statusFlag = problemFlag.equals("YES") ? "Problem" : "<font color=green>Pass</font>";
             } 
        String t0 = resultSet.getString(7);
        String t1 = resultSet.getString(8);
        String comments = "";

        if(commentsHash.containsKey(thisTestNo)) {
               if(!comments.equals("")) comments += "<br>";
               comments += (String)commentsHash.get(thisTestNo);
               }
        if(defectsHash.containsKey(thisTestNo)) {
               if(!comments.equals("")) comments += "<br>";
               comments += "<b>"+(String)defectsHash.get(thisTestNo)+" defect(s)</b>";
               }
        else {
             if(!comments.equals("")) comments += "<br>";
             comments += "No defects";
             }
        int testType=-1;
        if(sctdaqTestNumberHash.containsKey(thisTestName)) testType = ((Integer)sctdaqTestNumberHash.get(thisTestName)).intValue();

        String linkTestName = (colTestName.indexOf("TrimRange")!=-1) ? "TrimRange" : colTestName;
        String reports = (testType==-1) ? "" : "<a href=\"Type"+guiUtilities.HTMLViewer.SCTDAQTESTDATA+"&ref="+thisTestNo+"__"+Integer.toString(testType)+"\">Test Report</a>";
        if(!sctdaqTestNameHash.containsKey(thisTestName)) reports=""; // no report for non-sctdaq tests for now
//        System.out.println("reportslink="+reports);
        String rawData = rawDataHash.containsKey(thisTestNo) ? (String)rawDataHash.get(thisTestNo) : "";
        String plots = webLinkHash.containsKey(thisTestNo) ? (String)webLinkHash.get(thisTestNo) : "";
        genTable.append("<tr><td valign=top align=left>"+colTestName+"</td><td valign=top align=left>"+thisDate+"</td><td valign=top align=left>"+thisLocation+"</td>");
        genTable.append("<td valign=top align=left>"+statusFlag+"</td><td valign=top align=left>"+t0+"</td><td valign=top align=left>"+t1+"</td><td valign=top align=left>"+comments+"</td>");
        genTable.append("<td valign=top align=left>"+reports+"</td><td valign=top align=left>"+rawData+"</td><td valign=top align=left>"+plots+"</td></tr>\n");

        nCount++;  
        }
      statement.close();
      if(nCount==0) {genTable.append("<p>No tests found for "+sn+"\n"); return genTable.toString();}
      else genTable.append("</table>\n");

// last but not least, the defects:
      genTable.append("<p><font face=Arial color=NAVY size=+1>Defects</font>\n");
      sqlStat = new StringBuffer("SELECT tests.test_no,tests.test_name,tests.test_date,tests.locn_name,CHAN_1ST,CHAN_LAST,DEFECT_NAME FROM DEFECTS,tests,sct_tstdcsinfo WHERE tests.test_no=defects.test_no");
      sqlStat.append(" AND tests.ser_no="+sn);
      sqlStat.append(testnames);
      sqlStat.append(" ORDER by defects.chan_1st,tests.test_date,tests.test_no");

// submit query
     statement = db.connection.createStatement();
     if(DEBUG) System.out.println(sqlStat.toString());
     resultSet = statement.executeQuery(sqlStat.toString());

// now get the data
     int ntotal=0;
     nCount=0;
     int nMaxConChannels=0;
     int nMaxConNonTrimChannels=0;
    Hashtable nonTrimDefectHash = new Hashtable();
     Hashtable trimDefectHash = new Hashtable();
     Hashtable channelHash = new Hashtable();   // key = channel no, bit0: trim test defect, bit1: non-trim test defect
     Vector nonTrimDefectList = new Vector();
     Vector trimDefectList = new Vector();
     for(boolean n = resultSet.next() ; n==true ; n=resultSet.next() ){
          String thisTestNo = resultSet.getString(1);
          String thisTestName = resultSet.getString(2);
          thisTestName = sctdaqTestNameHash.containsKey(thisTestName) ? (String)sctdaqTestNameHash.get(thisTestName) : thisTestName;
          if(trimRangeHash.containsKey(thisTestNo)) {
             thisTestName += "Range "+(String)trimRangeHash.get(thisTestNo);
             }
          boolean isTrimTest = (thisTestName.indexOf("Trim")!=-1);
          String testDate = guiUtilities.DaveUtils.extractDate(resultSet.getString(3));
          String locn = resultSet.getString(4);
          String chan1 = resultSet.getString(5);
          String chan2 = resultSet.getString(6);
          int n1 = Integer.parseInt(chan1);
          int n2 = Integer.parseInt(resultSet.getString(6));
          String defectname = resultSet.getString(7);

          int iDiff = n2-n1;
          String defectChannel = (iDiff>0) ? chan1+"-"+chan2 : chan1;
          String thisDefectInfo = defectname+" ("+thisTestName+" at "+locn+" on "+testDate+")";

          for(int i=n1;i<=n2;i++) {
              String thisChannel = Integer.toString(i);
              if(!channelHash.containsKey(thisChannel)) {
                    int status= (isTrimTest) ? 1 : 2;
                    channelHash.put(thisChannel, new Integer(status));
                    }
              else {
                   Integer theStatus = (Integer)channelHash.get(thisChannel);
                   int status = theStatus.intValue();
                   if(isTrimTest) status |=1;
                   else status |= 2;
                   channelHash.put(thisChannel,new Integer(status));
                   }
              }
           if(iDiff>0) {
             iDiff++;
             nMaxConChannels = iDiff>nMaxConChannels ? iDiff : nMaxConChannels;
             nMaxConNonTrimChannels = (iDiff>nMaxConNonTrimChannels && !isTrimTest) ? iDiff : nMaxConNonTrimChannels;
             }

// Non-Trim defects
          if(thisTestName.indexOf("Trim")==-1) {
             if(nonTrimDefectHash.containsKey(defectChannel)) {
               Vector thisDefectVector = (Vector)nonTrimDefectHash.get(defectChannel);
               if(!thisDefectVector.contains((String)thisDefectInfo)) thisDefectVector.addElement(thisDefectInfo);
               nonTrimDefectHash.put(defectChannel,(Vector)thisDefectVector);               
               }
             else {
               nonTrimDefectList.addElement(defectChannel);
               Vector thisDefectVector = new Vector();
               thisDefectVector.addElement(thisDefectInfo);
               nonTrimDefectHash.put(defectChannel,(Vector)thisDefectVector);
               }
             }
// Trim defects
          else {
             if(trimDefectHash.containsKey(defectChannel)) {
               Vector thisDefectVector = (Vector)trimDefectHash.get(defectChannel);
               if(!thisDefectVector.contains((String)thisDefectInfo)) thisDefectVector.addElement(thisDefectInfo);
               trimDefectHash.put(defectChannel,(Vector)thisDefectVector);               
               }
             else {
               trimDefectList.addElement(defectChannel);
               Vector thisDefectVector = new Vector();
               thisDefectVector.addElement(thisDefectInfo);
               trimDefectHash.put(defectChannel,(Vector)thisDefectVector);
               }
           }
        }
      statement.close();

// now generate the html tables
// start with statistics
     int nDefectCount=0;
     int nTrimDefectCount=0;
     int nNonTrimDefectCount=0;
     int nBothCount=0;
//
 for (Enumeration e = channelHash.elements() ; e.hasMoreElements() ;) {
         Integer theStatus = (Integer)e.nextElement();
         int status = theStatus.intValue();
         if(status>0) nDefectCount++;
         if((status & 1)>0) nTrimDefectCount++;
         if((status & 2)>0) nNonTrimDefectCount++;
         if((status & 3)==3) nBothCount++;
          }
        genTable.append("<br><br><b>Statistics</b>\n");
//        genTable.append("<br>Found "+channelHash.size()+" defects containing "+nDefectCount+" channels.<br>");
        genTable.append("<br><table cellspacing=5 border=1>\n");
        genTable.append("<col width=*><col width=*>\n");
        genTable.append("<tr><td align=left>Channels with any defect(s)</td><td align=left>"+nDefectCount+"</td></tr>\n");
        genTable.append("<tr><td align=left>Channels with non-trim defect(s)</td><td align=left>"+nNonTrimDefectCount+"</td></tr>\n");
        genTable.append("<tr><td align=left>Channels with trim defect(s)</td><td align=left>"+nTrimDefectCount+"</td></tr>\n");
        genTable.append("<tr><td align=left>Channels with non-trim and trim defect(s)</td><td align=left>"+nBothCount+"</td></tr>\n");
        genTable.append("<tr><td align=left>Max consecutive bad channels (non-trim defects only)</td><td align=left>"+nMaxConNonTrimChannels+"</td></tr>\n");
        genTable.append("<tr><td align=left>Max consecutive bad channels (any defect)</td><td align=left>"+nMaxConChannels+"</td></tr>\n");
        genTable.append("</table>");
// then list the non-trim defects         
        genTable.append("<br>");
        genTable.append("<br><b>Non-Trim Defects</b>");
        if(nonTrimDefectList.size()==0) genTable.append("<br>No defective channels");
        else {
            genTable.append("<table cellspacing=5 border=1>\n");
            genTable.append("<col width=*><col width=*>\n");
            genTable.append("<tr><td align=left><b>Channel(s)</b></td><td align=left><b>Non-Trim Defects</b></td></tr>");
            for(int i=0;i<nonTrimDefectList.size();i++) {
               String thisChan = (String)nonTrimDefectList.elementAt(i);
               Vector theList = (Vector)nonTrimDefectHash.get(thisChan);
               genTable.append("<tr><td align=left>"+thisChan+"</td><td align=left>");
               for(int j=0;j<theList.size();j++) {
                   if(j>0) genTable.append("<br>");
                   genTable.append((String)theList.elementAt(j));
                   }
               genTable.append("</td></tr>");
               }
            genTable.append("</table>");
            }
// and finally the trim defects
        genTable.append("<br>");
        genTable.append("<br><b>Trim Defects</b>");
        if(trimDefectList.size()==0) genTable.append("<br>No defective channels");
        else {
            genTable.append("<table cellspacing=5 border=1>\n");
            genTable.append("<col width=*><col width=*>\n");
            genTable.append("<tr><td align=left><b>Channel(s)</b></td><td align=left><b>Trim Defects</b></td></tr>");
            for(int i=0;i<trimDefectList.size();i++) {
               String thisChan = (String)trimDefectList.elementAt(i);
               Vector theList = (Vector)trimDefectHash.get(thisChan);
               genTable.append("<tr><td align=left>"+thisChan+"</td><td align=left>");
               for(int j=0;j<theList.size();j++) {
                   if(j>0) genTable.append("<br>");
                   genTable.append((String)theList.elementAt(j));
                   }
               genTable.append("</td></tr>");
               }
            genTable.append("</table><br>");
            }

      return genTable.toString();
      }

// ******************************************************************************************************
    public static String createVisualTestTable(String serno, String itemType) throws Exception {
      Hashtable testnoHash = new Hashtable();
      Vector testnoList = new Vector();
      Vector itemList = new Vector();
      Vector theLine = new Vector();
      String testnoKey = "TESTNO";
      String snKey = "SERIALNO";
      String dateKey = "DATE";
      String locationKey = "LOCN";
      String flagKey = "FLAG";

      StringBuffer genTable = new StringBuffer("<h3>Visual Inspections of "+itemType+"</h3>");

      SCTDBInterface db = SCTDBInterface.getInstance();
      Statement statement = db.connection.createStatement();
     StringBuffer sqlStat = new StringBuffer("SELECT ");
     sqlStat.append("tests.test_no,tests.ser_no,tests.test_date,tests.locn_name,tests.problem,tests.pass");
     sqlStat.append(" FROM tests");
     sqlStat.append(" WHERE tests.ser_no = "+serno);
     sqlStat.append(" AND tests.test_name='Visual_Inspection'");
     sqlStat.append(" ORDER BY tests.test_date, tests.test_no");


     ResultSet resultSet = statement.executeQuery(sqlStat.toString());
     int recordCount=0;
     Vector testNumberList = new Vector();
     for(boolean n = resultSet.next() ; n==true ; n=resultSet.next() ){
          Hashtable thisHash = new Hashtable();
          recordCount++;
//          if(recordCount%100 == 0) System.out.println("Retrieved "+recordCount+" records so far...");
          String testno = resultSet.getString(1);
          thisHash.put(snKey,resultSet.getString(2));
          String date = resultSet.getString(3);
          thisHash.put(dateKey,guiUtilities.DaveUtils.extractDate(date));
          thisHash.put(locationKey,resultSet.getString(4));
          String problemFlag = resultSet.getString(5);
          String passFlag = resultSet.getString(6);
          String statusFlag; 
          if(passFlag.equals("YES")) {
             statusFlag = (problemFlag.equals("YES")) ? "PROBLEM" : "Ok";
             }
          else statusFlag = "FAIL";
          thisHash.put(flagKey,statusFlag);
          testnoHash.put(testno,thisHash);   
          testnoList.addElement(testno);  

	    }
//      System.out.println("Retrieved "+recordCount+" records in total.");
      statement.close();
      if(recordCount==0) {
          genTable.append("None uploaded");
          return genTable.toString();
          }

// now get the comments, if any
      String subQuery = sqlStat.toString();
      subQuery = subQuery.substring(subQuery.indexOf("WHERE"),subQuery.indexOf("ORDER")-1);
      Hashtable commentsHash = GeneralUtilities.testComments(subQuery);
      Hashtable testImagesHash = GeneralUtilities.testImages(subQuery);

      genTable.append("<table border=1>\n");
      genTable.append("<tr><td>Date</td><td>Location</td><td>Status</td><td>Comments</td><td>Images</td></tr>\n");

      for(int i=0;i<testnoList.size();i++) {
            genTable.append("<tr>");
            String testno = (String)testnoList.elementAt(i); // this contains the testno's, ordered by serial no
            Hashtable tempHash = (Hashtable)testnoHash.get(testno);

            genTable.append("<td>"+tempHash.get(dateKey)+"</td>");                                    // 2nd column is the date
            genTable.append("<td>"+tempHash.get(locationKey)+"</td>");              
            genTable.append("<td>"+tempHash.get(flagKey)+"</td>");
            if(commentsHash.containsKey(testno)) genTable.append("<td>"+commentsHash.get(testno)+"</td>");
            else genTable.append("<td>None</td>");
            
            String ImageTitle = "Visual Inspection of "+serno+" at "+tempHash.get(locationKey)+" on "+tempHash.get(dateKey);
            if(testImagesHash.containsKey(testno)) {
               Vector imageList = (Vector)testImagesHash.get(testno);
               genTable.append("<td>");
               for(int j=0;j<imageList.size(); j++) {
                   if(j%2 !=0) continue;
                   if(j>0) genTable.append("<br>");
                   genTable.append("<a href=\"Type"+Integer.toString(guiUtilities.HTMLViewer.SCTDBIMAGE)+"&ref="+testno+ImageTitle+"\">"+(String)imageList.elementAt(j)+"</a>");
//                   genTable.append((String)imageList.elementAt(j));
                   }
               genTable.append("</td>");
             }
             else genTable.append("<td></td>");
             genTable.append("</tr>\n");
             }
       genTable.append("</table>");
       return genTable.toString();


      }

// *****************************************************************************************************************
   public static String createASICReWorkTable(String hybridSerialNo) throws Exception {

      StringBuffer genTable = new StringBuffer("<h3>ASIC Replacements</h3>\n");
      StringBuffer sqlStat = new StringBuffer("SELECT ser_no,locn_name,disassm_date,posn FROM DISASSMLOGS where ASSM_SER_NO='"+hybridSerialNo+"'");
      sqlStat.append(" AND ser_no NOT IN (SELECT ser_no FROM ASSM_ITEMS where assm_ser_no="+hybridSerialNo+")");
      sqlStat.append(" ORDER BY DISASSM_DATE");

// submit query
     Statement statement = SCTDBInterface.getInstance().connection.createStatement();
     if(DEBUG) System.out.println(sqlStat.toString());
     ResultSet resultSet = statement.executeQuery(sqlStat.toString());
     int recordCount=0;

// now get the data
     int ntotal=0;
     int nCount=0;
     for(boolean n = resultSet.next() ; n==true ; n=resultSet.next() ){
        if(nCount==0) {
          genTable.append("<table cellspacing=5 border=1>\n");
          for(int i=0;i<4;i++) genTable.append("<col width=*>\n");
          genTable.append("<tr><td valign=top align=left><b>Serial No</b></td><td valign=top align=left><b>Location</b></td><td valign=top align=left><b>Date</b></td><td valign=top align=left><b>Position</b></td></tr>\n");
          }
        nCount++;
        genTable.append("<tr><td>"+resultSet.getString(1)+"</td><td>"+resultSet.getString(2)+"</td><td>"+guiUtilities.DaveUtils.extractDate(resultSet.getString(3))+"</td><td>"+resultSet.getString(4)+"</td></tr>\n");
        }
      statement.close();
      if(nCount==0) genTable.append("None uploaded.\n");
      else genTable.append("</table>\n");
      return genTable.toString();
      }



}
